/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.tools;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.tools.Bundle;
import jmri.jmrit.operations.rollingstock.cars.CarRoads;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.setup.Setup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackRoadEditFrame
extends OperationsFrame
implements PropertyChangeListener {
    Location _location = null;
    Track _track = null;
    JPanel pRoadControls = new JPanel();
    JPanel panelRoads = new JPanel();
    JScrollPane paneRoads = new JScrollPane(this.panelRoads);
    JButton saveTrackButton = new JButton(Bundle.getMessage("SaveTrack"));
    JButton addRoadButton = new JButton(Bundle.getMessage("AddRoad"));
    JButton deleteRoadButton = new JButton(Bundle.getMessage("DeleteRoad"));
    JButton deleteAllRoadsButton = new JButton(Bundle.getMessage("DeleteAll"));
    JRadioButton roadNameAll = new JRadioButton(Bundle.getMessage("AcceptAll"));
    JRadioButton roadNameInclude = new JRadioButton(Bundle.getMessage("AcceptOnly"));
    JRadioButton roadNameExclude = new JRadioButton(Bundle.getMessage("Exclude"));
    JComboBox<String> comboBoxRoads = InstanceManager.getDefault(CarRoads.class).getComboBox();
    JLabel trackName = new JLabel();
    public static final String DISPOSE = "dispose";
    public static final int MAX_NAME_LENGTH = Control.max_len_string_track_name;
    private static final Logger log = LoggerFactory.getLogger(TrackRoadEditFrame.class);

    public TrackRoadEditFrame() {
        super(Bundle.getMessage("TitleEditTrackRoads"));
    }

    public void initComponents(Location location, Track track) {
        this._location = location;
        this._track = track;
        InstanceManager.getDefault(CarRoads.class).addPropertyChangeListener(this);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 0));
        p1.setMaximumSize(new Dimension(2000, 250));
        JPanel pTrackName = new JPanel();
        pTrackName.setLayout(new GridBagLayout());
        pTrackName.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Track")));
        this.addItem(pTrackName, this.trackName, 0, 0);
        JPanel pLocationName = new JPanel();
        pLocationName.setLayout(new GridBagLayout());
        pLocationName.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Location")));
        this.addItem(pLocationName, new JLabel(this._location.getName()), 0, 0);
        p1.add(pTrackName);
        p1.add(pLocationName);
        JPanel p3 = new JPanel();
        p3.setLayout(new BoxLayout(p3, 1));
        JScrollPane pane3 = new JScrollPane(p3);
        pane3.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("RoadsTrack")));
        pane3.setMaximumSize(new Dimension(2000, 400));
        JPanel pRoadRadioButtons = new JPanel();
        pRoadRadioButtons.setLayout(new FlowLayout());
        pRoadRadioButtons.add(this.roadNameAll);
        pRoadRadioButtons.add(this.roadNameInclude);
        pRoadRadioButtons.add(this.roadNameExclude);
        this.pRoadControls.setLayout(new FlowLayout());
        this.pRoadControls.add(this.comboBoxRoads);
        this.pRoadControls.add(this.addRoadButton);
        this.pRoadControls.add(this.deleteRoadButton);
        this.pRoadControls.add(this.deleteAllRoadsButton);
        this.pRoadControls.setVisible(false);
        p3.add(pRoadRadioButtons);
        p3.add(this.pRoadControls);
        this.panelRoads.setLayout(new GridBagLayout());
        this.paneRoads.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Roads")));
        ButtonGroup roadGroup = new ButtonGroup();
        roadGroup.add(this.roadNameAll);
        roadGroup.add(this.roadNameInclude);
        roadGroup.add(this.roadNameExclude);
        JPanel panelButtons = new JPanel();
        panelButtons.setLayout(new GridBagLayout());
        panelButtons.setBorder(BorderFactory.createTitledBorder(""));
        panelButtons.setMaximumSize(new Dimension(2000, 200));
        this.addItem(panelButtons, this.saveTrackButton, 0, 0);
        this.getContentPane().add(p1);
        this.getContentPane().add(pane3);
        this.getContentPane().add(this.paneRoads);
        this.getContentPane().add(panelButtons);
        this.addButtonAction(this.saveTrackButton);
        this.addButtonAction(this.deleteRoadButton);
        this.addButtonAction(this.deleteAllRoadsButton);
        this.addButtonAction(this.addRoadButton);
        this.addRadioButtonAction(this.roadNameAll);
        this.addRadioButtonAction(this.roadNameInclude);
        this.addRadioButtonAction(this.roadNameExclude);
        if (this._track != null) {
            this._track.addPropertyChangeListener(this);
            this.trackName.setText(this._track.getName());
            this.enableButtons(true);
        } else {
            this.enableButtons(false);
        }
        this.updateRoadComboBox();
        this.updateRoadNames();
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_RoadOptions", true);
        this.initMinimumSize(new Dimension(500, 400));
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (this._track == null) {
            return;
        }
        if (ae.getSource() == this.saveTrackButton) {
            log.debug("track save button activated");
            this.checkForErrors();
            OperationsXml.save();
            if (Setup.isCloseWindowOnSaveEnabled()) {
                this.dispose();
            }
        }
        if (ae.getSource() == this.addRoadButton) {
            this._track.addRoadName((String)this.comboBoxRoads.getSelectedItem());
            this.selectNextItemComboBox(this.comboBoxRoads);
        }
        if (ae.getSource() == this.deleteRoadButton) {
            this._track.deleteRoadName((String)this.comboBoxRoads.getSelectedItem());
            this.selectNextItemComboBox(this.comboBoxRoads);
        }
        if (ae.getSource() == this.deleteAllRoadsButton) {
            this.deleteAllRoads();
        }
    }

    protected void enableButtons(boolean enabled) {
        this.saveTrackButton.setEnabled(enabled);
        this.roadNameAll.setEnabled(enabled);
        this.roadNameInclude.setEnabled(enabled);
        this.roadNameExclude.setEnabled(enabled);
    }

    @Override
    public void radioButtonActionPerformed(ActionEvent ae) {
        log.debug("radio button activated");
        if (ae.getSource() == this.roadNameAll) {
            this._track.setRoadOption(Track.ALL_ROADS);
        }
        if (ae.getSource() == this.roadNameInclude) {
            this._track.setRoadOption(Track.INCLUDE_ROADS);
        }
        if (ae.getSource() == this.roadNameExclude) {
            this._track.setRoadOption(Track.EXCLUDE_ROADS);
        }
    }

    private void updateRoadComboBox() {
        InstanceManager.getDefault(CarRoads.class).updateComboBox(this.comboBoxRoads);
    }

    private void updateRoadNames() {
        log.debug("Update road names");
        this.panelRoads.removeAll();
        if (this._track != null) {
            this.roadNameAll.setSelected(this._track.getRoadOption().equals(Track.ALL_ROADS));
            this.roadNameInclude.setSelected(this._track.getRoadOption().equals(Track.INCLUDE_ROADS));
            this.roadNameExclude.setSelected(this._track.getRoadOption().equals(Track.EXCLUDE_ROADS));
            this.pRoadControls.setVisible(!this.roadNameAll.isSelected());
            if (!this.roadNameAll.isSelected()) {
                int x = 0;
                int y = 0;
                int numberOfRoads = this.getNumberOfCheckboxesPerLine();
                String[] stringArray = this._track.getRoadNames();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String roadName = stringArray[n2];
                    JLabel road = new JLabel();
                    road.setText(roadName);
                    this.addItemTop(this.panelRoads, road, x++, y);
                    if (x > numberOfRoads) {
                        ++y;
                        x = 0;
                    }
                    ++n2;
                }
                this.revalidate();
            }
        } else {
            this.roadNameAll.setSelected(true);
        }
        this.panelRoads.repaint();
        this.panelRoads.revalidate();
    }

    private void deleteAllRoads() {
        if (this._track != null) {
            String[] stringArray = this._track.getRoadNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String roadName = stringArray[n2];
                this._track.deleteRoadName(roadName);
                ++n2;
            }
        }
    }

    @Override
    public void checkBoxActionPerformed(ActionEvent ae) {
        JCheckBox b = (JCheckBox)ae.getSource();
        log.debug("checkbox change {}", (Object)b.getText());
        if (this._location == null) {
            return;
        }
        if (b.isSelected()) {
            this._track.addTypeName(b.getText());
        } else {
            this._track.deleteTypeName(b.getText());
        }
    }

    private void checkForErrors() {
        if (this._track.getRoadOption().equals(Track.INCLUDE_ROADS) && this._track.getRoadNames().length == 0) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("ErrorNeedRoads"), Bundle.getMessage("ErrorNoRoads"), 0);
        }
    }

    @Override
    public void dispose() {
        if (this._track != null) {
            this._track.removePropertyChangeListener(this);
        }
        InstanceManager.getDefault(CarRoads.class).removePropertyChangeListener(this);
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("CarRoads Length")) {
            this.updateRoadComboBox();
            this.updateRoadNames();
        }
        if (e.getPropertyName().equals("trackRoads")) {
            this.updateRoadNames();
        }
    }
}

