/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.tools;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.tools.Bundle;
import jmri.jmrit.operations.rollingstock.cars.CarLoads;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.setup.Setup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackLoadEditFrame
extends OperationsFrame
implements PropertyChangeListener {
    private static boolean loadAndType = false;
    private static boolean shipLoadAndType = false;
    Location _location = null;
    Track _track = null;
    String _type = "";
    JMenu _toolMenu = null;
    JPanel pLoadControls = new JPanel();
    JPanel panelLoads = new JPanel();
    JScrollPane paneLoads = new JScrollPane(this.panelLoads);
    JPanel pShipLoadControls = new JPanel();
    JPanel panelShipLoads = new JPanel();
    JScrollPane paneShipLoadControls;
    JScrollPane paneShipLoads = new JScrollPane(this.panelShipLoads);
    JButton saveTrackButton = new JButton(Bundle.getMessage("SaveTrack"));
    JButton addLoadButton = new JButton(Bundle.getMessage("AddLoad"));
    JButton deleteLoadButton = new JButton(Bundle.getMessage("DeleteLoad"));
    JButton deleteAllLoadsButton = new JButton(Bundle.getMessage("DeleteAll"));
    JButton addShipLoadButton = new JButton(Bundle.getMessage("AddLoad"));
    JButton deleteShipLoadButton = new JButton(Bundle.getMessage("DeleteLoad"));
    JButton deleteAllShipLoadsButton = new JButton(Bundle.getMessage("DeleteAll"));
    JCheckBox loadAndTypeCheckBox = new JCheckBox(Bundle.getMessage("TypeAndLoad"));
    JCheckBox shipLoadAndTypeCheckBox = new JCheckBox(Bundle.getMessage("TypeAndLoad"));
    JCheckBox holdCars = new JCheckBox();
    JRadioButton loadNameAll = new JRadioButton(Bundle.getMessage("AcceptAll"));
    JRadioButton loadNameInclude = new JRadioButton(Bundle.getMessage("AcceptOnly"));
    JRadioButton loadNameExclude = new JRadioButton(Bundle.getMessage("Exclude"));
    JRadioButton shipLoadNameAll = new JRadioButton(Bundle.getMessage("ShipAll"));
    JRadioButton shipLoadNameInclude = new JRadioButton(Bundle.getMessage("ShipOnly"));
    JRadioButton shipLoadNameExclude = new JRadioButton(Bundle.getMessage("Exclude"));
    JComboBox<String> comboBoxLoads = InstanceManager.getDefault(CarLoads.class).getComboBox(null);
    JComboBox<String> comboBoxShipLoads = InstanceManager.getDefault(CarLoads.class).getComboBox(null);
    JComboBox<String> comboBoxTypes = InstanceManager.getDefault(CarTypes.class).getComboBox();
    JComboBox<String> comboBoxShipTypes = InstanceManager.getDefault(CarTypes.class).getComboBox();
    JLabel trackName = new JLabel();
    public static final String DISPOSE = "dispose";
    public static final int MAX_NAME_LENGTH = Control.max_len_string_track_name;
    private static final Logger log = LoggerFactory.getLogger(TrackLoadEditFrame.class);

    public TrackLoadEditFrame() {
        super(Bundle.getMessage("TitleEditTrackLoads"));
    }

    public void initComponents(Location location, Track track) {
        this._location = location;
        this._track = track;
        this._location.addPropertyChangeListener(this);
        InstanceManager.getDefault(CarLoads.class).addPropertyChangeListener(this);
        InstanceManager.getDefault(CarTypes.class).addPropertyChangeListener(this);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 0));
        p1.setMaximumSize(new Dimension(2000, 250));
        JPanel pTrackName = new JPanel();
        pTrackName.setLayout(new GridBagLayout());
        pTrackName.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Track")));
        this.addItem(pTrackName, this.trackName, 0, 0);
        JPanel pLocationName = new JPanel();
        pLocationName.setLayout(new GridBagLayout());
        pLocationName.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Location")));
        this.addItem(pLocationName, new JLabel(this._location.getName()), 0, 0);
        p1.add(pTrackName);
        p1.add(pLocationName);
        JPanel p3 = new JPanel();
        p3.setLayout(new BoxLayout(p3, 1));
        JScrollPane pane3 = new JScrollPane(p3);
        pane3.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("LoadsTrack")));
        pane3.setMaximumSize(new Dimension(2000, 400));
        JPanel pLoadRadioButtons = new JPanel();
        pLoadRadioButtons.setLayout(new FlowLayout());
        pLoadRadioButtons.add(this.loadNameAll);
        pLoadRadioButtons.add(this.loadNameInclude);
        pLoadRadioButtons.add(this.loadNameExclude);
        pLoadRadioButtons.add(this.loadAndTypeCheckBox);
        this.pLoadControls.setLayout(new FlowLayout());
        this.pLoadControls.add(this.comboBoxTypes);
        this.pLoadControls.add(this.comboBoxLoads);
        this.pLoadControls.add(this.addLoadButton);
        this.pLoadControls.add(this.deleteLoadButton);
        this.pLoadControls.add(this.deleteAllLoadsButton);
        this.pLoadControls.setVisible(false);
        p3.add(pLoadRadioButtons);
        p3.add(this.pLoadControls);
        this.panelLoads.setLayout(new GridBagLayout());
        this.paneLoads.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Loads")));
        ButtonGroup loadGroup = new ButtonGroup();
        loadGroup.add(this.loadNameAll);
        loadGroup.add(this.loadNameInclude);
        loadGroup.add(this.loadNameExclude);
        JPanel p6 = new JPanel();
        p6.setLayout(new BoxLayout(p6, 1));
        this.paneShipLoadControls = new JScrollPane(p6);
        this.paneShipLoadControls.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("ShipLoadsTrack")));
        this.paneShipLoadControls.setMaximumSize(new Dimension(2000, 400));
        JPanel pShipLoadRadioButtons = new JPanel();
        pShipLoadRadioButtons.setLayout(new FlowLayout());
        pShipLoadRadioButtons.add(this.shipLoadNameAll);
        pShipLoadRadioButtons.add(this.shipLoadNameInclude);
        pShipLoadRadioButtons.add(this.shipLoadNameExclude);
        pShipLoadRadioButtons.add(this.shipLoadAndTypeCheckBox);
        this.pShipLoadControls.setLayout(new FlowLayout());
        this.pShipLoadControls.add(this.comboBoxShipTypes);
        this.pShipLoadControls.add(this.comboBoxShipLoads);
        this.pShipLoadControls.add(this.addShipLoadButton);
        this.pShipLoadControls.add(this.deleteShipLoadButton);
        this.pShipLoadControls.add(this.deleteAllShipLoadsButton);
        this.pShipLoadControls.setVisible(false);
        p6.add(pShipLoadRadioButtons);
        p6.add(this.pShipLoadControls);
        this.panelShipLoads.setLayout(new GridBagLayout());
        this.paneShipLoads.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Loads")));
        ButtonGroup shipLoadGroup = new ButtonGroup();
        shipLoadGroup.add(this.shipLoadNameAll);
        shipLoadGroup.add(this.shipLoadNameInclude);
        shipLoadGroup.add(this.shipLoadNameExclude);
        JPanel pOptions = new JPanel();
        pOptions.setLayout(new GridBagLayout());
        pOptions.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Options")));
        pOptions.setMaximumSize(new Dimension(2000, 400));
        this.addItem(pOptions, this.holdCars, 0, 0);
        this.holdCars.setText(Bundle.getMessage("HoldCarsWithCustomLoads"));
        this.holdCars.setToolTipText(Bundle.getMessage("HoldCarsWithCustomLoadsTip"));
        JPanel panelButtons = new JPanel();
        panelButtons.setLayout(new GridBagLayout());
        panelButtons.setBorder(BorderFactory.createTitledBorder(""));
        panelButtons.setMaximumSize(new Dimension(2000, 200));
        this.addItem(panelButtons, this.saveTrackButton, 0, 0);
        this.getContentPane().add(p1);
        this.getContentPane().add(pane3);
        this.getContentPane().add(this.paneLoads);
        this.getContentPane().add(this.paneShipLoadControls);
        this.getContentPane().add(this.paneShipLoads);
        this.getContentPane().add(pOptions);
        this.getContentPane().add(panelButtons);
        this.addButtonAction(this.saveTrackButton);
        this.addButtonAction(this.deleteLoadButton);
        this.addButtonAction(this.deleteAllLoadsButton);
        this.addButtonAction(this.addLoadButton);
        this.addButtonAction(this.deleteShipLoadButton);
        this.addButtonAction(this.deleteAllShipLoadsButton);
        this.addButtonAction(this.addShipLoadButton);
        this.addRadioButtonAction(this.loadNameAll);
        this.addRadioButtonAction(this.loadNameInclude);
        this.addRadioButtonAction(this.loadNameExclude);
        this.addRadioButtonAction(this.shipLoadNameAll);
        this.addRadioButtonAction(this.shipLoadNameInclude);
        this.addRadioButtonAction(this.shipLoadNameExclude);
        this.addComboBoxAction(this.comboBoxTypes);
        this.addComboBoxAction(this.comboBoxShipTypes);
        this.paneShipLoadControls.setVisible(false);
        this.paneShipLoads.setVisible(false);
        pOptions.setVisible(false);
        if (this._track != null) {
            this._track.addPropertyChangeListener(this);
            this.trackName.setText(this._track.getName());
            this.paneShipLoadControls.setVisible(this._track.isStaging());
            this.paneShipLoads.setVisible(this._track.isStaging());
            pOptions.setVisible(this._track.isSpur());
            this.holdCars.setSelected(this._track.isHoldCarsWithCustomLoadsEnabled());
            this.updateButtons(true);
        } else {
            this.updateButtons(false);
        }
        this.updateTypeComboBoxes();
        this.updateLoadComboBoxes();
        this.updateLoadNames();
        this.updateShipLoadNames();
        this.loadAndTypeCheckBox.setSelected(loadAndType);
        this.shipLoadAndTypeCheckBox.setSelected(shipLoadAndType);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_LoadOptions", true);
        this.initMinimumSize(new Dimension(600, 400));
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        String loadName;
        if (this._track == null) {
            return;
        }
        if (ae.getSource() == this.saveTrackButton) {
            log.debug("track save button activated");
            this.save();
            if (Setup.isCloseWindowOnSaveEnabled()) {
                this.dispose();
            }
        }
        if (ae.getSource() == this.addLoadButton) {
            loadName = (String)this.comboBoxLoads.getSelectedItem();
            if (this.loadAndTypeCheckBox.isSelected()) {
                loadName = this.comboBoxTypes.getSelectedItem() + " & " + loadName;
            }
            this._track.addLoadName(loadName);
            this.selectNextItemComboBox(this.comboBoxLoads);
        }
        if (ae.getSource() == this.deleteLoadButton) {
            loadName = (String)this.comboBoxLoads.getSelectedItem();
            if (this.loadAndTypeCheckBox.isSelected()) {
                loadName = this.comboBoxTypes.getSelectedItem() + " & " + loadName;
            }
            this._track.deleteLoadName(loadName);
            this.selectNextItemComboBox(this.comboBoxLoads);
        }
        if (ae.getSource() == this.deleteAllLoadsButton) {
            this.deleteAllLoads();
        }
        if (ae.getSource() == this.addShipLoadButton) {
            loadName = (String)this.comboBoxShipLoads.getSelectedItem();
            if (this.shipLoadAndTypeCheckBox.isSelected()) {
                loadName = this.comboBoxShipTypes.getSelectedItem() + " & " + loadName;
            }
            this._track.addShipLoadName(loadName);
            this.selectNextItemComboBox(this.comboBoxShipLoads);
        }
        if (ae.getSource() == this.deleteShipLoadButton) {
            loadName = (String)this.comboBoxShipLoads.getSelectedItem();
            if (this.shipLoadAndTypeCheckBox.isSelected()) {
                loadName = this.comboBoxShipTypes.getSelectedItem() + " & " + loadName;
            }
            this._track.deleteShipLoadName(loadName);
            this.selectNextItemComboBox(this.comboBoxShipLoads);
        }
        if (ae.getSource() == this.deleteAllShipLoadsButton) {
            this.deleteAllShipLoads();
        }
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="GUI ease of use")
    protected void save() {
        this.checkForErrors();
        this._track.setHoldCarsWithCustomLoadsEnabled(this.holdCars.isSelected());
        loadAndType = this.loadAndTypeCheckBox.isSelected();
        shipLoadAndType = this.shipLoadAndTypeCheckBox.isSelected();
        OperationsXml.save();
    }

    protected void updateButtons(boolean enabled) {
        this.saveTrackButton.setEnabled(enabled);
        this.loadNameAll.setEnabled(enabled);
        this.loadNameInclude.setEnabled(enabled);
        this.loadNameExclude.setEnabled(enabled);
        this.loadAndTypeCheckBox.setEnabled(enabled);
        boolean en = enabled && (this._track.isAddCustomLoadsAnyStagingTrackEnabled() || this._track.isAddCustomLoadsAnySpurEnabled() || this._track.isAddCustomLoadsEnabled() || !this._track.getShipLoadOption().equals(Track.ALL_LOADS));
        this.shipLoadNameAll.setEnabled(en);
        this.shipLoadNameInclude.setEnabled(en);
        this.shipLoadNameExclude.setEnabled(en);
        this.shipLoadAndTypeCheckBox.setEnabled(en);
        this.addShipLoadButton.setEnabled(en);
        this.deleteShipLoadButton.setEnabled(en);
        this.deleteAllShipLoadsButton.setEnabled(en);
        this.comboBoxShipLoads.setEnabled(en);
        this.comboBoxShipTypes.setEnabled(en);
    }

    @Override
    public void radioButtonActionPerformed(ActionEvent ae) {
        log.debug("radio button activated");
        if (ae.getSource() == this.loadNameAll) {
            this._track.setLoadOption(Track.ALL_LOADS);
        }
        if (ae.getSource() == this.loadNameInclude) {
            this._track.setLoadOption(Track.INCLUDE_LOADS);
        }
        if (ae.getSource() == this.loadNameExclude) {
            this._track.setLoadOption(Track.EXCLUDE_LOADS);
        }
        if (ae.getSource() == this.shipLoadNameAll) {
            this._track.setShipLoadOption(Track.ALL_LOADS);
        }
        if (ae.getSource() == this.shipLoadNameInclude) {
            this._track.setShipLoadOption(Track.INCLUDE_LOADS);
        }
        if (ae.getSource() == this.shipLoadNameExclude) {
            this._track.setShipLoadOption(Track.EXCLUDE_LOADS);
        }
    }

    @Override
    public void comboBoxActionPerformed(ActionEvent ae) {
        this.updateLoadComboBoxes();
    }

    private void updateLoadComboBoxes() {
        String carType = (String)this.comboBoxTypes.getSelectedItem();
        InstanceManager.getDefault(CarLoads.class).updateComboBox(carType, this.comboBoxLoads);
        carType = (String)this.comboBoxShipTypes.getSelectedItem();
        InstanceManager.getDefault(CarLoads.class).updateComboBox(carType, this.comboBoxShipLoads);
    }

    private void updateLoadNames() {
        log.debug("Update load names");
        this.panelLoads.removeAll();
        if (this._track != null) {
            this.loadNameAll.setSelected(this._track.getLoadOption().equals(Track.ALL_LOADS));
            this.loadNameInclude.setSelected(this._track.getLoadOption().equals(Track.INCLUDE_LOADS));
            this.loadNameExclude.setSelected(this._track.getLoadOption().equals(Track.EXCLUDE_LOADS));
            this.pLoadControls.setVisible(!this.loadNameAll.isSelected());
            if (!this.loadNameAll.isSelected()) {
                int x = 0;
                int y = 0;
                int numberOfLoads = this.getNumberOfCheckboxesPerLine() / 2 + 1;
                String[] stringArray = this._track.getLoadNames();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String loadName = stringArray[n2];
                    JLabel load = new JLabel();
                    load.setText(loadName);
                    this.addItemTop(this.panelLoads, load, x++, y);
                    if (x > numberOfLoads) {
                        ++y;
                        x = 0;
                    }
                    ++n2;
                }
                this.revalidate();
            }
        } else {
            this.loadNameAll.setSelected(true);
        }
        this.panelLoads.repaint();
        this.panelLoads.revalidate();
    }

    private void updateShipLoadNames() {
        log.debug("Update ship load names");
        this.panelShipLoads.removeAll();
        if (this._track != null) {
            this.shipLoadNameAll.setSelected(this._track.getShipLoadOption().equals(Track.ALL_LOADS));
            this.shipLoadNameInclude.setSelected(this._track.getShipLoadOption().equals(Track.INCLUDE_LOADS));
            this.shipLoadNameExclude.setSelected(this._track.getShipLoadOption().equals(Track.EXCLUDE_LOADS));
            this.pShipLoadControls.setVisible(!this.shipLoadNameAll.isSelected());
            if (!this.shipLoadNameAll.isSelected()) {
                int x = 0;
                int y = 0;
                int numberOfLoads = this.getNumberOfCheckboxesPerLine() / 2 + 1;
                String[] stringArray = this._track.getShipLoadNames();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String loadName = stringArray[n2];
                    JLabel load = new JLabel();
                    load.setText(loadName);
                    this.addItemTop(this.panelShipLoads, load, x++, y);
                    if (x > numberOfLoads) {
                        ++y;
                        x = 0;
                    }
                    ++n2;
                }
                this.revalidate();
            }
        } else {
            this.shipLoadNameAll.setSelected(true);
        }
        this.panelShipLoads.repaint();
        this.panelShipLoads.revalidate();
    }

    private void deleteAllLoads() {
        if (this._track != null) {
            String[] stringArray = this._track.getLoadNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String loadName = stringArray[n2];
                this._track.deleteLoadName(loadName);
                ++n2;
            }
        }
    }

    private void deleteAllShipLoads() {
        if (this._track != null) {
            String[] stringArray = this._track.getShipLoadNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String loadName = stringArray[n2];
                this._track.deleteShipLoadName(loadName);
                ++n2;
            }
        }
    }

    private void updateTypeComboBoxes() {
        String type;
        InstanceManager.getDefault(CarTypes.class).updateComboBox(this.comboBoxTypes);
        int i = this.comboBoxTypes.getItemCount() - 1;
        while (i >= 0) {
            type = this.comboBoxTypes.getItemAt(i);
            if (this._track != null && !this._track.isTypeNameAccepted(type)) {
                this.comboBoxTypes.removeItem(type);
            }
            --i;
        }
        InstanceManager.getDefault(CarTypes.class).updateComboBox(this.comboBoxShipTypes);
        i = this.comboBoxShipTypes.getItemCount() - 1;
        while (i >= 0) {
            type = this.comboBoxShipTypes.getItemAt(i);
            if (this._track != null && !this._track.isTypeNameAccepted(type)) {
                this.comboBoxShipTypes.removeItem(type);
            }
            --i;
        }
    }

    private void checkForErrors() {
        if (this._track.getLoadOption().equals(Track.INCLUDE_LOADS) && this._track.getLoadNames().length == 0 || this._track.getShipLoadOption().equals(Track.INCLUDE_LOADS) && this._track.getShipLoadNames().length == 0) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("ErrorNeedLoads"), Bundle.getMessage("ErrorNoLoads"), 0);
        }
    }

    @Override
    public void dispose() {
        if (this._track != null) {
            this._track.removePropertyChangeListener(this);
        }
        this._location.removePropertyChangeListener(this);
        InstanceManager.getDefault(CarLoads.class).removePropertyChangeListener(this);
        InstanceManager.getDefault(CarTypes.class).removePropertyChangeListener(this);
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("locationTypes") || e.getPropertyName().equals("CarTypes Length") || e.getPropertyName().equals("trackRollingStockTypes")) {
            this.updateTypeComboBoxes();
        }
        if (e.getPropertyName().equals("CarLoads_Name") || e.getPropertyName().equals("CarLoads_Load")) {
            this.updateLoadComboBoxes();
            this.updateLoadNames();
            this.updateShipLoadNames();
        }
        if (e.getPropertyName().equals("trackLoads")) {
            this.updateLoadNames();
            this.updateShipLoadNames();
        }
        if (e.getPropertyName().equals("trackLoadOptions") && this._track != null) {
            this.updateButtons(true);
        }
    }
}

