/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.tools;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsPanel;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.tools.Bundle;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.TrainCommon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackEditCommentsFrame
extends OperationsFrame {
    JTextArea commentBothTextArea = new JTextArea(5, 100);
    JTextArea commentPickupTextArea = new JTextArea(5, 100);
    JTextArea commentSetoutTextArea = new JTextArea(5, 100);
    JScrollPane commentBothScroller = new JScrollPane(this.commentBothTextArea);
    JScrollPane commentPickupScroller = new JScrollPane(this.commentPickupTextArea);
    JScrollPane commentSetoutScroller = new JScrollPane(this.commentSetoutTextArea);
    JColorChooser commentColorChooserBoth = new JColorChooser();
    JColorChooser commentColorChooserPickup = new JColorChooser();
    JColorChooser commentColorChooserSetout = new JColorChooser();
    JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
    JCheckBox printManifest = new JCheckBox(Bundle.getMessage("PrintManifest"));
    JCheckBox printSwitchList = new JCheckBox(Bundle.getMessage("PrintSwitchList"));
    Track _track;
    private static final Logger log = LoggerFactory.getLogger((String)TrackEditCommentsFrame.class.getName());

    public TrackEditCommentsFrame(Track track) {
        this.initComponents(track);
    }

    private void initComponents(Track track) {
        if (track == null) {
            log.debug("Track is null can't edit track comments");
            return;
        }
        this._track = track;
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel panelComments = new JPanel();
        JScrollPane panelPane = new JScrollPane(panelComments);
        panelComments.setLayout(new BoxLayout(panelComments, 1));
        panelPane.setBorder(BorderFactory.createTitledBorder(""));
        JPanel pCb = new JPanel();
        pCb.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("CommentBoth")));
        pCb.setLayout(new GridBagLayout());
        this.addItem(pCb, this.commentBothScroller, 1, 0);
        this.addItem(pCb, OperationsPanel.getColorChooserPanel(track.getCommentBoth(), this.commentColorChooserBoth), 2, 0);
        JPanel pCp = new JPanel();
        pCp.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("CommentPickup")));
        pCp.setLayout(new GridBagLayout());
        this.addItem(pCp, this.commentPickupScroller, 1, 0);
        this.addItem(pCp, OperationsPanel.getColorChooserPanel(track.getCommentPickup(), this.commentColorChooserPickup), 2, 0);
        JPanel pCs = new JPanel();
        pCs.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("CommentSetout")));
        pCs.setLayout(new GridBagLayout());
        this.addItem(pCs, this.commentSetoutScroller, 1, 0);
        this.addItem(pCs, OperationsPanel.getColorChooserPanel(track.getCommentSetout(), this.commentColorChooserSetout), 2, 0);
        this.commentBothTextArea.setText(TrainCommon.getTextColorString(track.getCommentBoth()));
        this.commentPickupTextArea.setText(TrainCommon.getTextColorString(track.getCommentPickup()));
        this.commentSetoutTextArea.setText(TrainCommon.getTextColorString(track.getCommentSetout()));
        JPanel pB = new JPanel();
        pB.setLayout(new GridBagLayout());
        this.addItem(pB, this.printManifest, 0, 0);
        this.addItem(pB, this.printSwitchList, 1, 0);
        this.addItem(pB, this.saveButton, 2, 0);
        this.printManifest.setSelected(track.isPrintManifestCommentEnabled());
        this.printSwitchList.setSelected(track.isPrintSwitchListCommentEnabled());
        panelComments.add(pCb);
        panelComments.add(pCp);
        panelComments.add(pCs);
        this.add(panelPane);
        this.add(pB);
        this.addButtonAction(this.saveButton);
        this.setTitle(track.getName());
        this.initMinimumSize(new Dimension(600, 400));
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.saveButton) {
            this._track.setCommentBoth(TrainCommon.formatColorString(this.commentBothTextArea.getText(), this.commentColorChooserBoth.getColor()));
            this._track.setCommentPickup(TrainCommon.formatColorString(this.commentPickupTextArea.getText(), this.commentColorChooserPickup.getColor()));
            this._track.setCommentSetout(TrainCommon.formatColorString(this.commentSetoutTextArea.getText(), this.commentColorChooserSetout.getColor()));
            this._track.setPrintManifestCommentEnabled(this.printManifest.isSelected());
            this._track.setPrintSwitchListCommentEnabled(this.printSwitchList.isSelected());
            OperationsXml.save();
            if (Setup.isCloseWindowOnSaveEnabled()) {
                super.dispose();
            }
        }
    }
}

