/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.tools;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.tools.Bundle;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowTrainsServingLocationFrame
extends OperationsFrame
implements PropertyChangeListener {
    Location _location = null;
    Track _track = null;
    JPanel pTrains = new JPanel();
    JComboBox<String> typeComboBox = new JComboBox();
    JCheckBox showAllTrainsCheckBox = new JCheckBox(Bundle.getMessage("ShowAllTrains"));
    private static boolean isShowAllTrains = true;
    private String typeComboBoxSelect;
    private static final Logger log = LoggerFactory.getLogger(ShowTrainsServingLocationFrame.class);

    public void initComponents(Location location, Track track) {
        this._location = location;
        this._track = track;
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel pOptions = new JPanel();
        pOptions.setLayout(new GridBagLayout());
        pOptions.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Options")));
        this.addItem(pOptions, this.showAllTrainsCheckBox, 0, 0);
        JPanel pCarType = new JPanel();
        pCarType.setLayout(new GridBagLayout());
        pCarType.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Type")));
        pCarType.setMaximumSize(new Dimension(2000, 50));
        this.addItem(pCarType, this.typeComboBox, 0, 0);
        this.pTrains.setLayout(new GridBagLayout());
        JScrollPane trainsPane = new JScrollPane(this.pTrains);
        trainsPane.setVerticalScrollBarPolicy(20);
        trainsPane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Trains")));
        this.getContentPane().add(pOptions);
        this.getContentPane().add(pCarType);
        this.getContentPane().add(trainsPane);
        this.showAllTrainsCheckBox.setToolTipText(Bundle.getMessage("TipDeselectedShowAllTrains"));
        this.addCheckBoxAction(this.showAllTrainsCheckBox);
        this.showAllTrainsCheckBox.setSelected(isShowAllTrains);
        this.updateComboBox();
        this.addComboBoxAction(this.typeComboBox);
        Dimension boxsize = this.typeComboBox.getMinimumSize();
        if (boxsize != null) {
            boxsize.setSize(boxsize.width + 10, boxsize.height);
            this.typeComboBox.setMinimumSize(boxsize);
        }
        location.addPropertyChangeListener(this);
        this.addPropertyChangeAllTrains();
        if (this._track != null) {
            this._track.addPropertyChangeListener(this);
            this.setTitle(MessageFormat.format(Bundle.getMessage("TitleShowTrains"), this._track.getName()));
        } else {
            this.setTitle(MessageFormat.format(Bundle.getMessage("TitleShowTrains"), this._location.getName()));
        }
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_ShowTrainsServicingThisLocation", true);
        this.setPreferredSize(null);
        this.initMinimumSize();
    }

    private void updateTrainPane() {
        this.pTrains.removeAll();
        int y = 0;
        for (Train train : InstanceManager.getDefault(TrainManager.class).getTrainsByNameList()) {
            Route route = train.getRoute();
            if (route == null) continue;
            for (RouteLocation rl : route.getLocationsBySequenceList()) {
                if (!rl.getName().equals(this._location.getName())) continue;
                boolean pickup = false;
                boolean setout = false;
                train.getRoute().removePropertyChangeListener(this);
                train.getRoute().addPropertyChangeListener(this);
                if (!(!rl.isPickUpAllowed() || rl.getMaxCarMoves() <= 0 || train.isLocationSkipped(rl.getId()) || !this.typeComboBoxSelect.equals("") && !train.isTypeNameAccepted(this.typeComboBoxSelect) || !train.isLocalSwitcher() && (rl.getTrainDirection() & this._location.getTrainDirections()) == 0 || !train.isLocalSwitcher() && this._track != null && (rl.getTrainDirection() & this._track.getTrainDirections()) == 0 || this._track != null && !this._track.isPickupTrainAccepted(train))) {
                    pickup = true;
                }
                if (!(!rl.isDropAllowed() || rl.getMaxCarMoves() <= 0 || train.isLocationSkipped(rl.getId()) || !this.typeComboBoxSelect.equals("") && !train.isTypeNameAccepted(this.typeComboBoxSelect) || !train.isLocalSwitcher() && (rl.getTrainDirection() & this._location.getTrainDirections()) == 0 || !train.isLocalSwitcher() && this._track != null && (rl.getTrainDirection() & this._track.getTrainDirections()) == 0 || this._track != null && !this._track.isDropTrainAccepted(train) || this._track != null && !this.typeComboBoxSelect.equals("") && !this._track.checkScheduleAttribute(Track.TYPE, this.typeComboBoxSelect, null))) {
                    setout = true;
                }
                if (this.showAllTrainsCheckBox.isSelected() || pickup || setout) {
                    this.addItemLeft(this.pTrains, new JLabel(train.getName()), 0, y);
                    this.addItem(this.pTrains, new JLabel(rl.getTrainDirectionString()), 1, y);
                    if (pickup) {
                        this.addItem(this.pTrains, new JLabel(Bundle.getMessage("OkayPickUp")), 2, y);
                    } else {
                        this.addItem(this.pTrains, new JLabel(Bundle.getMessage("NoPickUp")), 2, y);
                    }
                    if (setout) {
                        this.addItem(this.pTrains, new JLabel(Bundle.getMessage("OkaySetOut")), 3, y);
                    } else {
                        this.addItem(this.pTrains, new JLabel(Bundle.getMessage("NoSetOut")), 3, y);
                    }
                }
                ++y;
            }
        }
        this.pTrains.repaint();
        this.pTrains.revalidate();
    }

    @Override
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="GUI ease of use")
    public void checkBoxActionPerformed(ActionEvent ae) {
        log.debug("check box action");
        isShowAllTrains = this.showAllTrainsCheckBox.isSelected();
        this.updateTrainPane();
    }

    @Override
    public void comboBoxActionPerformed(ActionEvent ae) {
        log.debug("combo box action select {}", this.typeComboBox.getSelectedItem());
        if (this.typeComboBox.isEnabled() && ae.getSource().equals(this.typeComboBox)) {
            if (this.typeComboBox.getSelectedItem() != null) {
                this.typeComboBoxSelect = (String)this.typeComboBox.getSelectedItem();
            }
            this.updateTrainPane();
        }
    }

    private void updateComboBox() {
        log.debug("update combobox");
        this.typeComboBox.setEnabled(false);
        InstanceManager.getDefault(CarTypes.class).updateComboBox(this.typeComboBox);
        int i = this.typeComboBox.getItemCount() - 1;
        while (i >= 0) {
            String type = this.typeComboBox.getItemAt(i);
            if (this._location != null && !this._location.acceptsTypeName(type)) {
                this.typeComboBox.removeItem(type);
            }
            if (this._track != null && !this._track.isTypeNameAccepted(type)) {
                this.typeComboBox.removeItem(type);
            }
            --i;
        }
        this.typeComboBox.insertItemAt("", 0);
        if (this.typeComboBoxSelect == null) {
            this.typeComboBox.setSelectedItem("");
        } else {
            this.typeComboBox.setSelectedItem(this.typeComboBoxSelect);
            if (this.typeComboBox.getSelectedItem() != null && !this.typeComboBox.getSelectedItem().equals(this.typeComboBoxSelect)) {
                this.typeComboBox.setSelectedItem("");
            }
        }
        this.typeComboBoxSelect = (String)this.typeComboBox.getSelectedItem();
        this.updateTrainPane();
        this.typeComboBox.setEnabled(true);
    }

    @Override
    public void dispose() {
        if (this._location != null) {
            this._location.removePropertyChangeListener(this);
        }
        if (this._track != null) {
            this._track.removePropertyChangeListener(this);
        }
        this.removePropertyChangeAllTrains();
        super.dispose();
    }

    public void addPropertyChangeAllTrains() {
        InstanceManager.getDefault(TrainManager.class).addPropertyChangeListener(this);
        for (Train train : InstanceManager.getDefault(TrainManager.class).getTrainsByNameList()) {
            train.addPropertyChangeListener(this);
        }
    }

    public void removePropertyChangeAllTrains() {
        InstanceManager.getDefault(TrainManager.class).removePropertyChangeListener(this);
        for (Train train : InstanceManager.getDefault(TrainManager.class).getTrainsByNameList()) {
            train.removePropertyChangeListener(this);
            if (train.getRoute() == null) continue;
            train.getRoute().removePropertyChangeListener(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("locationTypes") || e.getPropertyName().equals("trackRollingStockTypes")) {
            this.updateComboBox();
        }
        if (e.getPropertyName().equals("locationTrainDirection") || e.getPropertyName().equals("trackTrainDirection") || e.getPropertyName().equals("trackDrop") || e.getPropertyName().equals("trackPickup") || e.getPropertyName().equals("TrainRoute") || e.getPropertyName().equals("TrainTypes") || e.getPropertyName().equals("TrainStops") || e.getPropertyName().equals("routeListChange")) {
            this.updateTrainPane();
        }
        if (e.getPropertyName().equals("TrainsListLength")) {
            this.removePropertyChangeAllTrains();
            this.addPropertyChangeAllTrains();
        }
    }
}

