/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.tools;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.tools.Bundle;
import jmri.jmrit.operations.setup.Setup;
import jmri.util.PhysicalLocation;
import jmri.util.PhysicalLocationPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetPhysicalLocationFrame
extends OperationsFrame {
    LocationManager locationManager = InstanceManager.getDefault(LocationManager.class);
    Location _location;
    JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
    JButton closeButton = new JButton(Bundle.getMessage("Close"));
    JComboBox<Location> locationBox = InstanceManager.getDefault(LocationManager.class).getComboBox();
    PhysicalLocationPanel physicalLocation;
    private static final Logger log = LoggerFactory.getLogger(SetPhysicalLocationFrame.class);

    public SetPhysicalLocationFrame(Location l) {
        super(Bundle.getMessage("MenuSetPhysicalLocation"));
        this._location = l;
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.saveButton.setToolTipText(Bundle.getMessage("TipSaveButton"));
        this.closeButton.setToolTipText(Bundle.getMessage("TipCloseButton"));
        JPanel pLocation = new JPanel();
        pLocation.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Location")));
        pLocation.add(this.locationBox);
        this.physicalLocation = new PhysicalLocationPanel(Bundle.getMessage("PhysicalLocation"));
        this.physicalLocation.setToolTipText(Bundle.getMessage("PhysicalLocationToolTip"));
        this.physicalLocation.setVisible(true);
        JPanel pControl = new JPanel();
        pControl.setLayout(new GridBagLayout());
        pControl.setBorder(BorderFactory.createTitledBorder(""));
        this.addItem(pControl, this.saveButton, 1, 0);
        this.addItem(pControl, this.closeButton, 2, 0);
        this.getContentPane().add(pLocation);
        this.getContentPane().add(this.physicalLocation);
        this.getContentPane().add(pControl);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_SetTrainIconCoordinates", true);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SetPhysicalLocationFrame.this.saveButtonActionPerformed(e);
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SetPhysicalLocationFrame.this.closeButtonActionPerformed(e);
            }
        });
        this.addComboBoxAction(this.locationBox);
        if (this._location != null) {
            this.locationBox.setSelectedItem(this._location);
        }
        this.initMinimumSize(new Dimension(400, 250));
    }

    public void closeButtonActionPerformed(ActionEvent ae) {
        this.dispose();
    }

    public void saveButtonActionPerformed(ActionEvent ae) {
        if (this.locationBox.getSelectedItem() == null) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("SelectLocationToEdit"), Bundle.getMessage("NoLocationSelected"), 0);
            return;
        }
        Location l = (Location)this.locationBox.getSelectedItem();
        if (l == null) {
            return;
        }
        if (ae.getSource() == this.saveButton) {
            int value = JOptionPane.showConfirmDialog(this, MessageFormat.format(Bundle.getMessage("UpdatePhysicalLocation"), l.getName()), Bundle.getMessage("UpdateDefaults"), 0);
            if (value == 0) {
                this.saveSpinnerValues(l);
            }
            OperationsXml.save();
            if (Setup.isCloseWindowOnSaveEnabled()) {
                this.dispose();
            }
        }
    }

    @Override
    public void comboBoxActionPerformed(ActionEvent ae) {
        if (this.locationBox.getSelectedItem() == null) {
            this.resetSpinners();
        } else {
            Location l = (Location)this.locationBox.getSelectedItem();
            this.loadSpinners(l);
        }
    }

    @Override
    public void spinnerChangeEvent(ChangeEvent ae) {
        Location l;
        if (ae.getSource() == this.physicalLocation && (l = (Location)this.locationBox.getSelectedItem()) != null) {
            l.setPhysicalLocation(this.physicalLocation.getValue());
        }
    }

    private void resetSpinners() {
        this.physicalLocation.setValue(new PhysicalLocation());
    }

    private void loadSpinners(Location l) {
        log.debug("Load spinners location {}", (Object)l.getName());
        this.physicalLocation.setValue(l.getPhysicalLocation());
    }

    private void saveSpinnerValues(Location l) {
        log.debug("Save physical coordinates for location {}", (Object)l.getName());
        l.setPhysicalLocation(this.physicalLocation.getValue());
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}

