/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.tools;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractAction;
import jmri.InstanceManager;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.tools.Bundle;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.setup.Control;
import jmri.util.davidflanagan.HardcopyWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintLocationsByCarTypesAction
extends AbstractAction {
    static final String NEW_LINE = "\n";
    static final String TAB = "\t";
    boolean isPreview;
    private static final Logger log = LoggerFactory.getLogger(PrintLocationsByCarTypesAction.class);

    public PrintLocationsByCarTypesAction(boolean preview) {
        super(preview ? Bundle.getMessage("MenuItemPreviewByType") : Bundle.getMessage("MenuItemPrintByType"));
        this.isPreview = preview;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.print();
    }

    private void print() {
        HardcopyWriter writer;
        try {
            writer = new HardcopyWriter(new Frame(), Bundle.getMessage("TitleLocationsByType"), Control.reportFontSize, 0.5, 0.5, 0.5, 0.5, this.isPreview);
        }
        catch (HardcopyWriter.PrintCanceledException printCanceledException) {
            log.debug("Print cancelled");
            return;
        }
        String[] carTypes = InstanceManager.getDefault(CarTypes.class).getNames();
        List<Location> locations = InstanceManager.getDefault(LocationManager.class).getLocationsByNameList();
        try {
            String s = String.valueOf(Bundle.getMessage("Type")) + TAB + Bundle.getMessage("Location") + TAB + Bundle.getMessage("Track") + NEW_LINE;
            writer.write(s);
            String[] stringArray = carTypes;
            int n = carTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String type = stringArray[n2];
                s = String.valueOf(type) + NEW_LINE;
                writer.write(s);
                for (Location location : locations) {
                    if (!location.acceptsTypeName(type)) continue;
                    s = TAB + location.getName() + NEW_LINE;
                    writer.write(s);
                    List<Track> tracks = location.getTracksByNameList(null);
                    for (Track track : tracks) {
                        if (!track.isTypeNameAccepted(type)) continue;
                        s = "\t\t\t" + track.getName() + NEW_LINE;
                        writer.write(s);
                    }
                }
                ++n2;
            }
        }
        catch (IOException we) {
            log.error("Error printing PrintLocationAction: {}", (Throwable)we);
        }
        writer.close();
    }
}

