/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.tools;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.schedules.Schedule;
import jmri.jmrit.operations.locations.schedules.ScheduleItem;
import jmri.jmrit.operations.locations.schedules.ScheduleManager;
import jmri.jmrit.operations.locations.tools.Bundle;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarLoads;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.rollingstock.cars.CarRoads;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.rollingstock.engines.EngineTypes;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteManager;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainCommon;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.util.davidflanagan.HardcopyWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintLocationsAction
extends AbstractAction {
    static final String NEW_LINE = "\n";
    static final String FORM_FEED = "\f";
    static final String TAB = "\t";
    static final int TAB_LENGTH = 10;
    static final String SPACE = "   ";
    static final int MAX_NAME_LENGTH = Control.max_len_string_location_name;
    LocationManager lmanager = InstanceManager.getDefault(LocationManager.class);
    CarTypes cts = InstanceManager.getDefault(CarTypes.class);
    CarLoads cls = InstanceManager.getDefault(CarLoads.class);
    CarRoads crs = InstanceManager.getDefault(CarRoads.class);
    boolean _isPreview;
    Location _location = null;
    HardcopyWriter writer;
    LocationPrintOptionFrame lpof = null;
    private int charactersPerLine = 70;
    private final boolean showStaging = false;
    JCheckBox printLocations = new JCheckBox(Bundle.getMessage("PrintLocations"));
    JCheckBox printSchedules = new JCheckBox(Bundle.getMessage("PrintSchedules"));
    JCheckBox printComments = new JCheckBox(Bundle.getMessage("PrintComments"));
    JCheckBox printDetails = new JCheckBox(Bundle.getMessage("PrintDetails"));
    JCheckBox printAnalysis = new JCheckBox(Bundle.getMessage("PrintAnalysis"));
    JCheckBox printErrorAnalysis = new JCheckBox(Bundle.getMessage("PrintErrorAnalysis"));
    private static final Logger log = LoggerFactory.getLogger(PrintLocationsAction.class);

    public PrintLocationsAction(boolean isPreview) {
        super(isPreview ? Bundle.getMessage("MenuItemPreview") : Bundle.getMessage("MenuItemPrint"));
        this._isPreview = isPreview;
    }

    public PrintLocationsAction(boolean isPreview, Location location) {
        super(isPreview ? Bundle.getMessage("MenuItemPreview") : Bundle.getMessage("MenuItemPrint"));
        this._isPreview = isPreview;
        this._location = location;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.lpof == null) {
            this.lpof = new LocationPrintOptionFrame(this);
        } else {
            this.lpof.setVisible(true);
        }
        this.lpof.initComponents();
    }

    public void printLocations() {
        String title = Bundle.getMessage("TitleLocationsTable");
        if (this._location != null) {
            title = this._location.getName();
        }
        try {
            this.writer = new HardcopyWriter(new Frame(), title, Control.reportFontSize, 0.5, 0.5, 0.5, 0.5, this._isPreview);
        }
        catch (HardcopyWriter.PrintCanceledException printCanceledException) {
            log.debug("Print cancelled");
            return;
        }
        this.charactersPerLine = this.writer.getCharactersPerLine();
        try {
            if (this.printLocations.isSelected()) {
                this.printLocationsSelected();
            }
            if (this.printSchedules.isSelected()) {
                this.printSchedulesSelected();
            }
            if (this.printComments.isSelected()) {
                this.printCommentsSelected();
            }
            if (this.printDetails.isSelected()) {
                this.printDetailsSelected();
            }
            if (this.printAnalysis.isSelected()) {
                this.printAnalysisSelected();
            }
            if (this.printErrorAnalysis.isSelected()) {
                this.printErrorAnalysisSelected();
            }
            if (this.printLocations.isSelected() || this.printSchedules.isSelected() || this.printComments.isSelected() || this.printDetails.isSelected() || this.printAnalysis.isSelected() || this.printErrorAnalysis.isSelected()) {
                this.writer.close();
            }
        }
        catch (IOException we) {
            log.error("Error printing PrintLocationAction: {}", (Throwable)we);
        }
    }

    private void printLocationsSelected() throws IOException {
        List<Location> locations = this.lmanager.getLocationsByNameList();
        int totalLength = 0;
        int usedLength = 0;
        int numberRS = 0;
        int numberCars = 0;
        int numberEngines = 0;
        String s = String.valueOf(Bundle.getMessage("Location")) + TAB + TAB + TAB + Bundle.getMessage("Length") + " " + Bundle.getMessage("Used") + TAB + Bundle.getMessage("RS") + TAB + Bundle.getMessage("Cars") + TAB + Bundle.getMessage("Engines") + TAB + Bundle.getMessage("Pickups") + " " + Bundle.getMessage("Drop") + NEW_LINE;
        this.writer.write(s);
        for (Location location : locations) {
            List<Track> stagingTracks;
            List<Track> interchanges;
            List<Track> spurs;
            if (this._location != null && location != this._location) continue;
            s = String.valueOf(this.padOutString(location.getName(), Control.max_len_string_location_name)) + TAB + "  " + Integer.toString(location.getLength()) + TAB + Integer.toString(location.getUsedLength()) + TAB + Integer.toString(location.getNumberRS()) + TAB + Integer.toString(location.getNumberCars()) + TAB + Integer.toString(location.getNumberEngines()) + TAB + Integer.toString(location.getPickupRS()) + TAB + Integer.toString(location.getDropRS()) + NEW_LINE;
            this.writer.write(s);
            if (location.getDivision() != null) {
                this.writer.write(SPACE + Bundle.getMessage("Division") + ": " + location.getDivisionName() + NEW_LINE);
            }
            totalLength += location.getLength();
            usedLength += location.getUsedLength();
            numberRS += location.getNumberRS();
            List<Track> yards = location.getTracksByNameList("Yard");
            if (yards.size() > 0) {
                this.writer.write(SPACE + Bundle.getMessage("YardName") + NEW_LINE);
                for (Track yard : yards) {
                    this.writer.write(this.getTrackString(yard));
                    numberCars += yard.getNumberCars();
                    numberEngines += yard.getNumberEngines();
                }
            }
            if ((spurs = location.getTracksByNameList("Spur")).size() > 0) {
                this.writer.write(SPACE + Bundle.getMessage("SpurName") + NEW_LINE);
                for (Track spur : spurs) {
                    this.writer.write(this.getTrackString(spur));
                    numberCars += spur.getNumberCars();
                    numberEngines += spur.getNumberEngines();
                }
            }
            if ((interchanges = location.getTracksByNameList("Interchange")).size() > 0) {
                this.writer.write(SPACE + Bundle.getMessage("InterchangeName") + NEW_LINE);
                for (Track interchange : interchanges) {
                    this.writer.write(this.getTrackString(interchange));
                    numberCars += interchange.getNumberCars();
                    numberEngines += interchange.getNumberEngines();
                }
            }
            if ((stagingTracks = location.getTracksByNameList("Staging")).size() > 0) {
                this.writer.write(SPACE + Bundle.getMessage("StagingName") + NEW_LINE);
                for (Track staging : stagingTracks) {
                    this.writer.write(this.getTrackString(staging));
                    numberCars += staging.getNumberCars();
                    numberEngines += staging.getNumberEngines();
                }
            }
            this.writer.write(NEW_LINE);
        }
        s = String.valueOf(MessageFormat.format(Bundle.getMessage("TotalLengthMsg"), Integer.toString(totalLength), Integer.toString(usedLength), totalLength > 0 ? Integer.toString(usedLength * 100 / totalLength) : Integer.valueOf(0))) + NEW_LINE;
        this.writer.write(s);
        s = String.valueOf(MessageFormat.format(Bundle.getMessage("TotalRollingMsg"), Integer.toString(numberRS), Integer.toString(numberCars), Integer.toString(numberEngines))) + NEW_LINE;
        this.writer.write(s);
        if (numberRS != numberCars + numberEngines) {
            s = String.valueOf(MessageFormat.format(Bundle.getMessage("NoteRSMsg"), Integer.toString(numberRS - (numberCars + numberEngines)))) + NEW_LINE;
            this.writer.write(s);
        }
        if (this.printSchedules.isSelected() || this.printComments.isSelected() || this.printDetails.isSelected() || this.printAnalysis.isSelected() || this.printErrorAnalysis.isSelected()) {
            this.writer.write(FORM_FEED);
        }
    }

    private void printSchedulesSelected() throws IOException {
        List<Location> locations = this.lmanager.getLocationsByNameList();
        String s = String.valueOf(this.padOutString(Bundle.getMessage("Schedules"), MAX_NAME_LENGTH)) + " " + Bundle.getMessage("Location") + " - " + Bundle.getMessage("SpurName") + NEW_LINE;
        this.writer.write(s);
        List<Schedule> schedules = InstanceManager.getDefault(ScheduleManager.class).getSchedulesByNameList();
        for (Schedule schedule : schedules) {
            for (Location location : locations) {
                if (this._location != null && location != this._location) continue;
                List<Track> spurs = location.getTracksByNameList("Spur");
                for (Track spur : spurs) {
                    if (!spur.getScheduleId().equals(schedule.getId())) continue;
                    s = String.valueOf(this.padOutString(schedule.getName(), MAX_NAME_LENGTH)) + " " + location.getName() + " - " + spur.getName();
                    String status = spur.checkScheduleValid();
                    if (!status.equals("")) {
                        StringBuffer buf = new StringBuffer(s);
                        int m = s.length();
                        while (m < 63) {
                            buf.append(" ");
                            ++m;
                        }
                        s = buf.toString();
                        if (s.length() > 63) {
                            s = s.substring(0, 63);
                        }
                        s = String.valueOf(s) + TAB + status;
                    }
                    s = String.valueOf(s) + NEW_LINE;
                    this.writer.write(s);
                    s = String.valueOf(this.padOutString("", MAX_NAME_LENGTH)) + SPACE + Bundle.getMessage("ScheduleMode") + ": " + spur.getScheduleModeName() + NEW_LINE;
                    this.writer.write(s);
                    if (spur.getAlternateTrack() != null) {
                        s = String.valueOf(this.padOutString("", MAX_NAME_LENGTH)) + SPACE + MessageFormat.format(Bundle.getMessage("AlternateTrackName"), spur.getAlternateTrack().getName()) + NEW_LINE;
                        this.writer.write(s);
                    }
                    if (spur.getReservationFactor() == 100) continue;
                    s = String.valueOf(this.padOutString("", MAX_NAME_LENGTH)) + SPACE + MessageFormat.format(Bundle.getMessage("PercentageStaging"), spur.getReservationFactor()) + NEW_LINE;
                    this.writer.write(s);
                }
            }
        }
        for (Schedule schedule : schedules) {
            this.writer.write(FORM_FEED);
            s = String.valueOf(schedule.getName()) + NEW_LINE;
            this.writer.write(s);
            for (ScheduleItem si : schedule.getItemsBySequenceList()) {
                s = String.valueOf(this.padOutString(Bundle.getMessage("Type"), this.cts.getMaxNameLength() + 1)) + this.padOutString(Bundle.getMessage("Receive"), this.cls.getMaxNameLength() + 1) + this.padOutString(Bundle.getMessage("Ship"), this.cls.getMaxNameLength() + 1) + this.padOutString(Bundle.getMessage("Destination"), this.lmanager.getMaxLocationNameLength() + 1) + Bundle.getMessage("Track") + NEW_LINE;
                this.writer.write(s);
                s = String.valueOf(this.padOutString(si.getTypeName(), this.cts.getMaxNameLength() + 1)) + this.padOutString(si.getReceiveLoadName(), this.cls.getMaxNameLength() + 1) + this.padOutString(si.getShipLoadName(), this.cls.getMaxNameLength() + 1) + this.padOutString(si.getDestinationName(), this.lmanager.getMaxLocationNameLength() + 1) + si.getDestinationTrackName() + NEW_LINE;
                this.writer.write(s);
                s = String.valueOf(this.padOutString("", this.cts.getMaxNameLength() + 1)) + this.padOutString(Bundle.getMessage("Random"), Bundle.getMessage("Random").length() + 1) + this.padOutString(Bundle.getMessage("Delivery"), Bundle.getMessage("Delivery").length() + 1) + this.padOutString(Bundle.getMessage("Road"), this.crs.getMaxNameLength() + 1) + this.padOutString(Bundle.getMessage("Pickup"), Bundle.getMessage("Delivery").length() + 1) + Bundle.getMessage("Wait") + NEW_LINE;
                this.writer.write(s);
                s = String.valueOf(this.padOutString("", this.cts.getMaxNameLength() + 1)) + this.padOutString(si.getRandom(), Bundle.getMessage("Random").length() + 1) + this.padOutString(si.getSetoutTrainScheduleName(), Bundle.getMessage("Delivery").length() + 1) + this.padOutString(si.getRoadName(), this.crs.getMaxNameLength() + 1) + this.padOutString(si.getPickupTrainScheduleName(), Bundle.getMessage("Delivery").length() + 1) + si.getWait() + NEW_LINE;
                this.writer.write(s);
            }
        }
        if (this.printComments.isSelected() || this.printDetails.isSelected() || this.printAnalysis.isSelected() || this.printErrorAnalysis.isSelected()) {
            this.writer.write(FORM_FEED);
        }
    }

    private void printCommentsSelected() throws IOException {
        String s = String.valueOf(Bundle.getMessage("PrintComments")) + NEW_LINE + NEW_LINE;
        this.writer.write(s);
        List<Location> locations = this.lmanager.getLocationsByNameList();
        for (Location location : locations) {
            if (this._location != null && location != this._location) continue;
            s = String.valueOf(location.getName()) + NEW_LINE;
            this.writer.write(s);
            s = SPACE + location.getComment() + NEW_LINE;
            this.writer.write(s);
            for (Track track : location.getTracksByNameList(null)) {
                if (track.getComment().equals("") && track.getCommentBoth().equals("") && track.getCommentPickup().equals("") && track.getCommentSetout().equals("")) continue;
                s = SPACE + track.getName() + NEW_LINE;
                this.writer.write(s);
                if (!track.getComment().equals("")) {
                    s = "      " + track.getComment() + NEW_LINE;
                    this.writer.write(s);
                }
                if (!track.getCommentBoth().equals("")) {
                    s = "      " + Bundle.getMessage("CommentBoth") + ":" + NEW_LINE;
                    this.writer.write(s);
                    s = "      " + track.getCommentBoth() + NEW_LINE;
                    this.writer.write(s);
                }
                if (!track.getCommentPickup().equals("")) {
                    s = "      " + Bundle.getMessage("CommentPickup") + ":" + NEW_LINE;
                    this.writer.write(s);
                    s = "      " + track.getCommentPickup() + NEW_LINE;
                    this.writer.write(s);
                }
                if (track.getCommentSetout().equals("")) continue;
                s = "      " + Bundle.getMessage("CommentSetout") + ":" + NEW_LINE;
                this.writer.write(s);
                s = "      " + track.getCommentSetout() + NEW_LINE;
                this.writer.write(s);
            }
        }
        if (this.printDetails.isSelected() || this.printAnalysis.isSelected() || this.printErrorAnalysis.isSelected()) {
            this.writer.write(FORM_FEED);
        }
    }

    private void printDetailsSelected() throws IOException {
        List<Location> locations = this.lmanager.getLocationsByNameList();
        String s = String.valueOf(Bundle.getMessage("DetailedReport")) + NEW_LINE;
        this.writer.write(s);
        for (Location location : locations) {
            List<Track> stagings;
            List<Track> interchanges;
            List<Track> spurs;
            if (this._location != null && location != this._location) continue;
            String name = location.getName();
            int dir = location.getTrainDirections();
            s = NEW_LINE + name + this.getDirection(dir);
            this.writer.write(s);
            s = this.getLocationTypes(location);
            this.writer.write(s);
            List<Track> yards = location.getTracksByNameList("Yard");
            if (yards.size() > 0) {
                s = SPACE + Bundle.getMessage("YardName") + NEW_LINE;
                this.writer.write(s);
                this.printTrackInfo(location, yards);
            }
            if ((spurs = location.getTracksByNameList("Spur")).size() > 0) {
                s = SPACE + Bundle.getMessage("SpurName") + NEW_LINE;
                this.writer.write(s);
                this.printTrackInfo(location, spurs);
            }
            if ((interchanges = location.getTracksByNameList("Interchange")).size() > 0) {
                s = SPACE + Bundle.getMessage("InterchangeName") + NEW_LINE;
                this.writer.write(s);
                this.printTrackInfo(location, interchanges);
            }
            if ((stagings = location.getTracksByNameList("Staging")).size() <= 0) continue;
            s = SPACE + Bundle.getMessage("StagingName") + NEW_LINE;
            this.writer.write(s);
            this.printTrackInfo(location, stagings);
        }
        if (this.printAnalysis.isSelected() || this.printErrorAnalysis.isSelected()) {
            this.writer.write(FORM_FEED);
        }
    }

    private void printAnalysisSelected() throws IOException {
        CarManager carManager = InstanceManager.getDefault(CarManager.class);
        List<Location> locations = this.lmanager.getLocationsByNameList();
        List<Car> cars = carManager.getByLocationList();
        String[] carTypes = this.cts.getNames();
        String s = String.valueOf(Bundle.getMessage("TrackAnalysis")) + NEW_LINE;
        this.writer.write(s);
        String[] stringArray = carTypes;
        int n = carTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            int numberOfCars = 0;
            int totalTrackLength = 0;
            for (Car car : cars) {
                if (!car.getTypeName().equals(type) || car.getLocation() == null) continue;
                ++numberOfCars;
                totalTrackLength += car.getTotalLength();
            }
            this.writer.write(String.valueOf(MessageFormat.format(Bundle.getMessage("NumberTypeLength"), numberOfCars, type, totalTrackLength, Setup.getLengthUnit().toLowerCase())) + NEW_LINE);
            if (numberOfCars > 0) {
                this.writer.write(SPACE + MessageFormat.format(Bundle.getMessage("SpurTrackThatAccept"), type) + NEW_LINE);
                int trackLength = this.getTrackLengthAcceptType(locations, type, "Spur");
                if (trackLength > 0) {
                    this.writer.write(SPACE + MessageFormat.format(Bundle.getMessage("TotalLengthSpur"), type, trackLength, Setup.getLengthUnit().toLowerCase(), 100 * totalTrackLength / trackLength) + NEW_LINE);
                } else {
                    this.writer.write(SPACE + Bundle.getMessage("None") + NEW_LINE);
                }
                this.writer.write(SPACE + MessageFormat.format(Bundle.getMessage("YardTrackThatAccept"), type) + NEW_LINE);
                trackLength = this.getTrackLengthAcceptType(locations, type, "Yard");
                if (trackLength > 0) {
                    this.writer.write(SPACE + MessageFormat.format(Bundle.getMessage("TotalLengthYard"), type, trackLength, Setup.getLengthUnit().toLowerCase(), 100 * totalTrackLength / trackLength) + NEW_LINE);
                } else {
                    this.writer.write(SPACE + Bundle.getMessage("None") + NEW_LINE);
                }
                this.writer.write(SPACE + MessageFormat.format(Bundle.getMessage("InterchangesThatAccept"), type) + NEW_LINE);
                trackLength = this.getTrackLengthAcceptType(locations, type, "Interchange");
                if (trackLength > 0) {
                    this.writer.write(SPACE + MessageFormat.format(Bundle.getMessage("TotalLengthInterchange"), type, trackLength, Setup.getLengthUnit().toLowerCase(), 100 * totalTrackLength / trackLength) + NEW_LINE);
                } else {
                    this.writer.write(SPACE + Bundle.getMessage("None") + NEW_LINE);
                }
            }
            ++n2;
        }
        if (this.printErrorAnalysis.isSelected()) {
            this.writer.write(FORM_FEED);
        }
    }

    private void printErrorAnalysisSelected() throws IOException {
        this.writer.write(String.valueOf(Bundle.getMessage("TrackErrorAnalysis")) + NEW_LINE);
        boolean foundError = false;
        for (Location location : this.lmanager.getLocationsByNameList()) {
            if (this._location != null && location != this._location) continue;
            this.writer.write(String.valueOf(location.getName()) + NEW_LINE);
            for (Track track : location.getTracksByNameList(null)) {
                if (track.checkPickups().equals("")) continue;
                this.writer.write(TAB + track.checkPickups() + NEW_LINE);
                foundError = true;
            }
        }
        if (!foundError) {
            this.writer.write(Bundle.getMessage("NoErrors"));
        }
    }

    private int getTrackLengthAcceptType(List<Location> locations, String carType, String trackType) throws IOException {
        int trackLength = 0;
        for (Location location : locations) {
            if (this._location != null && location != this._location) continue;
            List<Track> tracks = location.getTracksByNameList(trackType);
            for (Track track : tracks) {
                if (!track.isTypeNameAccepted(carType)) continue;
                trackLength += track.getLength();
                this.writer.write("      " + MessageFormat.format(Bundle.getMessage("LocationTrackLength"), location.getName(), track.getName(), track.getLength(), Setup.getLengthUnit().toLowerCase()) + NEW_LINE);
            }
        }
        return trackLength;
    }

    private String getTrackString(Track track) {
        String s = TAB + this.padOutString(track.getName(), Control.max_len_string_track_name) + " " + Integer.toString(track.getLength()) + TAB + Integer.toString(track.getUsedLength()) + TAB + Integer.toString(track.getNumberRS()) + TAB + Integer.toString(track.getNumberCars()) + TAB + Integer.toString(track.getNumberEngines()) + TAB + Integer.toString(track.getPickupRS()) + TAB + Integer.toString(track.getDropRS()) + NEW_LINE;
        return s;
    }

    private String getDirection(int dir) {
        if ((Setup.getTrainDirection() & dir) == 0) {
            return " " + Bundle.getMessage("LocalOnly") + NEW_LINE;
        }
        StringBuffer direction = new StringBuffer(" " + Bundle.getMessage("ServicedByTrain") + " ");
        if ((Setup.getTrainDirection() & dir & 4) == 4) {
            direction.append(String.valueOf(Bundle.getMessage("North")) + " ");
        }
        if ((Setup.getTrainDirection() & dir & 8) == 8) {
            direction.append(String.valueOf(Bundle.getMessage("South")) + " ");
        }
        if ((Setup.getTrainDirection() & dir & 1) == 1) {
            direction.append(String.valueOf(Bundle.getMessage("East")) + " ");
        }
        if ((Setup.getTrainDirection() & dir & 2) == 2) {
            direction.append(String.valueOf(Bundle.getMessage("West")) + " ");
        }
        direction.append(NEW_LINE);
        return direction.toString();
    }

    private void printTrackInfo(Location location, List<Track> tracks) {
        for (Track track : tracks) {
            try {
                String s = TAB + track.getName() + this.getDirection(location.getTrainDirections() & track.getTrainDirections());
                this.writer.write(s);
                this.writer.write(this.getTrackTypes(location, track));
                this.writer.write(this.getTrackRoads(track));
                this.writer.write(this.getTrackLoads(track));
                this.writer.write(this.getTrackShipLoads(track));
                this.writer.write(this.getCarOrder(track));
                this.writer.write(this.getSetOutTrains(track));
                this.writer.write(this.getPickUpTrains(track));
                this.writer.write(this.getDestinations(track));
                this.writer.write(this.getSchedule(track));
                this.writer.write(this.getStagingInfo(track));
            }
            catch (IOException we) {
                log.error("Error printing PrintLocationAction: {}", (Throwable)we);
            }
        }
    }

    private String getLocationTypes(Location location) {
        String type;
        StringBuffer buf = new StringBuffer("\t\t" + Bundle.getMessage("TypesServiced") + NEW_LINE + TAB + TAB);
        int charCount = 0;
        int typeCount = 0;
        String[] stringArray = this.cts.getNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            type = stringArray[n2];
            if (location.acceptsTypeName(type)) {
                ++typeCount;
                if ((charCount += type.length() + 2) > this.charactersPerLine - 20) {
                    buf.append("\n\t\t");
                    charCount = type.length() + 2;
                }
                buf.append(String.valueOf(type) + ", ");
            }
            ++n2;
        }
        stringArray = InstanceManager.getDefault(EngineTypes.class).getNames();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            type = stringArray[n2];
            if (location.acceptsTypeName(type)) {
                ++typeCount;
                if ((charCount += type.length() + 2) > this.charactersPerLine - 20) {
                    buf.append("\n\t\t");
                    charCount = type.length() + 2;
                }
                buf.append(String.valueOf(type) + ", ");
            }
            ++n2;
        }
        if (buf.length() > 2) {
            buf.setLength(buf.length() - 2);
        }
        if (typeCount == this.cts.getNames().length + InstanceManager.getDefault(EngineTypes.class).getNames().length) {
            buf = new StringBuffer("\t\t" + Bundle.getMessage("LocationAcceptsAllTypes"));
        }
        buf.append(NEW_LINE);
        return buf.toString();
    }

    private String getTrackTypes(Location location, Track track) {
        String type;
        StringBuffer buf = new StringBuffer("\t\t" + Bundle.getMessage("TypesServicedTrack") + NEW_LINE + TAB + TAB);
        int charCount = 0;
        int typeCount = 0;
        String[] stringArray = this.cts.getNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            type = stringArray[n2];
            if (track.isTypeNameAccepted(type)) {
                ++typeCount;
                if ((charCount += type.length() + 2) > this.charactersPerLine - 20) {
                    buf.append("\n\t\t");
                    charCount = type.length() + 2;
                }
                buf.append(String.valueOf(type) + ", ");
            }
            ++n2;
        }
        stringArray = InstanceManager.getDefault(EngineTypes.class).getNames();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            type = stringArray[n2];
            if (track.isTypeNameAccepted(type)) {
                ++typeCount;
                if ((charCount += type.length() + 2) > this.charactersPerLine - 20) {
                    buf.append("\n\t\t");
                    charCount = type.length() + 2;
                }
                buf.append(String.valueOf(type) + ", ");
            }
            ++n2;
        }
        if (buf.length() > 2) {
            buf.setLength(buf.length() - 2);
        }
        if (typeCount == this.cts.getNames().length + InstanceManager.getDefault(EngineTypes.class).getNames().length) {
            buf = new StringBuffer("\t\t" + Bundle.getMessage("TrackAcceptsAllTypes"));
        }
        buf.append(NEW_LINE);
        return buf.toString();
    }

    private String getTrackRoads(Track track) {
        if (track.getRoadOption().equals(Track.ALL_ROADS)) {
            return "\t\t" + Bundle.getMessage("AcceptsAllRoads") + NEW_LINE;
        }
        String op = Bundle.getMessage("RoadsServicedTrack");
        if (track.getRoadOption().equals(Track.EXCLUDE_ROADS)) {
            op = Bundle.getMessage("ExcludeRoadsTrack");
        }
        StringBuffer buf = new StringBuffer("\t\t" + op + NEW_LINE + TAB + TAB);
        int charCount = 0;
        String[] stringArray = track.getRoadNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String road = stringArray[n2];
            if ((charCount += road.length() + 2) > this.charactersPerLine - 20) {
                buf.append("\n\t\t");
                charCount = road.length() + 2;
            }
            buf.append(String.valueOf(road) + ", ");
            ++n2;
        }
        if (buf.length() > 2) {
            buf.setLength(buf.length() - 2);
        }
        buf.append(NEW_LINE);
        return buf.toString();
    }

    private String getTrackLoads(Track track) {
        if (track.getLoadOption().equals(Track.ALL_LOADS)) {
            return "\t\t" + Bundle.getMessage("AcceptsAllLoads") + NEW_LINE;
        }
        String op = Bundle.getMessage("LoadsServicedTrack");
        if (track.getLoadOption().equals(Track.EXCLUDE_LOADS)) {
            op = Bundle.getMessage("ExcludeLoadsTrack");
        }
        StringBuffer buf = new StringBuffer("\t\t" + op + NEW_LINE + TAB + TAB);
        int charCount = 0;
        String[] stringArray = track.getLoadNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String load = stringArray[n2];
            if ((charCount += load.length() + 2) > this.charactersPerLine - 20) {
                buf.append("\n\t\t");
                charCount = load.length() + 2;
            }
            buf.append(String.valueOf(load) + ", ");
            ++n2;
        }
        if (buf.length() > 2) {
            buf.setLength(buf.length() - 2);
        }
        buf.append(NEW_LINE);
        return buf.toString();
    }

    private String getTrackShipLoads(Track track) {
        if (!track.isStaging()) {
            return "";
        }
        if (track.getShipLoadOption().equals(Track.ALL_LOADS)) {
            return "\t\t" + Bundle.getMessage("ShipsAllLoads") + NEW_LINE;
        }
        String op = Bundle.getMessage("LoadsShippedTrack");
        if (track.getShipLoadOption().equals(Track.EXCLUDE_LOADS)) {
            op = Bundle.getMessage("ExcludeLoadsShippedTrack");
        }
        StringBuffer buf = new StringBuffer("\t\t" + op + NEW_LINE + TAB + TAB);
        int charCount = 0;
        String[] stringArray = track.getShipLoadNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String load = stringArray[n2];
            if ((charCount += load.length() + 2) > this.charactersPerLine - 20) {
                buf.append("\n\t\t");
                charCount = load.length() + 2;
            }
            buf.append(String.valueOf(load) + ", ");
            ++n2;
        }
        if (buf.length() > 2) {
            buf.setLength(buf.length() - 2);
        }
        buf.append(NEW_LINE);
        return buf.toString();
    }

    private String getCarOrder(Track track) {
        if (track.isSpur() || track.isStaging() || track.getServiceOrder().equals(Track.NORMAL)) {
            return "";
        }
        if (track.getServiceOrder().equals(Track.FIFO)) {
            return "\t\t" + Bundle.getMessage("TrackPickUpOrderFIFO") + NEW_LINE;
        }
        return "\t\t" + Bundle.getMessage("TrackPickUpOrderLIFO") + NEW_LINE;
    }

    private String getSetOutTrains(Track track) {
        StringBuffer buf;
        if (track.getDropOption().equals("Any")) {
            return "\t\t" + Bundle.getMessage("SetOutAllTrains") + NEW_LINE;
        }
        int charCount = 0;
        String[] ids = track.getDropIds();
        if (track.getDropOption().equals("trains") || track.getDropOption().equals("excludeTrains")) {
            String trainType = Bundle.getMessage("TrainsSetOutTrack");
            if (track.getDropOption().equals("excludeTrains")) {
                trainType = Bundle.getMessage("ExcludeTrainsSetOutTrack");
            }
            buf = new StringBuffer("\t\t" + trainType + NEW_LINE + TAB + TAB);
            String[] stringArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                Train train = InstanceManager.getDefault(TrainManager.class).getTrainById(id);
                if (train == null) {
                    log.info("Could not find a train for id: {} track ({})", (Object)id, (Object)track.getName());
                } else {
                    if ((charCount += train.getName().length() + 2) > this.charactersPerLine - 20) {
                        buf.append("\n\t\t");
                        charCount = train.getName().length() + 2;
                    }
                    buf.append(String.valueOf(train.getName()) + ", ");
                }
                ++n2;
            }
        } else {
            String routeType = Bundle.getMessage("RoutesSetOutTrack");
            if (track.getDropOption().equals("excludeRoutes")) {
                routeType = Bundle.getMessage("ExcludeRoutesSetOutTrack");
            }
            buf = new StringBuffer("\t\t" + routeType + NEW_LINE + TAB + TAB);
            String[] stringArray = ids;
            int n = ids.length;
            int n3 = 0;
            while (n3 < n) {
                String id = stringArray[n3];
                Route route = InstanceManager.getDefault(RouteManager.class).getRouteById(id);
                if (route == null) {
                    log.info("Could not find a route for id: {} location ({}) track ({})", new Object[]{id, track.getLocation().getName(), track.getName()});
                } else {
                    if ((charCount += route.getName().length() + 2) > this.charactersPerLine - 20) {
                        buf.append("\n\t\t");
                        charCount = route.getName().length() + 2;
                    }
                    buf.append(String.valueOf(route.getName()) + ", ");
                }
                ++n3;
            }
        }
        if (buf.length() > 2) {
            buf.setLength(buf.length() - 2);
        }
        buf.append(NEW_LINE);
        return buf.toString();
    }

    private String getPickUpTrains(Track track) {
        StringBuffer buf;
        if (track.getPickupOption().equals("Any")) {
            return "\t\t" + Bundle.getMessage("PickUpAllTrains") + NEW_LINE;
        }
        int charCount = 0;
        String[] ids = track.getPickupIds();
        if (track.getPickupOption().equals("trains") || track.getPickupOption().equals("excludeTrains")) {
            String trainType = Bundle.getMessage("TrainsPickUpTrack");
            if (track.getPickupOption().equals("excludeTrains")) {
                trainType = Bundle.getMessage("ExcludeTrainsPickUpTrack");
            }
            buf = new StringBuffer("\t\t" + trainType + NEW_LINE + TAB + TAB);
            String[] stringArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                Train train = InstanceManager.getDefault(TrainManager.class).getTrainById(id);
                if (train == null) {
                    log.info("Could not find a train for id: {} track ({})", (Object)id, (Object)track.getName());
                } else {
                    if ((charCount += train.getName().length() + 2) > this.charactersPerLine - 20) {
                        buf.append("\n\t\t");
                        charCount = train.getName().length() + 2;
                    }
                    buf.append(String.valueOf(train.getName()) + ", ");
                }
                ++n2;
            }
        } else {
            String routeType = Bundle.getMessage("RoutesPickUpTrack");
            if (track.getPickupOption().equals("excludeRoutes")) {
                routeType = Bundle.getMessage("ExcludeRoutesPickUpTrack");
            }
            buf = new StringBuffer("\t\t" + routeType + NEW_LINE + TAB + TAB);
            String[] stringArray = ids;
            int n = ids.length;
            int n3 = 0;
            while (n3 < n) {
                String id = stringArray[n3];
                Route route = InstanceManager.getDefault(RouteManager.class).getRouteById(id);
                if (route == null) {
                    log.info("Could not find a route for id: {} location ({}) track ({})", new Object[]{id, track.getLocation().getName(), track.getName()});
                } else {
                    if ((charCount += route.getName().length() + 2) > this.charactersPerLine - 20) {
                        buf.append("\n\t\t");
                        charCount = route.getName().length() + 2;
                    }
                    buf.append(String.valueOf(route.getName()) + ", ");
                }
                ++n3;
            }
        }
        if (buf.length() > 2) {
            buf.setLength(buf.length() - 2);
        }
        buf.append(NEW_LINE);
        return buf.toString();
    }

    private String getDestinations(Track track) {
        if (track.getDestinationOption().equals(Track.ALL_DESTINATIONS)) {
            return "";
        }
        String op = String.valueOf(Bundle.getMessage("AcceptOnly")) + " " + track.getDestinationListSize() + " " + Bundle.getMessage("Destinations") + ":";
        if (track.getDestinationOption().equals(Track.EXCLUDE_DESTINATIONS)) {
            op = String.valueOf(Bundle.getMessage("Exclude")) + " " + (this.lmanager.getNumberOfLocations() - track.getDestinationListSize()) + " " + Bundle.getMessage("Destinations") + ":";
        }
        StringBuffer buf = new StringBuffer("\t\t" + op + NEW_LINE + TAB + TAB);
        String[] destIds = track.getDestinationIds();
        int charCount = 0;
        String[] stringArray = destIds;
        int n = destIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            Location location = this.lmanager.getLocationById(id);
            if (location != null) {
                if ((charCount += location.getName().length() + 2) > this.charactersPerLine - 20) {
                    buf.append("\n\t\t");
                    charCount = location.getName().length() + 2;
                }
                buf.append(String.valueOf(location.getName()) + ", ");
            }
            ++n2;
        }
        if (buf.length() > 2) {
            buf.setLength(buf.length() - 2);
        }
        buf.append(NEW_LINE);
        return buf.toString();
    }

    private String getSchedule(Track track) {
        if (!track.isSpur() || track.getSchedule() == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer("\t\t" + MessageFormat.format(Bundle.getMessage("TrackScheduleName"), track.getScheduleName()) + NEW_LINE);
        if (track.getAlternateTrack() != null) {
            buf.append("\t\t" + MessageFormat.format(Bundle.getMessage("AlternateTrackName"), track.getAlternateTrack().getName()) + NEW_LINE);
        }
        if (track.getReservationFactor() != 100) {
            buf.append("\t\t" + MessageFormat.format(Bundle.getMessage("PercentageStaging"), track.getReservationFactor()) + NEW_LINE);
        }
        return buf.toString();
    }

    private String getStagingInfo(Track track) {
        if (!track.isStaging()) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        if (track.isLoadSwapEnabled() || track.isLoadEmptyEnabled()) {
            buf.append("\t   " + Bundle.getMessage("OptionalLoads") + NEW_LINE);
            if (track.isLoadSwapEnabled()) {
                buf.append("\t\t" + Bundle.getMessage("SwapCarLoads") + NEW_LINE);
            }
            if (track.isLoadEmptyEnabled()) {
                buf.append("\t\t" + Bundle.getMessage("EmptyDefaultCarLoads") + NEW_LINE);
            }
        }
        if (track.isRemoveCustomLoadsEnabled() || track.isAddCustomLoadsEnabled() || track.isAddCustomLoadsAnySpurEnabled() || track.isAddCustomLoadsAnyStagingTrackEnabled()) {
            buf.append("\t   " + Bundle.getMessage("OptionalCustomLoads") + NEW_LINE);
            if (track.isRemoveCustomLoadsEnabled()) {
                buf.append("\t\t" + Bundle.getMessage("EmptyCarLoads") + NEW_LINE);
            }
            if (track.isAddCustomLoadsEnabled()) {
                buf.append("\t\t" + Bundle.getMessage("LoadCarLoads") + NEW_LINE);
            }
            if (track.isAddCustomLoadsAnySpurEnabled()) {
                buf.append("\t\t" + Bundle.getMessage("LoadAnyCarLoads") + NEW_LINE);
            }
            if (track.isAddCustomLoadsAnyStagingTrackEnabled()) {
                buf.append("\t\t" + Bundle.getMessage("LoadsStaging") + NEW_LINE);
            }
        }
        if (track.isBlockCarsEnabled()) {
            buf.append("\t   " + Bundle.getMessage("OptionalBlocking") + NEW_LINE);
            buf.append("\t\t" + Bundle.getMessage("BlockCars") + NEW_LINE);
        }
        buf.append(NEW_LINE);
        return buf.toString();
    }

    private String padOutString(String s, int length) {
        return TrainCommon.padAndTruncate(s, length);
    }

    public class LocationPrintOptionFrame
    extends OperationsFrame {
        PrintLocationsAction pla;
        JButton okayButton = new JButton(Bundle.getMessage("ButtonOK"));

        public LocationPrintOptionFrame(PrintLocationsAction pla) {
            this.pla = pla;
            JPanel pPanel = new JPanel();
            pPanel.setLayout(new GridBagLayout());
            pPanel.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("PrintOptions")));
            this.addItemLeft(pPanel, PrintLocationsAction.this.printLocations, 0, 0);
            this.addItemLeft(pPanel, PrintLocationsAction.this.printSchedules, 0, 3);
            this.addItemLeft(pPanel, PrintLocationsAction.this.printComments, 0, 5);
            this.addItemLeft(pPanel, PrintLocationsAction.this.printDetails, 0, 7);
            this.addItemLeft(pPanel, PrintLocationsAction.this.printAnalysis, 0, 9);
            this.addItemLeft(pPanel, PrintLocationsAction.this.printErrorAnalysis, 0, 11);
            PrintLocationsAction.this.printLocations.setSelected(true);
            PrintLocationsAction.this.printSchedules.setSelected(false);
            PrintLocationsAction.this.printComments.setSelected(false);
            PrintLocationsAction.this.printDetails.setSelected(false);
            PrintLocationsAction.this.printAnalysis.setSelected(false);
            PrintLocationsAction.this.printErrorAnalysis.setSelected(false);
            JPanel pButtons = new JPanel();
            pButtons.setLayout(new GridBagLayout());
            pButtons.add(this.okayButton);
            this.addButtonAction(this.okayButton);
            this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
            this.getContentPane().add(pPanel);
            this.getContentPane().add(pButtons);
            this.setPreferredSize(null);
            if (PrintLocationsAction.this._isPreview) {
                this.setTitle(Bundle.getMessage("MenuItemPreview"));
            } else {
                this.setTitle(Bundle.getMessage("MenuItemPrint"));
            }
            this.initMinimumSize(new Dimension(300, 250));
        }

        @Override
        public void initComponents() {
        }

        @Override
        public void buttonActionPerformed(ActionEvent ae) {
            this.setVisible(false);
            this.pla.printLocations();
        }
    }
}

