/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.tools;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.Pool;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.TrackEditFrame;
import jmri.jmrit.operations.locations.tools.Bundle;
import jmri.jmrit.operations.setup.Setup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PoolTrackFrame
extends OperationsFrame
implements PropertyChangeListener {
    JLabel name = new JLabel(Bundle.getMessage("Name"));
    JLabel minimum = new JLabel(Bundle.getMessage("Minimum"));
    JLabel maximum = new JLabel(Bundle.getMessage("Maximum"));
    JLabel length = new JLabel(Bundle.getMessage("Length"));
    JTextField trackPoolNameTextField = new JTextField(20);
    JTextField trackMinLengthTextField = new JTextField(5);
    JComboBox<Pool> comboBoxPools = new JComboBox();
    JButton addButton = new JButton(Bundle.getMessage("Add"));
    JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
    JPanel poolStatus = new JPanel();
    private TrackEditFrame _tefx;
    protected Track _track;
    protected Pool _pool;
    private static final Logger log = LoggerFactory.getLogger(PoolTrackFrame.class);

    public PoolTrackFrame(TrackEditFrame tef) {
        this._tefx = tef;
        this._track = this._tefx._track;
    }

    public PoolTrackFrame(Track track) {
        this._track = track;
    }

    @Override
    public void initComponents() {
        if (this._track == null) {
            log.debug("track is null, pools can not be created");
            return;
        }
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this._track.addPropertyChangeListener(this);
        this._track.getLocation().addPropertyChangeListener(this);
        this._pool = this._track.getPool();
        if (this._pool != null) {
            this._pool.addPropertyChangeListener(this);
        }
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 1));
        JScrollPane p1Pane = new JScrollPane(p1);
        p1Pane.setHorizontalScrollBarPolicy(31);
        p1Pane.setBorder(BorderFactory.createTitledBorder(""));
        JPanel pt = new JPanel();
        pt.setLayout(new BoxLayout(pt, 0));
        pt.setMaximumSize(new Dimension(2000, 250));
        JPanel pTrackName = new JPanel();
        pTrackName.setLayout(new GridBagLayout());
        pTrackName.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Track")));
        this.addItem(pTrackName, new JLabel(this._track.getName()), 0, 0);
        JPanel pLocationName = new JPanel();
        pLocationName.setLayout(new GridBagLayout());
        pLocationName.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Location")));
        this.addItem(pLocationName, new JLabel(this._track.getLocation().getName()), 0, 0);
        pt.add(pTrackName);
        pt.add(pLocationName);
        JPanel poolName = new JPanel();
        poolName.setLayout(new GridBagLayout());
        poolName.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("PoolName")));
        this.addItem(poolName, this.trackPoolNameTextField, 0, 0);
        this.addItem(poolName, this.addButton, 1, 0);
        JPanel selectPool = new JPanel();
        selectPool.setLayout(new GridBagLayout());
        selectPool.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("PoolSelect")));
        this.addItem(selectPool, this.comboBoxPools, 0, 0);
        JPanel minLengthTrack = new JPanel();
        minLengthTrack.setLayout(new GridBagLayout());
        minLengthTrack.setBorder(BorderFactory.createTitledBorder(MessageFormat.format(Bundle.getMessage("PoolTrackMinimum"), this._track.getName())));
        this.addItem(minLengthTrack, this.trackMinLengthTextField, 0, 0);
        this.trackMinLengthTextField.setText(Integer.toString(this._track.getMinimumLength()));
        JPanel savePool = new JPanel();
        savePool.setLayout(new GridBagLayout());
        savePool.setBorder(BorderFactory.createTitledBorder(""));
        this.addItem(savePool, this.saveButton, 0, 0);
        p1.add(pt);
        p1.add(poolName);
        p1.add(selectPool);
        p1.add(minLengthTrack);
        p1.add(savePool);
        JPanel p2 = new JPanel();
        p2.setLayout(new BoxLayout(p2, 1));
        JScrollPane p2Pane = new JScrollPane(p2);
        p2Pane.setHorizontalScrollBarPolicy(31);
        p2Pane.setBorder(BorderFactory.createTitledBorder(""));
        this.poolStatus.setLayout(new GridBagLayout());
        p2.add(this.poolStatus);
        this.getContentPane().add(p1Pane);
        this.getContentPane().add(p2Pane);
        this.setTitle(Bundle.getMessage("MenuItemPoolTrack"));
        this.updatePoolsComboBox();
        this.updatePoolStatus();
        this.addButtonAction(this.addButton);
        this.addButtonAction(this.saveButton);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_Pools", true);
        this.initMinimumSize(new Dimension(600, 300));
    }

    private void updatePoolsComboBox() {
        this._track.getLocation().updatePoolComboBox(this.comboBoxPools);
        this.comboBoxPools.setSelectedItem(this._track.getPool());
    }

    private void updatePoolStatus() {
        this.poolStatus.removeAll();
        this.addItemLeft(this.poolStatus, this.name, 0, 0);
        this.addItem(this.poolStatus, this.maximum, 1, 0);
        this.addItem(this.poolStatus, this.minimum, 2, 0);
        this.addItem(this.poolStatus, this.length, 3, 0);
        String poolName = "";
        if (this._track.getPool() != null) {
            Pool pool = this._track.getPool();
            poolName = pool.getName();
            List<Track> tracks = pool.getTracks();
            int totalMinLength = 0;
            int totalLength = 0;
            int i = 0;
            while (i < tracks.size()) {
                Track track = tracks.get(i);
                JLabel name = new JLabel();
                name.setText(track.getName());
                JLabel maximum = new JLabel();
                maximum.setText(Integer.toString(pool.getMaxLengthTrack(track)));
                JLabel minimum = new JLabel();
                minimum.setText(Integer.toString(track.getMinimumLength()));
                totalMinLength += track.getMinimumLength();
                JLabel length = new JLabel();
                length.setText(Integer.toString(track.getLength()));
                totalLength += track.getLength();
                this.addItemLeft(this.poolStatus, name, 0, i + 1);
                this.addItem(this.poolStatus, maximum, 1, i + 1);
                this.addItem(this.poolStatus, minimum, 2, i + 1);
                this.addItem(this.poolStatus, length, 3, i + 1);
                ++i;
            }
            JLabel total = new JLabel(Bundle.getMessage("Totals"));
            this.addItem(this.poolStatus, total, 0, tracks.size() + 1);
            JLabel totalMin = new JLabel();
            totalMin.setText(Integer.toString(totalMinLength));
            this.addItem(this.poolStatus, totalMin, 2, tracks.size() + 1);
            JLabel totalLen = new JLabel();
            totalLen.setText(Integer.toString(totalLength));
            this.addItem(this.poolStatus, totalLen, 3, tracks.size() + 1);
        }
        this.poolStatus.setBorder(BorderFactory.createTitledBorder(MessageFormat.format(Bundle.getMessage("PoolTracks"), poolName)));
        this.poolStatus.repaint();
        this.poolStatus.revalidate();
        this.setPreferredSize(null);
        this.pack();
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.addButton) {
            Location location = this._track.getLocation();
            location.addPool(this.trackPoolNameTextField.getText().trim());
        }
        if (ae.getSource() == this.saveButton) {
            try {
                this._track.setMinimumLength(Integer.parseInt(this.trackMinLengthTextField.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, Bundle.getMessage("TrackMustBeNumber"), Bundle.getMessage("ErrorTrackLength"), 0);
                return;
            }
            if (this._pool != null) {
                this._pool.removePropertyChangeListener(this);
            }
            this._pool = (Pool)this.comboBoxPools.getSelectedItem();
            if (this._pool != null) {
                this._pool.addPropertyChangeListener(this);
            }
            this._track.setPool(this._pool);
            OperationsXml.save();
            if (Setup.isCloseWindowOnSaveEnabled()) {
                this.dispose();
            }
        }
    }

    @Override
    public void dispose() {
        if (this._track != null) {
            this._track.removePropertyChangeListener(this);
            this._track.getLocation().removePropertyChangeListener(this);
        }
        if (this._pool != null) {
            this._pool.removePropertyChangeListener(this);
        }
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("poolLengthChanged")) {
            this.updatePoolsComboBox();
        }
        if (e.getPropertyName().equals("poolListChange") || e.getPropertyName().equals("locationTrackLengths") || e.getPropertyName().equals("trackPool") || e.getPropertyName().equals("trackMinLength")) {
            this.updatePoolStatus();
        }
    }
}

