/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.tools;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.tools.Bundle;
import jmri.jmrit.operations.locations.tools.PrintLocationsByCarTypesAction;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.setup.Setup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationsByCarTypeFrame
extends OperationsFrame
implements PropertyChangeListener {
    LocationManager manager;
    static final String EMPTY = "                 ";
    ArrayList<JCheckBox> locationCheckBoxList = new ArrayList();
    ArrayList<JCheckBox> trackCheckBoxList = new ArrayList();
    JPanel locationCheckBoxes = new JPanel();
    JPanel pLocations;
    JButton clearButton = new JButton(Bundle.getMessage("ClearAll"));
    JButton setButton = new JButton(Bundle.getMessage("SelectAll"));
    JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
    JCheckBox copyCheckBox = new JCheckBox(Bundle.getMessage("ButtonCopy"));
    JLabel textCarType = new JLabel("                 ");
    JComboBox<String> typeComboBox = InstanceManager.getDefault(CarTypes.class).getComboBox();
    Location _location;
    private static final Logger log = LoggerFactory.getLogger(LocationsByCarTypeFrame.class);

    @Override
    public void initComponents() {
        this.initComponents("");
    }

    public void initComponents(Location location) {
        this._location = location;
        this.initComponents("");
    }

    public void initComponents(Location location, String carType) {
        this._location = location;
        this.initComponents(carType);
    }

    public void initComponents(String carType) {
        this.manager = InstanceManager.getDefault(LocationManager.class);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel pCarType = new JPanel();
        pCarType.setLayout(new GridBagLayout());
        pCarType.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Type")));
        JPanel pCarCopy = new JPanel();
        pCarCopy.setLayout(new GridBagLayout());
        this.addItem(pCarCopy, this.textCarType, 0, 0);
        pCarCopy.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("CopyType")));
        this.addItem(pCarType, this.typeComboBox, 0, 0);
        this.addItem(pCarType, this.copyCheckBox, 1, 0);
        this.addItem(pCarType, pCarCopy, 2, 0);
        this.typeComboBox.setSelectedItem(carType);
        this.copyCheckBox.setToolTipText(Bundle.getMessage("TipCopyCarType"));
        this.pLocations = new JPanel();
        this.pLocations.setLayout(new GridBagLayout());
        JScrollPane locationPane = new JScrollPane(this.pLocations);
        locationPane.setVerticalScrollBarPolicy(20);
        locationPane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Locations")));
        this.updateLocations();
        JPanel pButtons = new JPanel();
        pButtons.setLayout(new GridBagLayout());
        pButtons.setBorder(BorderFactory.createTitledBorder(""));
        this.addItem(pButtons, this.clearButton, 0, 0);
        this.addItem(pButtons, this.setButton, 1, 0);
        this.addItem(pButtons, this.saveButton, 2, 0);
        this.getContentPane().add(pCarType);
        this.getContentPane().add(locationPane);
        this.getContentPane().add(pButtons);
        this.addComboBoxAction(this.typeComboBox);
        this.addButtonAction(this.setButton);
        this.addButtonAction(this.clearButton);
        this.addButtonAction(this.saveButton);
        this.addCheckBoxAction(this.copyCheckBox);
        this.manager.addPropertyChangeListener(this);
        InstanceManager.getDefault(CarTypes.class).addPropertyChangeListener(this);
        JMenuBar menuBar = new JMenuBar();
        JMenu toolMenu = new JMenu(Bundle.getMessage("MenuTools"));
        toolMenu.add(new PrintLocationsByCarTypesAction(false));
        toolMenu.add(new PrintLocationsByCarTypesAction(true));
        menuBar.add(toolMenu);
        this.setJMenuBar(menuBar);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_ModifyLocationsByCarType", true);
        this.setPreferredSize(null);
        this.pack();
        this.setMinimumSize(new Dimension(300, 250));
        this.setSize(this.getWidth() + 25, this.getHeight());
        if (this._location != null) {
            this.setTitle(Bundle.getMessage("TitleModifyLocation"));
        } else {
            this.setTitle(Bundle.getMessage("TitleModifyLocations"));
        }
        this.setVisible(true);
    }

    @Override
    public void comboBoxActionPerformed(ActionEvent ae) {
        log.debug("combo box action");
        this.updateLocations();
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.saveButton) {
            this.save();
        }
        if (ae.getSource() == this.setButton) {
            this.selectCheckboxes(true);
        }
        if (ae.getSource() == this.clearButton) {
            this.selectCheckboxes(false);
        }
    }

    private void save() {
        if (this.copyCheckBox.isSelected() && JOptionPane.showConfirmDialog(this, MessageFormat.format(Bundle.getMessage("CopyCarType"), this.typeComboBox.getSelectedItem(), this.textCarType.getText()), Bundle.getMessage("CopyCarTypeTitle"), 0) != 0) {
            return;
        }
        log.debug("save {} locations", (Object)this.locationCheckBoxList.size());
        this.removePropertyChangeLocations();
        for (JCheckBox cb : this.locationCheckBoxList) {
            Location loc = this.manager.getLocationById(cb.getName());
            if (cb.isSelected()) {
                loc.addTypeName((String)this.typeComboBox.getSelectedItem());
                for (JCheckBox cbt : this.trackCheckBoxList) {
                    String[] id = cbt.getName().split("s");
                    if (!loc.getId().equals(id[0])) continue;
                    Track track = loc.getTrackById(cbt.getName());
                    if (cbt.isSelected()) {
                        track.addTypeName((String)this.typeComboBox.getSelectedItem());
                        continue;
                    }
                    track.deleteTypeName((String)this.typeComboBox.getSelectedItem());
                }
                continue;
            }
            loc.deleteTypeName((String)this.typeComboBox.getSelectedItem());
        }
        OperationsXml.save();
        this.updateLocations();
        if (Setup.isCloseWindowOnSaveEnabled()) {
            this.dispose();
        }
    }

    private void updateLocations() {
        log.debug("update checkboxes");
        this.removePropertyChangeLocations();
        this.locationCheckBoxList.clear();
        this.trackCheckBoxList.clear();
        int x = 0;
        this.pLocations.removeAll();
        String carType = (String)this.typeComboBox.getSelectedItem();
        if (this.copyCheckBox.isSelected()) {
            carType = this.textCarType.getText();
        }
        if (this._location != null && this.manager.getLocationByName(this._location.getName()) == null) {
            this._location = null;
        }
        List<Location> locations = this.manager.getLocationsByNameList();
        for (Location loc : locations) {
            if (this._location != null && this._location != loc) continue;
            loc.addPropertyChangeListener(this);
            JCheckBox cb = new JCheckBox(loc.getName());
            cb.setName(loc.getId());
            cb.setToolTipText(MessageFormat.format(Bundle.getMessage("TipLocCarType"), carType));
            this.addCheckBoxAction(cb);
            this.locationCheckBoxList.add(cb);
            boolean locAcceptsType = loc.acceptsTypeName(carType);
            cb.setSelected(locAcceptsType);
            this.addItemLeft(this.pLocations, cb, 0, x++);
            List<Track> tracks = loc.getTracksByNameList(null);
            for (Track track : tracks) {
                track.addPropertyChangeListener(this);
                cb = new JCheckBox(track.getName());
                cb.setName(track.getId());
                cb.setToolTipText(MessageFormat.format(Bundle.getMessage("TipTrackCarType"), carType));
                this.addCheckBoxAction(cb);
                this.trackCheckBoxList.add(cb);
                cb.setSelected(track.isTypeNameAccepted(carType));
                this.addItemLeft(this.pLocations, cb, 1, x++);
            }
        }
        this.pLocations.revalidate();
        this.repaint();
    }

    private void updateComboBox() {
        log.debug("update combobox");
        InstanceManager.getDefault(CarTypes.class).updateComboBox(this.typeComboBox);
    }

    private void selectCheckboxes(boolean select) {
        int i = 0;
        while (i < this.locationCheckBoxList.size()) {
            this.locationCheckBoxList.get(i).setSelected(select);
            ++i;
        }
        i = 0;
        while (i < this.trackCheckBoxList.size()) {
            this.trackCheckBoxList.get(i).setSelected(select);
            ++i;
        }
    }

    @Override
    public void checkBoxActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.copyCheckBox) {
            if (this.copyCheckBox.isSelected()) {
                this.textCarType.setText((String)this.typeComboBox.getSelectedItem());
            } else {
                this.textCarType.setText(EMPTY);
                this.updateLocations();
            }
        } else {
            JCheckBox cb = (JCheckBox)ae.getSource();
            log.debug("Checkbox {} text: {}", (Object)cb.getName(), (Object)cb.getText());
            if (this.locationCheckBoxList.contains(cb)) {
                log.debug("Checkbox location {}", (Object)cb.getText());
                if (!cb.isSelected()) {
                    String locId = cb.getName();
                    int i = 0;
                    while (i < this.trackCheckBoxList.size()) {
                        cb = this.trackCheckBoxList.get(i);
                        String[] id = cb.getName().split("s");
                        if (locId.equals(id[0])) {
                            cb.setSelected(false);
                        }
                        ++i;
                    }
                }
            } else if (this.trackCheckBoxList.contains(cb)) {
                log.debug("Checkbox track {}", (Object)cb.getText());
                if (cb.isSelected()) {
                    String[] loc = cb.getName().split("s");
                    int i = 0;
                    while (i < this.locationCheckBoxList.size()) {
                        cb = this.locationCheckBoxList.get(i);
                        if (cb.getName().equals(loc[0])) {
                            cb.setSelected(true);
                            break;
                        }
                        ++i;
                    }
                }
            } else {
                log.error("Error checkbox not found");
            }
        }
    }

    private void removePropertyChangeLocations() {
        if (this.locationCheckBoxList != null) {
            int i = 0;
            while (i < this.locationCheckBoxList.size()) {
                Location loc = this.manager.getLocationById(this.locationCheckBoxList.get(i).getName());
                if (loc != null) {
                    loc.removePropertyChangeListener(this);
                    List<Track> tracks = loc.getTracksList();
                    for (Track track : tracks) {
                        track.removePropertyChangeListener(this);
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public void dispose() {
        this.manager.removePropertyChangeListener(this);
        InstanceManager.getDefault(CarTypes.class).removePropertyChangeListener(this);
        this.removePropertyChangeLocations();
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        log.debug("Property change: ({}) old: ({}) new: ({})", new Object[]{e.getPropertyName(), e.getOldValue(), e.getNewValue()});
        if (e.getPropertyName().equals("locationsListLength") || e.getPropertyName().equals("locationTypes") || e.getPropertyName().equals("locationName") || e.getPropertyName().equals("trackListLength") || e.getPropertyName().equals("trackRollingStockTypes") || e.getPropertyName().equals("trackName")) {
            this.updateLocations();
        }
        if (e.getPropertyName().equals("CarTypes Length") || e.getPropertyName().equals("CarTypes Name")) {
            this.updateComboBox();
        }
    }
}

