/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.tools;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.tools.Bundle;
import jmri.jmrit.operations.locations.tools.LocationTrackBlockingOrderTableModel;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.TrainManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationTrackBlockingOrderFrame
extends OperationsFrame {
    LocationTrackBlockingOrderTableModel trackModel = new LocationTrackBlockingOrderTableModel();
    JTable trackTable = new JTable(this.trackModel);
    JScrollPane trackPane = new JScrollPane(this.trackTable);
    LocationManager locationManager = InstanceManager.getDefault(LocationManager.class);
    Location _location = null;
    JLabel locationName = new JLabel();
    JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
    JButton resetButton = new JButton(Bundle.getMessage("Reset"));
    JButton reorderButton = new JButton(Bundle.getMessage("Reorder"));
    private static final Logger log = LoggerFactory.getLogger(LocationTrackBlockingOrderFrame.class);

    public LocationTrackBlockingOrderFrame() {
        super(Bundle.getMessage("TitleTrackBlockingOrder"));
    }

    public void initComponents(Location location) {
        this._location = location;
        this.trackPane.setVerticalScrollBarPolicy(20);
        this.trackPane.setBorder(BorderFactory.createTitledBorder(""));
        if (this._location != null) {
            this.trackModel.initTable(this.trackTable, location);
            this.locationName.setText(this._location.getName());
            this.trackTable.setEnabled(!Setup.isSortByTrackNameEnabled());
            this.enableButtons(!Setup.isSortByTrackNameEnabled());
        } else {
            this.enableButtons(false);
        }
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel pName = new JPanel();
        pName.setLayout(new GridBagLayout());
        pName.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Location")));
        this.addItem(pName, this.locationName, 0, 0);
        JPanel pB = new JPanel();
        pB.setLayout(new GridBagLayout());
        this.addItem(pB, this.resetButton, 0, 0);
        this.addItem(pB, this.reorderButton, 1, 0);
        this.addItem(pB, this.saveButton, 2, 0);
        JLabel note1 = new JLabel(Bundle.getMessage("ServiceOrderMessage"));
        JLabel note2 = new JLabel(Bundle.getMessage("ServiceOrderEastSouth"));
        this.getContentPane().add(pName);
        this.getContentPane().add(note1);
        this.getContentPane().add(note2);
        this.getContentPane().add(this.trackPane);
        this.getContentPane().add(pB);
        this.addButtonAction(this.resetButton);
        this.addButtonAction(this.reorderButton);
        this.addButtonAction(this.saveButton);
        this.resetButton.setToolTipText(Bundle.getMessage("TipResetButton"));
        this.reorderButton.setToolTipText(Bundle.getMessage("TipReorderButton"));
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_TrackBlockingOrder", true);
        this.initMinimumSize(new Dimension(600, 500));
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.resetButton && this._location != null) {
            this._location.resetTracksByBlockingOrder();
        }
        if (ae.getSource() == this.reorderButton && this._location != null) {
            this._location.resequnceTracksByBlockingOrder();
        }
        if (ae.getSource() == this.saveButton) {
            if (this.trackTable.isEditing()) {
                log.debug("track table edit true");
                this.trackTable.getCellEditor().stopCellEditing();
            }
            InstanceManager.getDefault(TrainManager.class).setTrainsModified();
            OperationsXml.save();
            if (Setup.isCloseWindowOnSaveEnabled()) {
                this.dispose();
            }
        }
    }

    private void enableButtons(boolean enabled) {
        this.resetButton.setEnabled(enabled);
        this.reorderButton.setEnabled(enabled);
        this.saveButton.setEnabled(enabled);
    }

    @Override
    public void dispose() {
        this.trackModel.dispose();
        super.dispose();
    }
}

