/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.JOptionPane;
import jmri.InstanceManager;
import jmri.jmrit.XmlFile;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.tools.Bundle;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteManager;
import jmri.jmrit.operations.setup.OperationsSetupXml;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportLocations
extends XmlFile {
    TrainManager trainManager = InstanceManager.getDefault(TrainManager.class);
    RouteManager routeManager = InstanceManager.getDefault(RouteManager.class);
    LocationManager locationManager = InstanceManager.getDefault(LocationManager.class);
    private static String operationsFileName = "ExportOperationsLocationRoster.csv";
    private static final Logger log = LoggerFactory.getLogger(ExportLocations.class);

    public void writeOperationsLocationFile() {
        this.makeBackupFile(ExportLocations.defaultOperationsFilename());
        try {
            if (!this.checkFile(ExportLocations.defaultOperationsFilename())) {
                File file = new File(ExportLocations.defaultOperationsFilename());
                File parentDir = file.getParentFile();
                if (!parentDir.exists() && !parentDir.mkdir()) {
                    log.error("Directory wasn't created");
                }
                if (file.createNewFile()) {
                    log.debug("File created");
                }
            }
            this.writeFile(ExportLocations.defaultOperationsFilename());
        }
        catch (IOException e) {
            log.error("Exception while writing the new CSV operations file, may not be complete: {}", (Throwable)e);
        }
    }

    public void writeFile(String name) {
        log.debug("writeFile {}", (Object)name);
        File file = this.findFile(name);
        if (file == null) {
            file = new File(name);
        }
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (CSVPrinter fileOut = new CSVPrinter((Appendable)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8)), CSVFormat.DEFAULT);){
                fileOut.printRecord(new Object[]{Bundle.getMessage("Location"), Bundle.getMessage("Track"), Bundle.getMessage("Type"), Bundle.getMessage("Length"), Bundle.getMessage("Division"), Bundle.getMessage("ServicedByTrains"), Bundle.getMessage("RollingStock"), Bundle.getMessage("ServiceOrder"), Bundle.getMessage("RoadOption"), Bundle.getMessage("Roads"), Bundle.getMessage("LoadOption"), Bundle.getMessage("Loads"), Bundle.getMessage("ShipLoadOption"), Bundle.getMessage("Ships"), Bundle.getMessage("SetOutRestrictions"), Bundle.getMessage("Restrictions"), Bundle.getMessage("PickUpRestrictions"), Bundle.getMessage("Restrictions"), Bundle.getMessage("ScheduleName"), Bundle.getMessage("ScheduleMode"), Bundle.getMessage("AlternateTrack"), Bundle.getMessage("PoolName"), Bundle.getMessage("Minimum"), Bundle.getMessage("TitleTrackBlockingOrder"), Bundle.getMessage("MenuItemPlannedPickups"), Bundle.getMessage("MenuItemDestinations"), Bundle.getMessage("Destinations"), Bundle.getMessage("SwapCarLoads"), Bundle.getMessage("EmptyDefaultCarLoads"), Bundle.getMessage("EmptyCarLoads"), Bundle.getMessage("LoadCarLoads"), Bundle.getMessage("LoadAnyCarLoads"), Bundle.getMessage("LoadsStaging"), Bundle.getMessage("BlockCars"), Bundle.getMessage("Comment"), Bundle.getMessage("CommentBoth"), Bundle.getMessage("CommentPickup"), Bundle.getMessage("CommentSetout")});
                List<Location> locations = this.locationManager.getLocationsByNameList();
                for (Location location : locations) {
                    for (Track track : location.getTracksByNameList(null)) {
                        String id;
                        int n;
                        String[] stringArray;
                        String id2;
                        int n2;
                        int n3;
                        String[] stringArray2;
                        String[] directions;
                        StringBuilder trainDirections = new StringBuilder();
                        String[] stringArray3 = directions = Setup.getDirectionStrings(Setup.getTrainDirection() & location.getTrainDirections() & track.getTrainDirections());
                        int n4 = directions.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            String dir = stringArray3[n5];
                            if (dir != null) {
                                trainDirections.append(dir).append("; ");
                            }
                            ++n5;
                        }
                        StringBuilder rollingStockNames = new StringBuilder();
                        String[] stringArray4 = track.getTypeNames();
                        int n6 = stringArray4.length;
                        n4 = 0;
                        while (n4 < n6) {
                            String rollingStockName = stringArray4[n4];
                            rollingStockNames.append(rollingStockName).append("; ");
                            ++n4;
                        }
                        StringBuilder roadNames = new StringBuilder();
                        if (!track.getRoadOption().equals(Track.ALL_ROADS)) {
                            Object object = track.getRoadNames();
                            int n7 = ((String[])object).length;
                            n6 = 0;
                            while (n6 < n7) {
                                String roadName = object[n6];
                                roadNames.append(roadName).append("; ");
                                ++n6;
                            }
                        }
                        StringBuilder loadNames = new StringBuilder();
                        if (!track.getLoadOption().equals(Track.ALL_LOADS)) {
                            String[] stringArray5 = track.getLoadNames();
                            int n8 = stringArray5.length;
                            int n9 = 0;
                            while (n9 < n8) {
                                String loadName = stringArray5[n9];
                                loadNames.append(loadName).append("; ");
                                ++n9;
                            }
                        }
                        StringBuilder shipNames = new StringBuilder();
                        if (!track.getShipLoadOption().equals(Track.ALL_LOADS)) {
                            String[] stringArray6 = track.getShipLoadNames();
                            int n10 = stringArray6.length;
                            int n11 = 0;
                            while (n11 < n10) {
                                String shipName = stringArray6[n11];
                                shipNames.append(shipName).append("; ");
                                ++n11;
                            }
                        }
                        String setOutRestriction = Bundle.getMessage("None");
                        switch (track.getDropOption()) {
                            case "trains": {
                                setOutRestriction = Bundle.getMessage("Trains");
                                break;
                            }
                            case "routes": {
                                setOutRestriction = Bundle.getMessage("Routes");
                                break;
                            }
                            case "excludeTrains": {
                                setOutRestriction = Bundle.getMessage("ExcludeTrains");
                                break;
                            }
                            case "excludeRoutes": {
                                setOutRestriction = Bundle.getMessage("ExcludeRoutes");
                                break;
                            }
                        }
                        StringBuilder setOutRestrictions = new StringBuilder();
                        if (track.getDropOption().equals("trains") || track.getDropOption().equals("excludeTrains")) {
                            stringArray2 = track.getDropIds();
                            n3 = stringArray2.length;
                            n2 = 0;
                            while (n2 < n3) {
                                id2 = stringArray2[n2];
                                Train train = this.trainManager.getTrainById(id2);
                                if (train != null) {
                                    setOutRestrictions.append(train.getName()).append("; ");
                                }
                                ++n2;
                            }
                        }
                        if (track.getDropOption().equals("routes") || track.getDropOption().equals("excludeRoutes")) {
                            stringArray2 = track.getDropIds();
                            n3 = stringArray2.length;
                            n2 = 0;
                            while (n2 < n3) {
                                id2 = stringArray2[n2];
                                Route route = this.routeManager.getRouteById(id2);
                                if (route != null) {
                                    setOutRestrictions.append(route.getName()).append("; ");
                                }
                                ++n2;
                            }
                        }
                        String pickUpRestriction = Bundle.getMessage("None");
                        switch (track.getPickupOption()) {
                            case "trains": {
                                pickUpRestriction = Bundle.getMessage("Trains");
                                break;
                            }
                            case "routes": {
                                pickUpRestriction = Bundle.getMessage("Routes");
                                break;
                            }
                            case "excludeTrains": {
                                pickUpRestriction = Bundle.getMessage("ExcludeTrains");
                                break;
                            }
                            case "excludeRoutes": {
                                pickUpRestriction = Bundle.getMessage("ExcludeRoutes");
                                break;
                            }
                        }
                        StringBuilder pickUpRestrictions = new StringBuilder();
                        if (track.getPickupOption().equals("trains") || track.getPickupOption().equals("excludeTrains")) {
                            stringArray = track.getPickupIds();
                            n = stringArray.length;
                            int route = 0;
                            while (route < n) {
                                id = stringArray[route];
                                Train train = this.trainManager.getTrainById(id);
                                if (train != null) {
                                    pickUpRestrictions.append(train.getName()).append("; ");
                                }
                                ++route;
                            }
                        }
                        if (track.getPickupOption().equals("routes") || track.getPickupOption().equals("excludeRoutes")) {
                            stringArray = track.getPickupIds();
                            n = stringArray.length;
                            int route = 0;
                            while (route < n) {
                                id = stringArray[route];
                                Route route2 = this.routeManager.getRouteById(id);
                                if (route2 != null) {
                                    pickUpRestrictions.append(route2.getName()).append("; ");
                                }
                                ++route;
                            }
                        }
                        String alternateTrackName = "";
                        if (track.getAlternateTrack() != null) {
                            alternateTrackName = track.getAlternateTrack().getName();
                        }
                        if (track.isAlternate()) {
                            alternateTrackName = Bundle.getMessage("ButtonYes");
                        }
                        StringBuilder destinationNames = new StringBuilder();
                        String[] stringArray7 = track.getDestinationIds();
                        int n12 = stringArray7.length;
                        int n13 = 0;
                        while (n13 < n12) {
                            String id3 = stringArray7[n13];
                            Location destination = this.locationManager.getLocationById(id3);
                            if (destination != null) {
                                destinationNames.append(destination.getName()).append("; ");
                            }
                            ++n13;
                        }
                        fileOut.printRecord(new Object[]{location.getName(), track.getName(), track.getTrackTypeName(), track.getLength(), track.getDivision(), trainDirections.toString(), rollingStockNames.toString(), track.getServiceOrder(), track.getRoadOptionString(), roadNames.toString(), track.getLoadOptionString(), loadNames.toString(), track.getShipLoadOptionString(), shipNames.toString(), setOutRestriction, setOutRestrictions.toString(), pickUpRestriction, pickUpRestrictions.toString(), track.getScheduleName(), track.getScheduleModeName(), alternateTrackName, track.getPoolName(), track.getMinimumLength(), track.getBlockingOrder(), track.getIgnoreUsedLengthPercentage(), Bundle.getMessage(track.getDestinationOption().equals(Track.ALL_DESTINATIONS) ? "All" : "Include"), destinationNames.toString(), track.isLoadSwapEnabled() ? Bundle.getMessage("ButtonYes") : "", track.isLoadEmptyEnabled() ? Bundle.getMessage("ButtonYes") : "", track.isRemoveCustomLoadsEnabled() ? Bundle.getMessage("ButtonYes") : "", track.isAddCustomLoadsEnabled() ? Bundle.getMessage("ButtonYes") : "", track.isAddCustomLoadsAnySpurEnabled() ? Bundle.getMessage("ButtonYes") : "", track.isAddCustomLoadsAnyStagingTrackEnabled() ? Bundle.getMessage("ButtonYes") : "", track.isBlockCarsEnabled() ? Bundle.getMessage("ButtonYes") : "", track.getComment(), track.getCommentBoth(), track.getCommentPickup(), track.getCommentSetout()});
                    }
                }
                fileOut.flush();
                fileOut.close();
                log.info("Exported {} locations to file {}", (Object)locations.size(), (Object)ExportLocations.defaultOperationsFilename());
                JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("ExportedLocationsToFile"), locations.size(), ExportLocations.defaultOperationsFilename()), Bundle.getMessage("ExportComplete"), 1);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            log.error("Can not open export locations CSV file: {}", (Object)file.getName());
            JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("ExportedLocationsToFile"), 0, ExportLocations.defaultOperationsFilename()), Bundle.getMessage("ExportFailed"), 0);
        }
    }

    public static String defaultOperationsFilename() {
        return String.valueOf(OperationsSetupXml.getFileLocation()) + OperationsSetupXml.getOperationsDirectoryName() + File.separator + ExportLocations.getOperationsFileName();
    }

    public static void setOperationsFileName(String name) {
        operationsFileName = name;
    }

    public static String getOperationsFileName() {
        return operationsFileName;
    }
}

