/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.schedules;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import jmri.InstanceManager;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.schedules.Bundle;
import jmri.jmrit.operations.locations.schedules.Schedule;
import jmri.jmrit.operations.locations.schedules.ScheduleEditFrame;
import jmri.jmrit.operations.locations.schedules.ScheduleItem;
import jmri.jmrit.operations.rollingstock.cars.CarLoads;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.rollingstock.cars.CarRoads;
import jmri.jmrit.operations.trains.schedules.TrainSchedule;
import jmri.jmrit.operations.trains.schedules.TrainScheduleManager;
import jmri.jmrit.symbolicprog.ValueEditor;
import jmri.jmrit.symbolicprog.ValueRenderer;
import jmri.util.swing.XTableColumnModel;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    protected static final String POINTER = "    -->";
    private static final int ID_COLUMN = 0;
    private static final int CURRENT_COLUMN = 1;
    private static final int TYPE_COLUMN = 2;
    private static final int RANDOM_COLUMN = 3;
    private static final int SETOUT_DAY_COLUMN = 4;
    private static final int ROAD_COLUMN = 5;
    private static final int LOAD_COLUMN = 6;
    private static final int SHIP_COLUMN = 7;
    private static final int DEST_COLUMN = 8;
    private static final int TRACK_COLUMN = 9;
    private static final int PICKUP_DAY_COLUMN = 10;
    private static final int COUNT_COLUMN = 11;
    private static final int HIT_COLUMN = 12;
    private static final int WAIT_COLUMN = 13;
    private static final int UP_COLUMN = 14;
    private static final int DOWN_COLUMN = 15;
    private static final int DELETE_COLUMN = 16;
    private static final int HIGHEST_COLUMN = 17;
    Schedule _schedule;
    Location _location;
    Track _track;
    JTable _table;
    ScheduleEditFrame _frame;
    boolean _matchMode = false;
    List<ScheduleItem> _list = new ArrayList<ScheduleItem>();
    String[] randomValues = new String[]{"", "50", "30", "25", "20", "15", "10", "5", "2", "1"};
    private static final Logger log = LoggerFactory.getLogger(ScheduleTableModel.class);

    private void updateList() {
        if (this._schedule == null) {
            return;
        }
        this.removePropertyChangeScheduleItems();
        this._list = this._schedule.getItemsBySequenceList();
        for (ScheduleItem si : this._list) {
            si.addPropertyChangeListener(this);
            if (si.getDestination() != null) {
                si.getDestination().addPropertyChangeListener(this);
            }
            if (si.getDestinationTrack() == null) continue;
            si.getDestinationTrack().addPropertyChangeListener(this);
        }
    }

    protected void initTable(ScheduleEditFrame frame, JTable table, Schedule schedule, Location location, Track track) {
        this._schedule = schedule;
        this._location = location;
        this._track = track;
        this._table = table;
        this._frame = frame;
        if (this._schedule != null) {
            this._schedule.addPropertyChangeListener(this);
        }
        this._location.addPropertyChangeListener(this);
        this._track.addPropertyChangeListener(this);
        this.initTable();
    }

    private void initTable() {
        XTableColumnModel tcm = new XTableColumnModel();
        this._table.setColumnModel(tcm);
        this._table.createDefaultColumnsFromModel();
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        ButtonEditor buttonEditor = new ButtonEditor(new JButton());
        tcm.getColumn(14).setCellRenderer(buttonRenderer);
        tcm.getColumn(14).setCellEditor(buttonEditor);
        tcm.getColumn(15).setCellRenderer(buttonRenderer);
        tcm.getColumn(15).setCellEditor(buttonEditor);
        tcm.getColumn(16).setCellRenderer(buttonRenderer);
        tcm.getColumn(16).setCellEditor(buttonEditor);
        this._table.setDefaultRenderer(JComboBox.class, new ValueRenderer());
        this._table.setDefaultEditor(JComboBox.class, new ValueEditor());
        this._table.getColumnModel().getColumn(0).setPreferredWidth(35);
        this._table.getColumnModel().getColumn(1).setPreferredWidth(50);
        this._table.getColumnModel().getColumn(2).setPreferredWidth(90);
        this._table.getColumnModel().getColumn(3).setPreferredWidth(60);
        this._table.getColumnModel().getColumn(4).setPreferredWidth(90);
        this._table.getColumnModel().getColumn(5).setPreferredWidth(90);
        this._table.getColumnModel().getColumn(6).setPreferredWidth(90);
        this._table.getColumnModel().getColumn(7).setPreferredWidth(90);
        this._table.getColumnModel().getColumn(8).setPreferredWidth(130);
        this._table.getColumnModel().getColumn(9).setPreferredWidth(130);
        this._table.getColumnModel().getColumn(10).setPreferredWidth(90);
        this._table.getColumnModel().getColumn(11).setPreferredWidth(45);
        this._table.getColumnModel().getColumn(12).setPreferredWidth(45);
        this._table.getColumnModel().getColumn(13).setPreferredWidth(40);
        this._table.getColumnModel().getColumn(14).setPreferredWidth(60);
        this._table.getColumnModel().getColumn(15).setPreferredWidth(70);
        this._table.getColumnModel().getColumn(16).setPreferredWidth(70);
        this._frame.loadTableDetails(this._table);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(12), this._matchMode);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(11), !this._matchMode);
        this._table.setRowSorter(null);
        this.updateList();
    }

    @Override
    public int getRowCount() {
        return this._list.size();
    }

    @Override
    public int getColumnCount() {
        return 17;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("Id");
            }
            case 1: {
                return Bundle.getMessage("Current");
            }
            case 2: {
                return Bundle.getMessage("Type");
            }
            case 3: {
                return Bundle.getMessage("Random");
            }
            case 4: {
                return Bundle.getMessage("Delivery");
            }
            case 5: {
                return Bundle.getMessage("Road");
            }
            case 6: {
                return Bundle.getMessage("Receive");
            }
            case 7: {
                return Bundle.getMessage("Ship");
            }
            case 8: {
                return Bundle.getMessage("Destination");
            }
            case 9: {
                return Bundle.getMessage("Track");
            }
            case 10: {
                return Bundle.getMessage("Pickup");
            }
            case 11: {
                return Bundle.getMessage("Count");
            }
            case 12: {
                return Bundle.getMessage("Hits");
            }
            case 13: {
                return Bundle.getMessage("Wait");
            }
            case 14: {
                return Bundle.getMessage("Up");
            }
            case 15: {
                return Bundle.getMessage("Down");
            }
            case 16: {
                return Bundle.getMessage("ButtonDelete");
            }
        }
        return "unknown";
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: 
            case 1: 
            case 2: {
                return String.class;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return JComboBox.class;
            }
            case 11: 
            case 12: 
            case 13: {
                return Integer.class;
            }
            case 14: 
            case 15: 
            case 16: {
                return JButton.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.getRowCount()) {
            return "ERROR row " + row;
        }
        ScheduleItem si = this._list.get(row);
        if (si == null) {
            return "ERROR schedule item unknown " + row;
        }
        switch (col) {
            case 0: {
                return si.getId();
            }
            case 1: {
                return this.getCurrentPointer(si);
            }
            case 2: {
                return this.getType(si);
            }
            case 3: {
                return this.getRandomComboBox(si);
            }
            case 4: {
                return this.getSetoutDayComboBox(si);
            }
            case 5: {
                return this.getRoadComboBox(si);
            }
            case 6: {
                return this.getLoadComboBox(si);
            }
            case 7: {
                return this.getShipComboBox(si);
            }
            case 8: {
                return this.getDestComboBox(si);
            }
            case 9: {
                return this.getTrackComboBox(si);
            }
            case 10: {
                return this.getPickupDayComboBox(si);
            }
            case 11: {
                return si.getCount();
            }
            case 12: {
                return si.getHits();
            }
            case 13: {
                return si.getWait();
            }
            case 14: {
                return Bundle.getMessage("Up");
            }
            case 15: {
                return Bundle.getMessage("Down");
            }
            case 16: {
                return Bundle.getMessage("ButtonDelete");
            }
        }
        return "unknown " + col;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (value == null) {
            log.debug("Warning schedule table row {} still in edit", (Object)row);
            return;
        }
        switch (col) {
            case 1: {
                this.setCurrent(row);
                break;
            }
            case 3: {
                this.setRandom(value, row);
                break;
            }
            case 4: {
                this.setSetoutDay(value, row);
                break;
            }
            case 5: {
                this.setRoad(value, row);
                break;
            }
            case 6: {
                this.setLoad(value, row);
                break;
            }
            case 7: {
                this.setShip(value, row);
                break;
            }
            case 8: {
                this.setDestination(value, row);
                break;
            }
            case 9: {
                this.setTrack(value, row);
                break;
            }
            case 10: {
                this.setPickupDay(value, row);
                break;
            }
            case 11: {
                this.setCount(value, row);
                break;
            }
            case 12: {
                this.setHit(value, row);
                break;
            }
            case 13: {
                this.setWait(value, row);
                break;
            }
            case 14: {
                this.moveUpScheduleItem(row);
                break;
            }
            case 15: {
                this.moveDownScheduleItem(row);
                break;
            }
            case 16: {
                this.deleteScheduleItem(row);
                break;
            }
        }
    }

    private String getCurrentPointer(ScheduleItem si) {
        if (this._track.getCurrentScheduleItem() == si) {
            if (this._track.getScheduleMode() == 0 && si.getCount() > 1) {
                return " " + this._track.getScheduleCount() + POINTER;
            }
            return POINTER;
        }
        return "";
    }

    private String getType(ScheduleItem si) {
        if (this._track.isTypeNameAccepted(si.getTypeName())) {
            return si.getTypeName();
        }
        return MessageFormat.format(Bundle.getMessage("NotValid"), si.getTypeName());
    }

    private JComboBox<String> getRoadComboBox(ScheduleItem si) {
        JComboBox<String> cb = new JComboBox<String>();
        cb.addItem("");
        String[] stringArray = InstanceManager.getDefault(CarRoads.class).getNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String roadName = stringArray[n2];
            if (this._track.isRoadNameAccepted(roadName) && InstanceManager.getDefault(CarManager.class).getByTypeAndRoad(si.getTypeName(), roadName) != null) {
                cb.addItem(roadName);
            }
            ++n2;
        }
        cb.setSelectedItem(si.getRoadName());
        if (!cb.getSelectedItem().equals(si.getRoadName())) {
            String notValid = MessageFormat.format(Bundle.getMessage("NotValid"), si.getRoadName());
            cb.addItem(notValid);
            cb.setSelectedItem(notValid);
        }
        return cb;
    }

    protected JComboBox<String> getRandomComboBox(ScheduleItem si) {
        JComboBox<String> cb = new JComboBox<String>();
        String[] stringArray = this.randomValues;
        int n = this.randomValues.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            cb.addItem(item);
            ++n2;
        }
        cb.setSelectedItem(si.getRandom());
        return cb;
    }

    private JComboBox<TrainSchedule> getSetoutDayComboBox(ScheduleItem si) {
        JComboBox<TrainSchedule> cb = InstanceManager.getDefault(TrainScheduleManager.class).getSelectComboBox();
        TrainSchedule sch = InstanceManager.getDefault(TrainScheduleManager.class).getScheduleById(si.getSetoutTrainScheduleId());
        if (sch != null) {
            cb.setSelectedItem(sch);
        } else if (!si.getSetoutTrainScheduleId().equals("")) {
            String notValid = MessageFormat.format(Bundle.getMessage("NotValid"), si.getSetoutTrainScheduleId());
            TrainSchedule errorSchedule = new TrainSchedule(si.getSetoutTrainScheduleId(), notValid);
            cb.addItem(errorSchedule);
            cb.setSelectedItem(errorSchedule);
        }
        return cb;
    }

    private JComboBox<TrainSchedule> getPickupDayComboBox(ScheduleItem si) {
        JComboBox<TrainSchedule> cb = InstanceManager.getDefault(TrainScheduleManager.class).getSelectComboBox();
        TrainSchedule sch = InstanceManager.getDefault(TrainScheduleManager.class).getScheduleById(si.getPickupTrainScheduleId());
        if (sch != null) {
            cb.setSelectedItem(sch);
        } else if (!si.getPickupTrainScheduleId().equals("")) {
            String notValid = MessageFormat.format(Bundle.getMessage("NotValid"), si.getPickupTrainScheduleId());
            TrainSchedule errorSchedule = new TrainSchedule(si.getSetoutTrainScheduleId(), notValid);
            cb.addItem(errorSchedule);
            cb.setSelectedItem(errorSchedule);
        }
        return cb;
    }

    protected JComboBox<String> getLoadComboBox(ScheduleItem si) {
        JComboBox<String> cb = InstanceManager.getDefault(CarLoads.class).getSelectComboBox(si.getTypeName());
        this.filterLoads(si, cb);
        cb.setSelectedItem(si.getReceiveLoadName());
        if (!cb.getSelectedItem().equals(si.getReceiveLoadName())) {
            String notValid = MessageFormat.format(Bundle.getMessage("NotValid"), si.getReceiveLoadName());
            cb.addItem(notValid);
            cb.setSelectedItem(notValid);
        }
        return cb;
    }

    protected JComboBox<String> getShipComboBox(ScheduleItem si) {
        JComboBox<String> cb = InstanceManager.getDefault(CarLoads.class).getSelectComboBox(si.getTypeName());
        cb.setSelectedItem(si.getShipLoadName());
        if (!cb.getSelectedItem().equals(si.getShipLoadName())) {
            String notValid = MessageFormat.format(Bundle.getMessage("NotValid"), si.getShipLoadName());
            cb.addItem(notValid);
            cb.setSelectedItem(notValid);
        }
        return cb;
    }

    protected JComboBox<Location> getDestComboBox(ScheduleItem si) {
        JComboBox<Location> cb = InstanceManager.getDefault(LocationManager.class).getComboBox();
        this.filterDestinations(cb, si.getTypeName());
        cb.setSelectedItem(si.getDestination());
        if (si.getDestination() != null && cb.getSelectedIndex() == -1) {
            cb.addItem(si.getDestination());
            cb.setSelectedItem(si.getDestination());
        }
        return cb;
    }

    protected JComboBox<Track> getTrackComboBox(ScheduleItem si) {
        JComboBox<Track> cb = new JComboBox<Track>();
        if (si.getDestination() != null) {
            Location dest = si.getDestination();
            dest.updateComboBox(cb);
            this.filterTracks(dest, cb, si.getTypeName(), si.getRoadName(), si.getShipLoadName());
            cb.setSelectedItem(si.getDestinationTrack());
            if (si.getDestinationTrack() != null && cb.getSelectedIndex() == -1) {
                cb.addItem(si.getDestinationTrack());
                cb.setSelectedItem(si.getDestinationTrack());
            }
        }
        return cb;
    }

    private void setCurrent(int row) {
        ScheduleItem si = this._list.get(row);
        this._track.setScheduleItemId(si.getId());
    }

    private void setCount(Object value, int row) {
        int count;
        ScheduleItem si = this._list.get(row);
        try {
            count = Integer.parseInt(value.toString());
        }
        catch (NumberFormatException numberFormatException) {
            log.error("Schedule count must be a number");
            return;
        }
        if (count < 1) {
            log.error("Schedule count must be greater than 0");
            return;
        }
        if (count > 100) {
            log.warn("Schedule count must be 100 or less");
            count = 100;
        }
        si.setCount(count);
    }

    private void setHit(Object value, int row) {
        int count;
        ScheduleItem si = this._list.get(row);
        try {
            count = Integer.parseInt(value.toString());
        }
        catch (NumberFormatException numberFormatException) {
            log.error("Schedule hits must be a number");
            return;
        }
        si.setHits(count);
    }

    private void setWait(Object value, int row) {
        int wait;
        ScheduleItem si = this._list.get(row);
        try {
            wait = Integer.parseInt(value.toString());
        }
        catch (NumberFormatException numberFormatException) {
            log.error("Schedule wait must be a number");
            return;
        }
        if (wait < 0) {
            log.error("Schedule wait must be a positive number");
            return;
        }
        if (wait > 10) {
            log.warn("Schedule wait must be 10 or less");
            wait = 10;
        }
        si.setWait(wait);
    }

    private void setRandom(Object value, int row) {
        ScheduleItem si = this._list.get(row);
        String random = (String)((JComboBox)value).getSelectedItem();
        si.setRandom(random);
    }

    private void setSetoutDay(Object value, int row) {
        ScheduleItem si = this._list.get(row);
        Object obj = ((JComboBox)value).getSelectedItem();
        if (obj == null) {
            si.setSetoutTrainScheduleId("");
        } else if (obj.getClass().equals(TrainSchedule.class)) {
            si.setSetoutTrainScheduleId(((TrainSchedule)obj).getId());
        }
    }

    private void setPickupDay(Object value, int row) {
        ScheduleItem si = this._list.get(row);
        Object obj = ((JComboBox)value).getSelectedItem();
        if (obj == null) {
            si.setPickupTrainScheduleId("");
        } else if (obj.getClass().equals(TrainSchedule.class)) {
            si.setPickupTrainScheduleId(((TrainSchedule)obj).getId());
        }
    }

    private void setRoad(Object value, int row) {
        ScheduleItem si = this._list.get(row);
        String road = (String)((JComboBox)value).getSelectedItem();
        if (this.checkForNotValidString(road)) {
            si.setRoadName(road);
        }
    }

    private void setLoad(Object value, int row) {
        ScheduleItem si = this._list.get(row);
        String load = (String)((JComboBox)value).getSelectedItem();
        if (this.checkForNotValidString(load)) {
            si.setReceiveLoadName(load);
        }
    }

    private void setShip(Object value, int row) {
        ScheduleItem si = this._list.get(row);
        String load = (String)((JComboBox)value).getSelectedItem();
        if (this.checkForNotValidString(load)) {
            si.setShipLoadName(load);
        }
    }

    private boolean checkForNotValidString(String s) {
        if (s.length() < 12) {
            return true;
        }
        String test = s.substring(0, 11);
        return !test.equals(Bundle.getMessage("NotValid").substring(0, 11));
    }

    private void setDestination(Object value, int row) {
        ScheduleItem si = this._list.get(row);
        si.setDestinationTrack(null);
        Location dest = (Location)((JComboBox)value).getSelectedItem();
        si.setDestination(dest);
        this.fireTableCellUpdated(row, 9);
    }

    private void setTrack(Object value, int row) {
        ScheduleItem si = this._list.get(row);
        Track track = (Track)((JComboBox)value).getSelectedItem();
        si.setDestinationTrack(track);
    }

    private void moveUpScheduleItem(int row) {
        log.debug("move schedule item up");
        this._schedule.moveItemUp(this._list.get(row));
    }

    private void moveDownScheduleItem(int row) {
        log.debug("move schedule item down");
        this._schedule.moveItemDown(this._list.get(row));
    }

    private void deleteScheduleItem(int row) {
        log.debug("Delete schedule item");
        this._schedule.deleteItem(this._list.get(row));
    }

    private void filterDestinations(JComboBox<Location> cb, String carType) {
        int i = 1;
        while (i < cb.getItemCount()) {
            Location dest = cb.getItemAt(i);
            if (!dest.acceptsTypeName(carType)) {
                cb.removeItem(dest);
                --i;
            }
            ++i;
        }
    }

    private void filterTracks(Location loc, JComboBox<Track> cb, String carType, String carRoad, String carLoad) {
        List<Track> tracks = loc.getTracksList();
        for (Track track : tracks) {
            if (track.isTypeNameAccepted(carType) && !track.isStaging() && (carRoad.equals("") || track.isRoadNameAccepted(carRoad)) && (carLoad.equals("") || track.isLoadNameAndCarTypeAccepted(carLoad, carType))) continue;
            cb.removeItem(track);
        }
    }

    private void filterLoads(ScheduleItem si, JComboBox<String> cb) {
        int i = cb.getItemCount() - 1;
        while (i > 0) {
            String loadName = cb.getItemAt(i);
            if (!loadName.equals("") && !this._track.isLoadNameAndCarTypeAccepted(loadName, si.getTypeName())) {
                cb.removeItem(loadName);
            }
            --i;
        }
    }

    public void setMatchMode(boolean mode) {
        if (mode != this._matchMode) {
            this._matchMode = mode;
            XTableColumnModel tcm = (XTableColumnModel)this._table.getColumnModel();
            tcm.setColumnVisible(tcm.getColumnByModelIndex(12), mode);
            tcm.setColumnVisible(tcm.getColumnByModelIndex(11), !mode);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        ScheduleItem item;
        int row;
        if (e.getPropertyName().equals("scheduleListChange")) {
            this.updateList();
            this.fireTableDataChanged();
        }
        if (e.getPropertyName().equals("trackRollingStockTypes") || e.getPropertyName().equals("trackRoads") || e.getPropertyName().equals("trackLoads") || e.getPropertyName().equals("trackScheduleChange") || e.getPropertyName().equals("locationTypes") || e.getPropertyName().equals("locationDispose")) {
            this.fireTableDataChanged();
        }
        if (e.getSource().getClass().equals(ScheduleItem.class) && (row = this._list.indexOf(item = (ScheduleItem)e.getSource())) >= 0) {
            this.fireTableRowsUpdated(row, row);
        }
    }

    private void removePropertyChangeScheduleItems() {
        for (ScheduleItem si : this._list) {
            si.removePropertyChangeListener(this);
            if (si.getDestination() != null) {
                si.getDestination().removePropertyChangeListener(this);
            }
            if (si.getDestinationTrack() == null) continue;
            si.getDestinationTrack().removePropertyChangeListener(this);
        }
    }

    public void dispose() {
        if (this._schedule != null) {
            this.removePropertyChangeScheduleItems();
            this._schedule.removePropertyChangeListener(this);
        }
        this._location.removePropertyChangeListener(this);
        this._track.removePropertyChangeListener(this);
    }
}

