/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.schedules;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.schedules.Bundle;
import jmri.jmrit.operations.locations.schedules.ScheduleEditFrame;
import jmri.jmrit.operations.setup.Setup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ScheduleOptionsFrame
extends OperationsFrame
implements PropertyChangeListener {
    JTextField factorTextField = new JTextField(5);
    JComboBox<Track> trackBox = new JComboBox();
    JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
    Track _track;
    private static final Logger log = LoggerFactory.getLogger(ScheduleOptionsFrame.class);

    public ScheduleOptionsFrame(ScheduleEditFrame sef) {
        super(Bundle.getMessage("MenuItemScheduleOptions"));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this._track = sef._track;
        JPanel pFactor = new JPanel();
        pFactor.setLayout(new GridBagLayout());
        pFactor.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("ScheduleFactor")));
        this.addItem(pFactor, this.factorTextField, 0, 0);
        this.factorTextField.setToolTipText(Bundle.getMessage("TipScheduleFactor"));
        this.factorTextField.setText(Integer.toString(this._track.getReservationFactor()));
        JPanel pAlternate = new JPanel();
        pAlternate.setLayout(new GridBagLayout());
        pAlternate.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("AlternateTrack")));
        this.addItem(pAlternate, this.trackBox, 0, 0);
        this.updateTrackCombobox();
        JPanel pControls = new JPanel();
        pControls.add(this.saveButton);
        this.addButtonAction(this.saveButton);
        this.getContentPane().add(pFactor);
        this.getContentPane().add(pAlternate);
        this.getContentPane().add(pControls);
        this._track.getLocation().addPropertyChangeListener(this);
        this.initMinimumSize(new Dimension(400, 200));
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.saveButton) {
            try {
                int factor = Integer.parseInt(this.factorTextField.getText());
                if (factor < 0 || factor > 1000) {
                    JOptionPane.showMessageDialog(this, Bundle.getMessage("FactorMustBeNumber"), Bundle.getMessage("ErrorFactor"), 0);
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, Bundle.getMessage("FactorMustBeNumber"), Bundle.getMessage("ErrorFactor"), 0);
                return;
            }
            this._track.setReservationFactor(Integer.parseInt(this.factorTextField.getText()));
            if (this.trackBox.getSelectedItem() != null && !this.trackBox.getSelectedItem().equals("")) {
                this._track.setAlternateTrack((Track)this.trackBox.getSelectedItem());
            } else {
                this._track.setAlternateTrack(null);
            }
            OperationsXml.save();
            if (Setup.isCloseWindowOnSaveEnabled()) {
                this.dispose();
            }
        }
    }

    private void updateTrackCombobox() {
        this._track.getLocation().updateComboBox(this.trackBox);
        this.trackBox.removeItem(this._track);
        this.trackBox.setSelectedItem(this._track.getAlternateTrack());
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("trackListLength")) {
            this.updateTrackCombobox();
        }
    }
}

