/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.schedules;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import jmri.InstanceManager;
import jmri.beans.PropertyChangeSupport;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.trains.schedules.TrainSchedule;
import jmri.jmrit.operations.trains.schedules.TrainScheduleManager;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleItem
extends PropertyChangeSupport
implements PropertyChangeListener {
    public static final String NONE = "";
    protected String _id = "";
    protected int _sequenceId = 0;
    protected String _random = "";
    protected String _setoutTrainScheduleId = "";
    protected String _type = "";
    protected String _road = "";
    protected String _load = "";
    protected String _ship = "";
    protected Location _destination = null;
    protected Track _trackDestination = null;
    protected String _pickupTrainScheduleId = "";
    protected int _count = 1;
    protected int _wait = 0;
    protected int _hits = 0;
    protected String _comment = "";
    public static final String TRAIN_SCHEDULE_CHANGED_PROPERTY = "trainScheduleId";
    public static final String COUNT_CHANGED_PROPERTY = "scheduleItemCount";
    public static final String TYPE_CHANGED_PROPERTY = "scheduleItemType";
    public static final String ROAD_CHANGED_PROPERTY = "scheduleItemRoad";
    public static final String LOAD_CHANGED_PROPERTY = "scheduleItemLoad";
    public static final String DESTINATION_CHANGED_PROPERTY = "scheduleItemDestination";
    public static final String DESTINATION_TRACK_CHANGED_PROPERTY = "scheduleItemDestinationTrack";
    public static final String WAIT_CHANGED_PROPERTY = "scheduleItemWait";
    public static final String HITS_CHANGED_PROPERTY = "scheduleItemHits";
    public static final String DISPOSE = "scheduleItemDispose";
    private static final Logger log = LoggerFactory.getLogger(ScheduleItem.class);

    public ScheduleItem(String id, String type) {
        log.debug("New schedule item, car type ({}) id: {}", (Object)type, (Object)id);
        this._type = type;
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    public String getTypeName() {
        return this._type;
    }

    public void setTypeName(String type) {
        String old = this._type;
        this._type = type;
        this.firePropertyChange(TYPE_CHANGED_PROPERTY, old, type);
    }

    public String getRandom() {
        return this._random;
    }

    public void setRandom(String value) {
        String old = this._random;
        this._random = value;
        this.firePropertyChange("scheduleItemRandomValueChanged", old, value);
    }

    public String getSetoutTrainScheduleId() {
        return this._setoutTrainScheduleId;
    }

    public String getSetoutTrainScheduleName() {
        String name = NONE;
        TrainSchedule sch = InstanceManager.getDefault(TrainScheduleManager.class).getScheduleById(this.getSetoutTrainScheduleId());
        if (sch != null) {
            name = sch.getName();
        }
        return name;
    }

    public void setSetoutTrainScheduleId(String id) {
        String old = this._setoutTrainScheduleId;
        this._setoutTrainScheduleId = id;
        this.firePropertyChange(TRAIN_SCHEDULE_CHANGED_PROPERTY, old, id);
    }

    public String getPickupTrainScheduleId() {
        return this._pickupTrainScheduleId;
    }

    public String getPickupTrainScheduleName() {
        String name = NONE;
        TrainSchedule sch = InstanceManager.getDefault(TrainScheduleManager.class).getScheduleById(this.getPickupTrainScheduleId());
        if (sch != null) {
            name = sch.getName();
        }
        return name;
    }

    public void setPickupTrainScheduleId(String id) {
        String old = this._pickupTrainScheduleId;
        this._pickupTrainScheduleId = id;
        this.firePropertyChange(TRAIN_SCHEDULE_CHANGED_PROPERTY, old, id);
    }

    public String getRoadName() {
        return this._road;
    }

    public void setRoadName(String road) {
        String old = this._road;
        this._road = road;
        this.firePropertyChange(ROAD_CHANGED_PROPERTY, old, road);
    }

    public void setReceiveLoadName(String load) {
        String old = this._load;
        this._load = load;
        this.firePropertyChange(LOAD_CHANGED_PROPERTY, old, load);
    }

    public String getReceiveLoadName() {
        return this._load;
    }

    public void setShipLoadName(String load) {
        String old = this._ship;
        this._ship = load;
        this.firePropertyChange(LOAD_CHANGED_PROPERTY, old, load);
    }

    public String getShipLoadName() {
        return this._ship;
    }

    public int getSequenceId() {
        return this._sequenceId;
    }

    public void setSequenceId(int sequence) {
        this._sequenceId = sequence;
    }

    public int getCount() {
        return this._count;
    }

    public void setCount(int count) {
        int old = this._count;
        this._count = count;
        this.firePropertyChange(COUNT_CHANGED_PROPERTY, old, count);
    }

    public int getWait() {
        return this._wait;
    }

    public void setWait(int wait) {
        int old = this._wait;
        this._wait = wait;
        this.firePropertyChange(WAIT_CHANGED_PROPERTY, old, wait);
    }

    public int getHits() {
        return this._hits;
    }

    public void setHits(int hit) {
        int old = this._hits;
        this._hits = hit;
        this.firePropertyChange(HITS_CHANGED_PROPERTY, old, hit);
    }

    public Location getDestination() {
        return this._destination;
    }

    public void setDestination(Location destination) {
        Location old = this._destination;
        this._destination = destination;
        String oldName = "null";
        if (old != null) {
            oldName = old.getName();
        }
        String newName = "null";
        if (this._destination != null) {
            newName = this._destination.getName();
        }
        this.firePropertyChange(DESTINATION_CHANGED_PROPERTY, oldName, newName);
    }

    public String getDestinationName() {
        if (this._destination != null) {
            return this._destination.getName();
        }
        return NONE;
    }

    public String getDestinationId() {
        if (this._destination != null) {
            return this._destination.getId();
        }
        return NONE;
    }

    public Track getDestinationTrack() {
        return this._trackDestination;
    }

    public void setDestinationTrack(Track track) {
        Track old = this._trackDestination;
        this._trackDestination = track;
        String oldName = "null";
        if (old != null) {
            oldName = old.getName();
        }
        String newName = "null";
        if (this._trackDestination != null) {
            newName = this._trackDestination.getName();
        }
        this.firePropertyChange(DESTINATION_TRACK_CHANGED_PROPERTY, oldName, newName);
    }

    public String getDestinationTrackName() {
        if (this._trackDestination != null) {
            return this._trackDestination.getName();
        }
        return NONE;
    }

    public String getDestinationTrackId() {
        if (this._trackDestination != null) {
            return this._trackDestination.getId();
        }
        return NONE;
    }

    public void setComment(String comment) {
        this._comment = comment;
    }

    public String getComment() {
        return this._comment;
    }

    public void copyScheduleItem(ScheduleItem si) {
        this.setComment(si.getComment());
        this.setCount(si.getCount());
        this.setDestination(si.getDestination());
        this.setDestinationTrack(si.getDestinationTrack());
        this.setPickupTrainScheduleId(si.getPickupTrainScheduleId());
        this.setRandom(si.getRandom());
        this.setReceiveLoadName(si.getReceiveLoadName());
        this.setRoadName(si.getRoadName());
        this.setSetoutTrainScheduleId(si.getSetoutTrainScheduleId());
        this.setShipLoadName(si.getShipLoadName());
        this.setWait(si.getWait());
    }

    public void dispose() {
        this.firePropertyChange(DISPOSE, null, DISPOSE);
    }

    public ScheduleItem(Element e) {
        Attribute a = e.getAttribute("id");
        if (a != null) {
            this._id = a.getValue();
        } else {
            log.warn("no id attribute in Schedule Item element when reading operations");
        }
        a = e.getAttribute("sequenceId");
        if (a != null) {
            this._sequenceId = Integer.parseInt(a.getValue());
        }
        if ((a = e.getAttribute("random")) != null) {
            this._random = a.getValue();
        }
        if ((a = e.getAttribute(TRAIN_SCHEDULE_CHANGED_PROPERTY)) != null) {
            this._setoutTrainScheduleId = a.getValue();
        }
        if ((a = e.getAttribute("pickupTrainScheduleId")) != null) {
            this._pickupTrainScheduleId = a.getValue();
        }
        if ((a = e.getAttribute("count")) != null) {
            this._count = Integer.parseInt(a.getValue());
        }
        if ((a = e.getAttribute("wait")) != null) {
            this._wait = Integer.parseInt(a.getValue());
        }
        if ((a = e.getAttribute("type")) != null) {
            this._type = a.getValue();
        }
        if ((a = e.getAttribute("road")) != null) {
            this._road = a.getValue();
        }
        if ((a = e.getAttribute("load")) != null) {
            this._load = a.getValue();
        }
        if ((a = e.getAttribute("ship")) != null) {
            this._ship = a.getValue();
        }
        if ((a = e.getAttribute("destinationId")) != null) {
            this._destination = InstanceManager.getDefault(LocationManager.class).getLocationById(a.getValue());
        }
        if ((a = e.getAttribute("destTrackId")) != null && this._destination != null) {
            this._trackDestination = this._destination.getTrackById(a.getValue());
        }
        if ((a = e.getAttribute("comment")) != null) {
            this._comment = a.getValue();
        }
        if ((a = e.getAttribute("hits")) != null) {
            this._hits = Integer.parseInt(a.getValue());
        }
    }

    public Element store() {
        Element e = new Element("item");
        e.setAttribute("id", this.getId());
        e.setAttribute("sequenceId", Integer.toString(this.getSequenceId()));
        e.setAttribute("random", this.getRandom());
        e.setAttribute(TRAIN_SCHEDULE_CHANGED_PROPERTY, this.getSetoutTrainScheduleId());
        e.setAttribute("pickupTrainScheduleId", this.getPickupTrainScheduleId());
        e.setAttribute("count", Integer.toString(this.getCount()));
        e.setAttribute("wait", Integer.toString(this.getWait()));
        e.setAttribute("type", this.getTypeName());
        e.setAttribute("road", this.getRoadName());
        e.setAttribute("load", this.getReceiveLoadName());
        e.setAttribute("ship", this.getShipLoadName());
        if (!this.getDestinationId().equals(NONE)) {
            e.setAttribute("destinationId", this.getDestinationId());
        }
        if (!this.getDestinationTrackId().equals(NONE)) {
            e.setAttribute("destTrackId", this.getDestinationTrackId());
        }
        e.setAttribute("comment", this.getComment());
        e.setAttribute("hits", Integer.toString(this.getHits()));
        return e;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
    }
}

