/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.schedules;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.locations.schedules.Bundle;
import jmri.jmrit.operations.locations.schedules.Schedule;
import jmri.jmrit.operations.locations.schedules.ScheduleManager;
import jmri.jmrit.operations.setup.Control;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleCopyFrame
extends OperationsFrame
implements PropertyChangeListener {
    ScheduleManager scheduleManager = InstanceManager.getDefault(ScheduleManager.class);
    JTextField scheduleNameTextField = new JTextField(Control.max_len_string_location_name);
    JButton copyButton = new JButton(Bundle.getMessage("ButtonCopy"));
    JComboBox<Schedule> scheduleBox = this.scheduleManager.getComboBox();
    private static final Logger log = LoggerFactory.getLogger(ScheduleCopyFrame.class);

    public ScheduleCopyFrame() {
        this((Schedule)null);
    }

    public ScheduleCopyFrame(Schedule schedule) {
        super(Bundle.getMessage("MenuItemCopySchedule"));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel pName = new JPanel();
        pName.setLayout(new GridBagLayout());
        pName.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("ScheduleName")));
        this.addItem(pName, this.scheduleNameTextField, 0, 0);
        JPanel pCopy = new JPanel();
        pCopy.setLayout(new GridBagLayout());
        pCopy.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("SelectScheduleToCopy")));
        this.addItem(pCopy, this.scheduleBox, 0, 0);
        JPanel pButton = new JPanel();
        pButton.setLayout(new GridBagLayout());
        this.addItem(pButton, this.copyButton, 0, 0);
        this.getContentPane().add(pName);
        this.getContentPane().add(pCopy);
        this.getContentPane().add(pButton);
        this.scheduleManager.addPropertyChangeListener(this);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_Schedules", true);
        this.addButtonAction(this.copyButton);
        this.scheduleBox.setSelectedItem(schedule);
        this.initMinimumSize(new Dimension(400, 250));
    }

    @Override
    protected void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.copyButton) {
            log.debug("copy Schedule button activated");
            if (!this.checkName()) {
                return;
            }
            if (this.scheduleBox.getSelectedItem() == null) {
                JOptionPane.showMessageDialog(this, Bundle.getMessage("SelectScheduleToCopy"), MessageFormat.format(Bundle.getMessage("CanNotSchedule"), Bundle.getMessage("ButtonCopy")), 0);
                return;
            }
            Schedule schedule = (Schedule)this.scheduleBox.getSelectedItem();
            this.scheduleManager.copySchedule(schedule, this.scheduleNameTextField.getText());
        }
    }

    protected void updateComboBoxes() {
        log.debug("update Schedule combobox");
        Object item = this.scheduleBox.getSelectedItem();
        this.scheduleManager.updateComboBox(this.scheduleBox);
        this.scheduleBox.setSelectedItem(item);
    }

    protected boolean checkName() {
        if (this.scheduleNameTextField.getText().trim().isEmpty()) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("MustEnterName"), MessageFormat.format(Bundle.getMessage("CanNotSchedule"), Bundle.getMessage("ButtonCopy")), 0);
            return false;
        }
        if (this.scheduleNameTextField.getText().length() > Control.max_len_string_location_name) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("ScheduleNameLengthMax"), Integer.toString(Control.max_len_string_location_name + 1)), MessageFormat.format(Bundle.getMessage("CanNotSchedule"), Bundle.getMessage("ButtonCopy")), 0);
            return false;
        }
        Schedule check = this.scheduleManager.getScheduleByName(this.scheduleNameTextField.getText());
        if (check != null) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("ScheduleAlreadyExists"), MessageFormat.format(Bundle.getMessage("CanNotSchedule"), Bundle.getMessage("ButtonCopy")), 0);
            return false;
        }
        return true;
    }

    @Override
    public void dispose() {
        this.scheduleManager.removePropertyChangeListener(this);
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        log.debug("PropertyChange ({}) new: ({})", (Object)e.getPropertyName(), e.getNewValue());
        if (e.getPropertyName().equals("scheduleListLength")) {
            this.updateComboBoxes();
        }
    }
}

