/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.schedules;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import jmri.InstanceManager;
import jmri.beans.PropertyChangeSupport;
import jmri.jmrit.operations.locations.LocationManagerXml;
import jmri.jmrit.operations.locations.schedules.ScheduleItem;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Schedule
extends PropertyChangeSupport
implements PropertyChangeListener {
    protected String _id = "";
    protected String _name = "";
    protected String _comment = "";
    protected Hashtable<String, ScheduleItem> _scheduleHashTable = new Hashtable();
    protected int _IdNumber = 0;
    protected int _sequenceNum = 0;
    public static final String LISTCHANGE_CHANGED_PROPERTY = "scheduleListChange";
    public static final String DISPOSE = "scheduleDispose";
    private static final Logger log = LoggerFactory.getLogger(Schedule.class);

    public Schedule(String id, String name) {
        log.debug("New schedule ({}) id: {}", (Object)name, (Object)id);
        this._name = name;
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    public void setName(String name) {
        String old = this._name;
        this._name = name;
        if (!old.equals(name)) {
            this.setDirtyAndFirePropertyChange("ScheduleName", old, name);
        }
    }

    public String toString() {
        return this._name;
    }

    public String getName() {
        return this._name;
    }

    public int getSize() {
        return this._scheduleHashTable.size();
    }

    public void setComment(String comment) {
        String old = this._comment;
        this._comment = comment;
        if (!old.equals(comment)) {
            this.setDirtyAndFirePropertyChange("ScheduleComment", old, comment);
        }
    }

    public String getComment() {
        return this._comment;
    }

    public void dispose() {
        this.setDirtyAndFirePropertyChange(DISPOSE, null, DISPOSE);
    }

    public void resetHitCounts() {
        for (ScheduleItem si : this.getItemsByIdList()) {
            si.setHits(0);
        }
    }

    public ScheduleItem addItem(String type) {
        ++this._IdNumber;
        ++this._sequenceNum;
        String id = String.valueOf(this._id) + "c" + Integer.toString(this._IdNumber);
        log.debug("Adding new item to ({}) id: {}", (Object)this.getName(), (Object)id);
        ScheduleItem si = new ScheduleItem(id, type);
        si.setSequenceId(this._sequenceNum);
        Integer old = this._scheduleHashTable.size();
        this._scheduleHashTable.put(si.getId(), si);
        this.setDirtyAndFirePropertyChange(LISTCHANGE_CHANGED_PROPERTY, old, this._scheduleHashTable.size());
        si.addPropertyChangeListener(this);
        return si;
    }

    public ScheduleItem addItem(String carType, int sequence) {
        ScheduleItem si = this.addItem(carType);
        if (sequence < 0 || sequence > this._scheduleHashTable.size()) {
            return si;
        }
        int i = 0;
        while (i < this._scheduleHashTable.size() - sequence - 1) {
            this.moveItemUp(si);
            ++i;
        }
        return si;
    }

    public void register(ScheduleItem si) {
        Integer old = this._scheduleHashTable.size();
        this._scheduleHashTable.put(si.getId(), si);
        String[] getId = si.getId().split("c");
        int id = Integer.parseInt(getId[1]);
        if (id > this._IdNumber) {
            this._IdNumber = id;
        }
        if (si.getSequenceId() > this._sequenceNum) {
            this._sequenceNum = si.getSequenceId();
        }
        this.setDirtyAndFirePropertyChange(LISTCHANGE_CHANGED_PROPERTY, old, this._scheduleHashTable.size());
        si.addPropertyChangeListener(this);
    }

    public void deleteItem(ScheduleItem si) {
        if (si != null) {
            si.removePropertyChangeListener(this);
            String id = si.getId();
            si.dispose();
            Integer old = this._scheduleHashTable.size();
            this._scheduleHashTable.remove(id);
            this.resequenceIds();
            this.setDirtyAndFirePropertyChange(LISTCHANGE_CHANGED_PROPERTY, old, this._scheduleHashTable.size());
        }
    }

    private void resequenceIds() {
        List<ScheduleItem> scheduleItems = this.getItemsBySequenceList();
        int i = 0;
        while (i < scheduleItems.size()) {
            scheduleItems.get(i).setSequenceId(i + 1);
            this._sequenceNum = i++;
        }
    }

    public ScheduleItem getItemByType(String carType) {
        List<ScheduleItem> scheduleSequenceList = this.getItemsBySequenceList();
        int i = scheduleSequenceList.size() - 1;
        while (i >= 0) {
            ScheduleItem si = scheduleSequenceList.get(i);
            if (si.getTypeName().equals(carType)) {
                return si;
            }
            --i;
        }
        return null;
    }

    public ScheduleItem getItemById(String id) {
        return this._scheduleHashTable.get(id);
    }

    private List<ScheduleItem> getItemsByIdList() {
        Object[] arr = new String[this._scheduleHashTable.size()];
        ArrayList<ScheduleItem> out = new ArrayList<ScheduleItem>();
        Enumeration<String> en = this._scheduleHashTable.keys();
        int i = 0;
        while (en.hasMoreElements()) {
            arr[i++] = en.nextElement();
        }
        Arrays.sort(arr);
        i = 0;
        while (i < arr.length) {
            out.add(this.getItemById((String)arr[i]));
            ++i;
        }
        return out;
    }

    public List<ScheduleItem> getItemsBySequenceList() {
        List<ScheduleItem> sortList = this.getItemsByIdList();
        ArrayList<ScheduleItem> out = new ArrayList<ScheduleItem>();
        for (ScheduleItem si : sortList) {
            int j = 0;
            while (j < out.size()) {
                if (si.getSequenceId() < ((ScheduleItem)out.get(j)).getSequenceId()) {
                    out.add(j, si);
                    break;
                }
                ++j;
            }
            if (out.contains(si)) continue;
            out.add(si);
        }
        return out;
    }

    public void moveItemUp(ScheduleItem si) {
        int sequenceId = si.getSequenceId();
        if (sequenceId - 1 <= 0) {
            si.setSequenceId(this._sequenceNum + 1);
            this.resequenceIds();
        } else {
            ScheduleItem replaceSi = this.getItemBySequenceId(sequenceId - 1);
            if (replaceSi != null) {
                replaceSi.setSequenceId(sequenceId);
                si.setSequenceId(sequenceId - 1);
            } else {
                this.resequenceIds();
            }
        }
        this.setDirtyAndFirePropertyChange(LISTCHANGE_CHANGED_PROPERTY, null, Integer.toString(sequenceId));
    }

    public void moveItemDown(ScheduleItem si) {
        int sequenceId = si.getSequenceId();
        if (sequenceId + 1 > this._sequenceNum) {
            si.setSequenceId(0);
            this.resequenceIds();
        } else {
            ScheduleItem replaceSi = this.getItemBySequenceId(sequenceId + 1);
            if (replaceSi != null) {
                replaceSi.setSequenceId(sequenceId);
                si.setSequenceId(sequenceId + 1);
            } else {
                this.resequenceIds();
            }
        }
        this.setDirtyAndFirePropertyChange(LISTCHANGE_CHANGED_PROPERTY, null, Integer.toString(sequenceId));
    }

    public ScheduleItem getItemBySequenceId(int sequenceId) {
        for (ScheduleItem si : this.getItemsByIdList()) {
            if (si.getSequenceId() != sequenceId) continue;
            return si;
        }
        return null;
    }

    public Schedule(Element e) {
        Attribute a = e.getAttribute("id");
        if (a != null) {
            this._id = a.getValue();
        } else {
            log.warn("no id attribute in schedule element when reading operations");
        }
        a = e.getAttribute("name");
        if (a != null) {
            this._name = a.getValue();
        }
        if ((a = e.getAttribute("comment")) != null) {
            this._comment = a.getValue();
        }
        if (e.getChildren("item") != null) {
            List eScheduleItems = e.getChildren("item");
            log.debug("schedule: {} has {} items", (Object)this.getName(), (Object)eScheduleItems.size());
            for (Element eScheduleItem : eScheduleItems) {
                this.register(new ScheduleItem(eScheduleItem));
            }
        }
    }

    public Element store() {
        Element e = new Element("schedule");
        e.setAttribute("id", this.getId());
        e.setAttribute("name", this.getName());
        e.setAttribute("comment", this.getComment());
        for (ScheduleItem si : this.getItemsBySequenceList()) {
            e.addContent((Content)si.store());
        }
        return e;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.setDirtyAndFirePropertyChange(e.getPropertyName(), e.getOldValue(), e.getNewValue());
    }

    protected void setDirtyAndFirePropertyChange(String p, Object old, Object n) {
        InstanceManager.getDefault(LocationManagerXml.class).setDirty(true);
        this.firePropertyChange(p, old, n);
    }
}

