/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.schedules;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.JOptionPane;
import jmri.InstanceManager;
import jmri.jmrit.XmlFile;
import jmri.jmrit.operations.locations.schedules.Bundle;
import jmri.jmrit.operations.locations.schedules.Schedule;
import jmri.jmrit.operations.locations.schedules.ScheduleItem;
import jmri.jmrit.operations.locations.schedules.ScheduleManager;
import jmri.jmrit.operations.setup.OperationsSetupXml;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportSchedules
extends XmlFile {
    private static String operationsFileName = "ExportOperationsSchedules.csv";
    private static final Logger log = LoggerFactory.getLogger(ExportSchedules.class);

    public void writeOperationsScheduleFile() {
        this.makeBackupFile(ExportSchedules.defaultOperationsFilename());
        try {
            if (!this.checkFile(ExportSchedules.defaultOperationsFilename())) {
                File file = new File(ExportSchedules.defaultOperationsFilename());
                File parentDir = file.getParentFile();
                if (!parentDir.exists() && !parentDir.mkdir()) {
                    log.error("Directory wasn't created");
                }
                if (file.createNewFile()) {
                    log.debug("File created");
                }
            }
            this.writeFile(ExportSchedules.defaultOperationsFilename());
        }
        catch (IOException e) {
            log.error("Exception while writing the new CSV operations file, may not be complete: {}", (Throwable)e);
        }
    }

    public void writeFile(String name) {
        log.debug("writeFile {}", (Object)name);
        File file = this.findFile(name);
        if (file == null) {
            file = new File(name);
        }
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (CSVPrinter fileOut = new CSVPrinter((Appendable)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8)), CSVFormat.DEFAULT);){
                fileOut.printRecord(new Object[]{Bundle.getMessage("ScheduleName"), Bundle.getMessage("Id"), Bundle.getMessage("Type"), Bundle.getMessage("Random"), Bundle.getMessage("Delivery"), Bundle.getMessage("Road"), Bundle.getMessage("Receive"), Bundle.getMessage("Ship"), Bundle.getMessage("Destination"), Bundle.getMessage("Track"), Bundle.getMessage("Pickup"), Bundle.getMessage("Count"), Bundle.getMessage("Wait"), Bundle.getMessage("Hits"), Bundle.getMessage("Comment")});
                List<Schedule> schedules = InstanceManager.getDefault(ScheduleManager.class).getSchedulesByNameList();
                for (Schedule schedule : schedules) {
                    for (ScheduleItem scheduleItem : schedule.getItemsBySequenceList()) {
                        fileOut.printRecord(new Object[]{schedule.getName(), scheduleItem.getId(), scheduleItem.getTypeName(), scheduleItem.getRandom(), scheduleItem.getSetoutTrainScheduleName(), scheduleItem.getRoadName(), scheduleItem.getReceiveLoadName(), scheduleItem.getShipLoadName(), scheduleItem.getDestinationName(), scheduleItem.getDestinationTrackName(), scheduleItem.getPickupTrainScheduleName(), scheduleItem.getCount(), scheduleItem.getWait(), scheduleItem.getHits(), schedule.getComment()});
                    }
                }
                fileOut.flush();
                fileOut.close();
                log.info("Exported {} schedules to file {}", (Object)schedules.size(), (Object)ExportSchedules.defaultOperationsFilename());
                JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("ExportedSchedulesToFile"), schedules.size(), ExportSchedules.defaultOperationsFilename()), Bundle.getMessage("ExportComplete"), 1);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            log.error("Can not open export schedules CSV file: {}", (Object)file.getName());
            JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("ExportedSchedulesToFile"), 0, ExportSchedules.defaultOperationsFilename()), Bundle.getMessage("ExportFailed"), 0);
        }
    }

    public static String defaultOperationsFilename() {
        return String.valueOf(OperationsSetupXml.getFileLocation()) + OperationsSetupXml.getOperationsDirectoryName() + File.separator + ExportSchedules.getOperationsFileName();
    }

    public static void setOperationsFileName(String name) {
        operationsFileName = name;
    }

    public static String getOperationsFileName() {
        return operationsFileName;
    }
}

