/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.divisions;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.locations.divisions.Bundle;
import jmri.jmrit.operations.locations.divisions.Division;
import jmri.jmrit.operations.locations.divisions.DivisionManager;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.setup.Setup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DivisionEditFrame
extends OperationsFrame
implements PropertyChangeListener {
    protected Division _division;
    DivisionManager divisionManager;
    JButton saveDivisionButton = new JButton(Bundle.getMessage("SaveDivision"));
    JButton deleteDivisionButton = new JButton(Bundle.getMessage("DeleteDivision"));
    JButton addDivisionButton = new JButton(Bundle.getMessage("AddDivision"));
    JTextField divisionNameTextField = new JTextField(20);
    JTextField commentTextField = new JTextField(35);
    public static final int MAX_NAME_LENGTH = Control.max_len_string_location_name;
    public static final String NAME = Bundle.getMessage("Name");
    public static final String DISPOSE = "dispose";
    private static final Logger log = LoggerFactory.getLogger((String)DivisionEditFrame.class.getName());

    public DivisionEditFrame(Division division) {
        super(Bundle.getMessage("AddDivision"));
        this._division = division;
        this.divisionManager = InstanceManager.getDefault(DivisionManager.class);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 0));
        JScrollPane p1Pane = new JScrollPane(p1);
        p1Pane.setVerticalScrollBarPolicy(21);
        p1Pane.setMinimumSize(new Dimension(300, 3 * this.divisionNameTextField.getPreferredSize().height));
        p1Pane.setMaximumSize(new Dimension(2000, 200));
        JPanel pName = new JPanel();
        pName.setLayout(new GridBagLayout());
        pName.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Name")));
        this.addItem(pName, this.divisionNameTextField, 0, 0);
        JPanel pC = new JPanel();
        pC.setLayout(new GridBagLayout());
        pC.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Comment")));
        this.addItem(pC, this.commentTextField, 0, 0);
        p1.add(pName);
        p1.add(pC);
        JPanel pB = new JPanel();
        pB.setLayout(new GridBagLayout());
        pB.setBorder(BorderFactory.createTitledBorder(""));
        this.addItem(pB, this.deleteDivisionButton, 0, 0);
        this.addItem(pB, this.addDivisionButton, 1, 0);
        this.addItem(pB, this.saveDivisionButton, 3, 0);
        this.getContentPane().add(p1Pane);
        this.getContentPane().add(pB);
        this.addButtonAction(this.deleteDivisionButton);
        this.addButtonAction(this.addDivisionButton);
        this.addButtonAction(this.saveDivisionButton);
        this.enableButtons(division != null);
        if (division != null) {
            this.setTitle(Bundle.getMessage("EditDivision"));
            this.divisionNameTextField.setText(division.getName());
            this.commentTextField.setText(division.getComment());
        }
        this.setJMenuBar(new JMenuBar());
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_LocationDivision", true);
        this.initMinimumSize(new Dimension(700, 200));
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        Division division;
        if (ae.getSource() == this.saveDivisionButton) {
            log.debug("division save button activated");
            division = this.divisionManager.getDivisionByName(this.divisionNameTextField.getText());
            if (this._division == null && division == null) {
                this.addDivision();
            } else {
                if (division != null && division != this._division) {
                    this.reportDivisionExists(Bundle.getMessage("save"));
                    return;
                }
                this.saveDivision();
            }
            if (Setup.isCloseWindowOnSaveEnabled()) {
                this.dispose();
            }
        }
        if (ae.getSource() == this.deleteDivisionButton) {
            log.debug("division delete button activated");
            division = this.divisionManager.getDivisionByName(this.divisionNameTextField.getText());
            if (division == null) {
                return;
            }
            if (JOptionPane.showConfirmDialog(this, MessageFormat.format(Bundle.getMessage("DoYouWantToDeleteDivision"), this.divisionNameTextField.getText()), Bundle.getMessage("DeleteDivision"), 0) != 0) {
                return;
            }
            this.divisionManager.deregister(division);
            this._division = null;
            this.enableButtons(false);
            OperationsXml.save();
        }
        if (ae.getSource() == this.addDivisionButton) {
            division = this.divisionManager.getDivisionByName(this.divisionNameTextField.getText());
            if (division != null) {
                this.reportDivisionExists(Bundle.getMessage("add"));
                return;
            }
            this.addDivision();
        }
    }

    private void addDivision() {
        if (!this.checkName(Bundle.getMessage("add"))) {
            return;
        }
        this._division = this.divisionManager.newDivision(this.divisionNameTextField.getText());
        this.enableButtons(true);
        this.saveDivision();
    }

    private void saveDivision() {
        if (!this.checkName(Bundle.getMessage("save"))) {
            return;
        }
        this._division.setName(this.divisionNameTextField.getText());
        this._division.setComment(this.commentTextField.getText());
        OperationsXml.save();
    }

    private boolean checkName(String s) {
        if (this.divisionNameTextField.getText().trim().isEmpty()) {
            return false;
        }
        if (this.divisionNameTextField.getText().length() > MAX_NAME_LENGTH) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("DivisionNameLengthMax"), Integer.toString(MAX_NAME_LENGTH + 1)), MessageFormat.format(Bundle.getMessage("CanNotDivision"), s), 0);
            return false;
        }
        return true;
    }

    private void reportDivisionExists(String s) {
        JOptionPane.showMessageDialog(this, Bundle.getMessage("ReportDivisionExists"), MessageFormat.format(Bundle.getMessage("CanNotDivision"), s), 0);
    }

    private void enableButtons(boolean enabled) {
        this.saveDivisionButton.setEnabled(enabled);
        this.deleteDivisionButton.setEnabled(enabled);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
    }
}

