/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.divisions;

import jmri.InstanceManager;
import jmri.beans.Identifiable;
import jmri.beans.PropertyChangeSupport;
import jmri.jmrit.operations.locations.LocationManagerXml;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Division
extends PropertyChangeSupport
implements Identifiable {
    public static final String NONE = "";
    protected String _id = "";
    protected String _name = "";
    protected String _comment = "";
    public static final String NAME_CHANGED_PROPERTY = "divisionName";
    private static final Logger log = LoggerFactory.getLogger(Division.class);

    public Division(String id, String name) {
        log.debug("New division ({}) id: {}", (Object)name, (Object)id);
        this._name = name;
        this._id = id;
    }

    @Override
    public String getId() {
        return this._id;
    }

    public void setName(String name) {
        String old = this._name;
        this._name = name;
        if (!old.equals(name)) {
            this.setDirtyAndFirePropertyChange(NAME_CHANGED_PROPERTY, old, name);
        }
    }

    public String toString() {
        return this._name;
    }

    public String getName() {
        return this._name;
    }

    public void setComment(String comment) {
        String old = this._comment;
        this._comment = comment;
        if (!old.equals(comment)) {
            this.setDirtyAndFirePropertyChange("divisionComment", old, comment);
        }
    }

    public String getComment() {
        return this._comment;
    }

    public Division(Element e) {
        Attribute a = e.getAttribute("id");
        if (a != null) {
            this._id = a.getValue();
        } else {
            log.warn("no id attribute in location element when reading operations");
        }
        a = e.getAttribute("name");
        if (a != null) {
            this._name = a.getValue();
        }
        if ((a = e.getAttribute("comment")) != null) {
            this._comment = a.getValue();
        }
    }

    public Element store() {
        Element e = new Element("division");
        e.setAttribute("id", this.getId());
        e.setAttribute("name", this.getName());
        e.setAttribute("comment", this.getComment());
        return e;
    }

    protected void setDirtyAndFirePropertyChange(String p, Object old, Object n) {
        InstanceManager.getDefault(LocationManagerXml.class).setDirty(true);
        this.firePropertyChange(p, old, n);
    }
}

