/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations;

import java.beans.PropertyChangeEvent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import jmri.jmrit.operations.locations.Bundle;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.TrackTableModel;
import jmri.jmrit.operations.locations.YardEditFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YardTableModel
extends TrackTableModel {
    private static final Logger log = LoggerFactory.getLogger(YardTableModel.class);

    public void initTable(JTable table, Location location) {
        super.initTable(table, location, "Yard");
    }

    @Override
    protected void editTrack(int row) {
        log.debug("Edit yard");
        if (this.tef != null) {
            this.tef.dispose();
        }
        SwingUtilities.invokeLater(() -> {
            this.tef = new YardEditFrame();
            Track yard = (Track)this._tracksList.get(row);
            this.tef.initComponents(this._location, yard);
            this.tef.setTitle(Bundle.getMessage("EditYard"));
        });
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 1: {
                return Bundle.getMessage("YardName");
            }
        }
        return super.getColumnName(col);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        int row;
        Track track;
        super.propertyChange(e);
        if (e.getSource().getClass().equals(Track.class) && (track = (Track)e.getSource()).isYard() && (row = this._tracksList.indexOf(track)) >= 0) {
            this.fireTableRowsUpdated(row, row);
        }
    }
}

