/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsPanel;
import jmri.jmrit.operations.locations.Bundle;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.TrackEditFrame;
import jmri.jmrit.operations.setup.Setup;
import jmri.util.swing.XTableColumnModel;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TrackTableModel
extends AbstractTableModel
implements PropertyChangeListener,
TableColumnModelListener {
    protected Location _location;
    protected List<Track> _tracksList = new ArrayList<Track>();
    protected String _trackType;
    protected JTable _table;
    protected boolean _dirty = false;
    protected static final int ID_COLUMN = 0;
    protected static final int NAME_COLUMN = 1;
    protected static final int LENGTH_COLUMN = 2;
    protected static final int USED_LENGTH_COLUMN = 3;
    protected static final int RESERVED_COLUMN = 4;
    protected static final int MOVES_COLUMN = 5;
    protected static final int CARS_COLUMN = 6;
    protected static final int LOCOS_COLUMN = 7;
    protected static final int PICKUPS_COLUMN = 8;
    protected static final int SETOUT_COLUMN = 9;
    protected static final int SCHEDULE_COLUMN = 10;
    protected static final int ROAD_COLUMN = 11;
    protected static final int LOAD_COLUMN = 12;
    protected static final int SHIP_COLUMN = 13;
    protected static final int RESTRICTION_COLUMN = 14;
    protected static final int DESTINATION_COLUMN = 15;
    protected static final int POOL_COLUMN = 16;
    protected static final int PLANPICKUP_COLUMN = 17;
    protected static final int ALT_TRACK_COLUMN = 18;
    protected static final int ORDER_COLUMN = 19;
    protected static final int REPORTER_COLUMN = 20;
    protected static final int EDIT_COLUMN = 21;
    protected static final int HIGHESTCOLUMN = 22;
    TrackEditFrame tef = null;
    private static final Logger log = LoggerFactory.getLogger(TrackTableModel.class);

    protected void initTable(JTable table, Location location, String trackType) {
        this._table = table;
        this._location = location;
        this._trackType = trackType;
        if (this._location != null) {
            this._location.addPropertyChangeListener(this);
        }
        Setup.getDefault().addPropertyChangeListener(this);
        this.updateList();
        this.initTable();
    }

    private void updateList() {
        if (this._location == null) {
            return;
        }
        this.removePropertyChangeTracks();
        this._tracksList = this._location.getTracksByNameList(this._trackType);
        for (Track track : this._tracksList) {
            track.addPropertyChangeListener(this);
        }
    }

    private void initTable() {
        XTableColumnModel tcm = new XTableColumnModel();
        this._table.setColumnModel(tcm);
        this._table.createDefaultColumnsFromModel();
        tcm.getColumn(0).setPreferredWidth(40);
        tcm.getColumn(1).setPreferredWidth(200);
        tcm.getColumn(2).setPreferredWidth(Math.max(50, new JLabel((String)this.getColumnName((int)2)).getPreferredSize().width + 10));
        tcm.getColumn(3).setPreferredWidth(50);
        tcm.getColumn(4).setPreferredWidth(Math.max(65, new JLabel((String)this.getColumnName((int)4)).getPreferredSize().width + 10));
        tcm.getColumn(5).setPreferredWidth(60);
        tcm.getColumn(7).setPreferredWidth(60);
        tcm.getColumn(6).setPreferredWidth(60);
        tcm.getColumn(8).setPreferredWidth(Math.max(60, new JLabel((String)this.getColumnName((int)8)).getPreferredSize().width + 10));
        tcm.getColumn(9).setPreferredWidth(Math.max(60, new JLabel((String)this.getColumnName((int)9)).getPreferredSize().width + 10));
        tcm.getColumn(10).setPreferredWidth(Math.max(90, new JLabel((String)this.getColumnName((int)10)).getPreferredSize().width + 10));
        tcm.getColumn(14).setPreferredWidth(90);
        tcm.getColumn(12).setPreferredWidth(50);
        tcm.getColumn(13).setPreferredWidth(50);
        tcm.getColumn(11).setPreferredWidth(50);
        tcm.getColumn(15).setPreferredWidth(50);
        tcm.getColumn(16).setPreferredWidth(70);
        tcm.getColumn(17).setPreferredWidth(70);
        tcm.getColumn(18).setPreferredWidth(120);
        tcm.getColumn(19).setPreferredWidth(Math.max(50, new JLabel((String)this.getColumnName((int)19)).getPreferredSize().width + 10));
        tcm.getColumn(20).setPreferredWidth(70);
        tcm.getColumn(21).setPreferredWidth(80);
        tcm.getColumn(21).setCellRenderer(new ButtonRenderer());
        tcm.getColumn(21).setCellEditor(new ButtonEditor(new JButton()));
        OperationsPanel.loadTableDetails(this._table, "Location");
        this.setColumnsVisible();
        this.addTableColumnListeners();
    }

    private void setColumnsVisible() {
        XTableColumnModel tcm = (XTableColumnModel)this._table.getColumnModel();
        tcm.setColumnVisible(tcm.getColumnByModelIndex(10), this._location.hasSchedules());
        tcm.setColumnVisible(tcm.getColumnByModelIndex(14), this._location.hasServiceRestrictions());
        tcm.setColumnVisible(tcm.getColumnByModelIndex(12), this._location.hasLoadRestrictions());
        tcm.setColumnVisible(tcm.getColumnByModelIndex(13), this._location.hasShipLoadRestrictions());
        tcm.setColumnVisible(tcm.getColumnByModelIndex(11), this._location.hasRoadRestrictions());
        tcm.setColumnVisible(tcm.getColumnByModelIndex(15), this._location.hasDestinationRestrictions());
        tcm.setColumnVisible(tcm.getColumnByModelIndex(17), this._location.hasPlannedPickups());
        tcm.setColumnVisible(tcm.getColumnByModelIndex(16), this._location.hasPools());
        tcm.setColumnVisible(tcm.getColumnByModelIndex(18), this._location.hasAlternateTracks());
        tcm.setColumnVisible(tcm.getColumnByModelIndex(19), this._location.hasOrderRestrictions());
        tcm.setColumnVisible(tcm.getColumnByModelIndex(20), Setup.isRfidEnabled() && this._location.hasReporters());
        tcm.setColumnVisible(tcm.getColumnByModelIndex(5), Setup.isShowTrackMovesEnabled());
    }

    private void addTableColumnListeners() {
        Enumeration<TableColumn> e = this._table.getColumnModel().getColumns();
        while (e.hasMoreElements()) {
            TableColumn column = e.nextElement();
            column.addPropertyChangeListener(this);
        }
        this._table.getColumnModel().addColumnModelListener(this);
    }

    private void setDirty(boolean dirty) {
        this._dirty = dirty;
    }

    private boolean isDirty() {
        return this._dirty;
    }

    @Override
    public int getRowCount() {
        return this._tracksList.size();
    }

    @Override
    public int getColumnCount() {
        return 22;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("Id");
            }
            case 1: {
                return Bundle.getMessage("TrackName");
            }
            case 2: {
                return Bundle.getMessage("Length");
            }
            case 3: {
                return Bundle.getMessage("Used");
            }
            case 4: {
                return Bundle.getMessage("Reserved");
            }
            case 5: {
                return Bundle.getMessage("Moves");
            }
            case 7: {
                return Bundle.getMessage("Engines");
            }
            case 6: {
                return Bundle.getMessage("Cars");
            }
            case 8: {
                return Bundle.getMessage("Pickups");
            }
            case 9: {
                return Bundle.getMessage("Drop");
            }
            case 10: {
                return Bundle.getMessage("Schedule");
            }
            case 14: {
                return Bundle.getMessage("Restrictions");
            }
            case 12: {
                return Bundle.getMessage("Load");
            }
            case 13: {
                return Bundle.getMessage("Ship");
            }
            case 11: {
                return Bundle.getMessage("Road");
            }
            case 15: {
                return Bundle.getMessage("Dest");
            }
            case 16: {
                return Bundle.getMessage("Pool");
            }
            case 17: {
                return Bundle.getMessage("PlanPickUp");
            }
            case 18: {
                return Bundle.getMessage("AlternateTrack");
            }
            case 19: {
                return Bundle.getMessage("ServiceOrder");
            }
            case 20: {
                return Bundle.getMessage("Reporters");
            }
            case 21: {
                return Bundle.getMessage("ButtonEdit");
            }
        }
        return "unknown";
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: 
            case 1: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                return String.class;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return Integer.class;
            }
            case 21: {
                return JButton.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 5: 
            case 21: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.getRowCount()) {
            return "ERROR row " + row;
        }
        Track track = this._tracksList.get(row);
        if (track == null) {
            return "ERROR track unknown " + row;
        }
        switch (col) {
            case 0: {
                return track.getId();
            }
            case 1: {
                return track.getName();
            }
            case 2: {
                return track.getLength();
            }
            case 3: {
                return track.getUsedLength();
            }
            case 4: {
                return track.getReserved();
            }
            case 5: {
                return track.getMoves();
            }
            case 7: {
                return track.getNumberEngines();
            }
            case 6: {
                return track.getNumberCars();
            }
            case 8: {
                return track.getPickupRS();
            }
            case 9: {
                return track.getDropRS();
            }
            case 10: {
                return track.getScheduleName();
            }
            case 14: {
                return this.getRestrictions(track);
            }
            case 12: {
                return String.valueOf(this.getModifiedString(track.getLoadNames().length, track.getLoadOption().equals(Track.ALL_LOADS), track.getLoadOption().equals(Track.INCLUDE_LOADS))) + (track.isSpur() && track.isHoldCarsWithCustomLoadsEnabled() ? " H" : "");
            }
            case 13: {
                return this.getModifiedString(track.getShipLoadNames().length, track.getShipLoadOption().equals(Track.ALL_LOADS), track.getShipLoadOption().equals(Track.INCLUDE_LOADS));
            }
            case 11: {
                return this.getModifiedString(track.getRoadNames().length, track.getRoadOption().equals(Track.ALL_ROADS), track.getRoadOption().equals(Track.INCLUDE_ROADS));
            }
            case 15: {
                int size = track.getDestinationListSize();
                if (track.getDestinationOption().equals(Track.EXCLUDE_DESTINATIONS)) {
                    size = InstanceManager.getDefault(LocationManager.class).getNumberOfLocations() - size;
                }
                return this.getModifiedString(size, track.getDestinationOption().equals(Track.ALL_DESTINATIONS), track.getDestinationOption().equals(Track.INCLUDE_DESTINATIONS));
            }
            case 16: {
                return track.getPoolName();
            }
            case 17: {
                if (track.getIgnoreUsedLengthPercentage() > 0) {
                    return String.valueOf(track.getIgnoreUsedLengthPercentage()) + "%";
                }
                return "";
            }
            case 18: {
                if (track.getAlternateTrack() != null) {
                    return track.getAlternateTrack().getName();
                }
                if (track.isAlternate()) {
                    return Bundle.getMessage("ButtonYes");
                }
                return "";
            }
            case 19: {
                return track.getServiceOrder();
            }
            case 20: {
                return track.getReporterName();
            }
            case 21: {
                return Bundle.getMessage("ButtonEdit");
            }
        }
        return "unknown " + col;
    }

    private String getRestrictions(Track track) {
        String suffix;
        StringBuffer restrictions = new StringBuffer();
        if (!track.getDropOption().equals("Any")) {
            suffix = " ";
            if (track.getDropOption().equals("excludeRoutes") || track.getDropOption().equals("excludeTrains")) {
                suffix = "x";
            }
            restrictions.append(String.valueOf(Bundle.getMessage("AbbreviationSetOut")) + suffix + track.getDropIds().length);
        }
        if (!track.getPickupOption().equals("Any")) {
            suffix = " ";
            if (track.getPickupOption().equals("excludeRoutes") || track.getPickupOption().equals("excludeTrains")) {
                suffix = "x";
            }
            restrictions.append(" " + Bundle.getMessage("AbbreviationPickUp") + suffix + track.getPickupIds().length);
        }
        return restrictions.toString();
    }

    private String getModifiedString(int number, boolean all, boolean accept) {
        if (all) {
            return "";
        }
        if (accept) {
            return "A " + Integer.toString(number);
        }
        return "E " + Integer.toString(number);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        switch (col) {
            case 21: {
                this.editTrack(row);
                break;
            }
            case 5: {
                this.setMoves(row, value);
                break;
            }
        }
    }

    protected abstract void editTrack(int var1);

    private void setMoves(int row, Object value) {
        Track track = this._tracksList.get(row);
        track.setMoves((Integer)value);
    }

    private void removePropertyChangeTracks() {
        for (Track track : this._tracksList) {
            track.removePropertyChangeListener(this);
        }
    }

    public void dispose() {
        if (this._table != null) {
            this._table.getRowSorter().setSortKeys(null);
            if (this.isDirty()) {
                OperationsPanel.cacheState(this._table);
                OperationsPanel.saveTableState();
                this.setDirty(false);
            }
        }
        this.removePropertyChangeTracks();
        if (this._location != null) {
            this._location.removePropertyChangeListener(this);
        }
        if (this.tef != null) {
            this.tef.dispose();
        }
        Setup.getDefault().removePropertyChangeListener(this);
        this._tracksList.clear();
        this.fireTableDataChanged();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("trackListLength")) {
            this.updateList();
            this.fireTableDataChanged();
        }
        if (e.getPropertyName().equals("setupShowTrackMoves")) {
            this.setColumnsVisible();
        }
        if (e.getSource().getClass().equals(Track.class) && (e.getPropertyName().equals("trackDrop") || e.getPropertyName().equals("trackPickup") || e.getPropertyName().equals("trackScheduleId") || e.getPropertyName().equals("trackLoads") || e.getPropertyName().equals("trackRoads") || e.getPropertyName().equals("trackDestinationOptions") || e.getPropertyName().equals("trackPool") || e.getPropertyName().equals("plannedPickUps") || e.getPropertyName().equals("trackAlternate") || e.getPropertyName().equals("trackServiceOrder") || e.getPropertyName().equals("trackReporterChange"))) {
            this.setColumnsVisible();
        }
        if (e.getSource() instanceof TableColumn && e.getPropertyName().equals("preferredWidth")) {
            log.debug("Column width change");
            this.setDirty(true);
        }
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
    }

    @Override
    public void columnRemoved(TableColumnModelEvent e) {
    }

    @Override
    public void columnMoved(TableColumnModelEvent e) {
        if (e.getFromIndex() != e.getToIndex()) {
            log.debug("Table Column Moved");
            this.setDirty(true);
        }
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent e) {
    }
}

