/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.locations.Bundle;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.schedules.ScheduleManager;
import jmri.jmrit.operations.locations.tools.PoolTrackAction;
import jmri.jmrit.operations.locations.tools.TrackDestinationEditAction;
import jmri.jmrit.operations.locations.tools.TrackEditCommentsAction;
import jmri.jmrit.operations.locations.tools.TrackLoadEditAction;
import jmri.jmrit.operations.locations.tools.TrackRoadEditAction;
import jmri.jmrit.operations.rollingstock.cars.CarLoads;
import jmri.jmrit.operations.rollingstock.cars.CarRoads;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.rollingstock.engines.EngineTypes;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.routes.RouteManager;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainCommon;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.swing.NamedBeanComboBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TrackEditFrame
extends OperationsFrame
implements PropertyChangeListener {
    TrainManager trainManager = InstanceManager.getDefault(TrainManager.class);
    RouteManager routeManager = InstanceManager.getDefault(RouteManager.class);
    public Location _location = null;
    public Track _track = null;
    String _type = "";
    JMenu _toolMenu = new JMenu(Bundle.getMessage("MenuTools"));
    List<JCheckBox> checkBoxes = new ArrayList<JCheckBox>();
    JPanel panelCheckBoxes = new JPanel();
    JScrollPane paneCheckBoxes = new JScrollPane(this.panelCheckBoxes);
    JPanel panelTrainDir = new JPanel();
    JPanel pShipLoadOption = new JPanel();
    JPanel pDestinationOption = new JPanel();
    JPanel panelOrder = new JPanel();
    JButton loadOptionButton = new JButton(Bundle.getMessage("AcceptsAllLoads"));
    JButton shipLoadOptionButton = new JButton(Bundle.getMessage("ShipAll"));
    JButton roadOptionButton = new JButton(Bundle.getMessage("AcceptsAllRoads"));
    JButton destinationOptionButton = new JButton();
    JButton clearButton = new JButton(Bundle.getMessage("ClearAll"));
    JButton setButton = new JButton(Bundle.getMessage("SelectAll"));
    JButton saveTrackButton = new JButton(Bundle.getMessage("SaveTrack"));
    JButton deleteTrackButton = new JButton(Bundle.getMessage("DeleteTrack"));
    JButton addTrackButton = new JButton(Bundle.getMessage("AddTrack"));
    JButton deleteDropButton = new JButton(Bundle.getMessage("ButtonDelete"));
    JButton addDropButton = new JButton(Bundle.getMessage("Add"));
    JButton deletePickupButton = new JButton(Bundle.getMessage("ButtonDelete"));
    JButton addPickupButton = new JButton(Bundle.getMessage("Add"));
    JCheckBox northCheckBox = new JCheckBox(Bundle.getMessage("North"));
    JCheckBox southCheckBox = new JCheckBox(Bundle.getMessage("South"));
    JCheckBox eastCheckBox = new JCheckBox(Bundle.getMessage("East"));
    JCheckBox westCheckBox = new JCheckBox(Bundle.getMessage("West"));
    JCheckBox autoDropCheckBox = new JCheckBox(Bundle.getMessage("Auto"));
    JCheckBox autoPickupCheckBox = new JCheckBox(Bundle.getMessage("Auto"));
    JRadioButton orderNormal = new JRadioButton(Bundle.getMessage("Normal"));
    JRadioButton orderFIFO = new JRadioButton(Bundle.getMessage("DescriptiveFIFO"));
    JRadioButton orderLIFO = new JRadioButton(Bundle.getMessage("DescriptiveLIFO"));
    JRadioButton anyDrops = new JRadioButton(Bundle.getMessage("Any"));
    JRadioButton trainDrop = new JRadioButton(Bundle.getMessage("Trains"));
    JRadioButton routeDrop = new JRadioButton(Bundle.getMessage("Routes"));
    JRadioButton excludeTrainDrop = new JRadioButton(Bundle.getMessage("ExcludeTrains"));
    JRadioButton excludeRouteDrop = new JRadioButton(Bundle.getMessage("ExcludeRoutes"));
    JRadioButton anyPickups = new JRadioButton(Bundle.getMessage("Any"));
    JRadioButton trainPickup = new JRadioButton(Bundle.getMessage("Trains"));
    JRadioButton routePickup = new JRadioButton(Bundle.getMessage("Routes"));
    JRadioButton excludeTrainPickup = new JRadioButton(Bundle.getMessage("ExcludeTrains"));
    JRadioButton excludeRoutePickup = new JRadioButton(Bundle.getMessage("ExcludeRoutes"));
    JComboBox<Train> comboBoxDropTrains = this.trainManager.getTrainComboBox();
    JComboBox<Route> comboBoxDropRoutes = this.routeManager.getComboBox();
    JComboBox<Train> comboBoxPickupTrains = this.trainManager.getTrainComboBox();
    JComboBox<Route> comboBoxPickupRoutes = this.routeManager.getComboBox();
    JTextField trackNameTextField = new JTextField(Control.max_len_string_track_name);
    JTextField trackLengthTextField = new JTextField(Control.max_len_string_track_length_name);
    JTextArea commentTextArea = new JTextArea(2, 60);
    JScrollPane commentScroller = new JScrollPane(this.commentTextArea, 20, 30);
    JPanel dropPanel = new JPanel();
    JPanel pickupPanel = new JPanel();
    JPanel panelOpt3 = new JPanel();
    JPanel panelOpt4 = new JPanel();
    NamedBeanComboBox<Reporter> readerSelector;
    public static final String DISPOSE = "dispose";
    public static final int MAX_NAME_LENGTH = Control.max_len_string_track_name;
    int x = 0;
    int y = 0;
    private static final Logger log = LoggerFactory.getLogger(TrackEditFrame.class);

    public TrackEditFrame(String title) {
        super(title);
    }

    public void initComponents(Location location, Track track) {
        this._location = location;
        this._track = track;
        this.autoDropCheckBox.setToolTipText(Bundle.getMessage("TipAutoTrack"));
        this.autoPickupCheckBox.setToolTipText(Bundle.getMessage("TipAutoTrack"));
        this.trackLengthTextField.setToolTipText(MessageFormat.format(Bundle.getMessage("TipTrackLength"), Setup.getLengthUnit().toLowerCase()));
        this._location.addPropertyChangeListener(this);
        InstanceManager.getDefault(CarRoads.class).addPropertyChangeListener(this);
        InstanceManager.getDefault(CarLoads.class).addPropertyChangeListener(this);
        InstanceManager.getDefault(CarTypes.class).addPropertyChangeListener(this);
        this.trainManager.addPropertyChangeListener(this);
        this.routeManager.addPropertyChangeListener(this);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel panels = new JPanel();
        panels.setLayout(new BoxLayout(panels, 1));
        JScrollPane pane = new JScrollPane(panels);
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 0));
        JScrollPane p1Pane = new JScrollPane(p1);
        p1Pane.setVerticalScrollBarPolicy(21);
        p1Pane.setMinimumSize(new Dimension(300, 3 * this.trackNameTextField.getPreferredSize().height));
        p1Pane.setBorder(BorderFactory.createTitledBorder(""));
        JPanel pName = new JPanel();
        pName.setLayout(new GridBagLayout());
        pName.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Name")));
        this.addItem(pName, this.trackNameTextField, 0, 0);
        JPanel pLength = new JPanel();
        pLength.setLayout(new GridBagLayout());
        pLength.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Length")));
        pLength.setMinimumSize(new Dimension(60, 1));
        this.addItem(pLength, this.trackLengthTextField, 0, 0);
        this.panelTrainDir.setLayout(new GridBagLayout());
        this.panelTrainDir.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("TrainTrack")));
        this.panelTrainDir.setPreferredSize(new Dimension(200, 10));
        this.addItem(this.panelTrainDir, this.northCheckBox, 1, 1);
        this.addItem(this.panelTrainDir, this.southCheckBox, 2, 1);
        this.addItem(this.panelTrainDir, this.eastCheckBox, 3, 1);
        this.addItem(this.panelTrainDir, this.westCheckBox, 4, 1);
        p1.add(pName);
        p1.add(pLength);
        p1.add(this.panelTrainDir);
        this.panelCheckBoxes.setLayout(new GridBagLayout());
        JPanel panelRoadAndLoadStatus = new JPanel();
        panelRoadAndLoadStatus.setLayout(new BoxLayout(panelRoadAndLoadStatus, 0));
        JPanel pRoadOption = new JPanel();
        pRoadOption.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("RoadOption")));
        pRoadOption.add(this.roadOptionButton);
        this.roadOptionButton.addActionListener(new TrackRoadEditAction(this));
        JPanel pLoadOption = new JPanel();
        pLoadOption.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("LoadOption")));
        pLoadOption.add(this.loadOptionButton);
        this.loadOptionButton.addActionListener(new TrackLoadEditAction(this));
        this.pShipLoadOption.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("ShipLoadOption")));
        this.pShipLoadOption.add(this.shipLoadOptionButton);
        this.shipLoadOptionButton.addActionListener(new TrackLoadEditAction(this));
        this.pDestinationOption.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Destinations")));
        this.pDestinationOption.add(this.destinationOptionButton);
        this.destinationOptionButton.addActionListener(new TrackDestinationEditAction(this._track));
        panelRoadAndLoadStatus.add(pRoadOption);
        panelRoadAndLoadStatus.add(pLoadOption);
        panelRoadAndLoadStatus.add(this.pShipLoadOption);
        panelRoadAndLoadStatus.add(this.pDestinationOption);
        this.pShipLoadOption.setVisible(false);
        this.pDestinationOption.setVisible(false);
        this.panelOrder.setLayout(new GridBagLayout());
        this.panelOrder.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("PickupOrder")));
        this.panelOrder.add(this.orderNormal);
        this.panelOrder.add(this.orderFIFO);
        this.panelOrder.add(this.orderLIFO);
        ButtonGroup orderGroup = new ButtonGroup();
        orderGroup.add(this.orderNormal);
        orderGroup.add(this.orderFIFO);
        orderGroup.add(this.orderLIFO);
        this.dropPanel.setLayout(new GridBagLayout());
        this.dropPanel.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("TrainsOrRoutesDrops")));
        this.pickupPanel.setLayout(new GridBagLayout());
        this.pickupPanel.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("TrainsOrRoutesPickups")));
        JPanel panelComment = new JPanel();
        panelComment.setLayout(new GridBagLayout());
        panelComment.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Comment")));
        this.addItem(panelComment, this.commentScroller, 0, 0);
        this.adjustTextAreaColumnWidth(this.commentScroller, this.commentTextArea);
        JPanel readerPanel = new JPanel();
        if (Setup.isRfidEnabled()) {
            readerPanel.setLayout(new GridBagLayout());
            readerPanel.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("idReporter")));
            ReporterManager reporterManager = InstanceManager.getDefault(ReporterManager.class);
            this.readerSelector = new NamedBeanComboBox<Reporter>(reporterManager);
            this.readerSelector.setAllowNull(true);
            this.addItem(readerPanel, this.readerSelector, 0, 0);
        } else {
            readerPanel.setVisible(false);
        }
        JPanel panelButtons = new JPanel();
        panelButtons.setLayout(new GridBagLayout());
        this.addItem(panelButtons, this.deleteTrackButton, 0, 0);
        this.addItem(panelButtons, this.addTrackButton, 1, 0);
        this.addItem(panelButtons, this.saveTrackButton, 2, 0);
        this.paneCheckBoxes.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("TypesTrack")));
        panels.add(p1Pane);
        panels.add(this.paneCheckBoxes);
        panels.add(panelRoadAndLoadStatus);
        panels.add(this.panelOrder);
        panels.add(this.dropPanel);
        panels.add(this.pickupPanel);
        panels.add(this.panelOpt3);
        panels.add(this.panelOpt4);
        panels.add(panelComment);
        panels.add(readerPanel);
        panels.add(panelButtons);
        this.getContentPane().add(pane);
        this.addButtonAction(this.setButton);
        this.addButtonAction(this.clearButton);
        this.addButtonAction(this.deleteTrackButton);
        this.addButtonAction(this.addTrackButton);
        this.addButtonAction(this.saveTrackButton);
        this.addButtonAction(this.deleteDropButton);
        this.addButtonAction(this.addDropButton);
        this.addButtonAction(this.deletePickupButton);
        this.addButtonAction(this.addPickupButton);
        this.addRadioButtonAction(this.orderNormal);
        this.addRadioButtonAction(this.orderFIFO);
        this.addRadioButtonAction(this.orderLIFO);
        this.addRadioButtonAction(this.anyDrops);
        this.addRadioButtonAction(this.trainDrop);
        this.addRadioButtonAction(this.routeDrop);
        this.addRadioButtonAction(this.excludeTrainDrop);
        this.addRadioButtonAction(this.excludeRouteDrop);
        this.addRadioButtonAction(this.anyPickups);
        this.addRadioButtonAction(this.trainPickup);
        this.addRadioButtonAction(this.routePickup);
        this.addRadioButtonAction(this.excludeTrainPickup);
        this.addRadioButtonAction(this.excludeRoutePickup);
        this.addCheckBoxAction(this.autoDropCheckBox);
        this.addCheckBoxAction(this.autoPickupCheckBox);
        if (this._track != null) {
            this._track.addPropertyChangeListener(this);
            this.trackNameTextField.setText(this._track.getName());
            this.commentTextArea.setText(this._track.getComment());
            this.trackLengthTextField.setText(Integer.toString(this._track.getLength()));
            this.enableButtons(true);
            if (Setup.isRfidEnabled()) {
                this.readerSelector.setSelectedItem(this._track.getReporter());
            }
        } else {
            this.enableButtons(false);
        }
        JMenuBar menuBar = new JMenuBar();
        this._toolMenu.add(new TrackLoadEditAction(this));
        this._toolMenu.add(new TrackRoadEditAction(this));
        this._toolMenu.add(new TrackEditCommentsAction(this));
        this._toolMenu.add(new PoolTrackAction(this));
        menuBar.add(this._toolMenu);
        this.setJMenuBar(menuBar);
        this.updateCheckboxes();
        this.updateTrainDir();
        this.updateCarOrder();
        this.updateDropOptions();
        this.updatePickupOptions();
        this.updateRoadOption();
        this.updateLoadOption();
        this.updateDestinationOption();
        this.setMinimumSize(new Dimension(500, 600));
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        Route route;
        Route route2;
        Train train;
        String id;
        if (ae.getSource() == this.saveTrackButton) {
            log.debug("track save button activated");
            if (this._track != null) {
                if (!this.checkUserInputs(this._track)) {
                    return;
                }
                this.saveTrack(this._track);
                this.checkTrackPickups(this._track);
            } else {
                this.addNewTrack();
            }
            if (Setup.isCloseWindowOnSaveEnabled()) {
                this.dispose();
            }
        }
        if (ae.getSource() == this.deleteTrackButton) {
            log.debug("track delete button activated");
            this.deleteTrack();
        }
        if (ae.getSource() == this.addTrackButton) {
            this.addNewTrack();
        }
        if (this._track == null) {
            return;
        }
        if (ae.getSource() == this.setButton) {
            this.selectCheckboxes(true);
        }
        if (ae.getSource() == this.clearButton) {
            this.selectCheckboxes(false);
        }
        if (ae.getSource() == this.addDropButton) {
            id = "";
            if (this.trainDrop.isSelected() || this.excludeTrainDrop.isSelected()) {
                if (this.comboBoxDropTrains.getSelectedItem() == null) {
                    return;
                }
                train = (Train)this.comboBoxDropTrains.getSelectedItem();
                route2 = train.getRoute();
                id = train.getId();
                if (!this.checkRoute(route2)) {
                    JOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("TrackNotByTrain"), train.getName()), Bundle.getMessage("ErrorTitle"), 0);
                    return;
                }
                this.selectNextItemComboBox(this.comboBoxDropTrains);
            } else {
                if (this.comboBoxDropRoutes.getSelectedItem() == null) {
                    return;
                }
                route = (Route)this.comboBoxDropRoutes.getSelectedItem();
                id = route.getId();
                if (!this.checkRoute(route)) {
                    JOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("TrackNotByRoute"), route.getName()), Bundle.getMessage("ErrorTitle"), 0);
                    return;
                }
                this.selectNextItemComboBox(this.comboBoxDropRoutes);
            }
            this._track.addDropId(id);
        }
        if (ae.getSource() == this.deleteDropButton) {
            id = "";
            if (this.trainDrop.isSelected() || this.excludeTrainDrop.isSelected()) {
                if (this.comboBoxDropTrains.getSelectedItem() == null) {
                    return;
                }
                id = ((Train)this.comboBoxDropTrains.getSelectedItem()).getId();
                this.selectNextItemComboBox(this.comboBoxDropTrains);
            } else {
                if (this.comboBoxDropRoutes.getSelectedItem() == null) {
                    return;
                }
                id = ((Route)this.comboBoxDropRoutes.getSelectedItem()).getId();
                this.selectNextItemComboBox(this.comboBoxDropRoutes);
            }
            this._track.deleteDropId(id);
        }
        if (ae.getSource() == this.addPickupButton) {
            id = "";
            if (this.trainPickup.isSelected() || this.excludeTrainPickup.isSelected()) {
                if (this.comboBoxPickupTrains.getSelectedItem() == null) {
                    return;
                }
                train = (Train)this.comboBoxPickupTrains.getSelectedItem();
                route2 = train.getRoute();
                id = train.getId();
                if (!this.checkRoute(route2)) {
                    JOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("TrackNotByTrain"), train.getName()), Bundle.getMessage("ErrorTitle"), 0);
                    return;
                }
                this.selectNextItemComboBox(this.comboBoxPickupTrains);
            } else {
                if (this.comboBoxPickupRoutes.getSelectedItem() == null) {
                    return;
                }
                route = (Route)this.comboBoxPickupRoutes.getSelectedItem();
                id = route.getId();
                if (!this.checkRoute(route)) {
                    JOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("TrackNotByRoute"), route.getName()), Bundle.getMessage("ErrorTitle"), 0);
                    return;
                }
                this.selectNextItemComboBox(this.comboBoxPickupRoutes);
            }
            this._track.addPickupId(id);
        }
        if (ae.getSource() == this.deletePickupButton) {
            id = "";
            if (this.trainPickup.isSelected() || this.excludeTrainPickup.isSelected()) {
                if (this.comboBoxPickupTrains.getSelectedItem() == null) {
                    return;
                }
                id = ((Train)this.comboBoxPickupTrains.getSelectedItem()).getId();
                this.selectNextItemComboBox(this.comboBoxPickupTrains);
            } else {
                if (this.comboBoxPickupRoutes.getSelectedItem() == null) {
                    return;
                }
                id = ((Route)this.comboBoxPickupRoutes.getSelectedItem()).getId();
                this.selectNextItemComboBox(this.comboBoxPickupRoutes);
            }
            this._track.deletePickupId(id);
        }
    }

    protected void addNewTrack() {
        if (!this.checkName(Bundle.getMessage("add"))) {
            return;
        }
        Track check = this._location.getTrackByName(this.trackNameTextField.getText(), null);
        if (check != null) {
            this.reportTrackExists(Bundle.getMessage("add"));
            return;
        }
        this._track = this._location.addTrack(this.trackNameTextField.getText(), this._type);
        this.checkLength(this._track);
        this.setPreferredSize(this.getSize());
        this.updateTrainDir();
        this.updateCheckboxes();
        this.updateDropOptions();
        this.updatePickupOptions();
        this.updateRoadOption();
        this.updateLoadOption();
        this.updateDestinationOption();
        this._track.addPropertyChangeListener(this);
        this.selectCheckboxes(true);
        this._track.setComment(this.commentTextArea.getText());
        this.enableButtons(true);
        OperationsXml.save();
    }

    protected void deleteTrack() {
        if (this._track != null) {
            int rs = this._track.getNumberRS();
            if (rs > 0 && JOptionPane.showConfirmDialog(this, MessageFormat.format(Bundle.getMessage("ThereAreCars"), Integer.toString(rs)), Bundle.getMessage("deleteTrack?"), 0) != 0) {
                return;
            }
            this.selectCheckboxes(false);
            this._location.deleteTrack(this._track);
            this._track = null;
            this.enableButtons(false);
            OperationsXml.save();
        }
    }

    private boolean checkRoute(Route route) {
        if (route == null) {
            return false;
        }
        RouteLocation rl = null;
        rl = route.getLastLocationByName(this._location.getName());
        return rl != null;
    }

    protected void saveTrack(Track track) {
        this.saveTrackDirections(track);
        track.setName(this.trackNameTextField.getText());
        track.setComment(this.commentTextArea.getText());
        if (Setup.isRfidEnabled()) {
            this._track.setReporter((Reporter)this.readerSelector.getSelectedItem());
        }
        this.setPreferredSize(this.getSize());
        this.enableButtons(true);
        OperationsXml.save();
    }

    private void saveTrackDirections(Track track) {
        int direction = 0;
        if (this.northCheckBox.isSelected()) {
            direction += 4;
        }
        if (this.southCheckBox.isSelected()) {
            direction += 8;
        }
        if (this.eastCheckBox.isSelected()) {
            ++direction;
        }
        if (this.westCheckBox.isSelected()) {
            direction += 2;
        }
        track.setTrainDirections(direction);
    }

    private boolean checkUserInputs(Track track) {
        if (!this.checkName(Bundle.getMessage("save"))) {
            return false;
        }
        Track check = this._location.getTrackByName(this.trackNameTextField.getText(), null);
        if (check != null && check != track) {
            this.reportTrackExists(Bundle.getMessage("save"));
            return false;
        }
        if (!this.checkLength(track)) {
            return false;
        }
        return this.checkService(track);
    }

    private boolean checkName(String s) {
        String trackName = this.trackNameTextField.getText().trim();
        if (trackName.isEmpty()) {
            log.debug("Must enter a track name");
            JOptionPane.showMessageDialog(this, Bundle.getMessage("MustEnterName"), MessageFormat.format(Bundle.getMessage("CanNotTrack"), s), 0);
            return false;
        }
        String[] check = trackName.split("-");
        if (check.length == 0) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("HyphenFeature"), MessageFormat.format(Bundle.getMessage("CanNotTrack"), s), 0);
            return false;
        }
        if (TrainCommon.splitString(trackName).length() > MAX_NAME_LENGTH) {
            log.error("Track name must be less than {} charaters", (Object)Integer.toString(MAX_NAME_LENGTH + 1));
            JOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("TrackNameLengthMax"), Integer.toString(MAX_NAME_LENGTH + 1)), MessageFormat.format(Bundle.getMessage("CanNotTrack"), s), 0);
            return false;
        }
        return true;
    }

    private boolean checkLength(Track track) {
        String length = this.trackLengthTextField.getText();
        if (length.endsWith("\"")) {
            length = length.substring(0, length.length() - 1);
            try {
                double inches = Double.parseDouble(length);
                int feet = (int)(inches * (double)Setup.getScaleRatio() / 12.0);
                length = Integer.toString(feet);
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, Bundle.getMessage("CanNotConvertFeet"), Bundle.getMessage("ErrorTrackLength"), 0);
                return false;
            }
        }
        if (length.endsWith("cm")) {
            length = length.substring(0, length.length() - 2);
            try {
                double cm = Double.parseDouble(length);
                int meter = (int)(cm * (double)Setup.getScaleRatio() / 100.0);
                length = Integer.toString(meter);
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, Bundle.getMessage("CanNotConvertMeter"), Bundle.getMessage("ErrorTrackLength"), 0);
                return false;
            }
        }
        int trackLength = 0;
        try {
            trackLength = Integer.parseInt(length);
            if (length.length() > Control.max_len_string_track_length_name) {
                JOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("TrackMustBeLessThan"), Math.pow(10.0, Control.max_len_string_track_length_name), Setup.getLengthUnit().toLowerCase()), Bundle.getMessage("ErrorTrackLength"), 0);
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("TrackMustBeNumber"), Bundle.getMessage("ErrorTrackLength"), 0);
            return false;
        }
        if (trackLength != track.getLength() && trackLength < track.getUsedLength() + track.getReserved()) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("TrackMustBeGreater"), Bundle.getMessage("ErrorTrackLength"), 0);
            if (JOptionPane.showConfirmDialog(this, MessageFormat.format(Bundle.getMessage("TrackForceLength"), track.getLength(), trackLength, Setup.getLengthUnit().toLowerCase()), Bundle.getMessage("ErrorTrackLength"), 0) != 0) {
                return false;
            }
        }
        track.setLength(trackLength);
        return true;
    }

    private boolean checkService(Track track) {
        if ((this.trainDrop.isSelected() || this.routeDrop.isSelected()) && track.getDropIds().length == 0) {
            log.debug("Must enter trains or routes for this track");
            JOptionPane.showMessageDialog(this, Bundle.getMessage("UseAddTrainsOrRoutes"), Bundle.getMessage("SetOutDisabled"), 0);
            return false;
        }
        if ((this.trainPickup.isSelected() || this.routePickup.isSelected()) && track.getPickupIds().length == 0) {
            log.debug("Must enter trains or routes for this track");
            JOptionPane.showMessageDialog(this, Bundle.getMessage("UseAddTrainsOrRoutes"), Bundle.getMessage("PickUpsDisabled"), 0);
            return false;
        }
        return true;
    }

    private boolean checkTrackPickups(Track track) {
        String status = track.checkPickups();
        if (!status.equals("") && !track.getPickupOption().equals("Any")) {
            JOptionPane.showMessageDialog(this, status, Bundle.getMessage("ErrorStrandedCar"), 0);
            return false;
        }
        return true;
    }

    private void reportTrackExists(String s) {
        log.info("Can not {}, track already exists", (Object)s);
        JOptionPane.showMessageDialog(this, Bundle.getMessage("TrackAlreadyExists"), MessageFormat.format(Bundle.getMessage("CanNotTrack"), s), 0);
    }

    protected void enableButtons(boolean enabled) {
        this._toolMenu.setEnabled(enabled);
        this.northCheckBox.setEnabled(enabled);
        this.southCheckBox.setEnabled(enabled);
        this.eastCheckBox.setEnabled(enabled);
        this.westCheckBox.setEnabled(enabled);
        this.clearButton.setEnabled(enabled);
        this.setButton.setEnabled(enabled);
        this.deleteTrackButton.setEnabled(enabled);
        this.saveTrackButton.setEnabled(enabled);
        this.roadOptionButton.setEnabled(enabled);
        this.loadOptionButton.setEnabled(enabled);
        this.shipLoadOptionButton.setEnabled(enabled);
        this.destinationOptionButton.setEnabled(enabled);
        this.anyDrops.setEnabled(enabled);
        this.trainDrop.setEnabled(enabled);
        this.routeDrop.setEnabled(enabled);
        this.excludeTrainDrop.setEnabled(enabled);
        this.excludeRouteDrop.setEnabled(enabled);
        this.anyPickups.setEnabled(enabled);
        this.trainPickup.setEnabled(enabled);
        this.routePickup.setEnabled(enabled);
        this.excludeTrainPickup.setEnabled(enabled);
        this.excludeRoutePickup.setEnabled(enabled);
        this.orderNormal.setEnabled(enabled);
        this.orderFIFO.setEnabled(enabled);
        this.orderLIFO.setEnabled(enabled);
        this.enableCheckboxes(enabled);
        if (this.readerSelector != null) {
            this.readerSelector.setEnabled(enabled && Setup.isRfidEnabled());
        }
    }

    @Override
    public void radioButtonActionPerformed(ActionEvent ae) {
        log.debug("radio button activated");
        if (ae.getSource() == this.orderNormal) {
            this._track.setServiceOrder(Track.NORMAL);
        }
        if (ae.getSource() == this.orderFIFO) {
            this._track.setServiceOrder(Track.FIFO);
        }
        if (ae.getSource() == this.orderLIFO) {
            this._track.setServiceOrder(Track.LIFO);
        }
        if (ae.getSource() == this.anyDrops) {
            this._track.setDropOption("Any");
            this.updateDropOptions();
        }
        if (ae.getSource() == this.trainDrop) {
            this._track.setDropOption("trains");
            this.updateDropOptions();
        }
        if (ae.getSource() == this.routeDrop) {
            this._track.setDropOption("routes");
            this.updateDropOptions();
        }
        if (ae.getSource() == this.excludeTrainDrop) {
            this._track.setDropOption("excludeTrains");
            this.updateDropOptions();
        }
        if (ae.getSource() == this.excludeRouteDrop) {
            this._track.setDropOption("excludeRoutes");
            this.updateDropOptions();
        }
        if (ae.getSource() == this.anyPickups) {
            this._track.setPickupOption("Any");
            this.updatePickupOptions();
        }
        if (ae.getSource() == this.trainPickup) {
            this._track.setPickupOption("trains");
            this.updatePickupOptions();
        }
        if (ae.getSource() == this.routePickup) {
            this._track.setPickupOption("routes");
            this.updatePickupOptions();
        }
        if (ae.getSource() == this.excludeTrainPickup) {
            this._track.setPickupOption("excludeTrains");
            this.updatePickupOptions();
        }
        if (ae.getSource() == this.excludeRoutePickup) {
            this._track.setPickupOption("excludeRoutes");
            this.updatePickupOptions();
        }
    }

    private void updateDropOptions() {
        this.dropPanel.removeAll();
        int numberOfItems = this.getNumberOfCheckboxesPerLine();
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        p.add(this.anyDrops);
        p.add(this.trainDrop);
        p.add(this.routeDrop);
        p.add(this.excludeTrainDrop);
        p.add(this.excludeRouteDrop);
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridwidth = numberOfItems + 1;
        this.dropPanel.add((Component)p, gc);
        int y = 1;
        if (this._track != null) {
            this.anyDrops.setSelected(this._track.getDropOption().equals("Any"));
            this.trainDrop.setSelected(this._track.getDropOption().equals("trains"));
            this.routeDrop.setSelected(this._track.getDropOption().equals("routes"));
            this.excludeTrainDrop.setSelected(this._track.getDropOption().equals("excludeTrains"));
            this.excludeRouteDrop.setSelected(this._track.getDropOption().equals("excludeRoutes"));
            if (!this.anyDrops.isSelected()) {
                p = new JPanel();
                p.setLayout(new FlowLayout());
                if (this.trainDrop.isSelected() || this.excludeTrainDrop.isSelected()) {
                    p.add(this.comboBoxDropTrains);
                } else {
                    p.add(this.comboBoxDropRoutes);
                }
                p.add(this.addDropButton);
                p.add(this.deleteDropButton);
                p.add(this.autoDropCheckBox);
                gc.gridy = y++;
                this.dropPanel.add((Component)p, gc);
                ++y;
                String[] dropIds = this._track.getDropIds();
                int x = 0;
                String[] stringArray = dropIds;
                int n = dropIds.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    JLabel names = new JLabel();
                    String name = "<deleted>";
                    if (this.trainDrop.isSelected() || this.excludeTrainDrop.isSelected()) {
                        Train train = this.trainManager.getTrainById(id);
                        if (train != null) {
                            name = train.getName();
                        }
                    } else {
                        Route route = this.routeManager.getRouteById(id);
                        if (route != null) {
                            name = route.getName();
                        }
                    }
                    if (name.equals("<deleted>")) {
                        this._track.deleteDropId(id);
                    }
                    names.setText(name);
                    this.addItem(this.dropPanel, names, x++, y);
                    if (x > numberOfItems) {
                        ++y;
                        x = 0;
                    }
                    ++n2;
                }
            }
        } else {
            this.anyDrops.setSelected(true);
        }
        this.dropPanel.revalidate();
        this.dropPanel.repaint();
        this.revalidate();
    }

    private void updatePickupOptions() {
        log.debug("update pick up options");
        this.pickupPanel.removeAll();
        int numberOfCheckboxes = this.getNumberOfCheckboxesPerLine();
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        p.add(this.anyPickups);
        p.add(this.trainPickup);
        p.add(this.routePickup);
        p.add(this.excludeTrainPickup);
        p.add(this.excludeRoutePickup);
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridwidth = numberOfCheckboxes + 1;
        this.pickupPanel.add((Component)p, gc);
        int y = 1;
        if (this._track != null) {
            this.anyPickups.setSelected(this._track.getPickupOption().equals("Any"));
            this.trainPickup.setSelected(this._track.getPickupOption().equals("trains"));
            this.routePickup.setSelected(this._track.getPickupOption().equals("routes"));
            this.excludeTrainPickup.setSelected(this._track.getPickupOption().equals("excludeTrains"));
            this.excludeRoutePickup.setSelected(this._track.getPickupOption().equals("excludeRoutes"));
            if (!this.anyPickups.isSelected()) {
                p = new JPanel();
                p.setLayout(new FlowLayout());
                if (this.trainPickup.isSelected() || this.excludeTrainPickup.isSelected()) {
                    p.add(this.comboBoxPickupTrains);
                } else {
                    p.add(this.comboBoxPickupRoutes);
                }
                p.add(this.addPickupButton);
                p.add(this.deletePickupButton);
                p.add(this.autoPickupCheckBox);
                gc.gridy = y++;
                this.pickupPanel.add((Component)p, gc);
                ++y;
                int x = 0;
                String[] stringArray = this._track.getPickupIds();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    JLabel names = new JLabel();
                    String name = "<deleted>";
                    if (this.trainPickup.isSelected() || this.excludeTrainPickup.isSelected()) {
                        Train train = this.trainManager.getTrainById(id);
                        if (train != null) {
                            name = train.getName();
                        }
                    } else {
                        Route route = this.routeManager.getRouteById(id);
                        if (route != null) {
                            name = route.getName();
                        }
                    }
                    if (name.equals("<deleted>")) {
                        this._track.deletePickupId(id);
                    }
                    names.setText(name);
                    this.addItem(this.pickupPanel, names, x++, y);
                    if (x > numberOfCheckboxes) {
                        ++y;
                        x = 0;
                    }
                    ++n2;
                }
            }
        } else {
            this.anyPickups.setSelected(true);
        }
        this.pickupPanel.revalidate();
        this.pickupPanel.repaint();
        this.revalidate();
    }

    protected void updateTrainComboBox() {
        this.trainManager.updateTrainComboBox(this.comboBoxPickupTrains);
        if (this.autoPickupCheckBox.isSelected()) {
            this.autoTrainComboBox(this.comboBoxPickupTrains);
        }
        this.trainManager.updateTrainComboBox(this.comboBoxDropTrains);
        if (this.autoDropCheckBox.isSelected()) {
            this.autoTrainComboBox(this.comboBoxDropTrains);
        }
    }

    private void autoTrainComboBox(JComboBox<Train> box) {
        int i = 1;
        while (i < box.getItemCount()) {
            Train train = box.getItemAt(i);
            if (!this.checkRoute(train.getRoute())) {
                box.removeItemAt(i--);
            }
            ++i;
        }
    }

    protected void updateRouteComboBox() {
        this.routeManager.updateComboBox(this.comboBoxPickupRoutes);
        if (this.autoPickupCheckBox.isSelected()) {
            this.autoRouteComboBox(this.comboBoxPickupRoutes);
        }
        this.routeManager.updateComboBox(this.comboBoxDropRoutes);
        if (this.autoDropCheckBox.isSelected()) {
            this.autoRouteComboBox(this.comboBoxDropRoutes);
        }
    }

    private void autoRouteComboBox(JComboBox<Route> box) {
        int i = 1;
        while (i < box.getItemCount()) {
            Route route = box.getItemAt(i);
            if (!this.checkRoute(route)) {
                box.removeItemAt(i--);
            }
            ++i;
        }
    }

    private void enableCheckboxes(boolean enable) {
        int i = 0;
        while (i < this.checkBoxes.size()) {
            this.checkBoxes.get(i).setEnabled(enable);
            ++i;
        }
    }

    private void selectCheckboxes(boolean enable) {
        int i = 0;
        while (i < this.checkBoxes.size()) {
            JCheckBox checkBox = this.checkBoxes.get(i);
            checkBox.setSelected(enable);
            if (this._track != null) {
                if (enable) {
                    this._track.addTypeName(checkBox.getText());
                } else {
                    this._track.deleteTypeName(checkBox.getText());
                }
            }
            ++i;
        }
    }

    private void updateCheckboxes() {
        this.checkBoxes.clear();
        this.panelCheckBoxes.removeAll();
        this.x = 0;
        this.y = 0;
        this.loadTypes(InstanceManager.getDefault(CarTypes.class).getNames());
        this.loadTypes(InstanceManager.getDefault(EngineTypes.class).getNames());
        this.enableCheckboxes(this._track != null);
        JPanel p = new JPanel();
        p.add(this.clearButton);
        p.add(this.setButton);
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridwidth = this.getNumberOfCheckboxesPerLine() + 1;
        gc.gridy = ++this.y;
        this.panelCheckBoxes.add((Component)p, gc);
        this.panelCheckBoxes.revalidate();
        this.panelCheckBoxes.repaint();
    }

    private void loadTypes(String[] types) {
        int numberOfCheckboxes = this.getNumberOfCheckboxesPerLine();
        String[] stringArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (this._location.acceptsTypeName(type)) {
                JCheckBox checkBox = new JCheckBox();
                this.checkBoxes.add(checkBox);
                checkBox.setText(type);
                this.addCheckBoxAction(checkBox);
                this.addItemLeft(this.panelCheckBoxes, checkBox, this.x++, this.y);
                if (this._track != null && this._track.isTypeNameAccepted(type)) {
                    checkBox.setSelected(true);
                }
            }
            if (this.x > numberOfCheckboxes) {
                ++this.y;
                this.x = 0;
            }
            ++n2;
        }
    }

    private void updateRoadOption() {
        if (this._track != null) {
            this.roadOptionButton.setText(this._track.getRoadOptionString());
        }
    }

    private void updateLoadOption() {
        if (this._track != null) {
            this.loadOptionButton.setText(this._track.getLoadOptionString());
            this.shipLoadOptionButton.setText(this._track.getShipLoadOptionString());
        }
    }

    private void updateTrainDir() {
        this.northCheckBox.setVisible((Setup.getTrainDirection() & 4 & (this._location.getTrainDirections() & 4)) == 4);
        this.southCheckBox.setVisible((Setup.getTrainDirection() & 8 & (this._location.getTrainDirections() & 8)) == 8);
        this.eastCheckBox.setVisible((Setup.getTrainDirection() & 1 & (this._location.getTrainDirections() & 1)) == 1);
        this.westCheckBox.setVisible((Setup.getTrainDirection() & 2 & (this._location.getTrainDirections() & 2)) == 2);
        if (this._track != null) {
            this.northCheckBox.setSelected((this._track.getTrainDirections() & 4) == 4);
            this.southCheckBox.setSelected((this._track.getTrainDirections() & 8) == 8);
            this.eastCheckBox.setSelected((this._track.getTrainDirections() & 1) == 1);
            this.westCheckBox.setSelected((this._track.getTrainDirections() & 2) == 2);
        }
        this.panelTrainDir.revalidate();
        this.revalidate();
    }

    @Override
    public void checkBoxActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.autoDropCheckBox || ae.getSource() == this.autoPickupCheckBox) {
            this.updateTrainComboBox();
            this.updateRouteComboBox();
            return;
        }
        JCheckBox b = (JCheckBox)ae.getSource();
        log.debug("checkbox change {}", (Object)b.getText());
        if (this._location == null) {
            return;
        }
        if (b.isSelected()) {
            this._track.addTypeName(b.getText());
        } else {
            this._track.deleteTypeName(b.getText());
        }
    }

    private void updateCarOrder() {
        if (this._track != null) {
            this.orderNormal.setSelected(this._track.getServiceOrder().equals(Track.NORMAL));
            this.orderFIFO.setSelected(this._track.getServiceOrder().equals(Track.FIFO));
            this.orderLIFO.setSelected(this._track.getServiceOrder().equals(Track.LIFO));
        }
    }

    protected void updateDestinationOption() {
        if (this._track != null) {
            if (this._track.getDestinationOption().equals(Track.INCLUDE_DESTINATIONS)) {
                this.pDestinationOption.setVisible(true);
                this.destinationOptionButton.setText(String.valueOf(Bundle.getMessage("AcceptOnly")) + " " + this._track.getDestinationListSize() + " " + Bundle.getMessage("Destinations"));
            } else if (this._track.getDestinationOption().equals(Track.EXCLUDE_DESTINATIONS)) {
                this.pDestinationOption.setVisible(true);
                this.destinationOptionButton.setText(String.valueOf(Bundle.getMessage("Exclude")) + " " + (InstanceManager.getDefault(LocationManager.class).getNumberOfLocations() - this._track.getDestinationListSize()) + " " + Bundle.getMessage("Destinations"));
            } else {
                this.destinationOptionButton.setText(Bundle.getMessage("AcceptAll"));
            }
        }
    }

    @Override
    public void dispose() {
        if (this._track != null) {
            this._track.removePropertyChangeListener(this);
        }
        if (this._location != null) {
            this._location.removePropertyChangeListener(this);
        }
        InstanceManager.getDefault(CarRoads.class).removePropertyChangeListener(this);
        InstanceManager.getDefault(CarLoads.class).removePropertyChangeListener(this);
        InstanceManager.getDefault(CarTypes.class).removePropertyChangeListener(this);
        InstanceManager.getDefault(ScheduleManager.class).removePropertyChangeListener(this);
        this.trainManager.removePropertyChangeListener(this);
        this.routeManager.removePropertyChangeListener(this);
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("locationTypes") || e.getPropertyName().equals("CarTypes Length") || e.getPropertyName().equals("trackRollingStockTypes")) {
            this.updateCheckboxes();
        }
        if (e.getPropertyName().equals("locationTrainDirection") || e.getPropertyName().equals("trackTrainDirection")) {
            this.updateTrainDir();
        }
        if (e.getPropertyName().equals("TrainsListLength")) {
            this.updateTrainComboBox();
            this.updateDropOptions();
            this.updatePickupOptions();
        }
        if (e.getPropertyName().equals("routesListLengthChanged")) {
            this.updateRouteComboBox();
            this.updateDropOptions();
            this.updatePickupOptions();
        }
        if (e.getPropertyName().equals("trackRoads")) {
            this.updateRoadOption();
        }
        if (e.getPropertyName().equals("trackLoads")) {
            this.updateLoadOption();
        }
        if (e.getPropertyName().equals("trackDrop")) {
            this.updateDropOptions();
        }
        if (e.getPropertyName().equals("trackPickup")) {
            this.updatePickupOptions();
        }
        if (e.getPropertyName().equals("trackServiceOrder")) {
            this.updateCarOrder();
        }
        if (e.getPropertyName().equals("trackDestinations") || e.getPropertyName().equals("trackDestinationOptions")) {
            this.updateDestinationOption();
        }
    }
}

