/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations;

import java.beans.PropertyChangeEvent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import jmri.jmrit.operations.locations.Bundle;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.StagingEditFrame;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.TrackTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StagingTableModel
extends TrackTableModel {
    private static final Logger log = LoggerFactory.getLogger(StagingTableModel.class);

    public void initTable(JTable table, Location location) {
        super.initTable(table, location, "Staging");
    }

    @Override
    protected void editTrack(int row) {
        log.debug("Edit staging");
        if (this.tef != null) {
            this.tef.dispose();
        }
        SwingUtilities.invokeLater(() -> {
            this.tef = new StagingEditFrame();
            Track staging = (Track)this._tracksList.get(row);
            this.tef.initComponents(this._location, staging);
            this.tef.setTitle(Bundle.getMessage("EditStaging"));
        });
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 1: {
                return Bundle.getMessage("StagingName");
            }
        }
        return super.getColumnName(col);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        int row;
        Track track;
        super.propertyChange(e);
        if (e.getSource().getClass().equals(Track.class) && (track = (Track)e.getSource()).isStaging() && (row = this._tracksList.indexOf(track)) >= 0) {
            this.fireTableRowsUpdated(row, row);
        }
    }
}

