/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations;

import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import jmri.jmrit.operations.locations.Bundle;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.TrackEditFrame;
import jmri.jmrit.operations.locations.tools.ShowCarsByLocationAction;
import jmri.jmrit.operations.locations.tools.ShowTrainsServingLocationAction;
import jmri.jmrit.operations.locations.tools.TrackDestinationEditAction;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.trains.Train;

public class StagingEditFrame
extends TrackEditFrame {
    JCheckBox swapLoadsCheckBox = new JCheckBox(Bundle.getMessage("SwapCarLoads"));
    JCheckBox emptyCheckBox = new JCheckBox(Bundle.getMessage("EmptyDefaultCarLoads"));
    JCheckBox emptyCustomCheckBox = new JCheckBox(Bundle.getMessage("EmptyCarLoads"));
    JCheckBox loadCheckBox = new JCheckBox(Bundle.getMessage("LoadCarLoads"));
    JCheckBox loadAnyCheckBox = new JCheckBox(Bundle.getMessage("LoadAnyCarLoads"));
    JCheckBox loadAnyStagingCheckBox = new JCheckBox(Bundle.getMessage("LoadsStaging"));
    JCheckBox blockCarsCheckBox = new JCheckBox(Bundle.getMessage("BlockCars"));
    JPanel panelLoad = this.panelOpt4;

    public StagingEditFrame() {
        super(Bundle.getMessage("AddStaging"));
    }

    @Override
    public void initComponents(Location location, Track track) {
        this._type = "Staging";
        this.panelLoad.setLayout(new BoxLayout(this.panelLoad, 0));
        JPanel p1 = new JPanel();
        p1.setLayout(new GridBagLayout());
        p1.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("OptionalLoads")));
        this.addItemLeft(p1, this.swapLoadsCheckBox, 0, 0);
        this.addItemLeft(p1, this.emptyCheckBox, 0, 1);
        JPanel p2 = new JPanel();
        p2.setLayout(new GridBagLayout());
        p2.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("OptionalCustomLoads")));
        this.addItemLeft(p2, this.emptyCustomCheckBox, 0, 0);
        this.addItemLeft(p2, this.loadCheckBox, 0, 1);
        this.addItemLeft(p2, this.loadAnyCheckBox, 0, 2);
        this.addItemLeft(p2, this.loadAnyStagingCheckBox, 0, 3);
        JPanel p3 = new JPanel();
        p3.setLayout(new GridBagLayout());
        p3.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("OptionalBlocking")));
        this.addItemLeft(p3, this.blockCarsCheckBox, 0, 0);
        this.loadCheckBox.setToolTipText(Bundle.getMessage("TipIgnoresAlternate"));
        this.blockCarsCheckBox.setToolTipText(Bundle.getMessage("TipBlockByPickUp"));
        this.panelLoad.add(p1);
        this.panelLoad.add(p2);
        this.panelLoad.add(p3);
        super.initComponents(location, track);
        this._toolMenu.add(new TrackDestinationEditAction(this._track));
        this._toolMenu.add(new ShowTrainsServingLocationAction(this._location, this._track));
        this._toolMenu.add(new ShowCarsByLocationAction(false, this._location, this._track));
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_Staging", true);
        this.panelTrainDir.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("TrainStaging")));
        this.paneCheckBoxes.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("TypesStaging")));
        this.dropPanel.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("SelectTrainArrival")));
        this.pickupPanel.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("SelectTrainDeparture")));
        this.deleteTrackButton.setText(Bundle.getMessage("DeleteStaging"));
        this.addTrackButton.setText(Bundle.getMessage("AddStaging"));
        this.saveTrackButton.setText(Bundle.getMessage("SaveStaging"));
        if (this._track != null) {
            this.swapLoadsCheckBox.setSelected(this._track.isLoadSwapEnabled());
            this.emptyCheckBox.setSelected(this._track.isLoadEmptyEnabled());
            this.emptyCustomCheckBox.setSelected(this._track.isRemoveCustomLoadsEnabled());
            this.loadCheckBox.setSelected(this._track.isAddCustomLoadsEnabled());
            this.loadAnyCheckBox.setSelected(this._track.isAddCustomLoadsAnySpurEnabled());
            this.loadAnyStagingCheckBox.setSelected(this._track.isAddCustomLoadsAnyStagingTrackEnabled());
            this.blockCarsCheckBox.setSelected(this._track.isBlockCarsEnabled());
            if (this.loadCheckBox.isSelected() || this.loadAnyCheckBox.isSelected() || this.loadAnyStagingCheckBox.isSelected()) {
                this.blockCarsCheckBox.setSelected(false);
            }
        }
        this.addCheckBoxAction(this.swapLoadsCheckBox);
        this.addCheckBoxAction(this.emptyCheckBox);
        this.addCheckBoxAction(this.loadCheckBox);
        this.addCheckBoxAction(this.loadAnyCheckBox);
        this.addCheckBoxAction(this.loadAnyStagingCheckBox);
        this.panelOrder.setVisible(false);
        this.pack();
        this.setVisible(true);
    }

    @Override
    protected void saveTrack(Track track) {
        track.setLoadSwapEnabled(this.swapLoadsCheckBox.isSelected());
        track.setLoadEmptyEnabled(this.emptyCheckBox.isSelected());
        track.setRemoveCustomLoadsEnabled(this.emptyCustomCheckBox.isSelected());
        track.setAddCustomLoadsEnabled(this.loadCheckBox.isSelected());
        track.setAddCustomLoadsAnySpurEnabled(this.loadAnyCheckBox.isSelected());
        track.setAddCustomLoadsAnyStagingTrackEnabled(this.loadAnyStagingCheckBox.isSelected());
        track.setBlockCarsEnabled(this.blockCarsCheckBox.isSelected());
        super.saveTrack(track);
    }

    @Override
    protected void enableButtons(boolean enabled) {
        this.swapLoadsCheckBox.setEnabled(enabled);
        this.emptyCheckBox.setEnabled(enabled);
        this.emptyCustomCheckBox.setEnabled(enabled);
        this.loadCheckBox.setEnabled(enabled);
        this.loadAnyCheckBox.setEnabled(enabled);
        this.loadAnyStagingCheckBox.setEnabled(enabled);
        this.blockCarsCheckBox.setEnabled(this._track != null && !this._track.isAddCustomLoadsEnabled() && !this._track.isAddCustomLoadsAnySpurEnabled() && !this._track.isAddCustomLoadsAnyStagingTrackEnabled() && enabled);
        this.pShipLoadOption.setVisible(this._track == null || this._track.isAddCustomLoadsEnabled() || this._track.isAddCustomLoadsAnySpurEnabled() || this._track.isAddCustomLoadsAnyStagingTrackEnabled() || !this._track.getShipLoadOption().equals(Track.ALL_LOADS));
        super.enableButtons(enabled);
    }

    @Override
    protected void updateTrainComboBox() {
        Train train;
        int i;
        super.updateTrainComboBox();
        if (this.autoPickupCheckBox.isSelected()) {
            i = 1;
            while (i < this.comboBoxPickupTrains.getItemCount()) {
                train = (Train)this.comboBoxPickupTrains.getItemAt(i);
                if (!train.getTrainDepartsName().equals(this._location.getName())) {
                    this.comboBoxPickupTrains.removeItemAt(i--);
                }
                ++i;
            }
        }
        if (this.autoDropCheckBox.isSelected()) {
            i = 1;
            while (i < this.comboBoxDropTrains.getItemCount()) {
                train = (Train)this.comboBoxDropTrains.getItemAt(i);
                if (!train.getTrainTerminatesName().equals(this._location.getName())) {
                    this.comboBoxDropTrains.removeItemAt(i--);
                }
                ++i;
            }
        }
    }

    @Override
    protected void updateRouteComboBox() {
        Route route;
        int i;
        super.updateRouteComboBox();
        if (this.autoPickupCheckBox.isSelected()) {
            i = 1;
            while (i < this.comboBoxPickupRoutes.getItemCount()) {
                route = (Route)this.comboBoxPickupRoutes.getItemAt(i);
                if (route.getLocationsBySequenceList().get(0).getLocation() != this._location) {
                    this.comboBoxPickupRoutes.removeItemAt(i--);
                }
                ++i;
            }
        }
        if (this.autoDropCheckBox.isSelected()) {
            i = 1;
            while (i < this.comboBoxDropRoutes.getItemCount()) {
                route = (Route)this.comboBoxDropRoutes.getItemAt(i);
                if (route.getLocationsBySequenceList().get(route.getLocationsBySequenceList().size() - 1).getLocation() != this._location) {
                    this.comboBoxDropRoutes.removeItemAt(i--);
                }
                ++i;
            }
        }
    }

    @Override
    public void checkBoxActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.swapLoadsCheckBox) {
            if (this.swapLoadsCheckBox.isSelected()) {
                this.emptyCheckBox.setSelected(false);
            }
        } else if (ae.getSource() == this.emptyCheckBox) {
            if (this.emptyCheckBox.isSelected()) {
                this.swapLoadsCheckBox.setSelected(false);
            }
        } else if (ae.getSource() == this.loadCheckBox) {
            if (this.loadCheckBox.isSelected()) {
                this.loadAnyCheckBox.setSelected(false);
                this.blockCarsCheckBox.setSelected(false);
                this.blockCarsCheckBox.setEnabled(false);
            } else if (!this.loadAnyCheckBox.isSelected() && !this.loadAnyStagingCheckBox.isSelected()) {
                this.blockCarsCheckBox.setEnabled(true);
            }
        } else if (ae.getSource() == this.loadAnyCheckBox) {
            if (this.loadAnyCheckBox.isSelected()) {
                this.loadCheckBox.setSelected(false);
                this.blockCarsCheckBox.setSelected(false);
                this.blockCarsCheckBox.setEnabled(false);
            } else if (!this.loadCheckBox.isSelected() && !this.loadAnyStagingCheckBox.isSelected()) {
                this.blockCarsCheckBox.setEnabled(true);
            }
        } else if (ae.getSource() == this.loadAnyStagingCheckBox) {
            if (this.loadAnyStagingCheckBox.isSelected()) {
                this.blockCarsCheckBox.setSelected(false);
                this.blockCarsCheckBox.setEnabled(false);
            } else if (!this.loadCheckBox.isSelected() && !this.loadAnyCheckBox.isSelected()) {
                this.blockCarsCheckBox.setEnabled(true);
            }
        } else {
            super.checkBoxActionPerformed(ae);
        }
    }
}

