/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations;

import java.beans.PropertyChangeEvent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import jmri.jmrit.operations.locations.Bundle;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.SpurEditFrame;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.TrackTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpurTableModel
extends TrackTableModel {
    private static final Logger log = LoggerFactory.getLogger(SpurTableModel.class);

    public void initTable(JTable table, Location location) {
        super.initTable(table, location, "Spur");
    }

    @Override
    protected void editTrack(int row) {
        log.debug("Edit spur");
        if (this.tef != null) {
            this.tef.dispose();
        }
        SwingUtilities.invokeLater(() -> {
            this.tef = new SpurEditFrame();
            Track spur = (Track)this._tracksList.get(row);
            this.tef.initComponents(this._location, spur);
            this.tef.setTitle(Bundle.getMessage("EditSpur"));
        });
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 1: {
                return Bundle.getMessage("SpurName");
            }
        }
        return super.getColumnName(col);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        int row;
        Track track;
        super.propertyChange(e);
        if (e.getSource().getClass().equals(Track.class) && (track = (Track)e.getSource()).isSpur() && (row = this._tracksList.indexOf(track)) >= 0) {
            this.fireTableRowsUpdated(row, row);
        }
    }
}

