/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations;

import java.util.ArrayList;
import java.util.List;
import jmri.beans.Bean;
import jmri.jmrit.operations.locations.Track;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pool
extends Bean {
    public static final String LISTCHANGE_CHANGED_PROPERTY = "poolListChange";
    public static final String DISPOSE = "poolDispose";
    private static final Logger log = LoggerFactory.getLogger(Pool.class);
    protected List<Track> _tracks = new ArrayList<Track>();
    protected String _id = "";
    protected String _name = "";

    public String getId() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        String old = this._name;
        this._name = name;
        this.propertyChangeSupport.firePropertyChange("Name", old, name);
    }

    public int getSize() {
        return this._tracks.size();
    }

    public String toString() {
        return this._name;
    }

    public Pool(String id, String name) {
        super(false);
        log.debug("New pool ({}) id: {}", (Object)name, (Object)id);
        this._name = name;
        this._id = id;
    }

    public void dispose() {
        this.firePropertyChange(DISPOSE, null, DISPOSE);
    }

    public void add(Track track) {
        if (!this._tracks.contains(track)) {
            int oldSize = this._tracks.size();
            this._tracks.add(track);
            this.firePropertyChange(LISTCHANGE_CHANGED_PROPERTY, oldSize, this._tracks.size());
        }
    }

    public void remove(Track track) {
        if (this._tracks.contains(track)) {
            int oldSize = this._tracks.size();
            this._tracks.remove(track);
            this.firePropertyChange(LISTCHANGE_CHANGED_PROPERTY, oldSize, this._tracks.size());
        }
    }

    public List<Track> getTracks() {
        return new ArrayList<Track>(this._tracks);
    }

    public int getTotalLengthTracks() {
        return this.getTracks().stream().map(track -> track.getLength()).reduce(0, Integer::sum);
    }

    public int getMaxLengthTrack(Track track) {
        int length = this.getTotalLengthTracks();
        for (Track t : this.getTracks()) {
            if (t == track) continue;
            length -= t.getMinimumLength();
        }
        return length;
    }

    public boolean requestTrackLength(Track track, int length) {
        int additionalLength = track.getUsedLength() + track.getReserved() + length - track.getLength();
        for (Track t : this.getTracks()) {
            if (t == track) continue;
            if (t.getUsedLength() + t.getReserved() + additionalLength <= t.getLength() && t.getLength() - additionalLength >= t.getMinimumLength()) {
                log.debug("Pool ({}) increasing track ({}) length ({}) decreasing ({})", new Object[]{this.getName(), track.getName(), additionalLength, t.getName()});
                t.setLength(t.getLength() - additionalLength);
                track.setLength(track.getLength() + additionalLength);
                return true;
            }
            int available = t.getLength() - (t.getUsedLength() + t.getReserved());
            int min = t.getLength() - t.getMinimumLength();
            if (min < available) {
                available = min;
            }
            if (available <= 0) continue;
            log.debug("Pool ({}) incremental increase for track ({}) length ({}) decreasing ({})", new Object[]{this.getName(), track.getName(), available, t.getName()});
            t.setLength(t.getLength() - available);
            track.setLength(track.getLength() + available);
            additionalLength -= available;
        }
        return false;
    }
}

