/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import jmri.InstanceManager;
import jmri.jmrit.operations.locations.Bundle;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationEditFrame;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.LocationsTableFrame;
import jmri.jmrit.operations.locations.YardmasterFrame;
import jmri.jmrit.operations.setup.Setup;
import jmri.util.swing.XTableColumnModel;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationsTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    LocationManager locationManager;
    protected JTable _table;
    public static final int ID_COLUMN = 0;
    public static final int NAME_COLUMN = 1;
    public static final int TRACK_COLUMN = 2;
    public static final int NUMBER_COLUMN = 3;
    public static final int LENGTH_COLUMN = 4;
    public static final int USED_LENGTH_COLUMN = 5;
    public static final int ROLLINGSTOCK_COLUMN = 6;
    protected static final int CARS_COLUMN = 7;
    protected static final int LOCOS_COLUMN = 8;
    public static final int PICKUPS_COLUMN = 9;
    public static final int DROPS_COLUMN = 10;
    public static final int DIVISION_COLUMN = 11;
    public static final int REPORTER_COLUMN = 12;
    public static final int ACTION_COLUMN = 13;
    public static final int EDIT_COLUMN = 14;
    private static final int HIGHEST_COLUMN = 15;
    public final int SORTBYNAME = 1;
    public final int SORTBYID = 2;
    private int _sort = 1;
    List<Location> locationsList = null;
    List<LocationEditFrame> frameList = new ArrayList<LocationEditFrame>();
    private static final Logger log = LoggerFactory.getLogger(LocationsTableModel.class);

    public LocationsTableModel() {
        this.locationManager = InstanceManager.getDefault(LocationManager.class);
        this.locationManager.addPropertyChangeListener(this);
        this.updateList();
    }

    public void setSort(int sort) {
        this._sort = sort;
        this.updateList();
        this.fireTableDataChanged();
    }

    private void updateList() {
        this.removePropertyChangeLocations();
        this.locationsList = this._sort == 2 ? this.locationManager.getLocationsByIdList() : this.locationManager.getLocationsByNameList();
        for (Location loc : this.locationsList) {
            loc.addPropertyChangeListener(this);
        }
    }

    void initTable(LocationsTableFrame frame, JTable table) {
        this._table = table;
        XTableColumnModel tcm = new XTableColumnModel();
        table.setColumnModel(tcm);
        table.createDefaultColumnsFromModel();
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        ButtonEditor buttonEditor = new ButtonEditor(new JButton());
        tcm.getColumn(13).setCellRenderer(buttonRenderer);
        tcm.getColumn(13).setCellEditor(buttonEditor);
        tcm.getColumn(14).setCellRenderer(buttonRenderer);
        tcm.getColumn(14).setCellEditor(buttonEditor);
        table.getColumnModel().getColumn(0).setPreferredWidth(40);
        table.getColumnModel().getColumn(1).setPreferredWidth(200);
        table.getColumnModel().getColumn(2).setPreferredWidth(Math.max(60, new JLabel((String)new StringBuilder((String)String.valueOf((Object)Bundle.getMessage((String)"Class/Interchange"))).append((String)Bundle.getMessage((String)"Spurs")).append((String)Bundle.getMessage((String)"Yards")).toString()).getPreferredSize().width + 20));
        table.getColumnModel().getColumn(3).setPreferredWidth(40);
        table.getColumnModel().getColumn(4).setPreferredWidth(Math.max(60, new JLabel((String)this.getColumnName((int)4)).getPreferredSize().width + 10));
        table.getColumnModel().getColumn(5).setPreferredWidth(60);
        table.getColumnModel().getColumn(6).setPreferredWidth(Math.max(80, new JLabel((String)this.getColumnName((int)6)).getPreferredSize().width + 10));
        table.getColumnModel().getColumn(7).setPreferredWidth(60);
        table.getColumnModel().getColumn(8).setPreferredWidth(60);
        table.getColumnModel().getColumn(9).setPreferredWidth(Math.max(60, new JLabel((String)this.getColumnName((int)9)).getPreferredSize().width + 10));
        table.getColumnModel().getColumn(10).setPreferredWidth(Math.max(60, new JLabel((String)this.getColumnName((int)10)).getPreferredSize().width + 10));
        table.getColumnModel().getColumn(11).setPreferredWidth(160);
        table.getColumnModel().getColumn(13).setPreferredWidth(Math.max(80, new JLabel((String)Bundle.getMessage((String)"Yardmaster")).getPreferredSize().width + 40));
        table.getColumnModel().getColumn(14).setPreferredWidth(80);
        frame.loadTableDetails(table);
        this.setColumnsVisible();
    }

    protected void setColumnsVisible() {
        XTableColumnModel tcm = (XTableColumnModel)this._table.getColumnModel();
        tcm.setColumnVisible(tcm.getColumnByModelIndex(11), this.locationManager.hasDivisions());
        tcm.setColumnVisible(tcm.getColumnByModelIndex(12), Setup.isRfidEnabled() && this.locationManager.hasReporters());
    }

    @Override
    public int getRowCount() {
        return this.locationsList.size();
    }

    @Override
    public int getColumnCount() {
        return 15;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("Id");
            }
            case 1: {
                return Bundle.getMessage("Name");
            }
            case 2: {
                return Bundle.getMessage("Track");
            }
            case 3: {
                return Bundle.getMessage("Number");
            }
            case 4: {
                return Bundle.getMessage("Length");
            }
            case 5: {
                return Bundle.getMessage("Used");
            }
            case 6: {
                return Bundle.getMessage("RollingStock");
            }
            case 8: {
                return Bundle.getMessage("Engines");
            }
            case 7: {
                return Bundle.getMessage("Cars");
            }
            case 9: {
                return Bundle.getMessage("Pickups");
            }
            case 10: {
                return Bundle.getMessage("Drop");
            }
            case 11: {
                return Bundle.getMessage("Division");
            }
            case 12: {
                return Bundle.getMessage("Reporters");
            }
            case 13: {
                return Bundle.getMessage("Action");
            }
            case 14: {
                return Bundle.getMessage("ButtonEdit");
            }
        }
        return "unknown";
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 1: 
            case 2: 
            case 11: 
            case 12: {
                return String.class;
            }
            case 0: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return Integer.class;
            }
            case 13: 
            case 14: {
                return JButton.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 13: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.getRowCount()) {
            return "ERROR row " + row;
        }
        Location location = this.locationsList.get(row);
        if (location == null) {
            return "ERROR location unknown " + row;
        }
        switch (col) {
            case 0: {
                return Integer.parseInt(location.getId());
            }
            case 1: {
                return location.getName();
            }
            case 2: {
                return this.getTrackTypes(location);
            }
            case 3: {
                return location.getTracksList().size();
            }
            case 4: {
                return location.getLength();
            }
            case 5: {
                return location.getUsedLength();
            }
            case 6: {
                return location.getNumberRS();
            }
            case 8: {
                return location.getNumberEngines();
            }
            case 7: {
                return location.getNumberCars();
            }
            case 9: {
                return location.getPickupRS();
            }
            case 10: {
                return location.getDropRS();
            }
            case 11: {
                return location.getDivisionName();
            }
            case 12: {
                return location.getReporterName();
            }
            case 13: {
                return Bundle.getMessage("Yardmaster");
            }
            case 14: {
                return Bundle.getMessage("ButtonEdit");
            }
        }
        return "unknown " + col;
    }

    private String getTrackTypes(Location location) {
        if (location.isStaging()) {
            return Bundle.getMessage("Staging");
        }
        StringBuffer sb = new StringBuffer();
        if (location.hasInterchanges()) {
            sb.append(String.valueOf(Bundle.getMessage("Class/Interchange")) + " ");
        }
        if (location.hasSpurs()) {
            sb.append(String.valueOf(Bundle.getMessage("Spurs")) + " ");
        }
        if (location.hasYards()) {
            sb.append(Bundle.getMessage("Yards"));
        }
        return sb.toString();
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        switch (col) {
            case 13: {
                this.launchYardmaster(row);
                break;
            }
            case 14: {
                this.editLocation(row);
                break;
            }
        }
    }

    private void editLocation(int row) {
        SwingUtilities.invokeLater(() -> {
            LocationEditFrame lef2;
            Location loc = this.locationsList.get(row);
            log.debug("Edit location ({})", (Object)loc.getName());
            for (LocationEditFrame lef2 : this.frameList) {
                if (lef2._location != loc) continue;
                lef2.dispose();
                this.frameList.remove(lef2);
                break;
            }
            lef2 = new LocationEditFrame(loc);
            this.frameList.add(lef2);
        });
    }

    private void launchYardmaster(int row) {
        SwingUtilities.invokeLater(() -> {
            log.debug("Yardmaster");
            Location loc = this.locationsList.get(row);
            new YardmasterFrame(loc);
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("locationsListLength")) {
            this.updateList();
            this.fireTableDataChanged();
        } else if (e.getSource().getClass().equals(Location.class)) {
            Location loc = (Location)e.getSource();
            int row = this.locationsList.indexOf(loc);
            if (row >= 0) {
                this.fireTableRowsUpdated(row, row);
            }
            if (e.getPropertyName().equals("locationReporterChange") || e.getPropertyName().equals("homeDivisionChange")) {
                this.setColumnsVisible();
            }
        }
    }

    private void removePropertyChangeLocations() {
        if (this.locationsList != null) {
            for (Location loc : this.locationsList) {
                loc.removePropertyChangeListener(this);
            }
        }
    }

    public void dispose() {
        for (LocationEditFrame lef : this.frameList) {
            lef.dispose();
        }
        this.locationManager.removePropertyChangeListener(this);
        this.removePropertyChangeLocations();
    }
}

