/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsMenu;
import jmri.jmrit.operations.locations.Bundle;
import jmri.jmrit.operations.locations.LocationEditFrame;
import jmri.jmrit.operations.locations.LocationsTableModel;
import jmri.jmrit.operations.locations.schedules.SchedulesTableAction;
import jmri.jmrit.operations.locations.tools.ExportLocationsRosterAction;
import jmri.jmrit.operations.locations.tools.LocationCopyAction;
import jmri.jmrit.operations.locations.tools.ModifyLocationsAction;
import jmri.jmrit.operations.locations.tools.ModifyLocationsCarLoadsAction;
import jmri.jmrit.operations.locations.tools.PrintLocationsAction;
import jmri.jmrit.operations.locations.tools.SetPhysicalLocationAction;
import jmri.jmrit.operations.locations.tools.ShowCarsByLocationAction;
import jmri.jmrit.operations.locations.tools.TrackCopyAction;
import jmri.jmrit.operations.setup.Setup;
import jmri.swing.JTablePersistenceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationsTableFrame
extends OperationsFrame {
    LocationsTableModel locationsModel = new LocationsTableModel();
    JTable locationsTable = new JTable(this.locationsModel);
    JScrollPane locationsPane;
    JLabel textSort = new JLabel(Bundle.getMessage("SortBy"));
    JLabel textSep = new JLabel("          ");
    JRadioButton sortByName = new JRadioButton(Bundle.getMessage("Name"));
    JRadioButton sortById = new JRadioButton(Bundle.getMessage("Id"));
    JButton addButton = new JButton(Bundle.getMessage("ButtonAdd"));
    private static final Logger log = LoggerFactory.getLogger(LocationsTableFrame.class);

    public LocationsTableFrame() {
        super(Bundle.getMessage("TitleLocationsTable"));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.locationsPane = new JScrollPane(this.locationsTable);
        this.locationsPane.setVerticalScrollBarPolicy(20);
        this.locationsPane.setHorizontalScrollBarPolicy(30);
        this.locationsModel.initTable(this, this.locationsTable);
        this.getContentPane().add(this.locationsPane);
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new FlowLayout());
        controlPanel.add(this.textSort);
        controlPanel.add(this.sortByName);
        controlPanel.add(this.sortById);
        controlPanel.add(this.textSep);
        controlPanel.add(this.addButton);
        controlPanel.setMaximumSize(new Dimension(1025, 50));
        this.getContentPane().add(controlPanel);
        this.sortByName.setSelected(true);
        this.addButtonAction(this.addButton);
        this.addRadioButtonAction(this.sortByName);
        this.addRadioButtonAction(this.sortById);
        JMenuBar menuBar = new JMenuBar();
        JMenu toolMenu = new JMenu(Bundle.getMessage("MenuTools"));
        toolMenu.add(new LocationCopyAction());
        toolMenu.add(new TrackCopyAction());
        toolMenu.add(new SchedulesTableAction());
        toolMenu.add(new ModifyLocationsAction());
        toolMenu.add(new ModifyLocationsCarLoadsAction());
        toolMenu.add(new ShowCarsByLocationAction(false, null, null));
        toolMenu.add(new ExportLocationsRosterAction());
        if (Setup.isVsdPhysicalLocationEnabled()) {
            toolMenu.add(new SetPhysicalLocationAction(null));
        }
        toolMenu.addSeparator();
        toolMenu.add(new PrintLocationsAction(false));
        toolMenu.add(new PrintLocationsAction(true));
        menuBar.add(toolMenu);
        menuBar.add(new OperationsMenu());
        this.setJMenuBar(menuBar);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_Locations", true);
        this.initMinimumSize();
        if (this.getWidth() == 500) {
            this.setSize(700, this.getHeight());
        }
        this.createShutDownTask();
    }

    @Override
    public void radioButtonActionPerformed(ActionEvent ae) {
        log.debug("radio button activated");
        this.clearTableSort(this.locationsTable);
        if (ae.getSource() == this.sortByName) {
            this.sortByName.setSelected(true);
            this.sortById.setSelected(false);
            this.locationsModel.setSort(this.locationsModel.SORTBYNAME);
        }
        if (ae.getSource() == this.sortById) {
            this.sortByName.setSelected(false);
            this.sortById.setSelected(true);
            this.locationsModel.setSort(this.locationsModel.SORTBYID);
        }
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.addButton) {
            LocationEditFrame f = new LocationEditFrame(null);
            f.setTitle(Bundle.getMessage("TitleLocationAdd"));
        }
    }

    @Override
    public void dispose() {
        InstanceManager.getOptionalDefault(JTablePersistenceManager.class).ifPresent(tpm -> tpm.stopPersisting(this.locationsTable));
        this.locationsModel.dispose();
        super.dispose();
    }
}

