/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JComboBox;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.InstanceManagerAutoInitialize;
import jmri.Reporter;
import jmri.beans.PropertyChangeSupport;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManagerXml;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.setup.OperationsSetupXml;
import jmri.jmrit.operations.trains.TrainCommon;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationManager
extends PropertyChangeSupport
implements InstanceManagerAutoDefault,
InstanceManagerAutoInitialize,
PropertyChangeListener {
    public static final String LISTLENGTH_CHANGED_PROPERTY = "locationsListLength";
    private int _id = 0;
    protected Hashtable<String, Location> _locationHashTable = new Hashtable();
    protected int _maxLocationNameLength = 0;
    protected int _maxTrackNameLength = 0;
    protected int _maxLocationAndTrackNameLength = 0;
    private static final Logger log = LoggerFactory.getLogger(LocationManager.class);

    public void dispose() {
        this._locationHashTable.clear();
        this._id = 0;
    }

    public int getNumberOfLocations() {
        return this._locationHashTable.size();
    }

    public Location getLocationByName(String name) {
        Enumeration<Location> en = this._locationHashTable.elements();
        while (en.hasMoreElements()) {
            Location location = en.nextElement();
            if (!location.getName().equals(name)) continue;
            return location;
        }
        return null;
    }

    public Location getLocationById(String id) {
        return this._locationHashTable.get(id);
    }

    public boolean hasDivisions() {
        for (Location location : this.getList()) {
            if (location.getDivision() == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasWork() {
        for (Location location : this.getList()) {
            if (!location.hasWork()) continue;
            return true;
        }
        return false;
    }

    public boolean hasReporters() {
        for (Location location : this.getList()) {
            if (location.getReporter() == null) continue;
            return true;
        }
        return false;
    }

    public Location getLocationByReporter(Reporter r) {
        for (Location location : this._locationHashTable.values()) {
            try {
                if (!location.getReporter().equals(r)) continue;
                return location;
            }
            catch (NullPointerException nullPointerException) {}
        }
        return null;
    }

    public Track getTrackByReporter(Reporter r) {
        for (Track track : this.getTracks(null)) {
            try {
                if (!track.getReporter().equals(r)) continue;
                return track;
            }
            catch (NullPointerException nullPointerException) {}
        }
        return null;
    }

    public Location newLocation(String name) {
        Location location = this.getLocationByName(name);
        if (location == null) {
            ++this._id;
            location = new Location(Integer.toString(this._id), name);
            Integer oldSize = this._locationHashTable.size();
            this._locationHashTable.put(location.getId(), location);
            this.resetNameLengths();
            this.setDirtyAndFirePropertyChange(LISTLENGTH_CHANGED_PROPERTY, oldSize, this._locationHashTable.size());
        }
        return location;
    }

    public void register(Location location) {
        Integer oldSize = this._locationHashTable.size();
        this._locationHashTable.put(location.getId(), location);
        int id = Integer.parseInt(location.getId());
        if (id > this._id) {
            this._id = id;
        }
        this.setDirtyAndFirePropertyChange(LISTLENGTH_CHANGED_PROPERTY, oldSize, this._locationHashTable.size());
    }

    public void deregister(Location location) {
        if (location == null) {
            return;
        }
        location.dispose();
        Integer oldSize = this._locationHashTable.size();
        this._locationHashTable.remove(location.getId());
        this.setDirtyAndFirePropertyChange(LISTLENGTH_CHANGED_PROPERTY, oldSize, this._locationHashTable.size());
    }

    public List<Location> getLocationsByNameList() {
        List<Location> sortList = this.getList();
        ArrayList<Location> out = new ArrayList<Location>();
        for (Location location : sortList) {
            int j = 0;
            while (j < out.size()) {
                if (location.getName().compareToIgnoreCase(((Location)out.get(j)).getName()) < 0) {
                    out.add(j, location);
                    break;
                }
                ++j;
            }
            if (out.contains(location)) continue;
            out.add(location);
        }
        return out;
    }

    public List<Location> getLocationsByIdList() {
        List<Location> sortList = this.getList();
        ArrayList<Location> out = new ArrayList<Location>();
        for (Location location : sortList) {
            int j = 0;
            while (j < out.size()) {
                try {
                    if (Integer.parseInt(location.getId()) < Integer.parseInt(((Location)out.get(j)).getId())) {
                        out.add(j, location);
                        break;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    log.debug("list id number isn't a number");
                }
                ++j;
            }
            if (out.contains(location)) continue;
            out.add(location);
        }
        return out;
    }

    public List<Location> getList() {
        ArrayList<Location> out = new ArrayList<Location>();
        Enumeration<Location> en = this._locationHashTable.elements();
        while (en.hasMoreElements()) {
            out.add(en.nextElement());
        }
        return out;
    }

    public List<Track> getTracks(String type) {
        List<Location> sortList = this.getList();
        ArrayList<Track> trackList = new ArrayList<Track>();
        for (Location location : sortList) {
            List<Track> tracks = location.getTracksByNameList(type);
            for (Track track : tracks) {
                trackList.add(track);
            }
        }
        return trackList;
    }

    public List<Track> getTracksByMoves(String type) {
        List<Track> trackList = this.getTracks(type);
        ArrayList<Track> moveList = new ArrayList<Track>();
        for (Track track : trackList) {
            boolean locAdded = false;
            if (track.isAlternate()) continue;
            int j = 0;
            while (j < moveList.size()) {
                if (track.getMoves() < ((Track)moveList.get(j)).getMoves()) {
                    moveList.add(j, track);
                    locAdded = true;
                    break;
                }
                ++j;
            }
            if (locAdded) continue;
            moveList.add(track);
        }
        return moveList;
    }

    public void resetMoves() {
        List<Location> locations = this.getList();
        for (Location loc : locations) {
            loc.resetMoves();
        }
    }

    public JComboBox<Location> getComboBox() {
        JComboBox<Location> box = new JComboBox<Location>();
        this.updateComboBox(box);
        return box;
    }

    public void updateComboBox(JComboBox<Location> box) {
        box.removeAllItems();
        box.addItem(null);
        for (Location loc : this.getLocationsByNameList()) {
            box.addItem(loc);
        }
    }

    public void replaceLoad(String type, String oldLoadName, String newLoadName) {
        List<Location> locs = this.getList();
        for (Location loc : locs) {
            List<Track> tracks = loc.getTracksList();
            for (Track track : tracks) {
                String[] splitLoad;
                String loadName;
                String[] stringArray = track.getLoadNames();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    loadName = stringArray[n2];
                    if (loadName.equals(oldLoadName)) {
                        track.deleteLoadName(oldLoadName);
                        if (newLoadName != null) {
                            track.addLoadName(newLoadName);
                        }
                    }
                    if ((splitLoad = loadName.split(" & ")).length > 1 && splitLoad[0].equals(type) && splitLoad[1].equals(oldLoadName)) {
                        track.deleteLoadName(loadName);
                        if (newLoadName != null) {
                            track.addLoadName(String.valueOf(type) + " & " + newLoadName);
                        }
                    }
                    ++n2;
                }
                stringArray = track.getShipLoadNames();
                n = stringArray.length;
                n2 = 0;
                while (n2 < n) {
                    loadName = stringArray[n2];
                    if (loadName.equals(oldLoadName)) {
                        track.deleteShipLoadName(oldLoadName);
                        if (newLoadName != null) {
                            track.addShipLoadName(newLoadName);
                        }
                    }
                    if ((splitLoad = loadName.split(" & ")).length > 1 && splitLoad[0].equals(type) && splitLoad[1].equals(oldLoadName)) {
                        track.deleteShipLoadName(loadName);
                        if (newLoadName != null) {
                            track.addShipLoadName(String.valueOf(type) + " & " + newLoadName);
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    public void resetNameLengths() {
        this._maxLocationNameLength = 0;
        this._maxTrackNameLength = 0;
        this._maxLocationAndTrackNameLength = 0;
    }

    public int getMaxLocationNameLength() {
        this.calculateMaxNameLengths();
        return this._maxLocationNameLength;
    }

    public int getMaxTrackNameLength() {
        this.calculateMaxNameLengths();
        return this._maxTrackNameLength;
    }

    public int getMaxLocationAndTrackNameLength() {
        this.calculateMaxNameLengths();
        return this._maxLocationAndTrackNameLength;
    }

    private void calculateMaxNameLengths() {
        if (this._maxLocationNameLength != 0) {
            return;
        }
        String maxTrackName = "";
        String maxLocNameForTrack = "";
        String maxLocationName = "";
        String maxLocationAndTrackName = "";
        for (Track track : this.getTracks(null)) {
            if (TrainCommon.splitString(track.getName()).length() > this._maxTrackNameLength) {
                maxTrackName = track.getName();
                maxLocNameForTrack = track.getLocation().getName();
                this._maxTrackNameLength = TrainCommon.splitString(track.getName()).length();
            }
            if (TrainCommon.splitString(track.getLocation().getName()).length() > this._maxLocationNameLength) {
                maxLocationName = track.getLocation().getName();
                this._maxLocationNameLength = TrainCommon.splitString(track.getLocation().getName()).length();
            }
            if (TrainCommon.splitString(track.getLocation().getName()).length() + TrainCommon.splitString(track.getName()).length() <= this._maxLocationAndTrackNameLength) continue;
            maxLocationAndTrackName = String.valueOf(track.getLocation().getName()) + ", " + track.getName();
            this._maxLocationAndTrackNameLength = TrainCommon.splitString(track.getLocation().getName()).length() + TrainCommon.splitString(track.getName()).length();
        }
        log.info("Max track name ({}) at ({}) length {}", new Object[]{maxTrackName, maxLocNameForTrack, this._maxTrackNameLength});
        log.info("Max location name ({}) length {}", (Object)maxLocationName, (Object)this._maxLocationNameLength);
        log.info("Max location and track name ({}) length {}", (Object)maxLocationAndTrackName, (Object)this._maxLocationAndTrackNameLength);
    }

    public void load(Element root) {
        if (root.getChild("locations") != null) {
            List locs = root.getChild("locations").getChildren("location");
            log.debug("readFile sees {} locations", (Object)locs.size());
            for (Element loc : locs) {
                this.register(new Location(loc));
            }
        }
    }

    public void store(Element root) {
        Element values = new Element("locations");
        root.addContent((Content)values);
        List<Location> locationList = this.getLocationsByIdList();
        for (Location loc : locationList) {
            values.addContent((Content)loc.store());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        log.debug("LocationManager sees property change: ({}) old: ({}) new: ({})", new Object[]{e.getPropertyName(), e.getOldValue(), e.getNewValue()});
    }

    protected void setDirtyAndFirePropertyChange(String p, Object old, Object n) {
        InstanceManager.getDefault(LocationManagerXml.class).setDirty(true);
        this.firePropertyChange(p, old, n);
    }

    @Override
    public void initialize() {
        InstanceManager.getDefault(OperationsSetupXml.class);
        InstanceManager.getDefault(LocationManagerXml.class);
    }
}

