/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations;

import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JComboBox;
import javax.vecmath.Tuple3f;
import jmri.InstanceManager;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.beans.Identifiable;
import jmri.beans.PropertyChangeSupport;
import jmri.jmrit.operations.locations.Bundle;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.LocationManagerXml;
import jmri.jmrit.operations.locations.Pool;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.divisions.Division;
import jmri.jmrit.operations.locations.divisions.DivisionManager;
import jmri.jmrit.operations.rollingstock.RollingStock;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarRoads;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.rollingstock.engines.EngineTypes;
import jmri.jmrit.operations.setup.Setup;
import jmri.util.PhysicalLocation;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Location
extends PropertyChangeSupport
implements Identifiable,
PropertyChangeListener {
    public static final String LOC_TRACK_REGIX = "s";
    public static final String NONE = "";
    public static final int RANGE_DEFAULT = 25;
    protected String _id = "";
    protected String _name = "";
    protected int _IdNumber = 0;
    protected int _numberRS = 0;
    protected int _numberCars = 0;
    protected int _numberEngines = 0;
    protected int _pickupRS = 0;
    protected int _dropRS = 0;
    protected int _trainDir = 15;
    protected int _length = 0;
    protected int _usedLength = 0;
    protected String _comment = "";
    protected String _switchListComment = "";
    protected boolean _switchList = true;
    protected String _defaultPrinter = "";
    protected String _status = "";
    protected int _switchListState = 0;
    protected Point _trainIconEast = new Point();
    protected Point _trainIconWest = new Point();
    protected Point _trainIconNorth = new Point();
    protected Point _trainIconSouth = new Point();
    protected int _trainIconRangeX = 25;
    protected int _trainIconRangeY = 25;
    protected Hashtable<String, Track> _trackHashTable = new Hashtable();
    protected PhysicalLocation _physicalLocation = new PhysicalLocation();
    protected List<String> _listTypes = new ArrayList<String>();
    protected Division _division = null;
    protected Reporter _reader = null;
    protected int _idPoolNumber = 0;
    protected Hashtable<String, Pool> _poolHashTable = new Hashtable();
    public static final String NORMAL = "1";
    public static final String STAGING = "2";
    public static final int EAST = 1;
    public static final int WEST = 2;
    public static final int NORTH = 4;
    public static final int SOUTH = 8;
    public static final String UNKNOWN = "";
    public static final String PRINTED = Bundle.getMessage("Printed");
    public static final String CSV_GENERATED = Bundle.getMessage("CsvGenerated");
    public static final String MODIFIED = Bundle.getMessage("Modified");
    public static final String UPDATED = Bundle.getMessage("Updated");
    public static final int SW_CREATE = 0;
    public static final int SW_APPEND = 1;
    public static final int SW_PRINTED = 2;
    public static final String TRACK_LISTLENGTH_CHANGED_PROPERTY = "trackListLength";
    public static final String TYPES_CHANGED_PROPERTY = "locationTypes";
    public static final String TRAINDIRECTION_CHANGED_PROPERTY = "locationTrainDirection";
    public static final String LENGTH_CHANGED_PROPERTY = "locationTrackLengths";
    public static final String USEDLENGTH_CHANGED_PROPERTY = "locationUsedLength";
    public static final String NAME_CHANGED_PROPERTY = "locationName";
    public static final String SWITCHLIST_CHANGED_PROPERTY = "switchList";
    public static final String DISPOSE_CHANGED_PROPERTY = "locationDispose";
    public static final String STATUS_CHANGED_PROPERTY = "locationStatus";
    public static final String POOL_LENGTH_CHANGED_PROPERTY = "poolLengthChanged";
    public static final String SWITCHLIST_COMMENT_CHANGED_PROPERTY = "switchListComment";
    public static final String TRACK_BLOCKING_ORDER_CHANGED_PROPERTY = "locationTrackBlockingOrder";
    public static final String LOCATION_REPORTER_PROPERTY = "locationReporterChange";
    public static final String LOCATION_DIVISION_PROPERTY = "homeDivisionChange";
    private static final Logger log = LoggerFactory.getLogger(Location.class);

    public Location(String id, String name) {
        log.debug("New location ({}) id: {}", (Object)name, (Object)id);
        this._name = name;
        this._id = id;
        this.setTypeNames(InstanceManager.getDefault(CarTypes.class).getNames());
        this.setTypeNames(InstanceManager.getDefault(EngineTypes.class).getNames());
        this.addPropertyChangeListeners();
    }

    @Override
    public String getId() {
        return this._id;
    }

    public void setName(String name) {
        String old = this._name;
        this._name = name;
        if (!old.equals(name)) {
            InstanceManager.getDefault(LocationManager.class).resetNameLengths();
            this.setDirtyAndFirePropertyChange(NAME_CHANGED_PROPERTY, old, name);
        }
    }

    public String toString() {
        return this._name;
    }

    public String getName() {
        return this._name;
    }

    public void copyLocation(Location newLocation) {
        newLocation.setComment(this.getComment());
        newLocation.setDefaultPrinterName(this.getDefaultPrinterName());
        newLocation.setSwitchListComment(this.getSwitchListComment());
        newLocation.setSwitchListEnabled(this.isSwitchListEnabled());
        newLocation.setTrainDirections(this.getTrainDirections());
        String[] stringArray = newLocation.getTypeNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (!this.acceptsTypeName(type)) {
                newLocation.deleteTypeName(type);
            }
            ++n2;
        }
        this.copyTracksLocation(newLocation);
    }

    public void copyTracksLocation(Location location) {
        for (Track track : this.getTracksList()) {
            if (location.getTrackByName(track.getName(), null) != null) continue;
            track.copyTrack(track.getName(), location);
        }
    }

    public PhysicalLocation getPhysicalLocation() {
        return this._physicalLocation;
    }

    public void setPhysicalLocation(PhysicalLocation l) {
        this._physicalLocation = l;
        InstanceManager.getDefault(LocationManagerXml.class).setDirty(true);
    }

    public void setLength(int length) {
        int old = this._length;
        this._length = length;
        if (old != length) {
            this.setDirtyAndFirePropertyChange(LENGTH_CHANGED_PROPERTY, Integer.toString(old), Integer.toString(length));
        }
    }

    public int getLength() {
        return this._length;
    }

    public void setUsedLength(int length) {
        int old = this._usedLength;
        this._usedLength = length;
        if (old != length) {
            this.setDirtyAndFirePropertyChange(USEDLENGTH_CHANGED_PROPERTY, Integer.toString(old), Integer.toString(length));
        }
    }

    public int getUsedLength() {
        return this._usedLength;
    }

    public boolean isStaging() {
        return this.hasTrackType("Staging");
    }

    public boolean hasSpurs() {
        return this.hasTrackType("Spur");
    }

    public boolean hasInterchanges() {
        return this.hasTrackType("Interchange");
    }

    public boolean hasYards() {
        return this.hasTrackType("Yard");
    }

    public boolean hasTrackType(String trackType) {
        Enumeration<Track> en = this._trackHashTable.elements();
        while (en.hasMoreElements()) {
            Track track = en.nextElement();
            if (!track.getTrackType().equals(trackType)) continue;
            return true;
        }
        return false;
    }

    public void changeTrackType(String type) {
        List<Track> tracks = this.getTracksByNameList(null);
        for (Track track : tracks) {
            track.setTrackType(type);
        }
    }

    public int getNumberOfTracks() {
        return this._trackHashTable.size();
    }

    public void setTrainDirections(int direction) {
        int old = this._trainDir;
        this._trainDir = direction;
        if (old != direction) {
            this.setDirtyAndFirePropertyChange(TRAINDIRECTION_CHANGED_PROPERTY, Integer.toString(old), Integer.toString(direction));
        }
    }

    public int getTrainDirections() {
        return this._trainDir;
    }

    public void setNumberRS(int number) {
        int old = this._numberRS;
        this._numberRS = number;
        if (old != number) {
            this.setDirtyAndFirePropertyChange("locationNumberRS", Integer.toString(old), Integer.toString(number));
        }
    }

    public int getNumberRS() {
        return this._numberRS;
    }

    private void setNumberCars(int number) {
        int old = this._numberCars;
        this._numberCars = number;
        if (old != number) {
            this.setDirtyAndFirePropertyChange("locationNumberCars", Integer.toString(old), Integer.toString(number));
        }
    }

    public int getNumberCars() {
        return this._numberCars;
    }

    private void setNumberEngines(int number) {
        int old = this._numberEngines;
        this._numberEngines = number;
        if (old != number) {
            this.setDirtyAndFirePropertyChange("locationNumberEngines", Integer.toString(old), Integer.toString(number));
        }
    }

    public int getNumberEngines() {
        return this._numberEngines;
    }

    public void setSwitchListEnabled(boolean switchList) {
        boolean old = this._switchList;
        this._switchList = switchList;
        if (old != switchList) {
            this.setDirtyAndFirePropertyChange(SWITCHLIST_CHANGED_PROPERTY, old ? "true" : "false", switchList ? "true" : "false");
        }
    }

    public boolean isSwitchListEnabled() {
        return this._switchList;
    }

    public void setDefaultPrinterName(String name) {
        String old = this._defaultPrinter;
        this._defaultPrinter = name;
        if (!old.equals(name)) {
            this.setDirtyAndFirePropertyChange("locationDefaultPrinter", old, name);
        }
    }

    public String getDefaultPrinterName() {
        return this._defaultPrinter;
    }

    public void setStatus(String status) {
        String old = this._status;
        this._status = status;
        if (!old.equals(status)) {
            this.setDirtyAndFirePropertyChange(STATUS_CHANGED_PROPERTY, old, status);
        }
    }

    public String getStatus() {
        return this._status;
    }

    public void setSwitchListState(int state) {
        int old = this._switchListState;
        this._switchListState = state;
        if (old != state) {
            this.setDirtyAndFirePropertyChange("locationSwitchListState", old, state);
        }
    }

    public int getSwitchListState() {
        return this._switchListState;
    }

    public void setTrainIconEast(Point point) {
        Point old = this._trainIconEast;
        this._trainIconEast = point;
        this.setDirtyAndFirePropertyChange("locationTrainIconEast", old.toString(), point.toString());
    }

    public Point getTrainIconEast() {
        return this._trainIconEast;
    }

    public void setTrainIconWest(Point point) {
        Point old = this._trainIconWest;
        this._trainIconWest = point;
        this.setDirtyAndFirePropertyChange("locationTrainIconWest", old.toString(), point.toString());
    }

    public Point getTrainIconWest() {
        return this._trainIconWest;
    }

    public void setTrainIconNorth(Point point) {
        Point old = this._trainIconNorth;
        this._trainIconNorth = point;
        this.setDirtyAndFirePropertyChange("locationTrainIconNorth", old.toString(), point.toString());
    }

    public Point getTrainIconNorth() {
        return this._trainIconNorth;
    }

    public void setTrainIconSouth(Point point) {
        Point old = this._trainIconSouth;
        this._trainIconSouth = point;
        this.setDirtyAndFirePropertyChange("locationTrainIconSouth", old.toString(), point.toString());
    }

    public Point getTrainIconSouth() {
        return this._trainIconSouth;
    }

    public void setTrainIconRangeX(int x) {
        int old = this._trainIconRangeX;
        this._trainIconRangeX = x;
        if (old != x) {
            this.setDirtyAndFirePropertyChange("trainIconRangeX", Integer.toString(old), Integer.toString(x));
        }
    }

    public int getTrainIconRangeX() {
        return this._trainIconRangeX;
    }

    public void setTrainIconRangeY(int y) {
        int old = this._trainIconRangeY;
        this._trainIconRangeY = y;
        if (old != y) {
            this.setDirtyAndFirePropertyChange("trainIconRangeY", Integer.toString(old), Integer.toString(y));
        }
    }

    public int getTrainIconRangeY() {
        return this._trainIconRangeY;
    }

    public void addRS(RollingStock rs) {
        this.setNumberRS(this.getNumberRS() + 1);
        if (rs.getClass() == Car.class) {
            this.setNumberCars(this.getNumberCars() + 1);
        } else if (rs.getClass() == Engine.class) {
            this.setNumberEngines(this.getNumberEngines() + 1);
        }
        this.setUsedLength(this.getUsedLength() + rs.getTotalLength());
    }

    public void deleteRS(RollingStock rs) {
        this.setNumberRS(this.getNumberRS() - 1);
        if (rs.getClass() == Car.class) {
            this.setNumberCars(this.getNumberCars() - 1);
        } else if (rs.getClass() == Engine.class) {
            this.setNumberEngines(this.getNumberEngines() - 1);
        }
        this.setUsedLength(this.getUsedLength() - rs.getTotalLength());
    }

    public void addPickupRS() {
        int old = this._pickupRS++;
        this.setDirtyAndFirePropertyChange("locationAddPickupRS", Integer.toString(old), Integer.toString(this._pickupRS));
    }

    public void deletePickupRS() {
        int old = this._pickupRS--;
        this.setDirtyAndFirePropertyChange("locationDeletePickupRS", Integer.toString(old), Integer.toString(this._pickupRS));
    }

    public void addDropRS() {
        int old = this._dropRS++;
        this.setDirtyAndFirePropertyChange("locationAddDropRS", Integer.toString(old), Integer.toString(this._dropRS));
    }

    public void deleteDropRS() {
        int old = this._dropRS--;
        this.setDirtyAndFirePropertyChange("locationDeleteDropRS", Integer.toString(old), Integer.toString(this._dropRS));
    }

    public int getPickupRS() {
        return this._pickupRS;
    }

    public int getDropRS() {
        return this._dropRS;
    }

    public void setDivision(Division division) {
        Division old = this._division;
        this._division = division;
        if (old != this._division) {
            this.setDirtyAndFirePropertyChange(LOCATION_DIVISION_PROPERTY, old, division);
        }
    }

    public Division getDivision() {
        return this._division;
    }

    public String getDivisionName() {
        if (this.getDivision() != null) {
            return this.getDivision().getName();
        }
        return "";
    }

    public String getDivisionId() {
        if (this.getDivision() != null) {
            return this.getDivision().getId();
        }
        return "";
    }

    public void setComment(String comment) {
        String old = this._comment;
        this._comment = comment;
        if (!old.equals(comment)) {
            this.setDirtyAndFirePropertyChange("locationComment", old, comment);
        }
    }

    public String getComment() {
        return this._comment;
    }

    public void setSwitchListComment(String comment) {
        String old = this._switchListComment;
        this._switchListComment = comment;
        if (!old.equals(comment)) {
            this.setDirtyAndFirePropertyChange(SWITCHLIST_COMMENT_CHANGED_PROPERTY, old, comment);
        }
    }

    public String getSwitchListComment() {
        return this._switchListComment;
    }

    public String[] getTypeNames() {
        return this._listTypes.toArray(new String[0]);
    }

    private void setTypeNames(String[] types) {
        if (types.length > 0) {
            Arrays.sort(types);
            String[] stringArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                String type = stringArray[n2];
                this._listTypes.add(type);
                ++n2;
            }
        }
    }

    public void addTypeName(String type) {
        if (type == null || this._listTypes.contains(type)) {
            return;
        }
        this._listTypes.add(0, type);
        log.debug("Location ({}) add rolling stock type ({})", (Object)this.getName(), (Object)type);
        this.setDirtyAndFirePropertyChange(TYPES_CHANGED_PROPERTY, this._listTypes.size() - 1, this._listTypes.size());
    }

    public void deleteTypeName(String type) {
        if (!this._listTypes.contains(type)) {
            return;
        }
        this._listTypes.remove(type);
        log.debug("Location ({}) delete rolling stock type ({})", (Object)this.getName(), (Object)type);
        this.setDirtyAndFirePropertyChange(TYPES_CHANGED_PROPERTY, this._listTypes.size() + 1, this._listTypes.size());
    }

    public boolean acceptsTypeName(String type) {
        return this._listTypes.contains(type);
    }

    public Track addTrack(String name, String type) {
        Track track = this.getTrackByName(name, type);
        if (track == null) {
            ++this._IdNumber;
            String id = String.valueOf(this._id) + LOC_TRACK_REGIX + Integer.toString(this._IdNumber);
            log.debug("Adding new ({}) to ({}) track name ({}) id: {}", new Object[]{type, this.getName(), name, id});
            track = new Track(id, name, type, this);
            InstanceManager.getDefault(LocationManager.class).resetNameLengths();
            this.register(track);
        }
        this.resetMoves();
        return track;
    }

    public void register(Track track) {
        Integer old = this._trackHashTable.size();
        this._trackHashTable.put(track.getId(), track);
        this.setLength(this.getLength() + track.getLength());
        String[] getId = track.getId().split(LOC_TRACK_REGIX);
        int id = Integer.parseInt(getId[1]);
        if (id > this._IdNumber) {
            this._IdNumber = id;
        }
        this.setDirtyAndFirePropertyChange(TRACK_LISTLENGTH_CHANGED_PROPERTY, old, this._trackHashTable.size());
        track.addPropertyChangeListener(this);
    }

    public void deleteTrack(Track track) {
        if (track != null) {
            track.removePropertyChangeListener(this);
            this.setLength(this.getLength() - track.getLength());
            track.dispose();
            Integer old = this._trackHashTable.size();
            this._trackHashTable.remove(track.getId());
            this.setDirtyAndFirePropertyChange(TRACK_LISTLENGTH_CHANGED_PROPERTY, old, this._trackHashTable.size());
        }
    }

    public Track getTrackByName(String name, String type) {
        Enumeration<Track> en = this._trackHashTable.elements();
        while (en.hasMoreElements()) {
            Track track = en.nextElement();
            if (!(type == null ? track.getName().equals(name) : track.getName().equals(name) && track.getTrackType().equals(type))) continue;
            return track;
        }
        return null;
    }

    public Track getTrackById(String id) {
        return this._trackHashTable.get(id);
    }

    public List<String> getTrackIdsByIdList() {
        ArrayList<String> out = new ArrayList<String>();
        Enumeration<String> en = this._trackHashTable.keys();
        while (en.hasMoreElements()) {
            out.add(en.nextElement());
        }
        Collections.sort(out);
        return out;
    }

    public List<Track> getTracksByIdList() {
        ArrayList<Track> out = new ArrayList<Track>();
        List<String> trackIds = this.getTrackIdsByIdList();
        for (String id : trackIds) {
            out.add(this.getTrackById(id));
        }
        return out;
    }

    public List<Track> getTracksList() {
        ArrayList<Track> out = new ArrayList<Track>();
        Enumeration<Track> en = this._trackHashTable.elements();
        while (en.hasMoreElements()) {
            out.add(en.nextElement());
        }
        return out;
    }

    public List<Track> getTracksByNameList(String type) {
        ArrayList<Track> out = new ArrayList<Track>();
        for (Track track : this.getTracksByIdList()) {
            boolean locAdded = false;
            int j = 0;
            while (j < out.size()) {
                if (track.getName().compareToIgnoreCase(((Track)out.get(j)).getName()) < 0 && (type != null && track.getTrackType().equals(type) || type == null)) {
                    out.add(j, track);
                    locAdded = true;
                    break;
                }
                ++j;
            }
            if (locAdded || (type == null || !track.getTrackType().equals(type)) && type != null) continue;
            out.add(track);
        }
        return out;
    }

    public List<Track> getTracksByMovesList(String type) {
        ArrayList<Track> moveList = new ArrayList<Track>();
        for (Track track : this.getTracksByIdList()) {
            boolean locAdded = false;
            int j = 0;
            while (j < moveList.size()) {
                if (track.getMoves() < ((Track)moveList.get(j)).getMoves() && (type != null && track.getTrackType().equals(type) || type == null)) {
                    moveList.add(j, track);
                    locAdded = true;
                    break;
                }
                ++j;
            }
            if (locAdded || (type == null || !track.getTrackType().equals(type)) && type != null) continue;
            moveList.add(track);
        }
        ArrayList<Track> out = new ArrayList<Track>();
        int i = 0;
        while (i < moveList.size()) {
            Track track = (Track)moveList.get(i);
            if (!track.getScheduleId().equals("")) {
                out.add(track);
                moveList.remove(i--);
            } else if (track.isAlternate()) {
                moveList.remove(i--);
            }
            ++i;
        }
        for (Track track : moveList) {
            out.add(track);
        }
        return out;
    }

    public List<Track> getTracksByBlockingOrderList(String type) {
        ArrayList<Track> orderList = new ArrayList<Track>();
        for (Track track : this.getTracksByNameList(type)) {
            boolean trackAdded = false;
            int j = 0;
            while (j < orderList.size()) {
                if (track.getBlockingOrder() < ((Track)orderList.get(j)).getBlockingOrder()) {
                    orderList.add(j, track);
                    trackAdded = true;
                    break;
                }
                ++j;
            }
            if (trackAdded) continue;
            orderList.add(track);
        }
        return orderList;
    }

    public void resetTracksByBlockingOrder() {
        for (Track track : this.getTracksList()) {
            track.setBlockingOrder(0);
        }
        this.setDirtyAndFirePropertyChange(TRACK_BLOCKING_ORDER_CHANGED_PROPERTY, true, false);
    }

    public void resequnceTracksByBlockingOrder() {
        int order = 1;
        for (Track track : this.getTracksByBlockingOrderList(null)) {
            track.setBlockingOrder(order++);
        }
        this.setDirtyAndFirePropertyChange(TRACK_BLOCKING_ORDER_CHANGED_PROPERTY, true, false);
    }

    public void changeTrackBlockingOrderEarlier(Track track) {
        if (track.getBlockingOrder() != 0) {
            Track repalceTrack = this.getTrackByBlockingOrder(track.getBlockingOrder() - 1);
            if (repalceTrack != null) {
                repalceTrack.setBlockingOrder(track.getBlockingOrder());
            }
            track.setBlockingOrder(track.getBlockingOrder() - 1);
            if (track.getBlockingOrder() <= 0) {
                track.setBlockingOrder(this._trackHashTable.size() + 1);
            }
        }
        this.resequnceTracksByBlockingOrder();
    }

    public void changeTrackBlockingOrderLater(Track track) {
        if (track.getBlockingOrder() != 0) {
            Track repalceTrack = this.getTrackByBlockingOrder(track.getBlockingOrder() + 1);
            if (repalceTrack != null) {
                repalceTrack.setBlockingOrder(track.getBlockingOrder());
            }
            track.setBlockingOrder(track.getBlockingOrder() + 1);
            if (track.getBlockingOrder() > this._trackHashTable.size()) {
                track.setBlockingOrder(0);
            }
        }
        this.resequnceTracksByBlockingOrder();
    }

    private Track getTrackByBlockingOrder(int order) {
        for (Track track : this.getTracksList()) {
            if (track.getBlockingOrder() != order) continue;
            return track;
        }
        return null;
    }

    public boolean isTrackAtLocation(Track track) {
        if (track == null) {
            return true;
        }
        return this._trackHashTable.contains(track);
    }

    public void resetMoves() {
        List<Track> tracks = this.getTracksList();
        for (Track track : tracks) {
            track.setMoves(0);
        }
    }

    public void updateComboBox(JComboBox<Track> box) {
        box.removeAllItems();
        box.addItem(null);
        List<Track> tracks = this.getTracksByNameList(null);
        for (Track track : tracks) {
            box.addItem(track);
        }
    }

    public void updateComboBox(JComboBox<Track> box, RollingStock rs, boolean filter, boolean isDestination) {
        this.updateComboBox(box);
        if (!filter || rs == null) {
            return;
        }
        List<Track> tracks = this.getTracksByNameList(null);
        for (Track track : tracks) {
            String status = "";
            status = isDestination ? rs.testDestination(this, track) : rs.testLocation(this, track);
            if (!(!status.equals(Track.OKAY) || isDestination && track.isStaging())) {
                box.setSelectedItem(track);
                log.debug("Available track: {} for location: {}", (Object)track.getName(), (Object)this.getName());
                continue;
            }
            box.removeItem(track);
        }
    }

    public Pool addPool(String name) {
        Pool pool = this.getPoolByName(name);
        if (pool == null) {
            ++this._idPoolNumber;
            String id = String.valueOf(this._id) + "p" + Integer.toString(this._idPoolNumber);
            log.debug("creating new pool ({}) id: {}", (Object)name, (Object)id);
            pool = new Pool(id, name);
            this.register(pool);
        }
        return pool;
    }

    public void removePool(Pool pool) {
        if (pool != null) {
            this._poolHashTable.remove(pool.getId());
            this.setDirtyAndFirePropertyChange(POOL_LENGTH_CHANGED_PROPERTY, this._poolHashTable.size() + 1, this._poolHashTable.size());
        }
    }

    public Pool getPoolByName(String name) {
        Enumeration<Pool> en = this._poolHashTable.elements();
        while (en.hasMoreElements()) {
            Pool pool = en.nextElement();
            if (!pool.getName().equals(name)) continue;
            return pool;
        }
        return null;
    }

    public void register(Pool pool) {
        Integer old = this._poolHashTable.size();
        this._poolHashTable.put(pool.getId(), pool);
        String[] getId = pool.getId().split("p");
        int id = Integer.parseInt(getId[1]);
        if (id > this._idPoolNumber) {
            this._idPoolNumber = id;
        }
        this.setDirtyAndFirePropertyChange(POOL_LENGTH_CHANGED_PROPERTY, old, this._poolHashTable.size());
    }

    public void updatePoolComboBox(JComboBox<Pool> box) {
        box.removeAllItems();
        box.addItem(null);
        for (Pool pool : this.getPoolsByNameList()) {
            box.addItem(pool);
        }
    }

    public List<Pool> getPoolsByNameList() {
        ArrayList<Pool> pools = new ArrayList<Pool>();
        Enumeration<Pool> en = this._poolHashTable.elements();
        while (en.hasMoreElements()) {
            pools.add(en.nextElement());
        }
        return pools;
    }

    public boolean hasServiceRestrictions() {
        Enumeration<Track> en = this._trackHashTable.elements();
        while (en.hasMoreElements()) {
            Track track = en.nextElement();
            if (track.getDropOption().equals("Any") && track.getPickupOption().equals("Any")) continue;
            return true;
        }
        return false;
    }

    public boolean hasPools() {
        return this._poolHashTable.size() > 0;
    }

    public boolean hasPlannedPickups() {
        List<Track> tracks = this.getTracksList();
        for (Track track : tracks) {
            if (track.getIgnoreUsedLengthPercentage() <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasLoadRestrictions() {
        List<Track> tracks = this.getTracksList();
        for (Track track : tracks) {
            if (track.getLoadOption().equals(Track.ALL_LOADS)) continue;
            return true;
        }
        return false;
    }

    public boolean hasShipLoadRestrictions() {
        List<Track> tracks = this.getTracksList();
        for (Track track : tracks) {
            if (track.getShipLoadOption().equals(Track.ALL_LOADS)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRoadRestrictions() {
        List<Track> tracks = this.getTracksList();
        for (Track track : tracks) {
            if (track.getRoadOption().equals(Track.ALL_ROADS)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDestinationRestrictions() {
        List<Track> tracks = this.getTracksList();
        for (Track track : tracks) {
            if (track.getDestinationOption().equals(Track.ALL_DESTINATIONS)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAlternateTracks() {
        for (Track track : this.getTracksList()) {
            if (track.getAlternateTrack() == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasOrderRestrictions() {
        for (Track track : this.getTracksList()) {
            if (track.getServiceOrder().equals(Track.NORMAL)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSchedules() {
        for (Track track : this.getTracksList()) {
            if (!track.isSpur() || track.getSchedule() == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasWork() {
        return this.getDropRS() != 0 || this.getPickupRS() != 0;
    }

    public boolean hasReporters() {
        for (Track track : this.getTracksList()) {
            if (track.getReporter() == null) continue;
            return true;
        }
        return false;
    }

    public void setReporter(Reporter r) {
        Reporter old = this._reader;
        this._reader = r;
        if (old != r) {
            this.setDirtyAndFirePropertyChange(LOCATION_REPORTER_PROPERTY, old, r);
        }
    }

    public Reporter getReporter() {
        return this._reader;
    }

    public String getReporterName() {
        if (this.getReporter() != null) {
            return this.getReporter().getDisplayName();
        }
        return "";
    }

    public void dispose() {
        List<Track> tracks = this.getTracksList();
        for (Track track : tracks) {
            this.deleteTrack(track);
        }
        InstanceManager.getDefault(CarTypes.class).removePropertyChangeListener(this);
        InstanceManager.getDefault(CarRoads.class).removePropertyChangeListener(this);
        InstanceManager.getDefault(EngineTypes.class).removePropertyChangeListener(this);
        this.setName(MessageFormat.format(Bundle.getMessage("NotValid"), this.getName()));
        this.setDirtyAndFirePropertyChange(DISPOSE_CHANGED_PROPERTY, null, DISPOSE_CHANGED_PROPERTY);
    }

    private void addPropertyChangeListeners() {
        InstanceManager.getDefault(CarTypes.class).addPropertyChangeListener(this);
        InstanceManager.getDefault(CarRoads.class).addPropertyChangeListener(this);
        InstanceManager.getDefault(EngineTypes.class).addPropertyChangeListener(this);
    }

    public Location(Element e) {
        List eTracks;
        Attribute a = e.getAttribute("id");
        if (a != null) {
            this._id = a.getValue();
        } else {
            log.warn("no id attribute in location element when reading operations");
        }
        a = e.getAttribute("name");
        if (a != null) {
            this._name = a.getValue();
        }
        if ((a = e.getAttribute("divisionId")) != null) {
            this._division = InstanceManager.getDefault(DivisionManager.class).getDivisionById(a.getValue());
        }
        if ((a = e.getAttribute("DivisionId")) != null) {
            this._division = InstanceManager.getDefault(DivisionManager.class).getDivisionById(a.getValue());
        }
        if ((a = e.getAttribute("dir")) != null) {
            try {
                this._trainDir = Integer.parseInt(a.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                log.error("Train directions isn't a vaild number for location {}", (Object)this.getName());
            }
        }
        if ((a = e.getAttribute(SWITCHLIST_CHANGED_PROPERTY)) != null) {
            this._switchList = a.getValue().equals("true");
        }
        if ((a = e.getAttribute("switchListState")) != null) {
            try {
                this._switchListState = Integer.parseInt(a.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                log.error("Switch list state isn't a vaild number for location {}", (Object)this.getName());
            }
            if (this.getSwitchListState() == 2) {
                this.setStatus(PRINTED);
            }
        }
        if ((a = e.getAttribute("printerName")) != null) {
            this._defaultPrinter = a.getValue();
        }
        try {
            Attribute y;
            Attribute x = e.getAttribute("eastTrainIconX");
            if (x != null && (y = e.getAttribute("eastTrainIconY")) != null) {
                this.setTrainIconEast(new Point(Integer.parseInt(x.getValue()), Integer.parseInt(y.getValue())));
            }
            if ((x = e.getAttribute("westTrainIconX")) != null && (y = e.getAttribute("westTrainIconY")) != null) {
                this.setTrainIconWest(new Point(Integer.parseInt(x.getValue()), Integer.parseInt(y.getValue())));
            }
            if ((x = e.getAttribute("northTrainIconX")) != null && (y = e.getAttribute("northTrainIconY")) != null) {
                this.setTrainIconNorth(new Point(Integer.parseInt(x.getValue()), Integer.parseInt(y.getValue())));
            }
            if ((x = e.getAttribute("southTrainIconX")) != null && (y = e.getAttribute("southTrainIconY")) != null) {
                this.setTrainIconSouth(new Point(Integer.parseInt(x.getValue()), Integer.parseInt(y.getValue())));
            }
            if ((x = e.getAttribute("trainIconRangeX")) != null) {
                this.setTrainIconRangeX(Integer.parseInt(x.getValue()));
            }
            if ((y = e.getAttribute("trainIconRangeY")) != null) {
                this.setTrainIconRangeY(Integer.parseInt(y.getValue()));
            }
        }
        catch (NumberFormatException numberFormatException) {
            log.error("Train icon coordinates aren't vaild for location {}", (Object)this.getName());
        }
        if ((a = e.getAttribute("comment")) != null) {
            this._comment = a.getValue();
        }
        if ((a = e.getAttribute(SWITCHLIST_COMMENT_CHANGED_PROPERTY)) != null) {
            this._switchListComment = a.getValue();
        }
        if ((a = e.getAttribute("physicalLocation")) != null) {
            this._physicalLocation = PhysicalLocation.parse(a.getValue());
        }
        if (e.getChild("types") != null) {
            List carTypes = e.getChild("types").getChildren("carType");
            String[] types = new String[carTypes.size()];
            int i = 0;
            while (i < carTypes.size()) {
                Element type = (Element)carTypes.get(i);
                a = type.getAttribute("name");
                if (a != null) {
                    types[i] = a.getValue();
                }
                ++i;
            }
            this.setTypeNames(types);
            List locoTypes = e.getChild("types").getChildren("locoType");
            types = new String[locoTypes.size()];
            int i2 = 0;
            while (i2 < locoTypes.size()) {
                Element type = (Element)locoTypes.get(i2);
                a = type.getAttribute("name");
                if (a != null) {
                    types[i2] = a.getValue();
                }
                ++i2;
            }
            this.setTypeNames(types);
        } else {
            a = e.getAttribute("carTypes");
            if (a != null) {
                String names = a.getValue();
                String[] Types = names.split("%%");
                this.setTypeNames(Types);
            }
        }
        if (e.getChildren("secondary") != null) {
            eTracks = e.getChildren("secondary");
            for (Element eTrack : eTracks) {
                this.register(new Track(eTrack, this));
            }
        }
        if (e.getChildren("track") != null) {
            eTracks = e.getChildren("track");
            log.debug("location ({}) has {} tracks", (Object)this.getName(), (Object)eTracks.size());
            for (Element eTrack : eTracks) {
                this.register(new Track(eTrack, this));
            }
        }
        if (e.getAttribute("idReader") != null) {
            try {
                Reporter r;
                this._reader = r = InstanceManager.getDefault(ReporterManager.class).provideReporter(e.getAttribute("idReader").getValue());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.warn("Not able to find reader: {} for location ({})", (Object)e.getAttribute("idReader").getValue(), (Object)this.getName());
            }
        }
        this.addPropertyChangeListeners();
    }

    public Element store() {
        Element e = new Element("location");
        e.setAttribute("id", this.getId());
        e.setAttribute("name", this.getName());
        if (!this.getDivisionId().equals("")) {
            e.setAttribute("divisionId", this.getDivisionId());
        }
        e.setAttribute("ops", this.isStaging() ? STAGING : NORMAL);
        e.setAttribute("dir", Integer.toString(this.getTrainDirections()));
        e.setAttribute(SWITCHLIST_CHANGED_PROPERTY, this.isSwitchListEnabled() ? "true" : "false");
        if (!Setup.isSwitchListRealTime()) {
            e.setAttribute("switchListState", Integer.toString(this.getSwitchListState()));
        }
        if (!this.getDefaultPrinterName().equals("")) {
            e.setAttribute("printerName", this.getDefaultPrinterName());
        }
        if (!this.getTrainIconEast().equals(new Point())) {
            e.setAttribute("eastTrainIconX", Integer.toString(this.getTrainIconEast().x));
            e.setAttribute("eastTrainIconY", Integer.toString(this.getTrainIconEast().y));
        }
        if (!this.getTrainIconWest().equals(new Point())) {
            e.setAttribute("westTrainIconX", Integer.toString(this.getTrainIconWest().x));
            e.setAttribute("westTrainIconY", Integer.toString(this.getTrainIconWest().y));
        }
        if (!this.getTrainIconNorth().equals(new Point())) {
            e.setAttribute("northTrainIconX", Integer.toString(this.getTrainIconNorth().x));
            e.setAttribute("northTrainIconY", Integer.toString(this.getTrainIconNorth().y));
        }
        if (!this.getTrainIconSouth().equals(new Point())) {
            e.setAttribute("southTrainIconX", Integer.toString(this.getTrainIconSouth().x));
            e.setAttribute("southTrainIconY", Integer.toString(this.getTrainIconSouth().y));
        }
        if (this.getTrainIconRangeX() != 25) {
            e.setAttribute("trainIconRangeX", Integer.toString(this.getTrainIconRangeX()));
        }
        if (this.getTrainIconRangeY() != 25) {
            e.setAttribute("trainIconRangeY", Integer.toString(this.getTrainIconRangeY()));
        }
        if (this._reader != null) {
            e.setAttribute("idReader", this._reader.getDisplayName());
        }
        String[] types = this.getTypeNames();
        Element eTypes = new Element("types");
        String[] stringArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Element eType;
            String type = stringArray[n2];
            if (InstanceManager.getDefault(EngineTypes.class).containsName(type)) {
                eType = new Element("locoType");
                eType.setAttribute("name", type);
                eTypes.addContent((Content)eType);
            } else if (InstanceManager.getDefault(CarTypes.class).containsName(type)) {
                eType = new Element("carType");
                eType.setAttribute("name", type);
                eTypes.addContent((Content)eType);
            }
            ++n2;
        }
        e.addContent((Content)eTypes);
        if (this.getPhysicalLocation() != null && !this.getPhysicalLocation().equals((Tuple3f)PhysicalLocation.Origin)) {
            e.setAttribute("physicalLocation", this.getPhysicalLocation().toString());
        }
        e.setAttribute("comment", this.getComment());
        e.setAttribute(SWITCHLIST_COMMENT_CHANGED_PROPERTY, this.getSwitchListComment());
        List<Track> tracks = this.getTracksByIdList();
        for (Track track : tracks) {
            e.addContent((Content)track.store());
        }
        return e;
    }

    private void replaceType(String oldType, String newType) {
        if (this.acceptsTypeName(oldType)) {
            if (newType != null) {
                this.addTypeName(newType);
            }
            List<Track> tracks = this.getTracksList();
            for (Track track : tracks) {
                String[] splitLoad;
                String load;
                String[] loadNames;
                if (track.isTypeNameAccepted(oldType)) {
                    track.deleteTypeName(oldType);
                    if (newType != null) {
                        track.addTypeName(newType);
                    }
                }
                String[] stringArray = loadNames = track.getLoadNames();
                int n = loadNames.length;
                int n2 = 0;
                while (n2 < n) {
                    load = stringArray[n2];
                    splitLoad = load.split(" & ");
                    if (splitLoad.length > 1 && splitLoad[0].equals(oldType)) {
                        track.deleteLoadName(load);
                        if (newType != null) {
                            load = String.valueOf(newType) + " & " + splitLoad[1];
                            track.addLoadName(load);
                        }
                    }
                    ++n2;
                }
                stringArray = loadNames = track.getShipLoadNames();
                n = loadNames.length;
                n2 = 0;
                while (n2 < n) {
                    load = stringArray[n2];
                    splitLoad = load.split(" & ");
                    if (splitLoad.length > 1 && splitLoad[0].equals(oldType)) {
                        track.deleteShipLoadName(load);
                        if (newType != null) {
                            load = String.valueOf(newType) + " & " + splitLoad[1];
                            track.addShipLoadName(load);
                        }
                    }
                    ++n2;
                }
            }
            this.deleteTypeName(oldType);
        }
    }

    private void replaceRoad(String oldRoad, String newRoad) {
        List<Track> tracks = this.getTracksList();
        for (Track track : tracks) {
            if (!track.containsRoadName(oldRoad)) continue;
            track.deleteRoadName(oldRoad);
            if (newRoad == null) continue;
            track.addRoadName(newRoad);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("trackLength")) {
            this.setLength(this.getLength() - Integer.parseInt((String)e.getOldValue()) + Integer.parseInt((String)e.getNewValue()));
        }
        if (e.getPropertyName().equals("trackType")) {
            this.setDirtyAndFirePropertyChange(TRACK_LISTLENGTH_CHANGED_PROPERTY, null, null);
        }
        if (e.getPropertyName().equals("CarTypes Name") || e.getPropertyName().equals("CarTypes Length") || e.getPropertyName().equals("EngineTypesName")) {
            this.replaceType((String)e.getOldValue(), (String)e.getNewValue());
        }
        if (e.getPropertyName().equals("CarRoads Name")) {
            this.replaceRoad((String)e.getOldValue(), (String)e.getNewValue());
        }
    }

    protected void setDirtyAndFirePropertyChange(String p, Object old, Object n) {
        InstanceManager.getDefault(LocationManagerXml.class).setDirty(true);
        this.firePropertyChange(p, old, n);
    }
}

