/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.automation.actions;

import java.io.File;
import jmri.InstanceManager;
import jmri.jmrit.operations.automation.actions.Action;
import jmri.jmrit.operations.automation.actions.Bundle;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainCsvSwitchLists;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.TrainSwitchLists;
import jmri.jmrit.operations.trains.excel.TrainCustomManifest;
import jmri.jmrit.operations.trains.excel.TrainCustomSwitchList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunSwitchListChangesAction
extends Action {
    private static final int _code = 4876;
    protected static final boolean IS_CHANGED = true;
    private static final Logger log = LoggerFactory.getLogger(RunSwitchListChangesAction.class);

    @Override
    public int getCode() {
        return 4876;
    }

    @Override
    public String getName() {
        return Bundle.getMessage("RunSwitchListChanges");
    }

    @Override
    public void doAction() {
        this.doAction(true);
    }

    protected void doAction(boolean isChanged) {
        if (this.getAutomationItem() != null) {
            if (!Setup.isGenerateCsvSwitchListEnabled()) {
                log.warn("Generate CSV Switch List isn't enabled!");
                this.finishAction(false);
                return;
            }
            if (!InstanceManager.getDefault(TrainCustomSwitchList.class).excelFileExists()) {
                log.warn("Manifest creator file not found!, directory name: {}, file name: {}", (Object)InstanceManager.getDefault(TrainCustomSwitchList.class).getDirectoryName(), (Object)InstanceManager.getDefault(TrainCustomSwitchList.class).getFileName());
                this.finishAction(false);
                return;
            }
            this.setRunning(true);
            TrainSwitchLists trainSwitchLists = new TrainSwitchLists();
            TrainCsvSwitchLists trainCsvSwitchLists = new TrainCsvSwitchLists();
            if (!InstanceManager.getDefault(TrainCustomManifest.class).checkProcessReady()) {
                log.warn("Timeout waiting for excel manifest program to complete previous operation, timeout value: {} seconds", (Object)Control.excelWaitTime);
            }
            if (!InstanceManager.getDefault(TrainCustomSwitchList.class).checkProcessReady()) {
                log.warn("Timeout waiting for excel switch list program to complete previous operation, timeout value: {} seconds", (Object)Control.excelWaitTime);
            }
            if (InstanceManager.getDefault(TrainCustomSwitchList.class).doesCommonFileExist()) {
                log.warn("Switch List CSV common file exists!");
            }
            for (Location location : InstanceManager.getDefault(LocationManager.class).getLocationsByNameList()) {
                if (!location.isSwitchListEnabled() || isChanged && !location.getStatus().equals(Location.MODIFIED)) continue;
                File csvFile = trainCsvSwitchLists.buildSwitchList(location);
                trainSwitchLists.buildSwitchList(location);
                if (csvFile == null || !csvFile.exists()) {
                    log.error("CSV switch list file was not created for location {}", (Object)location.getName());
                    this.finishAction(false);
                    return;
                }
                location.setStatus(Location.PRINTED);
                location.setSwitchListState(2);
                InstanceManager.getDefault(TrainCustomSwitchList.class).addCsvFile(csvFile);
                log.info("Queued switch list CSV file location ({}) for custom processing", (Object)location.getName());
            }
            boolean status = InstanceManager.getDefault(TrainCustomSwitchList.class).process();
            if (status) {
                try {
                    status = InstanceManager.getDefault(TrainCustomSwitchList.class).waitForProcessToComplete();
                }
                catch (InterruptedException e) {
                    log.error("Thread interrupeted while waiting", (Throwable)e);
                }
            } else {
                log.info("No switch list changes found");
            }
            InstanceManager.getDefault(TrainManager.class).setTrainsSwitchListStatus(Train.PRINTED);
            this.finishAction(status);
        }
    }

    @Override
    public void cancelAction() {
    }
}

