/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.automation.actions;

import jmri.InstanceManager;
import jmri.jmrit.operations.automation.actions.Action;
import jmri.jmrit.operations.automation.actions.Bundle;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainCsvSwitchLists;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.TrainSwitchLists;

public class PrintSwitchListChangesAction
extends Action {
    private static final int _code = 5380;
    protected static final boolean IS_CHANGED = true;

    @Override
    public int getCode() {
        return 5380;
    }

    @Override
    public String getName() {
        if (InstanceManager.getDefault(TrainManager.class).isPrintPreviewEnabled()) {
            return Bundle.getMessage("PreviewSwitchListChanges");
        }
        return Bundle.getMessage("PrintSwitchListChanges");
    }

    @Override
    public void doAction() {
        this.doAction(true);
    }

    protected void doAction(boolean isChanged) {
        if (this.getAutomationItem() != null) {
            this.setRunning(true);
            TrainSwitchLists trainSwitchLists = new TrainSwitchLists();
            TrainCsvSwitchLists trainCsvSwitchLists = new TrainCsvSwitchLists();
            for (Location location : InstanceManager.getDefault(LocationManager.class).getLocationsByNameList()) {
                if (!location.isSwitchListEnabled() || isChanged && !location.getStatus().equals(Location.MODIFIED)) continue;
                trainCsvSwitchLists.buildSwitchList(location);
                trainSwitchLists.buildSwitchList(location);
                trainSwitchLists.printSwitchList(location, InstanceManager.getDefault(TrainManager.class).isPrintPreviewEnabled());
            }
            InstanceManager.getDefault(TrainManager.class).setTrainsSwitchListStatus(Train.PRINTED);
        }
        this.finishAction(true);
    }

    @Override
    public void cancelAction() {
    }
}

