/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.automation.actions;

import javax.swing.JComboBox;
import jmri.InstanceManager;
import jmri.jmrit.operations.automation.Automation;
import jmri.jmrit.operations.automation.AutomationItem;
import jmri.jmrit.operations.automation.AutomationManager;
import jmri.jmrit.operations.automation.actions.Action;
import jmri.jmrit.operations.automation.actions.Bundle;

public class GotoAction
extends Action {
    private static final int _code = 20524;

    @Override
    public int getCode() {
        return 20524;
    }

    @Override
    public String getName() {
        return Bundle.getMessage("Goto");
    }

    @Override
    public void doAction() {
        if (this.getAutomationItem() != null) {
            AutomationItem gotoAutomationItem = this.getAutomationItem().getGotoAutomationItem();
            if (gotoAutomationItem != null) {
                this.setRunning(true);
                this.firePropertyChange("actionGoto", null, gotoAutomationItem);
            }
            this.finishAction(gotoAutomationItem != null);
        }
    }

    @Override
    public void cancelAction() {
        this.setRunning(false);
    }

    @Override
    public String getActionSuccessfulString() {
        return String.valueOf(Bundle.getMessage("ButtonOK")) + this.getGotoAutomationItemId();
    }

    private String getGotoAutomationItemId() {
        AutomationItem gotoAutomationItem;
        String id = "";
        if (this.getAutomationItem() != null && (gotoAutomationItem = this.getAutomationItem().getGotoAutomationItem()) != null && this.getAutomationItem().isGotoBranched()) {
            id = " -> " + gotoAutomationItem.getId();
        }
        return id;
    }

    public JComboBox<AutomationItem> getComboBox() {
        if (this.getAutomationItem() != null) {
            Automation automation = InstanceManager.getDefault(AutomationManager.class).getAutomationById(this.getAutomationItem().getId().split("c")[0]);
            JComboBox<AutomationItem> cb = automation.getComboBox();
            cb.removeItem(this.getAutomationItem());
            cb.setSelectedItem(this.getAutomationItem().getGotoAutomationItem());
            return cb;
        }
        return null;
    }
}

