/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.automation.actions;

import java.text.MessageFormat;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import jmri.beans.PropertyChangeSupport;
import jmri.jmrit.operations.automation.Automation;
import jmri.jmrit.operations.automation.AutomationItem;
import jmri.jmrit.operations.automation.actions.Bundle;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.schedules.TrainSchedule;

public abstract class Action
extends PropertyChangeSupport {
    public static final String ACTION_COMPLETE_CHANGED_PROPERTY = "actionComplete";
    public static final String ACTION_HALT_CHANGED_PROPERTY = "actionHalt";
    public static final String ACTION_RUNNING_CHANGED_PROPERTY = "actionRunning";
    public static final String ACTION_GOTO_CHANGED_PROPERTY = "actionGoto";
    public static final int HALT = 0;
    public static final int OKAY = 1;
    public static final int CLOSED = -1;
    public static final int NO_MESSAGE_SENT = -2;
    public static final int FINISH_FAILED = -3;
    protected AutomationItem _automationItem = null;

    public abstract int getCode();

    public abstract String getName();

    public abstract void doAction();

    public abstract void cancelAction();

    public String toString() {
        return this.getName();
    }

    protected int getCode(int code) {
        return code & 0xFF00;
    }

    public boolean isTrainMenuEnabled() {
        return (this.getCode() & 1) == 1;
    }

    public boolean isRouteMenuEnabled() {
        return (this.getCode() & 2) == 2;
    }

    public boolean isMessageOkEnabled() {
        return (this.getCode() & 4) == 4;
    }

    public boolean isMessageFailEnabled() {
        return (this.getCode() & 8) == 8;
    }

    public boolean isAutomationMenuEnabled() {
        return (this.getCode() & 0x10) == 16;
    }

    public boolean isGotoMenuEnabled() {
        return (this.getCode() & 0x20) == 32;
    }

    public boolean isOtherMenuEnabled() {
        return (this.getCode() & 0x40) == 64;
    }

    public boolean isConcurrentAction() {
        return false;
    }

    public void setAutomationItem(AutomationItem item) {
        this._automationItem = item;
    }

    public AutomationItem getAutomationItem() {
        return this._automationItem;
    }

    public String getActionString() {
        return this.getFormatedMessage("{0}{1}{2}{3}{4}{5}");
    }

    public String getActionSuccessfulString() {
        return Bundle.getMessage("ButtonOK");
    }

    public String getActionFailedString() {
        return Bundle.getMessage("FAILED");
    }

    public void setRunning(boolean running) {
        if (this.getAutomationItem() != null) {
            boolean old = this.getAutomationItem().isActionRunning();
            this.getAutomationItem().setActionRunning(running);
            if (old != running) {
                this.firePropertyChange(ACTION_RUNNING_CHANGED_PROPERTY, old, running);
            }
        }
    }

    public int finishAction(boolean success) {
        return this.finishAction(success, new Object[]{Bundle.getMessage("HALT"), Bundle.getMessage("ButtonOK")});
    }

    public int finishAction(boolean success, Object[] buttons) {
        int response = -3;
        if (this.getAutomationItem() != null) {
            this.setRunning(true);
            this.getAutomationItem().setActionSuccessful(success);
            this.setRunning(false);
            String message = this.getAutomationItem().getMessage();
            if (!success) {
                message = this.getAutomationItem().getMessageFail();
                if (this.getAutomationItem().isHaltFailureEnabled()) {
                    buttons = new Object[]{Bundle.getMessage("HALT")};
                }
            }
            if ((response = this.sendMessage(message, buttons, success)) == 0 && buttons[0].equals(Bundle.getMessage("HALT")) || !success && this.getAutomationItem().isHaltFailureEnabled()) {
                this.firePropertyChange(ACTION_HALT_CHANGED_PROPERTY, !success, success);
            } else {
                this.firePropertyChange(ACTION_COMPLETE_CHANGED_PROPERTY, !success, success);
            }
        }
        return response;
    }

    public int sendMessage(String message, Object[] buttons, boolean success) {
        int response = -2;
        if (this.getAutomationItem() != null && !message.equals("")) {
            String title = String.valueOf(this.getAutomationItem().getId()) + " " + (success ? "" : Bundle.getMessage("Failed")) + " " + this.getActionString();
            Object intialValue = buttons[0];
            if (buttons.length > 1 && success) {
                intialValue = buttons[1];
            }
            response = JOptionPane.showOptionDialog(null, this.getFormatedMessage(message), title, 2, 1, null, buttons, intialValue);
        }
        return response;
    }

    public String getFormatedMessage(String message) {
        String trainName = "";
        Train train = this.getAutomationItem().getTrain();
        if (train != null) {
            trainName = " " + train.getName();
        }
        String routeLocationName = "";
        RouteLocation rl = this.getAutomationItem().getRouteLocation();
        if (rl != null) {
            routeLocationName = " " + rl.getName();
        }
        String automationName = "";
        Automation automation = this.getAutomationItem().getAutomationToRun();
        if (automation != null) {
            automationName = " " + automation.getName();
        }
        String itemId = "";
        AutomationItem item = this.getAutomationItem().getGotoAutomationItem();
        if (item != null) {
            itemId = " " + item.getId();
        }
        String day = "";
        TrainSchedule trainSchedule = this.getAutomationItem().getTrainSchedule();
        if (trainSchedule != null) {
            day = " " + trainSchedule.getName();
        }
        return MessageFormat.format(message, this.getName(), trainName, routeLocationName, automationName, itemId, day);
    }

    public JComboBox<?> getComboBox() {
        JComboBox cb = new JComboBox();
        cb.setEnabled(false);
        return cb;
    }
}

