/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.automation;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.automation.Automation;
import jmri.jmrit.operations.automation.AutomationManager;
import jmri.jmrit.operations.automation.AutomationTableFrame;
import jmri.jmrit.operations.automation.AutomationsTableFrame;
import jmri.jmrit.operations.automation.Bundle;
import jmri.jmrit.symbolicprog.ValueEditor;
import jmri.jmrit.symbolicprog.ValueRenderer;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutomationsTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    AutomationManager automationManager;
    private static final int ID_COLUMN = 0;
    private static final int NAME_COLUMN = 1;
    private static final int COMMENT_COLUMN = 2;
    private static final int ACTION_COLUMN = 3;
    private static final int STATUS_COLUMN = 4;
    private static final int RUN_COLUMN = 5;
    private static final int EDIT_COLUMN = 6;
    private static final int DELETE_COLUMN = 7;
    private static final int HIGHEST_COLUMN = 8;
    public final int SORTBYNAME = 1;
    public final int SORTBYID = 2;
    private int _sort = 1;
    List<Automation> _sysList = null;
    JTable _table;
    Hashtable<String, AutomationTableFrame> automationEditFrames = new Hashtable();
    private static final Logger log = LoggerFactory.getLogger(AutomationsTableModel.class);

    public AutomationsTableModel() {
        this.automationManager = InstanceManager.getDefault(AutomationManager.class);
        this.automationManager.addPropertyChangeListener(this);
        this.updateList();
    }

    public void setSort(int sort) {
        this._sort = sort;
        this.updateList();
        this.fireTableDataChanged();
    }

    private void updateList() {
        this.removePropertyChangeAutomations();
        this._sysList = this._sort == 2 ? this.automationManager.getAutomationsByIdList() : this.automationManager.getAutomationsByNameList();
        for (Automation automation : this._sysList) {
            automation.addPropertyChangeListener(this);
        }
    }

    protected void initTable(AutomationsTableFrame frame, JTable table) {
        this._table = table;
        TableColumnModel tcm = table.getColumnModel();
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        ButtonEditor buttonEditor = new ButtonEditor(new JButton());
        tcm.getColumn(5).setCellRenderer(buttonRenderer);
        tcm.getColumn(5).setCellEditor(buttonEditor);
        tcm.getColumn(6).setCellRenderer(buttonRenderer);
        tcm.getColumn(6).setCellEditor(buttonEditor);
        tcm.getColumn(7).setCellRenderer(buttonRenderer);
        tcm.getColumn(7).setCellEditor(buttonEditor);
        table.setDefaultRenderer(JComboBox.class, new ValueRenderer());
        table.setDefaultEditor(JComboBox.class, new ValueEditor());
        table.getColumnModel().getColumn(0).setPreferredWidth(40);
        table.getColumnModel().getColumn(1).setPreferredWidth(200);
        table.getColumnModel().getColumn(2).setPreferredWidth(350);
        table.getColumnModel().getColumn(3).setPreferredWidth(250);
        table.getColumnModel().getColumn(4).setPreferredWidth(90);
        table.getColumnModel().getColumn(5).setPreferredWidth(90);
        table.getColumnModel().getColumn(6).setPreferredWidth(70);
        table.getColumnModel().getColumn(7).setPreferredWidth(90);
        frame.loadTableDetails(table);
    }

    @Override
    public int getRowCount() {
        return this._sysList.size();
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("Id");
            }
            case 1: {
                return Bundle.getMessage("Name");
            }
            case 2: {
                return Bundle.getMessage("Comment");
            }
            case 3: {
                return Bundle.getMessage("Action");
            }
            case 4: {
                return Bundle.getMessage("Status");
            }
            case 5: {
                return Bundle.getMessage("Run");
            }
            case 6: {
                return Bundle.getMessage("ButtonEdit");
            }
            case 7: {
                return Bundle.getMessage("ButtonDelete");
            }
        }
        return "unknown";
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 4: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 5: {
                return JButton.class;
            }
            case 6: {
                return JButton.class;
            }
            case 7: {
                return JButton.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.getRowCount()) {
            return "ERROR row " + row;
        }
        Automation automation = this._sysList.get(row);
        if (automation == null) {
            return "ERROR automation unknown " + row;
        }
        switch (col) {
            case 0: {
                return automation.getId();
            }
            case 1: {
                return automation.getName();
            }
            case 2: {
                return automation.getComment();
            }
            case 3: {
                return automation.getCurrentActionString();
            }
            case 4: {
                return automation.getActionStatus();
            }
            case 5: {
                if (automation.isActionRunning()) {
                    return Bundle.getMessage("Stop");
                }
                if (automation.isReadyToRun()) {
                    return Bundle.getMessage("Run");
                }
                return Bundle.getMessage("Resume");
            }
            case 6: {
                return Bundle.getMessage("ButtonEdit");
            }
            case 7: {
                return Bundle.getMessage("ButtonDelete");
            }
        }
        return "unknown " + col;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        switch (col) {
            case 5: {
                this.runAutomation(row);
                break;
            }
            case 6: {
                this.editAutomation(row);
                break;
            }
            case 7: {
                this.deleteAutomation(row);
                break;
            }
        }
    }

    private void runAutomation(int row) {
        Automation automation = this._sysList.get(row);
        SwingUtilities.invokeLater(() -> {
            if (automation.isActionRunning()) {
                automation.stop();
            } else {
                automation.resume();
            }
        });
    }

    private void editAutomation(int row) {
        AutomationTableFrame frame;
        log.debug("Edit automation");
        Automation automation = this._sysList.get(row);
        if (this.automationEditFrames.containsKey(automation.getId()) && (frame = this.automationEditFrames.get(automation.getId())).isVisible()) {
            frame.toFront();
            frame.setExtendedState(0);
            return;
        }
        SwingUtilities.invokeLater(() -> {
            AutomationTableFrame frame = new AutomationTableFrame(automation);
            this.automationEditFrames.put(automation.getId(), frame);
        });
    }

    private void deleteAutomation(int row) {
        log.debug("Delete automation");
        Automation automation = this._sysList.get(row);
        if (JOptionPane.showConfirmDialog(null, MessageFormat.format(Bundle.getMessage("DoYouWantToDeleteAutomation"), automation.getName()), Bundle.getMessage("DeleteAutomation?"), 0) == 0) {
            this.automationManager.deregister(automation);
            OperationsXml.save();
        }
    }

    protected void comboBoxActionPerformed(ActionEvent ae) {
        log.debug("combobox action");
        if (this._table.isEditing()) {
            this._table.getCellEditor().stopCellEditing();
        }
    }

    private void removePropertyChangeAutomations() {
        if (this._sysList != null) {
            for (Automation automation : this._sysList) {
                automation.removePropertyChangeListener(this);
            }
        }
    }

    public void dispose() {
        Enumeration<String> en = this.automationEditFrames.keys();
        while (en.hasMoreElements()) {
            AutomationTableFrame frame = this.automationEditFrames.get(en.nextElement());
            frame.dispose();
        }
        this.automationManager.removePropertyChangeListener(this);
        this.removePropertyChangeAutomations();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        Automation automation;
        int row;
        if (e.getPropertyName().equals("automationListLength")) {
            this.updateList();
            this.fireTableDataChanged();
        } else if (e.getSource().getClass().equals(Automation.class) && (row = this._sysList.indexOf(automation = (Automation)e.getSource())) >= 0) {
            this.fireTableRowsUpdated(row, row);
        }
    }
}

