/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.automation;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.automation.AutomationCopyAction;
import jmri.jmrit.operations.automation.AutomationResumeAction;
import jmri.jmrit.operations.automation.AutomationTableFrame;
import jmri.jmrit.operations.automation.AutomationsTableModel;
import jmri.jmrit.operations.automation.Bundle;
import jmri.swing.JTablePersistenceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutomationsTableFrame
extends OperationsFrame {
    AutomationsTableModel automationsModel = new AutomationsTableModel();
    JTable automationsTable = new JTable(this.automationsModel);
    JScrollPane automationsPane;
    JLabel textSort = new JLabel();
    JLabel textSep = new JLabel();
    JRadioButton sortByNameRadioButton = new JRadioButton(Bundle.getMessage("Name"));
    JRadioButton sortByIdRadioButton = new JRadioButton(Bundle.getMessage("Id"));
    JButton addButton = new JButton(Bundle.getMessage("AddAutomation"));
    private static final Logger log = LoggerFactory.getLogger(AutomationsTableFrame.class);

    public AutomationsTableFrame() {
        super(Bundle.getMessage("TitleAutomationsTableFrame"));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.automationsPane = new JScrollPane(this.automationsTable);
        this.automationsPane.setVerticalScrollBarPolicy(20);
        this.automationsPane.setHorizontalScrollBarPolicy(30);
        this.automationsModel.initTable(this, this.automationsTable);
        this.getContentPane().add(this.automationsPane);
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new FlowLayout());
        this.textSort.setText(Bundle.getMessage("SortBy"));
        controlPanel.add(this.textSort);
        controlPanel.add(this.sortByNameRadioButton);
        this.sortByNameRadioButton.setSelected(true);
        controlPanel.add(this.sortByIdRadioButton);
        this.textSep.setText("          ");
        controlPanel.add(this.textSep);
        controlPanel.add(this.addButton);
        controlPanel.setMaximumSize(new Dimension(1025, 50));
        this.getContentPane().add(controlPanel);
        this.addButtonAction(this.addButton);
        this.addRadioButtonAction(this.sortByNameRadioButton);
        this.addRadioButtonAction(this.sortByIdRadioButton);
        JMenuBar menuBar = new JMenuBar();
        JMenu toolMenu = new JMenu(Bundle.getMessage("MenuTools"));
        menuBar.add(toolMenu);
        toolMenu.add(new AutomationCopyAction());
        toolMenu.add(new AutomationResumeAction());
        this.setJMenuBar(menuBar);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_Automation", true);
        this.initMinimumSize();
        if (this.getWidth() == 500) {
            this.setSize(1025, this.getHeight());
        }
    }

    @Override
    public void radioButtonActionPerformed(ActionEvent ae) {
        log.debug("radio button activated");
        this.clearTableSort(this.automationsTable);
        if (ae.getSource() == this.sortByNameRadioButton) {
            this.sortByNameRadioButton.setSelected(true);
            this.sortByIdRadioButton.setSelected(false);
            this.automationsModel.setSort(this.automationsModel.SORTBYNAME);
        }
        if (ae.getSource() == this.sortByIdRadioButton) {
            this.sortByNameRadioButton.setSelected(false);
            this.sortByIdRadioButton.setSelected(true);
            this.automationsModel.setSort(this.automationsModel.SORTBYID);
        }
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        log.debug("add automation button activated");
        if (ae.getSource() == this.addButton) {
            new AutomationTableFrame(null);
        }
    }

    @Override
    public void dispose() {
        InstanceManager.getOptionalDefault(JTablePersistenceManager.class).ifPresent(tpm -> tpm.stopPersisting(this.automationsTable));
        this.automationsModel.dispose();
        super.dispose();
    }
}

