/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.automation;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.automation.Automation;
import jmri.jmrit.operations.automation.AutomationCopyAction;
import jmri.jmrit.operations.automation.AutomationItem;
import jmri.jmrit.operations.automation.AutomationManager;
import jmri.jmrit.operations.automation.AutomationResetAction;
import jmri.jmrit.operations.automation.AutomationTableModel;
import jmri.jmrit.operations.automation.Bundle;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.setup.Setup;
import jmri.swing.JTablePersistenceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutomationTableFrame
extends OperationsFrame
implements PropertyChangeListener {
    AutomationTableModel _automationTableModel = new AutomationTableModel();
    JTable _automationTable = new JTable(this._automationTableModel);
    JScrollPane _automationPane;
    AutomationManager automationManager;
    Automation _automation = null;
    AutomationItem _automationItem = null;
    JButton stepActionButton = new JButton(Bundle.getMessage("StepAutomation"));
    JButton runActionButton = new JButton(Bundle.getMessage("RunAutomation"));
    JButton stopActionButton = new JButton(Bundle.getMessage("StopAutomation"));
    JButton resumeActionButton = new JButton(Bundle.getMessage("ResumeAutomation"));
    JButton addActionButton = new JButton(Bundle.getMessage("AddAction"));
    JButton saveAutomationButton = new JButton(Bundle.getMessage("SaveAutomation"));
    JButton deleteAutomationButton = new JButton(Bundle.getMessage("DeleteAutomation"));
    JButton addAutomationButton = new JButton(Bundle.getMessage("AddAutomation"));
    JRadioButton addActionAtTopRadioButton = new JRadioButton(Bundle.getMessage("Top"));
    JRadioButton addActionAtMiddleRadioButton = new JRadioButton(Bundle.getMessage("Middle"));
    JRadioButton addActionAtBottomRadioButton = new JRadioButton(Bundle.getMessage("Bottom"));
    JTextField automationNameTextField = new JTextField(20);
    JTextField commentTextField = new JTextField(35);
    public static final int MAX_NAME_LENGTH = Control.max_len_string_automation_name;
    public static final String NAME = Bundle.getMessage("Name");
    public static final String DISPOSE = "dispose";
    private static final Logger log = LoggerFactory.getLogger(AutomationTableFrame.class);

    public AutomationTableFrame(Automation automation) {
        this._automation = automation;
        this.automationManager = InstanceManager.getDefault(AutomationManager.class);
        this.stepActionButton.setToolTipText(Bundle.getMessage("TipStepAutomation"));
        this.runActionButton.setToolTipText(Bundle.getMessage("TipRunAutomation"));
        this.stopActionButton.setToolTipText(Bundle.getMessage("TipStopAutomation"));
        this.resumeActionButton.setToolTipText(Bundle.getMessage("TipResumeAutomation"));
        this._automationPane = new JScrollPane(this._automationTable);
        this._automationPane.setVerticalScrollBarPolicy(20);
        this._automationTableModel.initTable(this, this._automationTable, automation);
        if (this._automation != null) {
            this.automationNameTextField.setText(this._automation.getName());
            this.commentTextField.setText(this._automation.getComment());
            this.setTitle(Bundle.getMessage("TitleAutomationEdit"));
            this.enableButtons(true);
        } else {
            this.setTitle(Bundle.getMessage("TitleAutomationAdd"));
            this.enableButtons(false);
        }
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 0));
        JScrollPane p1Pane = new JScrollPane(p1);
        p1Pane.setVerticalScrollBarPolicy(21);
        p1Pane.setMinimumSize(new Dimension(300, 3 * this.automationNameTextField.getPreferredSize().height));
        p1Pane.setMaximumSize(new Dimension(2000, 200));
        JPanel pName = new JPanel();
        pName.setLayout(new GridBagLayout());
        pName.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Name")));
        this.addItem(pName, this.automationNameTextField, 0, 0);
        JPanel pComment = new JPanel();
        pComment.setLayout(new GridBagLayout());
        pComment.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Comment")));
        this.addItem(pComment, this.commentTextField, 0, 0);
        p1.add(pName);
        p1.add(pComment);
        JPanel p3 = new JPanel();
        p3.setLayout(new GridBagLayout());
        p3.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("AddItem")));
        p3.setMaximumSize(new Dimension(2000, 200));
        this.addItem(p3, this.addActionButton, 1, 1);
        this.addItem(p3, this.addActionAtTopRadioButton, 2, 1);
        this.addItem(p3, this.addActionAtMiddleRadioButton, 3, 1);
        this.addItem(p3, this.addActionAtBottomRadioButton, 4, 1);
        ButtonGroup group = new ButtonGroup();
        group.add(this.addActionAtTopRadioButton);
        group.add(this.addActionAtMiddleRadioButton);
        group.add(this.addActionAtBottomRadioButton);
        this.addActionAtBottomRadioButton.setSelected(true);
        JPanel pControl = new JPanel();
        pControl.setLayout(new GridBagLayout());
        pControl.setBorder(BorderFactory.createTitledBorder(""));
        pControl.setMaximumSize(new Dimension(2000, 200));
        this.addItem(pControl, this.stepActionButton, 0, 0);
        this.addItem(pControl, this.runActionButton, 1, 0);
        this.addItem(pControl, this.resumeActionButton, 2, 0);
        this.addItem(pControl, this.stopActionButton, 3, 0);
        JPanel pB = new JPanel();
        pB.setLayout(new GridBagLayout());
        pB.setBorder(BorderFactory.createTitledBorder(""));
        pB.setMaximumSize(new Dimension(2000, 200));
        this.addItem(pB, this.deleteAutomationButton, 0, 0);
        this.addItem(pB, this.addAutomationButton, 1, 0);
        this.addItem(pB, this.saveAutomationButton, 3, 0);
        this.getContentPane().add(p1Pane);
        this.getContentPane().add(this._automationPane);
        this.getContentPane().add(p3);
        this.getContentPane().add(pControl);
        this.getContentPane().add(pB);
        this.addButtonAction(this.stepActionButton);
        this.addButtonAction(this.runActionButton);
        this.addButtonAction(this.stopActionButton);
        this.addButtonAction(this.resumeActionButton);
        this.addButtonAction(this.addActionButton);
        this.addButtonAction(this.deleteAutomationButton);
        this.addButtonAction(this.addAutomationButton);
        this.addButtonAction(this.saveAutomationButton);
        if (this._automation != null) {
            this._automation.addPropertyChangeListener(this);
        }
        JMenuBar menuBar = new JMenuBar();
        JMenu toolMenu = new JMenu(Bundle.getMessage("MenuTools"));
        menuBar.add(toolMenu);
        toolMenu.add(new AutomationResetAction(this));
        toolMenu.add(new AutomationCopyAction(automation));
        this.setJMenuBar(menuBar);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_Automation", true);
        this.initMinimumSize(new Dimension(700, 400));
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        Automation automation;
        this.stopCellEditing();
        if (this._automation != null) {
            if (ae.getSource() == this.stepActionButton) {
                this._automation.step();
            }
            if (ae.getSource() == this.runActionButton) {
                this._automation.run();
            }
            if (ae.getSource() == this.stopActionButton) {
                this._automation.stop();
            }
            if (ae.getSource() == this.resumeActionButton) {
                this._automation.resume();
            }
        }
        if (ae.getSource() == this.addActionButton) {
            this.addNewAutomationItem();
        }
        if (ae.getSource() == this.saveAutomationButton) {
            log.debug("automation save button activated");
            automation = this.automationManager.getAutomationByName(this.automationNameTextField.getText());
            if (this._automation == null && automation == null) {
                this.saveNewAutomation();
            } else {
                if (automation != null && automation != this._automation) {
                    this.reportAutomationExists(Bundle.getMessage("save"));
                    return;
                }
                this.saveAutomation();
            }
            if (Setup.isCloseWindowOnSaveEnabled()) {
                this.dispose();
            }
        }
        if (ae.getSource() == this.deleteAutomationButton) {
            log.debug("automation delete button activated");
            if (JOptionPane.showConfirmDialog(this, MessageFormat.format(Bundle.getMessage("DoYouWantToDeleteAutomation"), this.automationNameTextField.getText()), Bundle.getMessage("DeleteAutomation?"), 0) != 0) {
                return;
            }
            automation = this.automationManager.getAutomationByName(this.automationNameTextField.getText());
            if (automation == null) {
                return;
            }
            this.automationManager.deregister(automation);
            this._automation = null;
            this.enableButtons(false);
            OperationsXml.save();
        }
        if (ae.getSource() == this.addAutomationButton) {
            automation = this.automationManager.getAutomationByName(this.automationNameTextField.getText());
            if (automation != null) {
                this.reportAutomationExists(Bundle.getMessage("add"));
                return;
            }
            this.saveNewAutomation();
        }
    }

    private void addNewAutomationItem() {
        if (this.addActionAtTopRadioButton.isSelected()) {
            this._automation.addNewItem(0);
        } else if (this.addActionAtBottomRadioButton.isSelected()) {
            this._automation.addItem();
        } else if (this._automationTable.getSelectedRow() >= 0) {
            int row = this._automationTable.getSelectedRow();
            this._automation.addNewItem(row);
            this._automationTable.getSelectionModel().setSelectionInterval(row, row);
        } else {
            this._automation.addNewItem(this._automation.getSize() / 2);
        }
    }

    private void saveNewAutomation() {
        if (!this.checkName(Bundle.getMessage("add"))) {
            return;
        }
        Automation automation = this.automationManager.newAutomation(this.automationNameTextField.getText());
        this._automationTableModel.initTable(this, this._automationTable, automation);
        this._automation = automation;
        this._automation.addPropertyChangeListener(this);
        this.enableButtons(true);
        this.saveAutomation();
    }

    private void saveAutomation() {
        if (!this.checkName(Bundle.getMessage("save"))) {
            return;
        }
        this._automation.setName(this.automationNameTextField.getText());
        this._automation.setComment(this.commentTextField.getText());
        OperationsXml.save();
    }

    private void stopCellEditing() {
        if (this._automationTable.isEditing()) {
            log.debug("automation table edit true");
            this._automationTable.getCellEditor().stopCellEditing();
        }
    }

    private boolean checkName(String s) {
        if (this.automationNameTextField.getText().trim().isEmpty()) {
            return false;
        }
        if (this.automationNameTextField.getText().length() > MAX_NAME_LENGTH) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("AutomationNameLengthMax"), Integer.toString(MAX_NAME_LENGTH)), MessageFormat.format(Bundle.getMessage("CanNotAutomation"), s), 0);
            return false;
        }
        return true;
    }

    private void reportAutomationExists(String s) {
        log.info("Can not {} automation already exists", (Object)s);
        JOptionPane.showMessageDialog(this, Bundle.getMessage("ReportExists"), MessageFormat.format(Bundle.getMessage("CanNotAutomation"), s), 0);
    }

    private void enableButtons(boolean enabled) {
        this.enableControlButtons(enabled);
        this.addActionButton.setEnabled(enabled);
        this.addActionAtTopRadioButton.setEnabled(enabled);
        this.addActionAtMiddleRadioButton.setEnabled(enabled);
        this.addActionAtBottomRadioButton.setEnabled(enabled);
        this.saveAutomationButton.setEnabled(enabled);
        this.deleteAutomationButton.setEnabled(enabled);
        this._automationTable.setEnabled(enabled);
        this.addAutomationButton.setEnabled(!enabled);
    }

    private void enableControlButtons(boolean enabled) {
        boolean b = enabled && this._automation != null && this._automation.getSize() > 0;
        this.stepActionButton.setEnabled(b && !this._automation.isActionRunning());
        this.runActionButton.setEnabled(b && !this._automation.isRunning());
        this.stopActionButton.setEnabled(b);
        this.resumeActionButton.setEnabled(b && !this._automation.isRunning());
    }

    @Override
    public void dispose() {
        if (this._automation != null) {
            this._automation.removePropertyChangeListener(this);
        }
        InstanceManager.getOptionalDefault(JTablePersistenceManager.class).ifPresent(tpm -> tpm.stopPersisting(this._automationTable));
        this._automationTableModel.dispose();
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        log.debug("Property change: ({}) old: ({}) new: ({})", new Object[]{e.getPropertyName(), e.getOldValue(), e.getNewValue()});
        if (e.getPropertyName().equals("automationListChange") || e.getPropertyName().equals("automationRunningChange") || e.getPropertyName().equals("actionRunning")) {
            this.enableControlButtons(true);
        }
    }
}

