/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.automation;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import jmri.InstanceManager;
import jmri.beans.PropertyChangeSupport;
import jmri.jmrit.operations.automation.Automation;
import jmri.jmrit.operations.automation.AutomationManager;
import jmri.jmrit.operations.automation.Bundle;
import jmri.jmrit.operations.automation.actions.Action;
import jmri.jmrit.operations.automation.actions.ActivateTrainScheduleAction;
import jmri.jmrit.operations.automation.actions.ApplyTrainScheduleAction;
import jmri.jmrit.operations.automation.actions.BuildTrainAction;
import jmri.jmrit.operations.automation.actions.BuildTrainIfSelectedAction;
import jmri.jmrit.operations.automation.actions.DeselectTrainAction;
import jmri.jmrit.operations.automation.actions.GenerateSwitchListAction;
import jmri.jmrit.operations.automation.actions.GenerateSwitchListChangesAction;
import jmri.jmrit.operations.automation.actions.GotoAction;
import jmri.jmrit.operations.automation.actions.GotoFailureAction;
import jmri.jmrit.operations.automation.actions.GotoSuccessAction;
import jmri.jmrit.operations.automation.actions.HaltAction;
import jmri.jmrit.operations.automation.actions.IsTrainEnRouteAction;
import jmri.jmrit.operations.automation.actions.MessageYesNoAction;
import jmri.jmrit.operations.automation.actions.MoveTrainAction;
import jmri.jmrit.operations.automation.actions.NoAction;
import jmri.jmrit.operations.automation.actions.PrintSwitchListAction;
import jmri.jmrit.operations.automation.actions.PrintTrainManifestAction;
import jmri.jmrit.operations.automation.actions.PrintTrainManifestIfSelectedAction;
import jmri.jmrit.operations.automation.actions.ResetTrainAction;
import jmri.jmrit.operations.automation.actions.ResumeAutomationAction;
import jmri.jmrit.operations.automation.actions.RunAutomationAction;
import jmri.jmrit.operations.automation.actions.RunSwitchListAction;
import jmri.jmrit.operations.automation.actions.RunSwitchListChangesAction;
import jmri.jmrit.operations.automation.actions.RunTrainAction;
import jmri.jmrit.operations.automation.actions.SelectTrainAction;
import jmri.jmrit.operations.automation.actions.StopAutomationAction;
import jmri.jmrit.operations.automation.actions.TerminateTrainAction;
import jmri.jmrit.operations.automation.actions.UpdateSwitchListAction;
import jmri.jmrit.operations.automation.actions.WaitSwitchListAction;
import jmri.jmrit.operations.automation.actions.WaitTrainAction;
import jmri.jmrit.operations.automation.actions.WaitTrainTerminatedAction;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.TrainManagerXml;
import jmri.jmrit.operations.trains.schedules.TrainSchedule;
import jmri.jmrit.operations.trains.schedules.TrainScheduleManager;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutomationItem
extends PropertyChangeSupport
implements PropertyChangeListener {
    public static final String NONE = "";
    protected String _id = "";
    protected int _sequenceId = 0;
    protected boolean _actionRunning = false;
    protected boolean _actionSuccessful = false;
    protected boolean _actionRan = false;
    protected boolean _haltFail = true;
    protected Action _action = null;
    protected String _message = "";
    protected String _messageFail = "";
    protected Train _train = null;
    protected RouteLocation _routeLocation = null;
    protected String _automationIdToRun = "";
    protected String _gotoAutomationItemId = "";
    protected boolean _gotoAutomationBranched = false;
    protected String _trainScheduleId = "";
    public static final String DISPOSE = "automationItemDispose";
    private static final Logger log = LoggerFactory.getLogger(AutomationItem.class);

    public AutomationItem(String id) {
        log.debug("New automation item id: {}", (Object)id);
        this._id = id;
        this.setAction(new NoAction());
    }

    public String getId() {
        return this._id;
    }

    public String toString() {
        return this.getId();
    }

    public int getSequenceId() {
        return this._sequenceId;
    }

    public void setSequenceId(int sequence) {
        this._sequenceId = sequence;
    }

    public void setAction(Action action) {
        Action old = this._action;
        this._action = action;
        if (old != null) {
            old.cancelAction();
        }
        if (action != null) {
            action.setAutomationItem(this);
        }
        if (old != action) {
            this.setDirtyAndFirePropertyChange("AutomationItemActionChange", old, action);
        }
    }

    public Action getAction() {
        return this._action;
    }

    public String getActionName() {
        if (this.getAction() != null) {
            return this.getAction().getName();
        }
        return NONE;
    }

    public int getActionCode() {
        if (this.getAction() != null) {
            return this.getAction().getCode();
        }
        return 4;
    }

    public void doAction() {
        if (this.getAction() != null) {
            this.getAction().doAction();
        }
    }

    public void setTrain(Train train) {
        Train old = this._train;
        this._train = train;
        if (old != train) {
            this.setDirtyAndFirePropertyChange("AutomationItemTrainChange", old, train);
            this.setRouteLocation(null);
        }
    }

    public Train getTrain() {
        if (this.getAction() != null && this.getAction().isTrainMenuEnabled()) {
            return this._train;
        }
        return null;
    }

    public void setRouteLocation(RouteLocation rl) {
        RouteLocation old = this._routeLocation;
        this._routeLocation = rl;
        if (old != rl) {
            this.setDirtyAndFirePropertyChange("AutomationItemRouteLocationChange", old, rl);
        }
    }

    public RouteLocation getRouteLocation() {
        if (this.getAction() != null && this.getAction().isRouteMenuEnabled()) {
            return this._routeLocation;
        }
        return null;
    }

    public void setOther(Object other) {
        if (other != null && other.getClass().equals(Automation.class)) {
            this.setAutomationToRun((Automation)other);
        } else if (other != null && other.getClass().equals(AutomationItem.class)) {
            this.setGotoAutomationItem((AutomationItem)other);
        } else if (other == null || other.getClass().equals(TrainSchedule.class)) {
            this.setTrainSchedule((TrainSchedule)other);
        }
    }

    public void setAutomationToRun(Automation automation) {
        Automation old = InstanceManager.getDefault(AutomationManager.class).getAutomationById(this._automationIdToRun);
        this._automationIdToRun = automation != null ? automation.getId() : NONE;
        if (old != automation) {
            this.setDirtyAndFirePropertyChange("AutomationItemAutomationChange", old, automation);
        }
    }

    public Automation getAutomationToRun() {
        if (this.getAction() != null && this.getAction().isAutomationMenuEnabled()) {
            return InstanceManager.getDefault(AutomationManager.class).getAutomationById(this._automationIdToRun);
        }
        return null;
    }

    public void setGotoAutomationItem(AutomationItem automationItem) {
        AutomationItem oldItem = null;
        if (automationItem != null) {
            Automation automation = InstanceManager.getDefault(AutomationManager.class).getAutomationById(automationItem.getId().split("c")[0]);
            oldItem = automation.getItemById(this._gotoAutomationItemId);
            this._gotoAutomationItemId = automationItem.getId();
        } else {
            this._gotoAutomationItemId = NONE;
        }
        if (oldItem != automationItem) {
            this.setDirtyAndFirePropertyChange("AutomationItemAutomationChange", oldItem, automationItem);
        }
    }

    public AutomationItem getGotoAutomationItem() {
        Automation automation;
        if (this.getAction() != null && this.getAction().isGotoMenuEnabled() && (automation = InstanceManager.getDefault(AutomationManager.class).getAutomationById(this._gotoAutomationItemId.split("c")[0])) != null) {
            return automation.getItemById(this._gotoAutomationItemId);
        }
        return null;
    }

    public void setGotoBranched(boolean branched) {
        this._gotoAutomationBranched = branched;
    }

    public boolean isGotoBranched() {
        return this._gotoAutomationBranched;
    }

    public void setTrainSchedule(TrainSchedule trainSchedule) {
        String old = this._trainScheduleId;
        this._trainScheduleId = trainSchedule != null ? trainSchedule.getId() : NONE;
        if (!old.equals(this._trainScheduleId)) {
            this.setDirtyAndFirePropertyChange("AutomationItemTrainScheduleChange", old, this._trainScheduleId);
        }
    }

    public TrainSchedule getTrainSchedule() {
        if (this.getAction() != null && this.getAction().isOtherMenuEnabled()) {
            return InstanceManager.getDefault(TrainScheduleManager.class).getScheduleById(this._trainScheduleId);
        }
        return null;
    }

    public String getTrainScheduleId() {
        return this._trainScheduleId;
    }

    public void setMessage(String message) {
        String old = this._message;
        this._message = message;
        if (!old.equals(message)) {
            this.setDirtyAndFirePropertyChange("AutomationItemMessageChange", old, message);
        }
    }

    public String getMessage() {
        return this._message;
    }

    public void setMessageFail(String message) {
        String old = this._messageFail;
        this._messageFail = message;
        if (!old.equals(message)) {
            this.setDirtyAndFirePropertyChange("AutomationItemMessageFailChange", old, message);
        }
    }

    public String getMessageFail() {
        return this._messageFail;
    }

    public boolean isHaltFailureEnabled() {
        return this._haltFail;
    }

    public void setHaltFailureEnabled(boolean enable) {
        boolean old = this._haltFail;
        this._haltFail = enable;
        if (old != enable) {
            this.setDirtyAndFirePropertyChange("AutomationItemHaltFailureChange", old, enable);
        }
    }

    public void setActionRunning(boolean actionRunning) {
        boolean old = this._actionRunning;
        this._actionRunning = actionRunning;
        if (old != actionRunning) {
            if (!actionRunning) {
                this.setActionRan(true);
            }
            this.firePropertyChange("actionRunningChange", old, actionRunning);
        }
    }

    public boolean isActionRunning() {
        return this._actionRunning;
    }

    public void setActionSuccessful(boolean successful) {
        boolean old = this._actionSuccessful;
        this._actionSuccessful = successful;
        if (old != successful) {
            this.setDirtyAndFirePropertyChange("actionSuccessful", old, successful);
        }
    }

    public void setActionRan(boolean ran) {
        this._actionRan = ran;
        this.firePropertyChange("actionRan", !ran, ran);
    }

    public boolean isActionRan() {
        return this._actionRan;
    }

    public boolean isActionSuccessful() {
        return this._actionSuccessful;
    }

    public String getStatus() {
        if (this.isActionRunning()) {
            return Bundle.getMessage("Running");
        }
        if (!this.isActionRan()) {
            return NONE;
        }
        if (this.getAction() != null) {
            return this.isActionSuccessful() ? this.getAction().getActionSuccessfulString() : this.getAction().getActionFailedString();
        }
        return "unknown";
    }

    public void reset() {
        this.setActionRan(false);
        this.setActionSuccessful(false);
        this.setGotoBranched(false);
    }

    public void copyItem(AutomationItem item) {
        this.setAction(AutomationItem.getActionByCode(item.getActionCode()));
        this.setAutomationToRun(item.getAutomationToRun());
        this.setGotoAutomationItem(item.getGotoAutomationItem());
        this.setTrain(item.getTrain());
        this.setRouteLocation(item.getRouteLocation());
        this.setSequenceId(item.getSequenceId());
        this.setTrainSchedule(item.getTrainSchedule());
        this.setMessage(item.getMessage());
        this.setMessageFail(item.getMessageFail());
        this.setHaltFailureEnabled(item.isHaltFailureEnabled());
    }

    public static Action getActionByCode(int code) {
        for (Action action : AutomationItem.getActionList()) {
            if (action.getCode() != code) continue;
            return action;
        }
        return new NoAction();
    }

    public static List<Action> getActionList() {
        ArrayList<Action> list = new ArrayList<Action>();
        list.add(new NoAction());
        list.add(new BuildTrainAction());
        list.add(new BuildTrainIfSelectedAction());
        list.add(new PrintTrainManifestAction());
        list.add(new PrintTrainManifestIfSelectedAction());
        list.add(new RunTrainAction());
        list.add(new MoveTrainAction());
        list.add(new TerminateTrainAction());
        list.add(new ResetTrainAction());
        list.add(new IsTrainEnRouteAction());
        list.add(new WaitTrainAction());
        list.add(new WaitTrainTerminatedAction());
        list.add(new ActivateTrainScheduleAction());
        list.add(new ApplyTrainScheduleAction());
        list.add(new SelectTrainAction());
        list.add(new DeselectTrainAction());
        list.add(new PrintSwitchListAction());
        list.add(new UpdateSwitchListAction());
        list.add(new WaitSwitchListAction());
        list.add(new GenerateSwitchListAction());
        list.add(new GenerateSwitchListChangesAction());
        list.add(new RunSwitchListAction());
        list.add(new RunSwitchListChangesAction());
        list.add(new RunAutomationAction());
        list.add(new ResumeAutomationAction());
        list.add(new StopAutomationAction());
        list.add(new MessageYesNoAction());
        list.add(new GotoAction());
        list.add(new GotoSuccessAction());
        list.add(new GotoFailureAction());
        list.add(new HaltAction());
        return list;
    }

    public static JComboBox<Action> getActionComboBox() {
        JComboBox<Action> box = new JComboBox<Action>();
        for (Action action : AutomationItem.getActionList()) {
            box.addItem(action);
        }
        return box;
    }

    public void dispose() {
        this.setDirtyAndFirePropertyChange(DISPOSE, null, DISPOSE);
    }

    public AutomationItem(Element e) {
        Element eMessages;
        Attribute a = e.getAttribute("id");
        if (a != null) {
            this._id = a.getValue();
        } else {
            log.warn("no id attribute in Automation Item element when reading operations");
        }
        a = e.getAttribute("sequenceId");
        if (a != null) {
            this._sequenceId = Integer.parseInt(a.getValue());
        }
        if ((a = e.getAttribute("actionCode")) != null) {
            this.setAction(AutomationItem.getActionByCode(Integer.decode(a.getValue())));
        }
        if ((a = e.getAttribute("haltFail")) != null) {
            this._haltFail = a.getValue().equals("true");
        }
        if ((a = e.getAttribute("actionRan")) != null) {
            this._actionRan = a.getValue().equals("true");
        }
        if ((a = e.getAttribute("actionSuccessful")) != null) {
            this._actionSuccessful = a.getValue().equals("true");
        }
        if ((a = e.getAttribute("trainId")) != null) {
            this._train = InstanceManager.getDefault(TrainManager.class).getTrainById(a.getValue());
        }
        if ((a = e.getAttribute("routeLocationId")) != null && this.getTrain() != null) {
            this._routeLocation = this.getTrain().getRoute().getLocationById(a.getValue());
        }
        if ((a = e.getAttribute("automationId")) != null) {
            this._automationIdToRun = a.getValue();
        }
        if ((a = e.getAttribute("gotoAutomationId")) != null) {
            this._gotoAutomationItemId = a.getValue();
        }
        if ((a = e.getAttribute("gotoBranched")) != null) {
            this._gotoAutomationBranched = a.getValue().equals("true");
        }
        if ((a = e.getAttribute("trainScheduleId")) != null) {
            this._trainScheduleId = a.getValue();
        }
        if ((eMessages = e.getChild("messages")) != null) {
            Element eMessageFail;
            Element eMessageOk = eMessages.getChild("messageOk");
            if (eMessageOk != null && (a = eMessageOk.getAttribute("message")) != null) {
                this._message = a.getValue();
            }
            if ((eMessageFail = eMessages.getChild("messageFail")) != null && (a = eMessageFail.getAttribute("message")) != null) {
                this._messageFail = a.getValue();
            }
        }
    }

    public Element store() {
        Element e = new Element("item");
        e.setAttribute("id", this.getId());
        e.setAttribute("sequenceId", Integer.toString(this.getSequenceId()));
        e.setAttribute("name", this.getActionName());
        e.setAttribute("actionCode", "0x" + Integer.toHexString(this.getActionCode()));
        e.setAttribute("haltFail", this.isHaltFailureEnabled() ? "true" : "false");
        e.setAttribute("actionRan", this.isActionRan() ? "true" : "false");
        e.setAttribute("actionSuccessful", this.isActionSuccessful() ? "true" : "false");
        if (this.getTrain() != null) {
            e.setAttribute("trainId", this.getTrain().getId());
            if (this.getRouteLocation() != null) {
                e.setAttribute("routeLocationId", this.getRouteLocation().getId());
            }
        }
        if (this.getAutomationToRun() != null) {
            e.setAttribute("automationId", this.getAutomationToRun().getId());
        }
        if (this.getGotoAutomationItem() != null) {
            e.setAttribute("gotoAutomationId", this.getGotoAutomationItem().getId());
            e.setAttribute("gotoBranched", this.isGotoBranched() ? "true" : "false");
        }
        if (this.getTrainSchedule() != null) {
            e.setAttribute("trainScheduleId", this.getTrainSchedule().getId());
        }
        if (!this.getMessage().equals(NONE) || !this.getMessageFail().equals(NONE)) {
            Element eMessages = new Element("messages");
            e.addContent((Content)eMessages);
            Element eMessageOk = new Element("messageOk");
            eMessageOk.setAttribute("message", this.getMessage());
            Element eMessageFail = new Element("messageFail");
            eMessageFail.setAttribute("message", this.getMessageFail());
            eMessages.addContent((Content)eMessageOk);
            eMessages.addContent((Content)eMessageFail);
        }
        return e;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
    }

    protected void setDirtyAndFirePropertyChange(String p, Object old, Object n) {
        InstanceManager.getDefault(TrainManagerXml.class).setDirty(true);
        this.firePropertyChange(p, old, n);
    }
}

