/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.automation;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.automation.Automation;
import jmri.jmrit.operations.automation.AutomationManager;
import jmri.jmrit.operations.automation.AutomationTableFrame;
import jmri.jmrit.operations.automation.Bundle;
import jmri.jmrit.operations.setup.Control;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutomationCopyFrame
extends OperationsFrame {
    AutomationManager automationManager = InstanceManager.getDefault(AutomationManager.class);
    JTextField automationNameTextField = new JTextField(Control.max_len_string_automation_name);
    JButton copyButton = new JButton(Bundle.getMessage("ButtonCopy"));
    JComboBox<Automation> automationBox = InstanceManager.getDefault(AutomationManager.class).getComboBox();
    private static final Logger log = LoggerFactory.getLogger(AutomationCopyFrame.class);

    public AutomationCopyFrame(Automation automation) {
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel pName = new JPanel();
        pName.setLayout(new GridBagLayout());
        pName.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Name")));
        this.addItem(pName, this.automationNameTextField, 0, 0);
        JPanel pCopy = new JPanel();
        pCopy.setLayout(new GridBagLayout());
        pCopy.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("SelectAutomation")));
        this.addItem(pCopy, this.automationBox, 0, 0);
        this.automationBox.setSelectedItem(automation);
        JPanel pButton = new JPanel();
        pButton.add(this.copyButton);
        this.getContentPane().add(pName);
        this.getContentPane().add(pCopy);
        this.getContentPane().add(pButton);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_CopyAutomation", true);
        this.pack();
        this.setMinimumSize(new Dimension(400, 200));
        this.setTitle(Bundle.getMessage("TitleAutomationCopy"));
        this.addButtonAction(this.copyButton);
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.copyButton) {
            log.debug("copy automation button activated");
            if (!this.checkName()) {
                return;
            }
            Automation newAutomation = this.automationManager.getAutomationByName(this.automationNameTextField.getText());
            if (newAutomation != null) {
                this.reportAutomationExists();
                return;
            }
            if (this.automationBox.getSelectedItem() == null) {
                this.reportAutomationDoesNotExist();
                return;
            }
            Automation oldAutomation = (Automation)this.automationBox.getSelectedItem();
            if (oldAutomation == null) {
                this.reportAutomationDoesNotExist();
                return;
            }
            newAutomation = this.automationManager.copyAutomation(oldAutomation, this.automationNameTextField.getText());
            new AutomationTableFrame(newAutomation);
        }
    }

    private void reportAutomationExists() {
        JOptionPane.showMessageDialog(this, Bundle.getMessage("ReportExists"), Bundle.getMessage("CanNotCopyAutomation"), 0);
    }

    private void reportAutomationDoesNotExist() {
        JOptionPane.showMessageDialog(this, Bundle.getMessage("SelectAutomation"), Bundle.getMessage("CanNotCopyAutomation"), 0);
    }

    private boolean checkName() {
        if (this.automationNameTextField.getText().trim().isEmpty()) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("EnterAutomationName"), Bundle.getMessage("CanNotCopyAutomation"), 0);
            return false;
        }
        if (this.automationNameTextField.getText().length() > Control.max_len_string_automation_name) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("AutomationNameLengthMax"), Control.max_len_string_automation_name), Bundle.getMessage("CanNotCopyAutomation"), 0);
            return false;
        }
        return true;
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}

