/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import jmri.InstanceManager;
import jmri.jmrit.XmlFile;
import jmri.jmrit.operations.locations.LocationManagerXml;
import jmri.jmrit.operations.rollingstock.cars.CarManagerXml;
import jmri.jmrit.operations.rollingstock.engines.EngineManagerXml;
import jmri.jmrit.operations.routes.RouteManagerXml;
import jmri.jmrit.operations.setup.OperationsSetupXml;
import jmri.jmrit.operations.trains.TrainManagerXml;
import jmri.util.FileUtil;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OperationsXml
extends XmlFile {
    private boolean dirty = false;
    private static String operationsDirectoryName = "operations";
    private String operationsFileName = "DefaultOperations.xml";
    private static String fileLocation = FileUtil.getUserFilesPath();
    private static final Logger log = LoggerFactory.getLogger(OperationsXml.class);

    public void writeOperationsFile() {
        this.createFile(this.getDefaultOperationsFilename(), true);
        try {
            this.writeFile(this.getDefaultOperationsFilename());
        }
        catch (IOException e) {
            log.error("Exception while writing operation file, may not be complete: {}", (Object)e.getMessage());
        }
    }

    protected void load() {
        try {
            this.readFile(this.getDefaultOperationsFilename());
        }
        catch (IOException | JDOMException e) {
            log.error("Exception during operations file reading", e);
        }
    }

    protected File createFile(String fullPathName, boolean backupFile) {
        if (backupFile) {
            this.makeBackupFile(fullPathName);
        }
        File file = null;
        try {
            if (!this.checkFile(fullPathName)) {
                file = new File(fullPathName);
                File parentDir = file.getParentFile();
                if (!parentDir.exists() && !parentDir.mkdir()) {
                    log.error("Directory wasn't created");
                }
                if (file.createNewFile()) {
                    log.debug("File created {}", (Object)fullPathName);
                }
            } else {
                file = new File(fullPathName);
            }
        }
        catch (IOException e) {
            log.error("Exception while creating operations file, may not be complete: {}", (Object)e.getMessage());
        }
        return file;
    }

    protected void writeFile(String filename) throws FileNotFoundException, IOException {
        log.error("writeFile not overridden");
    }

    public abstract void readFile(String var1) throws JDOMException, IOException;

    public void setDirty(boolean b) {
        this.dirty = b;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void writeFileIfDirty() {
        if (this.isDirty()) {
            this.writeOperationsFile();
        }
    }

    public String getDefaultOperationsFilename() {
        return String.valueOf(OperationsXml.getFileLocation()) + OperationsXml.getOperationsDirectoryName() + File.separator + this.getOperationsFileName();
    }

    public static void setOperationsDirectoryName(String name) {
        operationsDirectoryName = name;
    }

    public static String getOperationsDirectoryName() {
        return operationsDirectoryName;
    }

    public void setOperationsFileName(String name) {
        this.operationsFileName = name;
    }

    public String getOperationsFileName() {
        return this.operationsFileName;
    }

    public static String getFileLocation() {
        return fileLocation;
    }

    public static void setFileLocation(String location) {
        fileLocation = location;
    }

    public static boolean checkFileName(String name) {
        return !name.contains(".") && !name.contains("<") && !name.contains(">") && !name.contains(":") && !name.contains("\"") && !name.contains("\\") && !name.contains("/") && !name.contains("|") && !name.contains("?") && !name.contains("*");
    }

    public static void save() {
        InstanceManager.getDefault(OperationsSetupXml.class).writeFileIfDirty();
        InstanceManager.getDefault(LocationManagerXml.class).writeFileIfDirty();
        InstanceManager.getDefault(RouteManagerXml.class).writeFileIfDirty();
        InstanceManager.getDefault(CarManagerXml.class).writeFileIfDirty();
        InstanceManager.getDefault(EngineManagerXml.class).writeFileIfDirty();
        InstanceManager.getDefault(TrainManagerXml.class).writeFileIfDirty();
    }

    public static boolean areFilesDirty() {
        return InstanceManager.getDefault(OperationsSetupXml.class).isDirty() || InstanceManager.getDefault(LocationManagerXml.class).isDirty() || InstanceManager.getDefault(RouteManagerXml.class).isDirty() || InstanceManager.getDefault(CarManagerXml.class).isDirty() || InstanceManager.getDefault(EngineManagerXml.class).isDirty() || InstanceManager.getDefault(TrainManagerXml.class).isDirty();
    }
}

