/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import jmri.InstanceManager;
import jmri.jmrit.operations.Bundle;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.trains.TrainCommon;
import jmri.swing.JTablePersistenceManager;
import jmri.util.JmriJFrame;
import jmri.util.swing.SplitButtonColorChooserPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationsPanel
extends JPanel {
    public static final String NEW_LINE = "\n";
    public static final String NONE = "";
    private static final int MIN_CHECKBOXES = 5;
    private static final int MAX_CHECKBOXES = 11;
    private static final Logger log = LoggerFactory.getLogger(OperationsPanel.class);

    public void dispose() {
    }

    protected void addItem(JComponent c, int x, int y) {
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = x;
        gc.gridy = y;
        gc.weightx = 100.0;
        gc.weighty = 100.0;
        this.add((Component)c, gc);
    }

    protected void addItem(JPanel p, JComponent c, int x, int y) {
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = x;
        gc.gridy = y;
        gc.weightx = 100.0;
        gc.weighty = 100.0;
        p.add((Component)c, gc);
    }

    protected void addItemLeft(JPanel p, JComponent c, int x, int y) {
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = x;
        gc.gridy = y;
        gc.weightx = 100.0;
        gc.weighty = 100.0;
        gc.anchor = 17;
        p.add((Component)c, gc);
    }

    protected void addItemTop(JPanel p, JComponent c, int x, int y) {
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = x;
        gc.gridy = y;
        gc.weightx = 100.0;
        gc.weighty = 100.0;
        gc.anchor = 11;
        p.add((Component)c, gc);
    }

    protected void addItemWidth(JPanel p, JComponent c, int width, int x, int y) {
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = x;
        gc.gridy = y;
        gc.gridwidth = width;
        gc.weightx = 100.0;
        gc.weighty = 100.0;
        gc.anchor = 17;
        p.add((Component)c, gc);
    }

    protected int getNumberOfCheckboxesPerLine(Dimension size) {
        if (size == null) {
            return 5;
        }
        StringBuilder padding = new StringBuilder("X");
        int i = 0;
        while (i < InstanceManager.getDefault(CarTypes.class).getMaxFullNameLength()) {
            padding.append("X");
            ++i;
        }
        JCheckBox box = new JCheckBox(padding.toString());
        int number = size.width / box.getPreferredSize().width;
        if (number < 5) {
            number = 5;
        }
        if (number > 11) {
            number = 11;
        }
        return number;
    }

    protected void addButtonAction(JButton b) {
        b.addActionListener(e -> this.buttonActionPerformed(e));
    }

    protected void buttonActionPerformed(ActionEvent ae) {
        log.debug("button action not overridden");
    }

    protected void addRadioButtonAction(JRadioButton b) {
        b.addActionListener(e -> this.radioButtonActionPerformed(e));
    }

    protected void radioButtonActionPerformed(ActionEvent ae) {
        log.debug("radio button action not overridden");
    }

    protected void addCheckBoxAction(JCheckBox b) {
        b.addActionListener(e -> this.checkBoxActionPerformed(e));
    }

    protected void checkBoxActionPerformed(ActionEvent ae) {
        log.debug("check box action not overridden");
    }

    protected void addSpinnerChangeListerner(JSpinner s) {
        s.addChangeListener(e -> this.spinnerChangeEvent(e));
    }

    protected void spinnerChangeEvent(ChangeEvent ae) {
        log.debug("spinner action not overridden");
    }

    protected void addComboBoxAction(JComboBox<?> b) {
        b.addActionListener(e -> this.comboBoxActionPerformed(e));
    }

    protected void comboBoxActionPerformed(ActionEvent ae) {
        log.debug("combobox action not overridden");
    }

    protected void selectNextItemComboBox(JComboBox<?> b) {
        int newIndex = b.getSelectedIndex() + 1;
        if (newIndex < b.getItemCount()) {
            b.setSelectedIndex(newIndex);
        }
    }

    protected void adjustTextAreaColumnWidth(JScrollPane scrollPane, JTextArea textArea, Dimension size) {
        int width = size.width;
        FontMetrics metrics = this.getFontMetrics(textArea.getFont());
        int columnWidth = metrics.charWidth('m');
        int columns = width / columnWidth * 90 / 100;
        if (columns > textArea.getColumns()) {
            log.debug("Increasing text area character width to {} columns", (Object)columns);
            textArea.setColumns(columns);
        }
        scrollPane.setMinimumSize(new Dimension(width * 95 / 100, 60));
    }

    public void loadTableDetails(JTable table) {
        OperationsPanel.loadTableDetails(table, this.getWindowFrameRef());
        OperationsPanel.persist(table);
    }

    public static void loadTableDetails(JTable table, String name) {
        if (table.getRowSorter() == null) {
            TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(table.getModel());
            table.setRowSorter(sorter);
            int i = 0;
            while (i < table.getColumnCount()) {
                if (table.getColumnClass(i) != String.class && table.getColumnClass(i) != Integer.class && table.getColumnClass(i) != Boolean.class) {
                    sorter.setSortable(i, false);
                }
                ++i;
            }
        }
        table.setRowHeight(new JComboBox<E>().getPreferredSize().height);
        table.setAutoResizeMode(0);
        table.setIntercellSpacing(new Dimension(3, 1));
        table.setName(String.valueOf(name) + ":table");
        Optional<JTablePersistenceManager> manager = InstanceManager.getOptionalDefault(JTablePersistenceManager.class);
        if (manager.isPresent()) {
            manager.get().resetState(table);
        }
    }

    public static void persist(JTable table) {
        Optional<JTablePersistenceManager> manager = InstanceManager.getOptionalDefault(JTablePersistenceManager.class);
        if (manager.isPresent()) {
            manager.get().persist(table);
        }
    }

    public static void cacheState(JTable table) {
        Optional<JTablePersistenceManager> manager = InstanceManager.getOptionalDefault(JTablePersistenceManager.class);
        if (manager.isPresent()) {
            manager.get().cacheState(table);
        }
    }

    public static void saveTableState() {
        Optional<JTablePersistenceManager> manager = InstanceManager.getOptionalDefault(JTablePersistenceManager.class);
        if (manager.isPresent()) {
            manager.get().setPaused(false);
        }
    }

    protected void clearTableSort(JTable table) {
        if (table.getRowSorter() != null) {
            table.getRowSorter().setSortKeys(null);
        }
    }

    protected void storeValues() {
        OperationsXml.save();
    }

    protected void addHorizontalScrollBarKludgeFix(JScrollPane pane, JPanel panel) {
        JPanel pad = new JPanel();
        pad.add(new JLabel(" "));
        panel.add(pad);
        pane.setMinimumSize(new Dimension(500, 130));
        pane.setMaximumSize(new Dimension(2000, 170));
        pane.setVerticalScrollBarPolicy(21);
    }

    protected String getWindowFrameRef() {
        Container c = this.getTopLevelAncestor();
        if (c instanceof JmriJFrame) {
            return ((JmriJFrame)c).getWindowFrameRef();
        }
        return null;
    }

    public static JPanel getColorChooserPanel(String text, JColorChooser chooser) {
        return OperationsPanel.getColorChooserPanel(Bundle.getMessage("TextColor"), TrainCommon.getTextColor(text), chooser);
    }

    public static JPanel getColorChooserPanel(String title, Color color, JColorChooser chooser) {
        JPanel pTextColorPanel = new JPanel();
        pTextColorPanel.setBorder(BorderFactory.createTitledBorder(title));
        chooser.setColor(color);
        AbstractColorChooserPanel[] commentColorPanels = new AbstractColorChooserPanel[]{new SplitButtonColorChooserPanel()};
        chooser.setChooserPanels(commentColorPanels);
        chooser.setPreviewPanel(new JPanel());
        pTextColorPanel.add(chooser);
        return pTextColorPanel;
    }

    public static void loadFontSizeComboBox(JComboBox<Integer> box) {
        int i = 7;
        while (i < 19) {
            box.addItem(i);
            ++i;
        }
        Dimension size = box.getPreferredSize();
        size = new Dimension(size.width + 10, size.height);
        box.setPreferredSize(size);
    }
}

