/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations;

import java.io.File;
import java.io.IOException;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.InstanceManagerAutoInitialize;
import jmri.ShutDownManager;
import jmri.ShutDownTask;
import jmri.implementation.AbstractShutDownTask;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.schedules.ScheduleManager;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.rollingstock.engines.EngineManager;
import jmri.jmrit.operations.routes.RouteManager;
import jmri.jmrit.operations.setup.AutoBackup;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.schedules.TrainScheduleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OperationsManager
implements InstanceManagerAutoDefault,
InstanceManagerAutoInitialize {
    private ShutDownTask shutDownTask = null;
    private static final Logger log = LoggerFactory.getLogger(OperationsManager.class);

    public String getPath() {
        return String.valueOf(OperationsXml.getFileLocation()) + OperationsXml.getOperationsDirectoryName() + File.separator;
    }

    public String getPath(String name) {
        if (name != null) {
            return String.valueOf(this.getPath()) + name;
        }
        return this.getPath();
    }

    public File getFile(String name) {
        return new File(this.getPath(name));
    }

    public void setShutDownTask(ShutDownTask shutDownTask) {
        ShutDownManager manager = InstanceManager.getDefault(ShutDownManager.class);
        if (this.shutDownTask != null) {
            manager.deregister(this.shutDownTask);
        }
        this.shutDownTask = shutDownTask;
        if (this.shutDownTask != null) {
            manager.register(this.shutDownTask);
        }
    }

    public static ShutDownTask getDefaultShutDownTask() {
        return new AbstractShutDownTask("Save Operations State"){

            @Override
            public void run() {
                try {
                    OperationsXml.save();
                }
                catch (Exception ex) {
                    log.warn("Error saving operations state: {}", (Object)ex.getMessage());
                    log.debug("Details follow: ", (Throwable)ex);
                }
            }
        };
    }

    @Override
    public void initialize() {
        InstanceManager.getDefault(CarManager.class);
        InstanceManager.getDefault(EngineManager.class);
        InstanceManager.getDefault(TrainManager.class);
        InstanceManager.getDefault(LocationManager.class);
        InstanceManager.getDefault(RouteManager.class);
        InstanceManager.getDefault(ScheduleManager.class);
        InstanceManager.getDefault(TrainScheduleManager.class);
        this.setShutDownTask(OperationsManager.getDefaultShutDownTask());
        if (Setup.isAutoBackupEnabled()) {
            try {
                AutoBackup backup = new AutoBackup();
                backup.autoBackup();
            }
            catch (IOException ex) {
                log.debug("Auto backup after enabling Auto Backup flag.", (Throwable)ex);
            }
        }
    }
}

