/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.mailreport;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.configurexml.LoadXmlUserAction;
import jmri.jmrit.mailreport.ReportContext;
import jmri.profile.Profile;
import jmri.profile.ProfileManager;
import jmri.util.MultipartMessage;
import jmri.util.javaworld.GridLayout2;
import jmri.util.problemreport.LogProblemReportProvider;
import jmri.util.startup.PerformFileModel;
import jmri.util.startup.StartupActionsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportPanel
extends JPanel {
    JButton sendButton;
    JTextField emailField = new JTextField(40);
    JTextField summaryField = new JTextField(40);
    JTextArea descField = new JTextArea(8, 40);
    JCheckBox checkContext;
    JCheckBox checkNetwork;
    JCheckBox checkLog;
    JCheckBox checkPanel;
    JCheckBox checkProfile;
    JCheckBox checkCopy;
    String[] profDirs = new String[]{"networkservices", "profile", "programmers", "throttle"};
    public static String requestURL = "http://jmri.org/problem-report.php";
    private static final Logger log = LoggerFactory.getLogger(ReportPanel.class);

    public ReportPanel() {
        ResourceBundle rb = ResourceBundle.getBundle("jmri.jmrit.mailreport.ReportBundle");
        this.setLayout(new BoxLayout(this, 1));
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout());
        p1.add(new JLabel(rb.getString("LabelTop")));
        this.add(p1);
        p1 = new JPanel();
        p1.setLayout(new GridLayout2(3, 2));
        this.add(p1);
        JLabel l = new JLabel(rb.getString("LabelEmail"));
        l.setToolTipText(rb.getString("TooltipEmail"));
        p1.add(l);
        this.emailField.setToolTipText(rb.getString("TooltipEmail"));
        p1.add(this.emailField);
        l = new JLabel(rb.getString("LabelSummary"));
        l.setToolTipText(rb.getString("TooltipSummary"));
        p1.add(l);
        this.summaryField.setToolTipText(rb.getString("TooltipSummary"));
        p1.add(this.summaryField);
        l = new JLabel(rb.getString("LabelDescription"));
        p1.add(l);
        this.descField.setFont(this.summaryField.getFont());
        this.descField.setBorder(this.summaryField.getBorder());
        this.descField.setLineWrap(true);
        this.descField.setWrapStyleWord(true);
        p1.add(this.descField);
        p1 = new JPanel();
        p1.setLayout(new FlowLayout());
        this.checkContext = new JCheckBox(rb.getString("CheckContext"));
        this.checkContext.setSelected(true);
        this.checkContext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportPanel.this.checkNetwork.setEnabled(ReportPanel.this.checkContext.isSelected());
            }
        });
        p1.add(this.checkContext);
        this.checkNetwork = new JCheckBox(rb.getString("CheckNetwork"));
        this.checkNetwork.setSelected(true);
        p1.add(this.checkNetwork);
        this.checkLog = new JCheckBox(rb.getString("CheckLog"));
        this.checkLog.setSelected(true);
        p1.add(this.checkLog);
        this.add(p1);
        p1 = new JPanel();
        p1.setLayout(new FlowLayout());
        this.checkPanel = new JCheckBox(rb.getString("CheckPanel"));
        this.checkPanel.setSelected(true);
        p1.add(this.checkPanel);
        this.checkProfile = new JCheckBox(rb.getString("CheckProfile"));
        this.checkProfile.setSelected(true);
        p1.add(this.checkProfile);
        this.checkCopy = new JCheckBox(rb.getString("CheckCopy"));
        this.checkCopy.setSelected(true);
        p1.add(this.checkCopy);
        this.add(p1);
        this.sendButton = new JButton(rb.getString("ButtonSend"));
        this.sendButton.setToolTipText(rb.getString("TooltipSend"));
        this.sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportPanel.this.sendButtonActionPerformed(e);
            }
        });
        this.add(this.sendButton);
    }

    public void sendButtonActionPerformed(ActionEvent e) {
        ResourceBundle rb = ResourceBundle.getBundle("jmri.jmrit.mailreport.ReportBundle");
        try {
            this.sendButton.setEnabled(false);
            log.debug("initial checks");
            InternetAddress email = new InternetAddress(this.emailField.getText());
            email.validate();
            log.debug("start send");
            MultipartMessage msg = new MultipartMessage(requestURL, StandardCharsets.UTF_8.name());
            log.debug("start creating message");
            msg.addFormField("reporter", this.emailField.getText());
            msg.addFormField("sendcopy", this.checkCopy.isSelected() ? "yes" : "no");
            msg.addFormField("summary", this.summaryField.getText());
            String report = String.valueOf(this.descField.getText()) + "\r\n";
            if (this.checkContext.isSelected()) {
                report = String.valueOf(report) + "=========================================================\r\n";
                report = String.valueOf(report) + new ReportContext().getReport(this.checkNetwork.isSelected() && this.checkNetwork.isEnabled());
            }
            msg.addFormField("problem", report);
            log.debug("start adding attachments");
            if (this.checkPanel.isSelected()) {
                log.debug("prepare panel attachment");
                for (PerformFileModel m : InstanceManager.getDefault(StartupActionsManager.class).getActions(PerformFileModel.class)) {
                    String fn = m.getFileName();
                    File f = new File(fn);
                    log.info("Add panel file loaded at startup: {}", (Object)f);
                    msg.addFilePart("logfileupload[]", f);
                }
                File file = LoadXmlUserAction.getCurrentFile();
                if (file != null) {
                    log.info("Adding manually-loaded panel file: {}", (Object)file.getPath());
                    msg.addFilePart("logfileupload[]", LoadXmlUserAction.getCurrentFile());
                } else {
                    log.debug("No panel file manually loaded");
                }
            }
            if (this.checkProfile.isSelected()) {
                log.debug("prepare profile attachment");
                Profile profile = ProfileManager.getDefault().getActiveProfile();
                if (profile != null) {
                    File file = profile.getPath();
                    if (file != null) {
                        log.debug("add profile: {}", (Object)file.getPath());
                        File temp = File.createTempFile("profile", ".zip");
                        temp.deleteOnExit();
                        FileOutputStream out = new FileOutputStream(temp);
                        ZipOutputStream zip = new ZipOutputStream(out);
                        this.addDirectory(zip, file);
                        zip.close();
                        out.close();
                        msg.addFilePart("logfileupload[]", temp);
                    }
                } else {
                    log.warn("No profile loaded - not sending");
                }
            }
            if (this.checkLog.isSelected()) {
                log.debug("prepare log attachments");
                ServiceLoader<LogProblemReportProvider> loggers = ServiceLoader.load(LogProblemReportProvider.class);
                for (LogProblemReportProvider provider : loggers) {
                    File[] fileArray = provider.getFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        msg.addFilePart("logfileupload[]", file, "application/octet-stream");
                        ++n2;
                    }
                }
                loggers.reload();
            }
            log.debug("done adding attachments");
            log.debug("posting report...");
            List<String> response = msg.finish();
            log.debug("send complete");
            log.debug("server response:");
            boolean checkResponse = false;
            for (String line : response) {
                log.debug("               :{}", (Object)line);
                if (!line.contains("<p>Message successfully sent!</p>")) continue;
                checkResponse = true;
            }
            if (checkResponse) {
                JOptionPane.showMessageDialog(null, rb.getString("InfoMessage"), rb.getString("InfoTitle"), 1);
                this.getTopLevelAncestor().setVisible(false);
            } else {
                JOptionPane.showMessageDialog(null, rb.getString("ErrMessage"), rb.getString("ErrTitle"), 0);
                this.sendButton.setEnabled(true);
            }
        }
        catch (IOException ex) {
            log.error("Error when attempting to send report: {}", (Throwable)ex);
            this.sendButton.setEnabled(true);
        }
        catch (AddressException ex) {
            log.error("Invalid email address: {}", (Throwable)ex);
            JOptionPane.showMessageDialog(null, rb.getString("ErrAddress"), rb.getString("ErrTitle"), 0);
            this.sendButton.setEnabled(true);
        }
    }

    private void addDirectory(ZipOutputStream out, File source) {
        log.debug("Add profile: {}", (Object)source.getName());
        this.addDirectory(out, source, "");
    }

    private void addDirectory(ZipOutputStream out, File source, String directory) {
        File[] files = source.listFiles();
        log.debug("Add directory: {}", (Object)directory);
        if (files == null) {
            log.warn("No files in directory {}", (Object)source);
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            block22: {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    if (!directory.equals("") || Arrays.asList(this.profDirs).contains(file.getName().toLowerCase())) {
                        try {
                            out.putNextEntry(new ZipEntry(String.valueOf(directory) + file.getName() + "/"));
                        }
                        catch (IOException ex) {
                            log.error("Exception when adding directory: {}", (Throwable)ex);
                        }
                        this.addDirectory(out, file, String.valueOf(directory) + file.getName() + "/");
                    } else {
                        log.debug("Skipping: {}{}", (Object)directory, (Object)file.getName());
                    }
                } else {
                    try {
                        if (!directory.equals("") || file.getName().toLowerCase().matches(".*(config\\.xml|\\.properties)")) {
                            log.debug("Add file: {}{}", (Object)directory, (Object)file.getName());
                            byte[] buffer = new byte[1024];
                            Throwable throwable = null;
                            Object var11_15 = null;
                            try (FileInputStream in = new FileInputStream(file);){
                                int length;
                                out.putNextEntry(new ZipEntry(String.valueOf(directory) + file.getName()));
                                while ((length = in.read(buffer)) > 0) {
                                    out.write(buffer, 0, length);
                                }
                                out.closeEntry();
                                in.close();
                                break block22;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        log.debug("Skip file: {}{}", (Object)directory, (Object)file.getName());
                    }
                    catch (FileNotFoundException ex) {
                        log.error("Exception when adding file: {}", (Throwable)ex);
                    }
                    catch (IOException ex) {
                        log.error("Exception when adding file: {}", (Throwable)ex);
                    }
                }
            }
            ++n2;
        }
    }
}

