/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.mailreport;

import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Toolkit;
import java.io.File;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileSystemView;
import jmri.Application;
import jmri.AudioManager;
import jmri.InstanceManager;
import jmri.Version;
import jmri.configurexml.LoadXmlUserAction;
import jmri.jmrit.audio.AudioFactory;
import jmri.jmrit.roster.Roster;
import jmri.jmrix.ConnectionConfig;
import jmri.jmrix.ConnectionConfigManager;
import jmri.profile.Profile;
import jmri.profile.ProfileManager;
import jmri.util.EarlyInitializationPreferences;
import jmri.util.FileUtil;
import jmri.util.JmriInsets;
import jmri.util.JmriJFrame;
import jmri.util.PortNameMapper;
import jmri.util.gui.GuiLafPreferencesManager;
import jmri.util.node.NodeIdentity;
import jmri.util.zeroconf.ZeroConfService;
import jmri.util.zeroconf.ZeroConfServiceManager;
import purejavacomm.CommPortIdentifier;

public class ReportContext {
    String report = "";

    public String getReport(boolean reportNetworkInfo) {
        this.addString("JMRI Version: " + Version.name() + "   ");
        this.addEarlyInitializationPreferences();
        this.addString("JMRI configuration file name: " + System.getProperty("org.jmri.apps.Apps.configFilename") + "   (from org.jmri.apps.Apps.configFilename system property)");
        if (!JmriJFrame.getFrameList().isEmpty() && JmriJFrame.getFrameList().get(0) != null) {
            this.addString("JMRI main window name: " + JmriJFrame.getFrameList().get(0).getTitle() + "   ");
        } else {
            this.addString("No main window present");
        }
        this.addString("JMRI Application: " + Application.getApplicationName() + "   ");
        ConnectionConfigManager cm = InstanceManager.getNullableDefault(ConnectionConfigManager.class);
        if (cm != null) {
            ConnectionConfig[] connList = cm.getConnections();
            int x = 0;
            while (x < connList.length) {
                ConnectionConfig conn = connList[x];
                this.addString("Connection " + x + ": " + conn.getManufacturer() + " connected via " + conn.name() + " on " + conn.getInfo() + " Disabled " + conn.getDisabled() + "   ");
                ++x;
            }
        } else {
            this.addString("No connections present");
        }
        this.addString("Available Communication Ports:");
        this.addCommunicationPortInfo();
        Profile profile = ProfileManager.getDefault().getActiveProfile();
        if (profile != null) {
            this.addString("Active profile: " + profile.getName() + "   ");
            this.addString("Profile location: " + profile.getPath().getPath() + "   ");
            this.addString("Profile ID: " + profile.getId() + "   ");
        } else {
            this.addString("No active profile");
        }
        this.addString("JMRI Network ID: " + NodeIdentity.networkIdentity());
        this.addString("JMRI Storage ID: " + NodeIdentity.storageIdentity(profile));
        String prefs = FileUtil.getUserFilesPath();
        this.addString("Preferences directory: " + prefs + "   ");
        String prog = System.getProperty("user.dir");
        this.addString("Program directory: " + prog + "   ");
        String roster = Roster.getDefault().getRosterIndexPath();
        this.addString("Roster index location: " + roster + "   ");
        File panel = LoadXmlUserAction.getCurrentFile();
        this.addString("Current panel file: " + (panel == null ? "[none]" : panel.getPath()) + "   ");
        this.addString("Locale: " + InstanceManager.getDefault(GuiLafPreferencesManager.class).getLocale());
        AudioManager am = InstanceManager.getNullableDefault(AudioManager.class);
        AudioFactory af = null;
        if (am != null) {
            af = am.getActiveAudioFactory();
        }
        String audio = af != null ? af.toString() : "[not initialised]";
        this.addString("Audio factory type: " + audio + "   ");
        this.addProperty("java.version");
        this.addProperty("java.vendor");
        this.addProperty("java.home");
        this.addProperty("java.vm.version");
        this.addProperty("java.vm.vendor");
        this.addProperty("java.vm.name");
        this.addProperty("java.specification.version");
        this.addProperty("java.specification.vendor");
        this.addProperty("java.specification.name");
        this.addProperty("java.class.version");
        this.addProperty("java.class.path");
        this.addProperty("java.library.path");
        this.addProperty("java.compiler");
        this.addProperty("java.ext.dirs");
        this.addProperty("file.encoding");
        this.addProperty("os.name");
        this.addProperty("os.arch");
        this.addProperty("os.version");
        this.addProperty("python.home");
        this.addProperty("python.path");
        this.addProperty("python.cachedir");
        this.addProperty("python.cachedir.skip");
        this.addProperty("python.startup");
        this.addProperty("user.name");
        this.addProperty("user.home");
        this.addProperty("user.dir");
        this.addProperty("user.country");
        this.addProperty("user.language");
        this.addProperty("user.timezone");
        this.addProperty("jmri.log.path");
        this.addString("FileSystemView#getDefaultDirectory(): " + FileSystemView.getFileSystemView().getDefaultDirectory().getPath());
        this.addString("FileSystemView#getHomeDirectory(): " + FileSystemView.getFileSystemView().getHomeDirectory().getPath());
        this.addString("Default JFileChooser(): " + new JFileChooser().getCurrentDirectory().getPath());
        this.addScreenSize();
        if (reportNetworkInfo) {
            this.addNetworkInfo();
        }
        return this.report;
    }

    void addString(String val) {
        this.report = String.valueOf(this.report) + val + "\n";
    }

    void addProperty(String prop) {
        this.addString(String.valueOf(prop) + ": " + System.getProperty(prop) + "   ");
    }

    void addEarlyInitializationPreferences() {
        EarlyInitializationPreferences eip = EarlyInitializationPreferences.getInstance();
        for (String pref : eip.getStartupPreferences()) {
            this.addString(String.valueOf(pref) + "   ");
        }
    }

    public void addScreenSize() {
        try {
            JFrame dummy = new JFrame();
            try {
                Insets insets = dummy.getToolkit().getScreenInsets(dummy.getGraphicsConfiguration());
                Dimension screen = dummy.getToolkit().getScreenSize();
                this.addString("Screen size h:" + screen.height + ", w:" + screen.width + " Inset t:" + insets.top + ", b:" + insets.bottom + "; l:" + insets.left + ", r:" + insets.right);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                Dimension screen = dummy.getToolkit().getScreenSize();
                this.addString("Screen size h:" + screen.height + ", w:" + screen.width + " (No Inset method available)");
            }
        }
        catch (HeadlessException ex) {
            this.addString("(Cannot sense screen size due to " + ex.toString() + ")");
        }
        try {
            int dpi = Toolkit.getDefaultToolkit().getScreenResolution();
            this.addString("Screen resolution: " + dpi);
        }
        catch (HeadlessException headlessException) {
            this.addString("Screen resolution not available");
        }
        try {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            this.addString("Environment max bounds: " + ge.getMaximumWindowBounds());
            try {
                for (JmriJFrame.ScreenDimensions sd : JmriJFrame.getScreenDimensions()) {
                    this.addString("Device: " + sd.getGraphicsDevice().getIDstring() + " bounds = " + sd.getBounds());
                    this.addString("Device: " + sd.getGraphicsDevice().getIDstring() + " insets = " + sd.getInsets());
                }
            }
            catch (HeadlessException ex) {
                this.addString("Exception getting device bounds " + ex.getMessage());
            }
        }
        catch (HeadlessException ex) {
            this.addString("Exception getting max window bounds " + ex.getMessage());
        }
        try {
            Insets jmriInsets = JmriInsets.getInsets();
            this.addString("JmriInsets t:" + jmriInsets.top + ", b:" + jmriInsets.bottom + "; l:" + jmriInsets.left + ", r:" + jmriInsets.right);
        }
        catch (Exception ex) {
            this.addString("Exception getting JmriInsets" + ex.getMessage());
        }
    }

    private void addNetworkInfo() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    String hostAddress = inetAddress.getHostAddress();
                    if (hostAddress.equals("0.0.0.0") || hostAddress.regionMatches(0, "127", 0, 3) || hostAddress.contains(":")) continue;
                    this.addString("Network Interface: " + networkInterface.getName());
                    this.addString(" Long Name: " + networkInterface.getDisplayName());
                    this.addString(" Host Name: " + inetAddress.getHostName());
                    this.addString(" IP address: " + hostAddress);
                }
            }
        }
        catch (SocketException socketException) {
            this.addString("Unable to enumerate Network Interfaces");
        }
        Collection<ZeroConfService> services = InstanceManager.getDefault(ZeroConfServiceManager.class).allServices();
        for (InetAddress address : InstanceManager.getDefault(ZeroConfServiceManager.class).getAddresses()) {
            this.addString("ZeroConfService host: " + InstanceManager.getDefault(ZeroConfServiceManager.class).hostName(address) + " running " + services.size() + " service(s)");
        }
        if (services.size() > 0) {
            for (ZeroConfService service : services) {
                int n;
                String[] stringArray;
                this.addString("ZeroConfService: " + service.getServiceInfo().getQualifiedName() + "  ");
                this.addString(" Name: " + service.getName() + "   ");
                try {
                    stringArray = service.getServiceInfo().getHostAddresses();
                    n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String address = stringArray[n2];
                        this.addString(" Address:" + address + "   ");
                        ++n2;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    this.addString(" Address: [unknown due to NPE]");
                }
                this.addString(" Port: " + service.getServiceInfo().getPort() + "   ");
                this.addString(" Server: " + service.getServiceInfo().getServer() + "   ");
                this.addString(" Type: " + service.getType() + "   ");
                try {
                    stringArray = service.getServiceInfo().getURLs();
                    n = stringArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String url = stringArray[n3];
                        this.addString(" URL: " + url + "   ");
                        ++n3;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    this.addString(" URL: [unknown due to NPE]");
                }
                this.addString(" Published: " + (service.isPublished() ? "yes" : "no"));
            }
        }
    }

    private void addCommunicationPortInfo() {
        Enumeration<CommPortIdentifier> portIDs = CommPortIdentifier.getPortIdentifiers();
        ArrayList<CommPortIdentifier> ports = new ArrayList<CommPortIdentifier>();
        while (portIDs.hasMoreElements()) {
            CommPortIdentifier id = portIDs.nextElement();
            if (id.getPortType() == 2) continue;
            ports.add(id);
        }
        this.addString(String.format(" Found %s serial ports", ports.size()));
        for (CommPortIdentifier id : ports) {
            PortNameMapper.SerialPortFriendlyName port = PortNameMapper.getPortNameMap().get(id.getName());
            if (port == null) {
                port = new PortNameMapper.SerialPortFriendlyName(id.getName(), null);
                PortNameMapper.getPortNameMap().put(id.getName(), port);
            }
            this.addString(" Port: " + port.getDisplayName() + (id.isCurrentlyOwned() ? " - in use by: " + id.getCurrentOwner() : " - not in use") + "   ");
        }
    }
}

