/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util.parser.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.jmrit.logixng.util.parser.Function;
import jmri.jmrit.logixng.util.parser.FunctionManager;
import jmri.jmrit.logixng.util.parser.swing.Bundle;
import jmri.util.swing.JComboBoxUtil;

public class FunctionsHelpDialog
implements InstanceManagerAutoDefault {
    private static final int panelWidth = 500;
    private static final int panelHeight = 500;
    private static final Map<String, Module> _modules = new HashMap<String, Module>();
    private JDialog _selectItemTypeDialog = null;
    private final JComboBox<Module> _moduleComboBox = new JComboBox();
    private final JComboBox<SortableFunction> _functionComboBox = new JComboBox();
    private final JLabel _moduleLabel = new JLabel(String.valueOf(Bundle.getMessage("FunctionsHelpDialog_Module")) + ":");
    private final JLabel _functionLabel = new JLabel(String.valueOf(Bundle.getMessage("FunctionsHelpDialog_Function")) + ":");
    private final JEditorPane _documentationEditorPane = new JEditorPane();

    public FunctionsHelpDialog() {
        FunctionManager fm = InstanceManager.getDefault(FunctionManager.class);
        for (Map.Entry<String, Function> entry : fm.getFunctions().entrySet()) {
            Module m = _modules.get(entry.getValue().getModule());
            if (m == null) {
                m = new Module(entry.getValue().getModule(), entry.getValue().getConstantDescriptions());
                _modules.put(m._name, m);
            }
            m._functions.add(entry.getValue());
        }
    }

    public void showDialog() {
        if (this._selectItemTypeDialog != null) {
            this._selectItemTypeDialog.requestFocus();
            return;
        }
        this._documentationEditorPane.setEditable(false);
        this._documentationEditorPane.setContentType("text/html");
        this._moduleComboBox.removeAllItems();
        ArrayList<Module> list = new ArrayList<Module>(_modules.values());
        Collections.sort(list);
        for (Module module : list) {
            this._moduleComboBox.addItem(module);
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._moduleComboBox);
        this._moduleComboBox.addActionListener(e -> this.initFunctionsComboBox());
        this._functionComboBox.addActionListener(e -> {
            if (this._functionComboBox.getSelectedIndex() > -1) {
                SortableFunction f = this._functionComboBox.getItemAt(this._functionComboBox.getSelectedIndex());
                this._documentationEditorPane.setText(f._functionDescr);
                this._documentationEditorPane.setCaretPosition(0);
            } else {
                this._documentationEditorPane.setText("");
            }
        });
        if (this._moduleComboBox.getItemCount() > 0) {
            this._moduleComboBox.setSelectedIndex(0);
        }
        this._selectItemTypeDialog = new JDialog(null, Bundle.getMessage("FunctionsHelpDialogTitle"), false);
        Container contentPanel = this._selectItemTypeDialog.getContentPane();
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 13;
        p.add((Component)this._moduleLabel, c);
        c.gridy = 1;
        p.add((Component)this._functionLabel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 2;
        p.add(this._moduleComboBox, c);
        c.gridy = 1;
        c.fill = 1;
        p.add(this._functionComboBox, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        JScrollPane documentationScroller = new JScrollPane(this._documentationEditorPane);
        documentationScroller.setPreferredSize(new Dimension(500, 500));
        documentationScroller.setAlignmentX(0.0f);
        documentationScroller.setAlignmentY(0.0f);
        p.add((Component)documentationScroller, c);
        contentPanel.add(p);
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BoxLayout(panel3, 1));
        contentPanel.add(panel3);
        JPanel panel5 = new JPanel();
        panel5.setLayout(new FlowLayout());
        JButton cancel = new JButton(Bundle.getMessage("ButtonCancel"));
        panel5.add(cancel);
        cancel.addActionListener(e -> this.cancelAddPressed(null));
        cancel.setToolTipText("CancelLogixButtonHint");
        this._selectItemTypeDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FunctionsHelpDialog.this.cancelAddPressed(null);
            }
        });
        contentPanel.add(panel5);
        this._selectItemTypeDialog.setMinimumSize(new Dimension(500, 500));
        this._selectItemTypeDialog.setLocationRelativeTo(null);
        this._selectItemTypeDialog.pack();
        this._selectItemTypeDialog.setVisible(true);
    }

    protected final void cancelAddPressed(ActionEvent e) {
        this._selectItemTypeDialog.setVisible(false);
        this._selectItemTypeDialog.dispose();
        this._selectItemTypeDialog = null;
    }

    private void initFunctionsComboBox() {
        this._functionComboBox.removeAllItems();
        if (this._moduleComboBox.getSelectedIndex() > -1) {
            Module module = this._moduleComboBox.getItemAt(this._moduleComboBox.getSelectedIndex());
            ArrayList<SortableFunction> list = new ArrayList<SortableFunction>();
            if (module._constantDescriptions != null) {
                list.add(new SortableFunction(Bundle.getMessage("FunctionsHelpDialog_Constants"), module._constantDescriptions));
            }
            for (Function f : module._functions) {
                list.add(new SortableFunction(f.getName(), f.getDescription()));
            }
            Collections.sort(list);
            for (SortableFunction function : list) {
                this._functionComboBox.addItem(function);
            }
            JComboBoxUtil.setupComboBoxMaxRows(this._functionComboBox);
        }
    }

    private static class Module
    implements Comparable<Module> {
        private final String _name;
        private final String _constantDescriptions;
        private final List<Function> _functions = new ArrayList<Function>();

        private Module(String name, String constantDescriptions) {
            this._name = name;
            this._constantDescriptions = constantDescriptions;
        }

        public boolean equals(Object o) {
            return o instanceof Module && this._name.equals(((Module)o)._name);
        }

        public int hashCode() {
            int hash = 7;
            hash = 47 * hash + Objects.hashCode(this._name);
            return hash;
        }

        @Override
        public int compareTo(Module o) {
            return this._name.compareTo(o._name);
        }

        public String toString() {
            return this._name;
        }
    }

    private static class SortableFunction
    implements Comparable<SortableFunction> {
        private final String _name;
        private final String _functionDescr;

        private SortableFunction(String name, String functionDescr) {
            this._name = name;
            this._functionDescr = functionDescr;
        }

        public boolean equals(Object o) {
            return o instanceof SortableFunction && this._name.equals(((SortableFunction)o)._name);
        }

        public int hashCode() {
            int hash = 7;
            hash = 47 * hash + Objects.hashCode(this._name);
            return hash;
        }

        @Override
        public int compareTo(SortableFunction o) {
            return this._name.compareTo(o._name);
        }

        public String toString() {
            return this._name;
        }
    }
}

