/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util.parser.functions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jmri.JmriException;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.util.parser.CalculateException;
import jmri.jmrit.logixng.util.parser.Constant;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.Function;
import jmri.jmrit.logixng.util.parser.FunctionFactory;
import jmri.jmrit.logixng.util.parser.WrongNumberOfParametersException;
import jmri.jmrit.logixng.util.parser.functions.Bundle;
import jmri.util.TypeConversionUtil;

public class StringFunctions
implements FunctionFactory {
    @Override
    public String getModule() {
        return "String";
    }

    @Override
    public Set<Function> getFunctions() {
        HashSet<Function> functionClasses = new HashSet<Function>();
        functionClasses.add(new FormatFunction());
        return functionClasses;
    }

    @Override
    public Set<Constant> getConstants() {
        return new HashSet<Constant>();
    }

    @Override
    public String getConstantDescription() {
        return null;
    }

    public static class FormatFunction
    implements Function {
        @Override
        public String getModule() {
            return new StringFunctions().getModule();
        }

        @Override
        public String getConstantDescriptions() {
            return new StringFunctions().getConstantDescription();
        }

        @Override
        public String getName() {
            return "format";
        }

        @Override
        public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
            if (parameterList.isEmpty()) {
                throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters1", this.getName(), 1));
            }
            String formatStr = TypeConversionUtil.convertToString(parameterList.get(0).calculate(symbolTable), false);
            ArrayList<Object> list = new ArrayList<Object>();
            int i = 1;
            while (i < parameterList.size()) {
                list.add(parameterList.get(i).calculate(symbolTable));
                ++i;
            }
            return String.format(formatStr, list.toArray());
        }

        @Override
        public String getDescription() {
            return Bundle.getMessage("String.format_Descr");
        }
    }
}

