/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util.parser.functions;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.Constant;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.Function;
import jmri.jmrit.logixng.util.parser.FunctionFactory;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.jmrit.logixng.util.parser.WrongNumberOfParametersException;
import jmri.jmrit.logixng.util.parser.functions.Bundle;
import jmri.util.TypeConversionUtil;

public class NamedBeanFunctions
implements FunctionFactory {
    @Override
    public String getModule() {
        return "NamedBean";
    }

    @Override
    public Set<Function> getFunctions() {
        HashSet<Function> functionClasses = new HashSet<Function>();
        functionClasses.add(new ReadMemoryFunction());
        functionClasses.add(new EvaluateMemoryFunction());
        return functionClasses;
    }

    @Override
    public Set<Constant> getConstants() {
        return new HashSet<Constant>();
    }

    @Override
    public String getConstantDescription() {
        return null;
    }

    public static class EvaluateMemoryFunction
    implements Function {
        @Override
        public String getModule() {
            return new NamedBeanFunctions().getModule();
        }

        @Override
        public String getConstantDescriptions() {
            return new NamedBeanFunctions().getConstantDescription();
        }

        @Override
        public String getName() {
            return "evaluateMemory";
        }

        @Override
        public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws JmriException {
            if (parameterList.size() != 1) {
                throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters2", this.getName(), 1));
            }
            Object value = parameterList.get(0).calculate(symbolTable);
            if (value == null) {
                return null;
            }
            String s = TypeConversionUtil.convertToString(value, false);
            if (s.isEmpty()) {
                return null;
            }
            Memory m = (Memory)InstanceManager.getDefault(MemoryManager.class).getNamedBean(s);
            if (m == null) {
                return null;
            }
            value = m.getValue();
            if (value instanceof String && ReferenceUtil.isReference((String)value)) {
                return ReferenceUtil.getReference(symbolTable, (String)value);
            }
            s = TypeConversionUtil.convertToString(value, false);
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            ExpressionNode expressionNode = parser.parseExpression(s);
            return expressionNode.calculate(symbolTable);
        }

        @Override
        public String getDescription() {
            return Bundle.getMessage("NamedBean.evaluateMemory_Descr");
        }
    }

    public static class ReadMemoryFunction
    implements Function {
        @Override
        public String getModule() {
            return new NamedBeanFunctions().getModule();
        }

        @Override
        public String getConstantDescriptions() {
            return new NamedBeanFunctions().getConstantDescription();
        }

        @Override
        public String getName() {
            return "readMemory";
        }

        @Override
        public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws JmriException {
            if (parameterList.size() != 1) {
                throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters2", this.getName(), 1));
            }
            Object value = parameterList.get(0).calculate(symbolTable);
            if (value == null) {
                return null;
            }
            String s = TypeConversionUtil.convertToString(value, false);
            if (s.isEmpty()) {
                return null;
            }
            Memory m = (Memory)InstanceManager.getDefault(MemoryManager.class).getNamedBean(s);
            if (m == null) {
                return null;
            }
            return m.getValue();
        }

        @Override
        public String getDescription() {
            return Bundle.getMessage("NamedBean.readMemory_Descr");
        }
    }
}

