/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util.parser.functions;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jmri.JmriException;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.util.parser.CalculateException;
import jmri.jmrit.logixng.util.parser.Constant;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.Function;
import jmri.jmrit.logixng.util.parser.FunctionFactory;
import jmri.jmrit.logixng.util.parser.WrongNumberOfParametersException;
import jmri.jmrit.logixng.util.parser.functions.Bundle;
import jmri.util.TypeConversionUtil;

public class MathFunctions
implements FunctionFactory {
    @Override
    public String getModule() {
        return "Math";
    }

    @Override
    public Set<Function> getFunctions() {
        HashSet<Function> functionClasses = new HashSet<Function>();
        functionClasses.add(new RandomFunction());
        functionClasses.add(new SinFunction());
        return functionClasses;
    }

    @Override
    public Set<Constant> getConstants() {
        HashSet<Constant> constantClasses = new HashSet<Constant>();
        constantClasses.add(new Constant(this.getModule(), "MathPI", Math.PI));
        constantClasses.add(new Constant(this.getModule(), "MathE", Math.E));
        return constantClasses;
    }

    @Override
    public String getConstantDescription() {
        return Bundle.getMessage("Math.ConstantDescriptions");
    }

    public static class RandomFunction
    implements Function {
        @Override
        public String getModule() {
            return new MathFunctions().getModule();
        }

        @Override
        public String getConstantDescriptions() {
            return new MathFunctions().getConstantDescription();
        }

        @Override
        public String getName() {
            return "random";
        }

        @Override
        public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
            switch (parameterList.size()) {
                case 0: {
                    return Math.random();
                }
                case 1: {
                    double max = TypeConversionUtil.convertToDouble(parameterList.get(0).calculate(symbolTable), false);
                    return Math.random() * max;
                }
                case 2: {
                    double min = TypeConversionUtil.convertToDouble(parameterList.get(0).calculate(symbolTable), false);
                    double max = TypeConversionUtil.convertToDouble(parameterList.get(1).calculate(symbolTable), false);
                    return min + Math.random() * (max - min);
                }
            }
            throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters1", this.getName()));
        }

        @Override
        public String getDescription() {
            return Bundle.getMessage("Math.random_Descr");
        }
    }

    public static class SinFunction
    implements Function {
        @Override
        public String getModule() {
            return new MathFunctions().getModule();
        }

        @Override
        public String getConstantDescriptions() {
            return new MathFunctions().getConstantDescription();
        }

        @Override
        public String getName() {
            return "sin";
        }

        @Override
        public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws JmriException {
            block17: {
                double result;
                block20: {
                    Object param1;
                    double param0;
                    block18: {
                        if (parameterList.size() == 1) {
                            double param = TypeConversionUtil.convertToDouble(parameterList.get(0).calculate(symbolTable), false);
                            return Math.sin(param);
                        }
                        if (parameterList.size() < 2) break block17;
                        param0 = TypeConversionUtil.convertToDouble(parameterList.get(0).calculate(symbolTable), false);
                        param1 = parameterList.get(1).calculate(symbolTable);
                        if (!(param1 instanceof String)) break block18;
                        switch ((String)param1) {
                            case "rad": {
                                result = Math.sin(param0);
                                break block20;
                            }
                            case "deg": {
                                result = Math.sin(Math.toRadians(param0));
                                break block20;
                            }
                            default: {
                                throw new CalculateException(Bundle.getMessage("IllegalParameter", 2, param1, this.getName()));
                            }
                        }
                    }
                    if (param1 instanceof Number) {
                        double p1 = TypeConversionUtil.convertToDouble(param1, false);
                        double angle = param0 / p1 * 2.0 * Math.PI;
                        result = Math.sin(angle);
                    } else {
                        throw new CalculateException(Bundle.getMessage("IllegalParameter", 2, param1, this.getName()));
                    }
                }
                switch (parameterList.size()) {
                    case 2: {
                        return result;
                    }
                    case 4: {
                        double min = TypeConversionUtil.convertToDouble(parameterList.get(2).calculate(symbolTable), false);
                        double max = TypeConversionUtil.convertToDouble(parameterList.get(3).calculate(symbolTable), false);
                        return (result + 1.0) / 2.0 * (max - min) + min;
                    }
                }
                throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters1", this.getName()));
            }
            throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters1", this.getName()));
        }

        @Override
        public String getDescription() {
            return Bundle.getMessage("Math.sin_Descr");
        }
    }
}

