/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util.parser.functions;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Light;
import jmri.LightManager;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.Turnout;
import jmri.TurnoutManager;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.util.parser.CalculateException;
import jmri.jmrit.logixng.util.parser.Constant;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.Function;
import jmri.jmrit.logixng.util.parser.FunctionFactory;
import jmri.jmrit.logixng.util.parser.WrongNumberOfParametersException;
import jmri.jmrit.logixng.util.parser.functions.Bundle;
import jmri.util.TypeConversionUtil;

public class LayoutFunctions
implements FunctionFactory {
    @Override
    public String getModule() {
        return "Layout";
    }

    @Override
    public Set<Function> getFunctions() {
        HashSet<Function> functionClasses = new HashSet<Function>();
        functionClasses.add(new TurnoutExistsFunction());
        functionClasses.add(new GetTurnoutStateFunction());
        functionClasses.add(new SetTurnoutStateFunction());
        functionClasses.add(new SensorExistsFunction());
        functionClasses.add(new GetSensorStateFunction());
        functionClasses.add(new SetSensorStateFunction());
        functionClasses.add(new LightExistsFunction());
        functionClasses.add(new GetLightStateFunction());
        functionClasses.add(new SetLightStateFunction());
        functionClasses.add(new SignalHeadExistsFunction());
        functionClasses.add(new GetSignalHeadAppearanceFunction());
        functionClasses.add(new SetSignalHeadAppearanceFunction());
        functionClasses.add(new SignalMastExistsFunction());
        functionClasses.add(new GetSignalMastAspectFunction());
        functionClasses.add(new SetSignalMastAspectFunction());
        return functionClasses;
    }

    @Override
    public Set<Constant> getConstants() {
        HashSet<Constant> constantClasses = new HashSet<Constant>();
        constantClasses.add(new Constant(this.getModule(), "Unknown", 1));
        constantClasses.add(new Constant(this.getModule(), "Inconsistent", 8));
        constantClasses.add(new Constant(this.getModule(), "Off", 4));
        constantClasses.add(new Constant(this.getModule(), "On", 2));
        constantClasses.add(new Constant(this.getModule(), "Inactive", 4));
        constantClasses.add(new Constant(this.getModule(), "Active", 2));
        constantClasses.add(new Constant(this.getModule(), "Closed", 2));
        constantClasses.add(new Constant(this.getModule(), "Thrown", 4));
        constantClasses.add(new Constant(this.getModule(), "Dark", 0));
        constantClasses.add(new Constant(this.getModule(), "Red", 1));
        constantClasses.add(new Constant(this.getModule(), "FlashRed", 2));
        constantClasses.add(new Constant(this.getModule(), "Yellow", 4));
        constantClasses.add(new Constant(this.getModule(), "FlashYellow", 8));
        constantClasses.add(new Constant(this.getModule(), "Green", 16));
        constantClasses.add(new Constant(this.getModule(), "FlashGreen", 32));
        constantClasses.add(new Constant(this.getModule(), "Lunar", 64));
        constantClasses.add(new Constant(this.getModule(), "FlashLunar", 128));
        constantClasses.add(new Constant(this.getModule(), "Held", 256));
        return constantClasses;
    }

    @Override
    public String getConstantDescription() {
        return Bundle.getMessage("Layout.ConstantDescriptions");
    }

    public static class GetLightStateFunction
    implements Function {
        @Override
        public String getModule() {
            return new LayoutFunctions().getModule();
        }

        @Override
        public String getConstantDescriptions() {
            return new LayoutFunctions().getConstantDescription();
        }

        @Override
        public String getName() {
            return "getLightState";
        }

        @Override
        public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
            if (parameterList.isEmpty()) {
                throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters2", this.getName(), 1));
            }
            String name = TypeConversionUtil.convertToString(parameterList.get(0).calculate(symbolTable), false);
            Light l = (Light)InstanceManager.getDefault(LightManager.class).getNamedBean(name);
            if (l == null) {
                throw new CalculateException(Bundle.getMessage("LayoutFunctions_GetLightState_LightNotFound", name));
            }
            return l.getKnownState();
        }

        @Override
        public String getDescription() {
            return Bundle.getMessage("LayoutFunctions.getLightState_Descr");
        }
    }

    public static class GetSensorStateFunction
    implements Function {
        @Override
        public String getModule() {
            return new LayoutFunctions().getModule();
        }

        @Override
        public String getConstantDescriptions() {
            return new LayoutFunctions().getConstantDescription();
        }

        @Override
        public String getName() {
            return "getSensorState";
        }

        @Override
        public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
            if (parameterList.isEmpty()) {
                throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters2", this.getName(), 1));
            }
            String name = TypeConversionUtil.convertToString(parameterList.get(0).calculate(symbolTable), false);
            Sensor s = (Sensor)InstanceManager.getDefault(SensorManager.class).getNamedBean(name);
            if (s == null) {
                throw new CalculateException(Bundle.getMessage("LayoutFunctions_GetSensorState_SensorNotFound", name));
            }
            return s.getKnownState();
        }

        @Override
        public String getDescription() {
            return Bundle.getMessage("LayoutFunctions.getSensorState_Descr");
        }
    }

    public static class GetSignalHeadAppearanceFunction
    implements Function {
        @Override
        public String getModule() {
            return new LayoutFunctions().getModule();
        }

        @Override
        public String getConstantDescriptions() {
            return new LayoutFunctions().getConstantDescription();
        }

        @Override
        public String getName() {
            return "getSignalHeadAppearance";
        }

        @Override
        public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
            if (parameterList.isEmpty()) {
                throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters2", this.getName(), 1));
            }
            String name = TypeConversionUtil.convertToString(parameterList.get(0).calculate(symbolTable), false);
            SignalHead sh = (SignalHead)InstanceManager.getDefault(SignalHeadManager.class).getNamedBean(name);
            if (sh == null) {
                throw new CalculateException(Bundle.getMessage("LayoutFunctions_GetSignalHeadAppearance_SignalHeadNotFound", name));
            }
            return sh.getAppearance();
        }

        @Override
        public String getDescription() {
            return Bundle.getMessage("LayoutFunctions.getSignalHeadAppearance_Descr");
        }
    }

    public static class GetSignalMastAspectFunction
    implements Function {
        @Override
        public String getModule() {
            return new LayoutFunctions().getModule();
        }

        @Override
        public String getConstantDescriptions() {
            return new LayoutFunctions().getConstantDescription();
        }

        @Override
        public String getName() {
            return "getSignalMastAspect";
        }

        @Override
        public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
            if (parameterList.isEmpty()) {
                throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters2", this.getName(), 1));
            }
            String name = TypeConversionUtil.convertToString(parameterList.get(0).calculate(symbolTable), false);
            SignalMast sm = (SignalMast)InstanceManager.getDefault(SignalMastManager.class).getNamedBean(name);
            if (sm == null) {
                throw new CalculateException(Bundle.getMessage("LayoutFunctions_GetSignalMastAspect_SignalMastNotFound", name));
            }
            return sm.getAspect();
        }

        @Override
        public String getDescription() {
            return Bundle.getMessage("LayoutFunctions.getSignalMastAspect_Descr");
        }
    }

    public static class GetTurnoutStateFunction
    implements Function {
        @Override
        public String getModule() {
            return new LayoutFunctions().getModule();
        }

        @Override
        public String getName() {
            return "getTurnoutState";
        }

        @Override
        public String getConstantDescriptions() {
            return new LayoutFunctions().getConstantDescription();
        }

        @Override
        public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
            if (parameterList.isEmpty()) {
                throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters2", this.getName(), 1));
            }
            String name = TypeConversionUtil.convertToString(parameterList.get(0).calculate(symbolTable), false);
            Turnout t = (Turnout)InstanceManager.getDefault(TurnoutManager.class).getNamedBean(name);
            if (t == null) {
                throw new CalculateException(Bundle.getMessage("LayoutFunctions_GetTurnoutState_TurnoutNotFound", name));
            }
            return t.getKnownState();
        }

        @Override
        public String getDescription() {
            return Bundle.getMessage("LayoutFunctions.getTurnoutState_Descr");
        }
    }

    public static class LightExistsFunction
    implements Function {
        @Override
        public String getModule() {
            return new LayoutFunctions().getModule();
        }

        @Override
        public String getName() {
            return "lightExists";
        }

        @Override
        public String getConstantDescriptions() {
            return new LayoutFunctions().getConstantDescription();
        }

        @Override
        public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
            if (parameterList.isEmpty()) {
                throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters2", this.getName(), 1));
            }
            String name = TypeConversionUtil.convertToString(parameterList.get(0).calculate(symbolTable), false);
            Light l = (Light)InstanceManager.getDefault(LightManager.class).getNamedBean(name);
            if (l != null) {
                return true;
            }
            return false;
        }

        @Override
        public String getDescription() {
            return Bundle.getMessage("LayoutFunctions.lightExists_Descr");
        }
    }

    public static class SensorExistsFunction
    implements Function {
        @Override
        public String getModule() {
            return new LayoutFunctions().getModule();
        }

        @Override
        public String getName() {
            return "sensorExists";
        }

        @Override
        public String getConstantDescriptions() {
            return new LayoutFunctions().getConstantDescription();
        }

        @Override
        public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
            if (parameterList.isEmpty()) {
                throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters2", this.getName(), 1));
            }
            String name = TypeConversionUtil.convertToString(parameterList.get(0).calculate(symbolTable), false);
            Sensor s = (Sensor)InstanceManager.getDefault(SensorManager.class).getNamedBean(name);
            if (s != null) {
                return true;
            }
            return false;
        }

        @Override
        public String getDescription() {
            return Bundle.getMessage("LayoutFunctions.sensorExists_Descr");
        }
    }

    public static class SetLightStateFunction
    implements Function {
        @Override
        public String getModule() {
            return new LayoutFunctions().getModule();
        }

        @Override
        public String getConstantDescriptions() {
            return new LayoutFunctions().getConstantDescription();
        }

        @Override
        public String getName() {
            return "setLightState";
        }

        @Override
        public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
            if (parameterList.isEmpty()) {
                throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters2", this.getName(), 2));
            }
            String name = TypeConversionUtil.convertToString(parameterList.get(0).calculate(symbolTable), false);
            int value = (int)TypeConversionUtil.convertToLong(parameterList.get(1).calculate(symbolTable));
            Light l = (Light)InstanceManager.getDefault(LightManager.class).getNamedBean(name);
            if (l == null) {
                throw new CalculateException(Bundle.getMessage("LayoutFunctions_SetLightState_LightNotFound", name));
            }
            l.setState(value);
            return l.getKnownState();
        }

        @Override
        public String getDescription() {
            return Bundle.getMessage("LayoutFunctions.setLightState_Descr");
        }
    }

    public static class SetSensorStateFunction
    implements Function {
        @Override
        public String getModule() {
            return new LayoutFunctions().getModule();
        }

        @Override
        public String getConstantDescriptions() {
            return new LayoutFunctions().getConstantDescription();
        }

        @Override
        public String getName() {
            return "setSensorState";
        }

        @Override
        public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
            if (parameterList.isEmpty()) {
                throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters2", this.getName(), 2));
            }
            String name = TypeConversionUtil.convertToString(parameterList.get(0).calculate(symbolTable), false);
            int value = (int)TypeConversionUtil.convertToLong(parameterList.get(1).calculate(symbolTable));
            Sensor s = (Sensor)InstanceManager.getDefault(SensorManager.class).getNamedBean(name);
            if (s == null) {
                throw new CalculateException(Bundle.getMessage("LayoutFunctions_SetSensorState_SensorNotFound", name));
            }
            s.setState(value);
            return s.getKnownState();
        }

        @Override
        public String getDescription() {
            return Bundle.getMessage("LayoutFunctions.setSensorState_Descr");
        }
    }

    public static class SetSignalHeadAppearanceFunction
    implements Function {
        @Override
        public String getModule() {
            return new LayoutFunctions().getModule();
        }

        @Override
        public String getConstantDescriptions() {
            return new LayoutFunctions().getConstantDescription();
        }

        @Override
        public String getName() {
            return "setSignalHeadAppearance";
        }

        @Override
        public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
            if (parameterList.isEmpty()) {
                throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters2", this.getName(), 2));
            }
            String name = TypeConversionUtil.convertToString(parameterList.get(0).calculate(symbolTable), false);
            int aspect = (int)TypeConversionUtil.convertToLong(parameterList.get(1).calculate(symbolTable));
            SignalHead sh = (SignalHead)InstanceManager.getDefault(SignalHeadManager.class).getNamedBean(name);
            if (sh == null) {
                throw new CalculateException(Bundle.getMessage("LayoutFunctions_SetSignalHeadAppearance_SignalHeadNotFound", name));
            }
            sh.setAppearance(aspect);
            return sh.getAppearance();
        }

        @Override
        public String getDescription() {
            return Bundle.getMessage("LayoutFunctions.setSignalHeadAppearance_Descr");
        }
    }

    public static class SetSignalMastAspectFunction
    implements Function {
        @Override
        public String getModule() {
            return new LayoutFunctions().getModule();
        }

        @Override
        public String getConstantDescriptions() {
            return new LayoutFunctions().getConstantDescription();
        }

        @Override
        public String getName() {
            return "setSignalMastAspect";
        }

        @Override
        public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
            if (parameterList.isEmpty()) {
                throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters2", this.getName(), 2));
            }
            String name = TypeConversionUtil.convertToString(parameterList.get(0).calculate(symbolTable), false);
            String aspect = TypeConversionUtil.convertToString(parameterList.get(1).calculate(symbolTable), false);
            SignalMast sm = (SignalMast)InstanceManager.getDefault(SignalMastManager.class).getNamedBean(name);
            if (sm == null) {
                throw new CalculateException(Bundle.getMessage("LayoutFunctions_SetSignalMastAspect_SignalMastNotFound", name));
            }
            sm.setAspect(aspect);
            return sm.getAspect();
        }

        @Override
        public String getDescription() {
            return Bundle.getMessage("LayoutFunctions.setSignalMastAspect_Descr");
        }
    }

    public static class SetTurnoutStateFunction
    implements Function {
        @Override
        public String getModule() {
            return new LayoutFunctions().getModule();
        }

        @Override
        public String getConstantDescriptions() {
            return new LayoutFunctions().getConstantDescription();
        }

        @Override
        public String getName() {
            return "setTurnoutState";
        }

        @Override
        public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
            if (parameterList.isEmpty()) {
                throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters2", this.getName(), 2));
            }
            String name = TypeConversionUtil.convertToString(parameterList.get(0).calculate(symbolTable), false);
            int value = (int)TypeConversionUtil.convertToLong(parameterList.get(1).calculate(symbolTable));
            Turnout t = (Turnout)InstanceManager.getDefault(TurnoutManager.class).getNamedBean(name);
            if (t == null) {
                throw new CalculateException(Bundle.getMessage("LayoutFunctions_SetTurnoutState_TurnoutNotFound", name));
            }
            t.setState(value);
            return t.getKnownState();
        }

        @Override
        public String getDescription() {
            return Bundle.getMessage("LayoutFunctions.setTurnoutState_Descr");
        }
    }

    public static class SignalHeadExistsFunction
    implements Function {
        @Override
        public String getModule() {
            return new LayoutFunctions().getModule();
        }

        @Override
        public String getName() {
            return "signalHeadExists";
        }

        @Override
        public String getConstantDescriptions() {
            return new LayoutFunctions().getConstantDescription();
        }

        @Override
        public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
            if (parameterList.isEmpty()) {
                throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters2", this.getName(), 1));
            }
            String name = TypeConversionUtil.convertToString(parameterList.get(0).calculate(symbolTable), false);
            SignalHead sh = (SignalHead)InstanceManager.getDefault(SignalHeadManager.class).getNamedBean(name);
            if (sh != null) {
                return true;
            }
            return false;
        }

        @Override
        public String getDescription() {
            return Bundle.getMessage("LayoutFunctions.signalHeadExists_Descr");
        }
    }

    public static class SignalMastExistsFunction
    implements Function {
        @Override
        public String getModule() {
            return new LayoutFunctions().getModule();
        }

        @Override
        public String getName() {
            return "signalMastExists";
        }

        @Override
        public String getConstantDescriptions() {
            return new LayoutFunctions().getConstantDescription();
        }

        @Override
        public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
            if (parameterList.isEmpty()) {
                throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters2", this.getName(), 1));
            }
            String name = TypeConversionUtil.convertToString(parameterList.get(0).calculate(symbolTable), false);
            SignalMast sh = (SignalMast)InstanceManager.getDefault(SignalMastManager.class).getNamedBean(name);
            if (sh != null) {
                return true;
            }
            return false;
        }

        @Override
        public String getDescription() {
            return Bundle.getMessage("LayoutFunctions.signalMastExists_Descr");
        }
    }

    public static class TurnoutExistsFunction
    implements Function {
        @Override
        public String getModule() {
            return new LayoutFunctions().getModule();
        }

        @Override
        public String getName() {
            return "turnoutExists";
        }

        @Override
        public String getConstantDescriptions() {
            return new LayoutFunctions().getConstantDescription();
        }

        @Override
        public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
            if (parameterList.isEmpty()) {
                throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters2", this.getName(), 1));
            }
            String name = TypeConversionUtil.convertToString(parameterList.get(0).calculate(symbolTable), false);
            Turnout t = (Turnout)InstanceManager.getDefault(TurnoutManager.class).getNamedBean(name);
            if (t != null) {
                return true;
            }
            return false;
        }

        @Override
        public String getDescription() {
            return Bundle.getMessage("LayoutFunctions.turnoutExists_Descr");
        }
    }
}

