/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util.parser.functions;

import java.time.Instant;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Timebase;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.util.parser.CalculateException;
import jmri.jmrit.logixng.util.parser.Constant;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.Function;
import jmri.jmrit.logixng.util.parser.FunctionFactory;
import jmri.jmrit.logixng.util.parser.WrongNumberOfParametersException;
import jmri.jmrit.logixng.util.parser.functions.Bundle;

public class ClockFunctions
implements FunctionFactory {
    @Override
    public String getModule() {
        return "Clock";
    }

    @Override
    public Set<Function> getFunctions() {
        HashSet<Function> functionClasses = new HashSet<Function>();
        functionClasses.add(new SystemClockFunction());
        functionClasses.add(new FastClockFunction());
        return functionClasses;
    }

    @Override
    public Set<Constant> getConstants() {
        return new HashSet<Constant>();
    }

    @Override
    public String getConstantDescription() {
        return null;
    }

    public static class FastClockFunction
    implements Function {
        private final Timebase _fastClock = InstanceManager.getDefault(Timebase.class);

        @Override
        public String getModule() {
            return new ClockFunctions().getModule();
        }

        @Override
        public String getConstantDescriptions() {
            return new ClockFunctions().getConstantDescription();
        }

        @Override
        public String getName() {
            return "fastClock";
        }

        @Override
        public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws JmriException {
            block14: {
                Object param;
                block15: {
                    Date currentTime = this._fastClock.getTime();
                    if (parameterList.isEmpty()) {
                        return currentTime.getHours() * 60 + currentTime.getMinutes();
                    }
                    if (parameterList.size() != 1) break block14;
                    param = parameterList.get(0).calculate(symbolTable);
                    if (!(param instanceof String)) break block15;
                    switch ((String)param) {
                        case "hour": {
                            return currentTime.getHours();
                        }
                        case "min": {
                            return currentTime.getMinutes();
                        }
                        case "minOfDay": {
                            return currentTime.getHours() * 60 + currentTime.getMinutes();
                        }
                    }
                    throw new CalculateException(Bundle.getMessage("IllegalParameter", 1, param, this.getName()));
                }
                throw new CalculateException(Bundle.getMessage("IllegalParameter", 1, param, this.getName()));
            }
            throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters1", this.getName()));
        }

        @Override
        public String getDescription() {
            return Bundle.getMessage("Clock.fastClock_Descr");
        }
    }

    public static class SystemClockFunction
    implements Function {
        @Override
        public String getModule() {
            return new ClockFunctions().getModule();
        }

        @Override
        public String getConstantDescriptions() {
            return new ClockFunctions().getConstantDescription();
        }

        @Override
        public String getName() {
            return "systemClock";
        }

        @Override
        public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
            block20: {
                Object param;
                block21: {
                    Date currentTime = Date.from(Instant.now());
                    if (parameterList.isEmpty()) {
                        return currentTime.getHours() * 60 + currentTime.getMinutes();
                    }
                    if (parameterList.size() != 1) break block20;
                    param = parameterList.get(0).calculate(symbolTable);
                    if (!(param instanceof String)) break block21;
                    switch ((String)param) {
                        case "hour": {
                            return currentTime.getHours();
                        }
                        case "min": {
                            return currentTime.getMinutes();
                        }
                        case "sec": {
                            return currentTime.getSeconds();
                        }
                        case "minOfDay": {
                            return currentTime.getHours() * 60 + currentTime.getMinutes();
                        }
                        case "secOfDay": {
                            return (currentTime.getHours() * 60 + currentTime.getMinutes()) * 60 + currentTime.getSeconds();
                        }
                    }
                    throw new CalculateException(Bundle.getMessage("IllegalParameter", 1, param, this.getName()));
                }
                throw new CalculateException(Bundle.getMessage("IllegalParameter", 1, param, this.getName()));
            }
            throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters1", this.getName()));
        }

        @Override
        public String getDescription() {
            return Bundle.getMessage("Clock.systemClock_Descr");
        }
    }
}

